using System;
using System.Runtime.InteropServices;

namespace csAvX
{
	/// <summary>
	/// WIN32 RECT structure.
	/// </summary>
	[StructLayout(LayoutKind.Sequential)]
	public struct RECT
	{
		public int	left;
		public int	top;
		public int	right;
		public int	bottom;
	};

	/// <summary>
	/// PAN_CtlBrush structure. Defined here, but not used in sample.
	/// </summary>
	[StructLayout(LayoutKind.Sequential)]
	public struct PAN_CtlBrush
	{
		public uint	style;
		public uint	color;
		public uint	hatch;
	};

	/// <summary>
	/// PAN_CtlRenderOptions structure used by PM_CTLRENDERONTODC
	/// message. Line weights, pens, and brushes not used/supported
	/// in this sample (All use pointers to arrays).
	/// </summary>
	[StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
	public class PAN_CtlRenderOptions
	{
		public IntPtr			hdc;
		public PAN_CtlRange	source;
		public uint			mode;

		public RECT			devRect;

		public int				xDevRes;
		public int				yDevRes;

		public ushort			numFixedWidthScale;
		public ulong			lpFixedWidthScale;

		public ushort			numPens;
		public ulong			lpPenThickness;

		public PAN_CtlRenderOptions()
		{
			hdc = IntPtr.Zero;

			mode = 0;

			xDevRes = 0;
			yDevRes = 0;
			numFixedWidthScale = 0;
			lpFixedWidthScale = 0;
			numPens = 0;
			lpPenThickness = 0;
		}
	}
}
