using System;
using System.Runtime.InteropServices;

namespace csAvX
{
	/// <summary>
	/// This file contains the C# translation of the constants and data
	/// structures from VCET's include file pctl.h that are used in this
	/// sample.
	/// </summary>
	public enum VCET_errcodes {
		PAN_CTLERRNONE,
		PAN_CTLERRMISC,
		PAN_CTLERRNOTINSTALLED,
		PAN_CTLERRALREADYINSTALLED,
		PAN_CTLERRNOTIMPLEMENTED,
		PAN_CTLERRNOTCOMPATIBLE,
		PAN_CTLERRBADDATA,
		PAN_CTLERRBADPARAM,
		PAN_CTLERRBADWPARAM,
		PAN_CTLERRBADLPARAM,

		PAN_CTLERRBADINSTANCE,
		PAN_CTLERRBADCTLTYPE,
		PAN_CTLERRBADMESSAGE,
		PAN_CTLERRBADCAPS,
		PAN_CTLERRBADWINDOW,
		PAN_CTLERRCANNOTLOCKMEM,
		PAN_CTLERRCANNOTALLOCMEM,
		PAN_CTLERRCANNOTLOCKCTLDATA,
		PAN_CTLERRCANNOTCREATECTLDATA,
		PAN_CTLERRCANNOTFINDCTLDATA,

		PAN_CTLERRCANNOTADDCTLDATA,
		PAN_CTLERRCANNOTFINDDLL,
		PAN_CTLERRCANNOTLOADDLL,
		PAN_CTLERRCANNOTGETPROCADDRESS,
		PAN_CTLERRCANNOTCREATEWINDOW,
		PAN_CTLERRCANNOTREGISTERCLASS,
		PAN_CTLERRCANNOTCREATECONTROL,
		PAN_CTLERRCANNOTQUERYFILE,
		PAN_CTLERRCANNOTBEGINFILE,
		PAN_CTLERRCANNOTPROCESSFILE,

		PAN_CTLERRCANNOTENDFILE,
		PAN_CTLERRCANNOTTERMINATEFILE,
		PAN_CTLERRCANNOTMAKEPROCINSTANCE,
		PAN_CTLERRNOTSUPPORTED,
		PAN_CTLERRNOFILESET,
		PAN_CTLERRCANNOTCONFIGURETABLE,
		PAN_CTLERRDLLFAILED,
		PAN_CTLERRCANNOTCREATEMETAFILE,
		PAN_CTLERRBADCLPBRDFMT,

		PAN_CTLERRNOSELSET,
		PAN_CTLERRBADLMBACTION,
		PAN_CTLERRCANNOTGETDC,
		PAN_CTLERRCANNOTCREATEPALETTE,
		PAN_CTLERRCANNOTCREATEOBJECT,
		PAN_CTLERRBADMODE,
		PAN_CTLERRCANNOTCREATEDC,
		PAN_CTLERRCANNOTOPENCLIPBOARD,
		PAN_CTLERRBADMSG,
		PAN_CTLERRCANNOTINITTEXT,

		PAN_CTLERRNOBLOCK,
		PAN_CTLERRNOLAYERS,
		PAN_CTLERRNOVIEW,
		PAN_CTLERRNOXREFS,
		PAN_CTLERRNORESOURCEINFO,
		PAN_CTLERRNO3DMODEL,
		PAN_CTLERRNOVIEWPORTS,
		PAN_CTLERRINTERNAL};

	public enum VCET_messages 
	{
		PM_CTLGETINFO = 1024,
		PM_CTLGETFILEFMTS,
		PM_CTLGETCLPBRDFMTS,
		PM_CTLGETSTATUS,
		PM_CTLGETCAPS,
		PM_CTLSETCAPS,

		PM_CTLGETMODE,
		PM_CTLSETMODE,
		PM_CTLGETLMBACTION,
		PM_CTLSETLMBACTION,
		PM_CTLCLONECONTROL,
		PM_CTLGETFILETYPE,
		PM_CTLGETFILE,
		PM_CTLSETFILE,
		PM_CTLPAINT,
		PM_CTLRENDERONTODC,

		PM_CTLGETNUMPAGES,
		PM_CTLGETPAGE,
		PM_CTLSETPAGE,
		PM_CTLGETPAGESIZE,
		PM_CTLGETROWHEIGHT,
		PM_CTLGETCOLWIDTH,
		PM_CTLSIZE,
		PM_CTLHSCROLL,
		PM_CTLVSCROLL,
		PM_CTLGETNUMSELS,

		PM_CTLGETSELS,
		PM_CTLSETSEL,
		PM_CTLCLEARSELS,
		PM_CTLCOPY,
		PM_CTLGETSTRING,
		PM_CTLGETENTITY,
		PM_CTLSEARCH,
		PM_CTLGETBASEFONT,
		PM_CTLSETBASEFONT,
		PM_CTLCLIENTTOWORLD,

		PM_CTLWORLDTOCLIENT,
		PM_CTLCARETTOWORLD,
		PM_CTLWORLDTOCARET,
		PM_CTLGETVIEWEXTENTS,
		PM_CTLSETVIEWEXTENTS,
		PM_CTLGETOFFSET,
		PM_CTLSETOFFSET,
		PM_CTLGETZOOM,
		PM_CTLSETZOOM,
		PM_CTLROTATE,

		PM_CTLFLIP,
		PM_CTLGETFGBGCOLOR,
		PM_CTLSETFGBGCOLOR,
		PM_CTLGETPALETTE,
		PM_CTLSETPALETTE,
		PM_CTLPALETTECHANGED,
		PM_CTLQUERYNEWPALETTE,
		PM_CTLVALIDATEMARGINS,
		PM_CTLPRINTPREVIEW,
		PM_CTLPRINT,

		PM_CTLREGEN,
		PM_CTLGETRESOURCEINFOSTATE,
		PM_CTLGETXREFSTATE,
		PM_CTLSETXREFSTATE,
		PM_CTLGETLAYERSTATE,
		PM_CTLSETLAYERSTATE,
		PM_CTLGETBLOCKNAMES,
		PM_CTLSETBLOCK,
		PM_CTLGETBLOCK,
		PM_CTLGETVIEWNAMES,

		PM_CTLSETVIEW,
		PM_CTLGETVIEW,
		PM_CTLGETBOOKMARKS,
		PM_CTLSETBOOKMARKS,
		PM_CTLABORT,                    /* Unused */
		PM_CTLDESTROYDESCENDENTS,
		PM_CTLDESTROY,
		PM_CTLGETCARETPOS,
		PM_CTLSETCARETPOS,
		PM_CTLGETDIMS,

		PM_CTLSORT,
		PM_CTLSETSELCARET,
		PM_CTLMULTISEARCH,
		PM_CTLCONVERT,
		PM_CTLGETIMAGEEX,
		PM_CTLSETIMAGEEX,
		PM_CTLGETOVERLAYS,
		PM_XFRMRECT,
		PM_CTLFLUSH,
		PM_CTLSETDEVICE,

		PM_CTLGETDEVICE,
		PM_CTLSHOWENTITY,
		PM_CTLGETPROFILENAME,
		PM_CTLSETPROFILENAME,
		PM_CTLGETLINESTYLETABLE,
		PM_CTLDETECTCOLLISION,
		PM_CTLSETLIGHT,
		PM_CTLGETLIGHT,	

		PM_CTLGETTREE,
		PM_CTLGETMASSPROPS,
		PM_CTLSETCAMERA,
		PM_CTLGETCAMERA,
		PM_CTLGETSECTIONINGPLANE,
		PM_CTLSETSECTIONINGPLANE,
		PM_CTLGETTRANSFORM,
		PM_CTLSETTRANSFORM,
		PM_CTLGETOPTION,
		PM_CTLSETOPTION,

		PM_CTLSETSELENTITY,
		PM_CTLGETMINDISTANCE,	
		PM_CTLGETSECEDGES,
		PM_CTLGETATTRIBUTE,
		PM_CTLSETATTRIBUTE,
		PM_CTLGETENTITYINFO,
		PM_CTLENUMENTITIES,
		PM_CTLENUMDEFINITIONS, 
		PM_CTLIMPORTFILE,
		PM_CTLHEALING,

		PM_CTLGETPAGEINFO,
		PM_CTLGETLINKS,
		PM_CTLGETROTATION,
		PM_CTLGETFLIP,
		PM_CTLSETPASSWORD,
		PM_CTLGETPASSWORD,
		PM_CTLGETPRINTSETTINGS,
		PMI_CONVERTCOORD,
		PMI_UPDATECTL,
		PMI_EXCEPTION,
		PMI_REALIZEBACKGROUNDPALETTE,

		PMI_SENDNOTIFICATION,
		PMI_CONSUMEEVENT,
		PMI_OVERLAYOBJECT,
		PMI_GETPAGEMINSIZE,
		PMI_CTLGETCLIENTRECT,

		PM_CTLGETIDENTICALPARTS = PMI_GETPAGEMINSIZE + 100,
		PM_CTLCREATEMETAFILE,
		PM_CTLRESTOREMETAFILE};

	[Flags]
	public enum VCET_mode
	{
		PAN_CTLMODEOPAQUE =				0x00000001,
		PAN_CTLMODENOREDRAW =			0x00000002,
		PAN_CTLMODEEXCESSSCROLL =		0x00000004,
		PAN_CTLMODEANISOTROPIC =		0x00000008,
		PAN_CTLMODEDRAGDROP =			0x00000010,
		PAN_CTLMODEINTERRUPTIBLE =		0x00000020,
		PAN_CTLMODESPREADSHEET_NOGRID =	0x00000040,		// Not implemented.

		// Implemented for rendering only.
		PAN_CTLMODEMONOCHROME =			0x00000100,
		PAN_CTLMODEPRESERVECLIP =		0x00000200,
		PAN_CTLMODEPRESERVEPALETTE =	0x00000400,
		PAN_CTLMODEIGNOREMINMARGINS =	0x00000800,

		PAN_CTLMODEPERSPECTIVE =		0x00001000,		// 3D control only.

		PAN_CTLMODESPREADSHEET_NORHEADERS =	0x00002000,		// Do not Show Row headers.
		PAN_CTLMODESPREADSHEET_NOCHEADERS =	0x00004000,		// Do not Show Column headers.
		PAN_CTLMODESPREADSHEET_NOHEADERS = (PAN_CTLMODESPREADSHEET_NORHEADERS | 
											PAN_CTLMODESPREADSHEET_NOCHEADERS),

		PAN_CTLMODERENDERSELECTED =		0x00008000,		// 3D control rendering only.
		// When set, only selected entities are rendered.

		PAN_CTLMODESPREADSHEET_NOFIRSTRCSNAP =	0x00010000,	// Disable snapping to start of first
	
		PAN_CTLMODERENDERTOPRINTER =	0x00020000};
							
														


	/// <summary>
	/// Summary description for PAN_Point.
	/// </summary>
	[StructLayout(LayoutKind.Sequential)]
	public struct PAN_Point
	{
		public double x;
		public double y;
		public double z;
	}

	/// <summary>
	/// Summary description for PAN_CtlRange.
	/// </summary>
	[StructLayout(LayoutKind.Sequential)]
	public struct PAN_CtlRange
	{
		public PAN_Point min;
		public PAN_Point max;
	}
}
