/*
**	Source listing for the DEMO program.
**	Copyright Oracle, 1993-2008, all rights reserved.
** demo.cpp : Defines the class behaviors for the application.
*/

#include "stdafx.h"

#include "demo.h"

#include "mainfrm.h" 
#include "demodoc.h"
#include "demoview.h"
#include "msghndl.h"	// declaration of the defaultBG/FGcolor and CWndOut class
#include "define.h" 
#include "outwnd.h"

#include "pctl.h"	  		// Control library public header file
#undef MoveTo

#include <stdarg.h>



#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

Public WNDPROC lpfnNotifyProc;


/////////////////////////////////////////////////////////////////////////////
#if	0
#if	TARGET == WIN32S || defined(_WIN64)
//  If this is not here, the WIN32S linker gives an undefined extern error.
#ifdef __cplusplus
extern "C" {
#endif
#ifdef	_MT
#undef	_doserrno
_CRTIMP unsigned long * __cdecl _doserrno(void)
{
	return 0L;
}
#else	/* ndef _MT */
_CRTIMP unsigned long _doserrno = 0L; 	/* OS system error value */
#endif	/* _MT */
#ifdef __cplusplus
}
#endif
#endif	/* TARGET == WIN32S || defined(_WIN64) */
#endif	/* 0 */
/////////////////////////////////////////////////////////////////////////////




//CWndOut * pWndOut; 
/////////////////////////////////////////////////////////////////////////////
// CDemoApp

BEGIN_MESSAGE_MAP(CDemoApp, CWinApp)
	//{{AFX_MSG_MAP(CDemoApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	//ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Global help commands
	ON_COMMAND(ID_HELP_INDEX, CWinApp::OnHelpIndex)
	ON_COMMAND(ID_HELP_USING, CWinApp::OnHelpUsing)
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemoApp construction

CDemoApp::CDemoApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CDemoApp object

CDemoApp NEAR theApp;

/////////////////////////////////////////////////////////////////////////////
// CDemoApp initialization

BOOL CDemoApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.
	m_pszProfileName = strdup("pctldemo.ini");
	m_pszHelpFilePath = strdup("..\\docs\\vcet.hlp");

	SetDialogBkColor();  			// set dialog background color to gray
	LoadStdProfileSettings();  		// Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	AddDocTemplate(new CMultiDocTemplate(IDR_DEMOTYPE,
			RUNTIME_CLASS(CDemoDoc),
			RUNTIME_CLASS(CMyMDIChildWnd),		// standard MDI child frame
			RUNTIME_CLASS(CDemoView)));

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;

	// Initialise the controls
	PAN_LoadControls(NULL, NULL);

	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();
	m_pMainWnd = pMainFrame; 

	// create a new (empty) document
	OnFileNew();

	// instanciate notification procedure
	*((FARPROC FAR*) &lpfnNotifyProc) =
		MakeProcInstance((FARPROC) NotifyWndProc, AfxGetInstanceHandle());

	if (lpfnNotifyProc == NULL) {
		::MessageBox((HWND) 0, "Cannot make procedure instance!", "INFO", MB_ICONINFORMATION);
		return FALSE;
	}

	if (m_lpCmdLine[0] != '\0')
	{
		// TODO: add command line processing here
	}
	return TRUE;
}

CDemoView* CDemoApp::GetCurrentView()
//
// This global function is used to get a pointer to the active view
// object.
{
	CMainFrame* pFrame = (CMainFrame*) m_pMainWnd;
	CMDIChildWnd* pChildWnd = pFrame->MDIGetActive();
	if (pChildWnd == NULL){
		return NULL;
	}

	CDemoView* pView = (CDemoView*)(pChildWnd->GetActiveView());
	return pView;
}

int CDemoApp::ExitInstance()
{
	// Free the controls
	PAN_FreeControls();

	// free notify proc
	if (lpfnNotifyProc != NULL) {
		FreeProcInstance( (FARPROC) lpfnNotifyProc);
	}
	return CWinApp::ExitInstance();
}

/*
** Notification procedure for controls.
*/
#if TARGET==WIN16
Public LRESULT __loadds CALLBACK
#else
Public LRESULT CALLBACK
#endif
	NotifyWndProc(HWND hwnd, UINT msg, WPARAM wp, LPARAM lp)
{								   
	PAN_MANAGE_MFCSTATE

	CDemoApp* pApp= (CDemoApp*) AfxGetApp();
	if (pApp == NULL){
		return 0;
	}

	CDemoView* pView = pApp->GetCurrentView();
	if (pView == NULL){
		return 0;
	}

	CDemoDoc* pDoc = pView->GetDocument();
	if (pDoc == NULL){
		return 0;
	}

	switch (msg) {
	  case PNM_CTLSETFOCUS: 
		pView->m_pWndOut->SendToOutput("NOTIFICATION: PNM_CTLSETFOCUS");
		break;

	  case PNM_CTLSTATUS: 
		{
			char tmpBuf[64] = "";

			if ((DWORD) lp & PAN_CTLSTATUSPROCESSING) {
				_fstrcat(tmpBuf, "Processing... ");
			}
			if ((DWORD) lp & PAN_CTLSTATUSREGENERATING) {
				_fstrcat(tmpBuf, "Reading... ");
			}
			if ((DWORD) lp & PAN_CTLSTATUSREFRESHING) {
				_fstrcat(tmpBuf, "Refreshing...");
			}
			if (*tmpBuf == 0) {
				_fstrcat(tmpBuf, "Idle");
			}
			pView->m_pWndOut->SendToOutput("Status: %s", (LPCSTR) tmpBuf);
		}
		break;

	  case PNM_CTLSETSEL: 
		pView->m_pWndOut->SendToOutput("NOTIFICATION: PNM_CTLSETSEL");
		break;

	  case PNM_CTLSETVIEWEXTENTS:
		pView->m_pWndOut->SendToOutput("NOTIFICATION: PNM_CTLSETVIEWEXTENTS");
		break;

	  case PNM_CTLSEARCH: 
		pView->m_pWndOut->SendToOutput("NOTIFICATION: PNM_CTLSEARCH");
		break;

	  case PNM_CTLPAINT: 
		pView->m_pWndOut->SendToOutput("NOTIFICATION: PNM_CTLPAINT");
		pView->RedrawHndlRgn();   
		break;

	  case PNM_CTLSIZE: 
		pView->m_pWndOut->SendToOutput("NOTIFICATION: PNM_CTLSIZE");
		break;				 

	  case PNM_CTLDROPFILE:
	  	{
			pView->m_pWndOut->SendToOutput("NOTIFICATION: PNM_CTLDROPFILE");
			
			LPCSTR pFileName = (LPCSTR) lp;
			if (pFileName == NULL) {
				break;
			}
            CPanCtRgn* pRgn	= pDoc->FindRgn(hwnd);
			WORD fileNum = (WORD) wp;
			if (fileNum == 0) {
				// First file.
				if (pRgn != NULL) {
					pRgn->LoadCtrlData((LPSTR) pFileName);
				}
			} else {
				// Remaining files.
			}                               
			if ( pRgn != NULL ) {
				pDoc->Select( pRgn );	                           
			}
		}
		break;

	  case PNM_CTLARCFILE: 
	  	{ 
		LPCSTR lpFileName = (LPCSTR) lp;
			if (lpFileName == NULL) {
				break;
			}
			pView->m_pWndOut->SendToOutput("NOTIFICATION: PNM_CTLARCFILE");
			pView->m_pWndOut->SendToOutput("     File %s was extracted\n", lpFileName );
		}
		break;

	  case PNM_CTLHSCROLL: 
		pView->m_pWndOut->SendToOutput("NOTIFICATION: PNM_CTLHSCROLL");
		break;

	  case PNM_CTLVSCROLL: 
		pView->m_pWndOut->SendToOutput("NOTIFICATION: PNM_CTLVSCROLL");
		break;

	  case PNM_CTLDESTROY: 
		pView->m_pWndOut->SendToOutput("NOTIFICATION: PNM_CTLDESTROY");
		break;

	  case PNM_CTLHELPSTRING: 
		if (lp && *(LPSTR)lp && _fstricmp((LPSTR)lp, " ")) {
			pView->m_pWndOut->SendToOutput("NOTIFICATION: [%s]", (LPSTR)lp);
		}
		break;

	  case PNM_CTLPRINTINGPAGE: 
		pView->m_pWndOut->SendToOutput("NOTIFICATION: PNM_PRINTINGPAGE");
		break;				 

	  case PNM_CTLPRINT: 
		pView->m_pWndOut->SendToOutput("NOTIFICATION: PNM_PRINT");
		break;				 

	  case PNM_CTLPROCESSINGPAGE: 
	  	{
	  	LPWORD ap = (LPWORD)lp;
		pView->m_pWndOut->SendToOutput("NOTIFICATION: PNM_CTLPROCESSINGPAGE");
		pView->m_pWndOut->SendToOutput("    phys  page: %d", ap[0]);
		pView->m_pWndOut->SendToOutput(" nb phys pages: %d", ap[1]);
		pView->m_pWndOut->SendToOutput("  logical page: %d", ap[2]);
		pView->m_pWndOut->SendToOutput(" nb log. pages: %d", ap[3]);
	        }
		break; 
	
	  case PNM_CTLOBJECT:
	  	{
	  	LPPAN_OBJECT lpObj = (LPPAN_OBJECT)lp;
	  	
	  	pView->m_pWndOut->SendToOutput("NOTIFICATION: PNM_CTLOBJECT");
		if (lpObj == NULL) {
			pView->m_pWndOut->SendToOutput("Did not receive object!");
			break;
		}	
		switch (lpObj->ObjectType) {
		   case OVERLAY_OBJECT     : pView->m_pWndOut->SendToOutput("    type: not an OLE"); break;
		   case OLE_OBJECT_STATIC  : pView->m_pWndOut->SendToOutput("    type: STATIC"    ); break;
		   case OLE_OBJECT_LINKED  : pView->m_pWndOut->SendToOutput("    type: LINKED"    ); break;
		   case OLE_OBJECT_EMBEDDED: pView->m_pWndOut->SendToOutput("    type: EMBEDDED"  ); break;
		}
		
		pView->m_pWndOut->SendToOutput("    name: %s", lpObj->filename);   
		}
		break;
	}
	return 0;
}			 

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CDemoApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

