/*
**	Source listing for the DEMO program.
**	Copyright Oracle, 1993-2008, all rights reserved. 
**
**	This file define the code of the DEMO document class:
** demodoc.cpp : implementation of the CDemoDoc class
*/

#include "stdafx.h"
#include "demo.h"

#include "demodoc.h"
#include "demoview.h"
#include "define.h"
#include "msghndl.h"

#include "pctl.h"				// Control library public header file
#undef MoveTo

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/*
**  Function defined in msghndl.cpp:
*/
extern	int	DemoSetHDCMode(HDC hdc, HWND hwndCtl, LPRECT lpRect, int type, PAN_CtlRange FAR *rg);

/////////////////////////////////////////////////////////////////////////////
// CDemoDoc

IMPLEMENT_DYNCREATE(CDemoDoc, CDocument)

BEGIN_MESSAGE_MAP(CDemoDoc, CDocument)
	//{{AFX_MSG_MAP(CDemoDoc)
	ON_COMMAND(ID_VIEW_AUTOUPDATE, OnViewAutoupdate)
	ON_UPDATE_COMMAND_UI(ID_VIEW_AUTOUPDATE, OnUpdateViewAutoupdate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemoDoc construction/destruction

//------------------------------------------------------------------------------
CDemoDoc::CDemoDoc()
{
	// Initialize private member variables.
	m_pList			= NULL;
	m_pCurRgn		= NULL;
	m_wAvaileableId		= 1000;
	m_nMode			= IDNOP;
        autoRepaint             = TRUE;
	
	TRY {
		m_pList = new CObList;
	} CATCH(CMemoryException, memEx) {
		AfxMessageBox("Out of Memory");
	} END_CATCH
}

//------------------------------------------------------------------------------
CDemoDoc::~CDemoDoc()
{
	if (m_pList != NULL) {
		for (POSITION pos = m_pList->GetHeadPosition(); pos != NULL; ) {
			CPanCtRgn* pRgn = (CPanCtRgn*) m_pList->GetNext(pos);
			if (pRgn != NULL) {
				delete pRgn;
			}
		}
		m_pList->RemoveAll();
		delete m_pList;
	}
}

//------------------------------------------------------------------------------
void CDemoDoc::InitDocument()
{  
	SetMode(IDNOP);
}

//------------------------------------------------------------------------------
BOOL CDemoDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument()) {
		return FALSE;
	}

	InitDocument();
	return TRUE;
} 

//------------------------------------------------------------------------------
BOOL CDemoDoc::OnOpenDocument(const char* pszPathName)
{
	if (!CDocument::OnOpenDocument(pszPathName)) {
		return FALSE;
	}

	InitDocument();
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CDemoDoc serialization

//------------------------------------------------------------------------------
void CDemoDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{			   
		// TODO: add loading code here
	}
}

//------------------------------------------------------------------------------
/*
** Delete the given region if not NULL.  Otherwise, delete the current region.
*/								   
void CDemoDoc::Delete(CPanCtRgn* rgn)
{
	if (m_pList->IsEmpty()) {
		return;
	}  
	if (rgn == NULL) {
		rgn = m_pCurRgn;
	}

	for (POSITION tmpPos, pos = m_pList->GetHeadPosition(); (tmpPos = pos) != NULL; ) {
		if ((CPanCtRgn*) m_pList->GetNext(pos) == rgn) {
			// Deselect region.
			if (rgn == m_pCurRgn) {
				Deselect(rgn, FALSE);
			}

			// Remove region from list and delete it.
		 	m_pList->RemoveAt(tmpPos);
	   		delete rgn;
	   		break;
	   	}
	}
}

//------------------------------------------------------------------------------
/*
** Update all controls intersecting the given rectangle,
** excluding the given region.
** Parameter fParts can be one of UR_CONTROL, UR_HANDLES, or UR_BOTH.
*/
void CDemoDoc::UpdateRect(CRect* pRect, CPanCtRgn* pExcludedRgn, int fParts)
{
	if (m_pList->IsEmpty()) {
		return;
	} // if

	// Get current view.
	CDemoView* pView = GetCurrentView();

	// Traverse list of regions.
	for (POSITION pos = m_pList->GetHeadPosition(); pos != NULL; ) {
		CPanCtRgn* pRgn = (CPanCtRgn*) m_pList->GetNext(pos);
		if (pRgn != NULL && pRgn != pExcludedRgn) {
			CRect innerRect = *pRect;
			CRect outerRect;

			HWND hView	= pView->GetSafeHwnd();
			HWND hCtl	= pRgn->GetCtlHandle();

			::UpdateWindow(hCtl);

			switch (fParts) {
			  case UR_CONTROL:
			  	::MapWindowPoints(hView, hCtl, (LPPOINT) (LPRECT) innerRect, 2);
			  	::InvalidateRect(hCtl, innerRect, TRUE);
				break;

			  case UR_HANDLES:
				outerRect = pView->GetOuterRect(innerRect);
			  	::MapWindowPoints(hView, hCtl, (LPPOINT) (LPRECT) innerRect, 2);
			  	::MapWindowPoints(hView, hCtl, (LPPOINT) (LPRECT) outerRect, 2);
				::InvalidateRect(hCtl, outerRect, TRUE);
				::ValidateRect(hCtl, innerRect);
				break;

			  case UR_BOTH:
				outerRect = pView->GetOuterRect(innerRect);
			  	::MapWindowPoints(hView, hCtl, (LPPOINT) (LPRECT) outerRect, 2);
				::InvalidateRect(hCtl, outerRect, TRUE);
				break;
			} // switch

			::UpdateWindow(hCtl);
		} // if
	} // for

} // CDemoDoc::UpdateRect

//------------------------------------------------------------------------------
/*
** Select the given region.
*/
void CDemoDoc::Select(CPanCtRgn* pRgn)
{
	if (pRgn == NULL) {
		return;
	} // if

	if (m_pCurRgn != NULL) {
		Deselect(m_pCurRgn, TRUE);
	}

	// Select region.
	m_pCurRgn = pRgn;
	pRgn->SetSelected(TRUE);

	// Draw active border.
	UpdateAllViews(NULL, 0, (CObject*) pRgn);

#if	0
	// Enable control capabilities.
	pRgn->Enable(pRgn->GetCurCaps());
	pRgn->ChangeLMB(pRgn->GetCurLMB());
#endif	/* 0 */
}

//------------------------------------------------------------------------------
/*
** Deselect the given region.
*/
void CDemoDoc::Deselect(CPanCtRgn* pRgn, BOOL fDrawBorder)
{
	if (pRgn == NULL) {
		return;
	} // if

#if	0
	// Save current capabilities and mouse action.
	pRgn->SetCurCaps();
	pRgn->SetCurLMB();
	
	// Disable mouse, keyboard, and scrolling capabilities.
	pRgn->Disable(PAN_CTLCAPSMOUSE);
	pRgn->Disable(PAN_CTLCAPSKEYBD);
	pRgn->Disable(PAN_CTLCAPSHSCROLL | PAN_CTLCAPSVSCROLL);
	pRgn->ChangeLMB(PAN_CTLLMBNONE);
#endif	/* 0 */

	// Erase active border.
	pRgn->SetDrawMode(FALSE);
	UpdateAllViews(NULL, 0, (CObject*) pRgn);
	pRgn->SetDrawMode(TRUE);

	// Deselect region.
	m_pCurRgn = NULL;
	pRgn->SetSelected(FALSE);
	GetCurrentView()->SetFocus();

	if (fDrawBorder) {
		// Draw inactive border.
		UpdateAllViews(NULL, 0, (CObject*) pRgn);
	}

} // CDemoDoc::Deselect

//------------------------------------------------------------------------------
/*
** Find the region associated with the given control window handle.
*/
CPanCtRgn* CDemoDoc::FindRgn(HWND hwnd)
{
	CPanCtRgn* pRgn = NULL;

	for (POSITION pos = m_pList->GetHeadPosition(); pos != NULL; ) {
		pRgn = (CPanCtRgn*) m_pList->GetNext(pos);
		if (pRgn != NULL && pRgn->GetCtlHandle() == hwnd) {
			break;
		}
	}
	return pRgn;
}

//------------------------------------------------------------------------------
/*
** Find the region under the given point.
** Return NULL if no region is found.
** Return the previously selected region in parameter ppOldRgn.
*/
CPanCtRgn* CDemoDoc::FindPickedRgn(CPoint pt, CPanCtRgn** ppOldRgn)
{
	*ppOldRgn = m_pCurRgn;

	if (m_pList->IsEmpty()) {
		return NULL;
	} // if

	CPanCtRgn* pNewCurRgn = NULL;

	// Check whether user clicked on current region.
	if (m_pCurRgn != NULL) {
		
		// Ignore points outside outer rectangle.
		int handle = m_pCurRgn->IsPickPointOverHandles(pt);
		if (handle != IDNONE) {
			pNewCurRgn = m_pCurRgn;
			pNewCurRgn->SetActiveHandle(handle);
		} // if
	} // if

	// Otherwise, check all other regions.
	if (pNewCurRgn == NULL) {
		for (POSITION pos = m_pList->GetHeadPosition(); pos != NULL; ) {
			CPanCtRgn* pRgn = (CPanCtRgn*) m_pList->GetNext(pos);
			if (pRgn == NULL) {
				continue;
			} // if

			int handle = pRgn->IsPickPointOverHandles(pt);
			if (handle != IDNONE) {
				pNewCurRgn = pRgn;
				pNewCurRgn->SetActiveHandle(handle);
			} // if
		} // for
	} // if

	return pNewCurRgn;

} // CDemoDoc::FindPickedRgn

//------------------------------------------------------------------------------
/*
** Disable the given capabilities for all controls in the list.
*/
void CDemoDoc::DisableAll(DWORD caps)
{
	if (m_pList == NULL) {
		return;
	}

	if (m_pList->IsEmpty()) {
		return;
	}

	for (POSITION pos = m_pList->GetHeadPosition(); pos!=NULL; ) {
		CPanCtRgn* pRgn = (CPanCtRgn*) m_pList->GetNext(pos);
		if (pRgn != NULL) {
			pRgn->Disable(caps);
		}
	}
}

//------------------------------------------------------------------------------
/*
** Enable the given capabilities for all controls in the list.
*/
void CDemoDoc::EnableAll(DWORD caps)
{   
	if (m_pList == NULL) {
		return;
	}

	if (m_pList->IsEmpty()) {
		return;
	}
	
	for (POSITION pos = m_pList->GetHeadPosition(); pos!=NULL; ) {
		CPanCtRgn* pRgn = (CPanCtRgn*) m_pList->GetNext(pos);
		pRgn->Enable(caps);		   
	}
}   

//------------------------------------------------------------------------------
/*
** Set the given mouse action for all controls in the list.
*/
void CDemoDoc::ChangeLMBAll(WORD lmb)
{   
	if (m_pList == NULL) {
		return;
	}

	if (m_pList->IsEmpty()) {
		return;
	}

	for (POSITION pos = m_pList->GetHeadPosition(); pos!=NULL; ) {
		CPanCtRgn* pRgn = (CPanCtRgn*) m_pList->GetNext(pos);
		if (pRgn != NULL) {
			pRgn->ChangeLMB(lmb);
		}
	}
}					 

/*------------------------------------------------------------------------------
** Render each region onto the given printer device context.
**
** NOTE: Empty regions, i.e. those for which no file has been set,
**       are not rendered.
*/
BOOL CDemoDoc::PrintAll(CDC* pDC)
{
	if (m_pList->IsEmpty()) {
		return FALSE;		   
	}

	/*
	** Get printer page width and height.
	*/
	int pxi = pDC->GetDeviceCaps(HORZRES);
	int pyi = pDC->GetDeviceCaps(VERTRES);

	/*
	** Get view area to print.
	*/
	CDemoView* pView = GetCurrentView();
	CRect viewRect;
	pView->GetClientRect(&viewRect);

	/*
	** Calculate scaling factors.
	*/
	float fx = ((float) pxi) / viewRect.right;
	float fy = ((float) pyi) / viewRect.bottom;
	float f  = min(fx, fy);

	/*
	** Scale view area.
	*/
	viewRect.left   = (int) (f * viewRect.left);
	viewRect.top    = (int) (f * viewRect.top);
	viewRect.right  = (int) (f * viewRect.right);
	viewRect.bottom = (int) (f * viewRect.bottom);

	/*
	** Draw view area frame.
	*/
	pDC->Rectangle(&viewRect);

	/*
	** Draw shadow effect.
	*/
	for (int i = 1; i < 8; ++i) {
		viewRect.right--; viewRect.bottom--;
		pDC->Rectangle(&viewRect);
	}

  	/*
  	** Render each region.
  	*/
	for (POSITION pos = m_pList->GetHeadPosition(); pos != NULL; ) {
		CPanCtRgn* pRgn = (CPanCtRgn*) m_pList->GetNext(pos);

		/*
		** Skip region if no file has been set.
		*/
		if (! pRgn->GetHasFile()) {
			continue;
		}

		/*
		** Get region rectangle.
		*/
		CRect ctlRect = pRgn->GetInnerRect();

		/*
		** Initialize control render options.
		*/
		PAN_CtlRenderOptions renderOptions;
		memset(&renderOptions, 0, sizeof (PAN_CtlRenderOptions));
		renderOptions.hdc            = pDC->m_hDC;
		renderOptions.devRect.left   = (int) (f * ctlRect.left);
		renderOptions.devRect.top    = (int) (f * ctlRect.top);
		renderOptions.devRect.right  = (int) (f * ctlRect.right);
		renderOptions.devRect.bottom = (int) (f * ctlRect.bottom);
		renderOptions.mode           = PAN_CTLMODEOPAQUE;

		::SendMessage(pRgn->GetCtlHandle(), PM_CTLGETVIEWEXTENTS,
			0, (LPARAM) (PAN_CtlRange FAR*) &renderOptions.source);

		::SendMessage(pRgn->GetCtlHandle(), PM_CTLRENDERONTODC, 0,
			(LPARAM) (PAN_CtlRenderOptions FAR*) &renderOptions);
	}						 
	return TRUE;		  
}									 

/////////////////////////////////////////////////////////////////////////////
// CDemoDoc diagnostics

#ifdef _DEBUG
void CDemoDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CDemoDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}

#endif //_DEBUG

void CDemoDoc::OnViewAutoupdate()
{
	if (autoRepaint == TRUE) autoRepaint = FALSE; else autoRepaint = TRUE;
}

void CDemoDoc::OnUpdateViewAutoupdate(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck(autoRepaint);
}
