/*
**	Source listing for the DEMO program.
**	Copyright Oracle, 1993-2008, all rights reserved.
** demodoc.h : Interface definitions.
*/

#include "pctl.h"
/////////////////////////////////////////////////////////////////////////////
class CDemoView;

//------------------------------------------------------------------------------
class CHndlRgn : public CObject
{      
public:
	// Constructors.
	CHndlRgn();
	
	// Destructor.
	virtual ~CHndlRgn();
	
	// Manipulators.
	void	SetInnerRect(CRect rc)			{ m_rcInnerRect		= rc; }
	void	SetDrawMode(BOOL nMode)			{ m_nDrawMode		= nMode; }
	void	SetSelected(BOOL bSelected)		{ m_nSelected		= bSelected; }

	void	SetActiveHandle(int nActiveHandle)	{ m_nActiveHandle	= nActiveHandle; }

	// Accessors.
	CRect	GetInnerRect()				{ return m_rcInnerRect; }
	CRect	GetOuterRect();
	BOOL	GetDrawMode()				{ return m_nDrawMode; }
	BOOL	GetSelected()				{ return m_nSelected; }

	int	GetActiveHandle()			{ return m_nActiveHandle; }
	CRect	GetHandle(int nHandle);

 	int	IsPickPointOverHandles(CPoint point);

protected:
	CRect	m_rcInnerRect;		// Region rectangle.
	CRect	m_rcOldInnerRect;
	int	m_nActiveHandle;	// Active handle number.
	BOOL	m_nSelected;		// TRUE if region is selected.
	BOOL	m_nDrawMode;		// TRUE if handles are drawn, FALSE if they are erased.
};				

//------------------------------------------------------------------------------
class CPanCtRgn : public CHndlRgn
{
public:
	// Constructors.
	CPanCtRgn(CView* pView, WORD ID, CRect* rc);
        
        // Destructor.
        ~CPanCtRgn();

	// Manipulators.
	void	SetCtlHandle(HWND hWnd)		{ m_hCtl	= hWnd; }
	void	SetCtlID(WORD wId)		{ m_wCtlId	= wId; }
	void	SetHasFile(BOOL bHasFile)	{ m_nHasFile	= bHasFile; }
	void	SetSelected(BOOL nSelected);

	void	LoadCtrlData(char *fname);
	void	Print();
	void	Convert();
	void	Search();
	void	GetString();
	void	GetEntity();

	void	Disable(DWORD caps);
	void	Enable(DWORD caps);		
	void	ChangeLMB(WORD lmb);

	void	SetCurCaps();
	void	SetCurLMB();

	// Accessors.        
	HWND	GetCtlHandle()			{ return m_hCtl; }
	BOOL	GetSelected()			{ return m_nSelected; }
	BOOL	GetHasFile()			{ return m_nHasFile; }

	BOOL	AcceptCaps(DWORD caps);
	BOOL	AcceptLMB(WORD lmb);

	DWORD	GetCurCaps()			{ return m_curCaps; }
	WORD	GetCurLMB()			{ return m_curLMB; }
	
private:  
	HWND	m_hCtl;		// Control window handle.
	WORD	m_wCtlId;	// Child control window ID.

	BOOL	m_nHasFile;	// TRUE if control contains a file.
	DWORD	m_curCaps;	// Current control capabilities.
	WORD	m_curLMB;	// Current control mouse action,

	PAN_CtlSearchInfo m_si;
};

//------------------------------------------------------------------------------

// Flags used with CDemoDoc::UpdateRect().
#define UR_CONTROL	0
#define UR_HANDLES	1
#define UR_BOTH		2

class CDemoDoc : public CDocument
{
protected: // create from serialization only
	CDemoDoc();
	DECLARE_DYNCREATE(CDemoDoc)
	CDemoDoc* 		GetDocument();    

// Operations
public:                            
	CObList* 		GetPanRgnList()	      { return m_pList; }	
// Attributes
public:
	void			DisableAll(DWORD caps);
	void			EnableAll(DWORD caps);
	void			ChangeLMBAll(WORD lmb);

	CPanCtRgn*		FindRgn(HWND hwnd);
	CPanCtRgn*		FindPickedRgn(CPoint pt, CPanCtRgn** ppOldRgn);
	void 			Delete(CPanCtRgn* rgn);
	void			UpdateRect(CRect* pRect, CPanCtRgn* pExcludedRgn, int flag);
	void			Select(CPanCtRgn* pRgn);
	void			Deselect(CPanCtRgn* pRgn, BOOL fDrawBorder);

	BOOL			IsEmpty()		{ return m_pList->IsEmpty(); }
	WORD			GetCtrlID()		{ return m_wAvaileableId++; }
	CPanCtRgn* 		GetCurrRgn()		{ return m_pCurRgn; }

	BOOL			PrintAll(CDC* dc);

	BOOL			GetMode()		{ return m_nMode; }
	void			SetMode(BOOL nMode)	{ m_nMode = nMode; }

	BOOL			autoRepaint;	
protected:
	CObList*   		m_pList;		// List of regions.
	CPanCtRgn* 		m_pCurRgn;		// Currently selected region.
	WORD			m_wAvaileableId;	// Next child control window ID.
	int			m_nState;		// Document state.
	int			m_nMode;

// Implementation
public:
	virtual ~CDemoDoc();
	virtual void Serialize(CArchive& ar);	// overridden for document i/o
#ifdef _DEBUG
	virtual	void AssertValid() const;
	virtual	void Dump(CDumpContext& dc) const;
#endif

protected:
	        void    InitDocument();
	virtual	BOOL	OnNewDocument();  
	virtual BOOL 	OnOpenDocument(const char* pszPathName);

// Generated message map functions
protected:
	//{{AFX_MSG(CDemoDoc)
	afx_msg void OnViewAutoupdate();
	afx_msg void OnUpdateViewAutoupdate(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()	
};

/////////////////////////////////////////////////////////////////////////////
			
