/*
**	Source listing for the DEMO program.
**	Copyright Oracle, 1993-2008, all rights reserved.
**
**	This module will handle all the messages for the application.
**  demoview.cpp : implementation of the CDemoView class
*/
#include "stdafx.h"
#include <commdlg.h>
#include <string.h>

#include "pctl.h"				// Control library public header file

#include "demo.h"
#include "mainfrm.h"
#include "define.h"
#include "diags.h"
#include "outwnd.h"

#undef MoveTo

#include "demodoc.h"
#include "demoview.h"


//--------------------------------------------------------------------------
// define 6 default file extensions for the 6 supported file types of the
// PAN controls.
static char filters[7][30] = {
	"All files   (*.*  )\0*.*\0",		// all		 file 24 char
	"WP Graphics (*.WPG)\0*.WPG\0",		// vector	  file 26 char
	"PCX files   (*.PCX)\0*.PCX\0",		// raster	  file 26 char
	"Ascii text  (*.TXT)\0*.TXT\0",		// text		file 26 char
	"Paradox	 (*.DB )\0*.DB\0",		// database	file 25 char
	"Quattro	 (*.WB1)\0*.WB1\0",		 // spreadsheet file 26 char
	"Pkzip files (*.ZIP)\0*.ZIP\0\0"};	// archive	 file 27 char

static char	custFilter[60] = "\0*.*\0\0";


// --------------------------------------------------------------------------
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDemoView
//
IMPLEMENT_DYNCREATE(CDemoView, CView)

BEGIN_MESSAGE_MAP(CDemoView, CView)
	//{{AFX_MSG_MAP(CDemoView)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_SETCURSOR()
	ON_WM_KEYUP()
	ON_MESSAGE(WM_QUERYNEWPALETTE, OnQueryNewPalette)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_FILE_CREATECONTROL, OnFileCreateCtl)
	ON_COMMAND(ID_FILE_DESTROYCONTROL, OnFileDestroyCtl)
	ON_COMMAND(ID_FILE_PRINTCONTROL, OnFilePrintctl)
	ON_COMMAND(ID_FILE_CONVERTCONTROL, OnFileConvertctl)
	ON_COMMAND(ID_FILE_CONVERT, OnFileConvertdoc)
	ON_COMMAND(ID_EDIT_ZOOM, OnEditZoom)
 	ON_COMMAND(ID_EDIT_SELANDCOPY, OnEditSelandcopy)
	ON_COMMAND(ID_EDIT_SEARCH, OnEditSearch)
	ON_COMMAND(ID_EDIT_SELECT, OnEditSelect)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_COMMAND(ID_VIEW_SCROLL, OnViewScroll)
	ON_UPDATE_COMMAND_UI(ID_FILE_OPEN, OnUpdateFileOpen)
	ON_UPDATE_COMMAND_UI(ID_FILE_CREATECONTROL, OnUpdateFileCreateCtl)
	ON_UPDATE_COMMAND_UI(ID_FILE_DESTROYCONTROL, OnUpdateFileDestroyCtl)
	ON_UPDATE_COMMAND_UI(ID_FILE_PRINTCONTROL, OnUpdateFilePrintctl)
	ON_UPDATE_COMMAND_UI(ID_FILE_CONVERTCONTROL, OnUpdateFileConvertctl)
	ON_UPDATE_COMMAND_UI(ID_FILE_CONVERT, OnUpdateFileConvertdoc)
	ON_UPDATE_COMMAND_UI(ID_EDIT_ZOOM, OnUpdateEditZoom)
	ON_UPDATE_COMMAND_UI(ID_EDIT_SELANDCOPY, OnUpdateEditSelandcopy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_SEARCH, OnUpdateEditSearch)
	ON_UPDATE_COMMAND_UI(ID_EDIT_SELECT, OnUpdateEditSelect)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateEditCopy)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SCROLL, OnUpdateViewScroll)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLCLEARSELS, OnSendmessagePmctlclearsels)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLCLIENTTOWORLD, OnSendmessagePmctlclienttoworld)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLCLONECONTROL, OnSendmessagePmctlclonecontrol)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLCOPY, OnSendmessagePmctlcopy)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETBASEFONT, OnSendmessagePmctlgetbasefont)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETBLOCK, OnSendmessagePmctlgetblock)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETBLOCKNAMES, OnSendmessagePmctlgetblocknames)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETCAPS, OnSendmessagePmctlgetcaps)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETCLPBRDFMTS, OnSendmessagePmctlgetclpbrdfmts)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETCOLWIDTH, OnSendmessagePmctlgetcolwidth)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETENTITY, OnSendmessagePmctlgetentity)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETFGBGCOLOR, OnSendmessagePmctlgetfgbgcolor)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETFILE, OnSendmessagePmctlgetfile)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETFILEFMTS, OnSendmessagePmctlgetfilefmts)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETIMAGEEX0, OnSendmessagePmctlgetimageex0)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETIMAGEEX1, OnSendmessagePmctlgetimageex1)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETIMAGEEX2, OnSendmessagePmctlgetimageex2)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETINFO, OnSendmessagePmctlgetinfo)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETLAYERSTATE, OnSendmessagePmctlgetlayerstate)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETLMBACTION, OnSendmessagePmctlgetlmbaction)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETMODE, OnSendmessagePmctlgetmode)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETNUMPAGES, OnSendmessagePmctlgetnumpages)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETNUMSELS, OnSendmessagePmctlgetnumsels)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETOFFSET, OnSendmessagePmctlgetoffset)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETPAGE, OnSendmessagePmctlgetpage)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETPAGESIZE, OnSendmessagePmctlgetpagesize)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETRESOURCEINFOSTATE, OnSendmessagePmctlgetresourceinfostate)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETROWHEIGHT, OnSendmessagePmctlgetrowheight)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETSELS, OnSendmessagePmctlgetsels)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETSTATUS, OnSendmessagePmctlgetstatus)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETSTRING, OnSendmessagePmctlgetstring)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETVIEW, OnSendmessagePmctlgetview)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETVIEWEXTENTS, OnSendmessagePmctlgetviewextents)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETVIEWNAMES, OnSendmessagePmctlgetviewnames)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETZOOM, OnSendmessagePmctlgetzoom)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLPRINT, OnSendmessagePmctlprint)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLREGEN, OnSendmessagePmctlregen)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSEARCH, OnSendmessagePmctlsearch)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSETBASEFONT, OnSendmessagePmctlsetbasefont)
 	ON_COMMAND(ID_SENDMESSAGE_PMCTLSETCAPS, OnSendmessagePmctlsetcaps)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSETFGBGCOLOR, OnSendmessagePmctlsetfgbgcolor)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSETFILE, OnSendmessagePmctlsetfile)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSETLMBACTION, OnSendmessagePmctlsetlmbaction)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSETMODE, OnSendmessagePmctlsetmode)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSETOFFSET, OnSendmessagePmctlsetoffset)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSETPAGE, OnSendmessagePmctlsetpage)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSETSEL, OnSendmessagePmctlsetsel)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSETVIEWEXTENTS, OnSendmessagePmctlsetviewextents)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSETZOOM, OnSendmessagePmctlsetzoom)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLWORLDTOCLIENT, OnSendmessagePmctlworldtoclient)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLFLIP_NONE, OnSendmessagePmctlflipNone)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLFLIP_X, OnSendmessagePmctlflipX)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLFLIP_XANDY, OnSendmessagePmctlflipXandy)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLFLIP_Y, OnSendmessagePmctlflipY)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLROTATE_0DEG, OnSendmessagePmctlrotate0deg)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLROTATE_180DEGREES, OnSendmessagePmctlrotate180degrees)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLROTATE_270DEGREES, OnSendmessagePmctlrotate270degrees)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLROTATE_90DEGREES, OnSendmessagePmctlrotate90degrees)
	ON_UPDATE_COMMAND_UI(ID_FILE_PRINT_SETUP, OnUpdateFilePrintSetup)
	ON_UPDATE_COMMAND_UI(ID_FILE_PRINT, OnUpdateFilePrint)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLPAINT, OnSendmessagePmctlpaint)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLCTLDESTROY, OnSendmessagePmctlctldestroy)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLDESTROYDESCENDANTS, OnSendmessagePmctldestroydescendants)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETFILETYPE, OnSendmessagePmctlgetfiletype)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETPALETTE, OnSendmessagePmctlgetpalette)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLHSCROLL, OnSendmessagePmctlhscroll)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLPALETTECHANGED, OnSendmessagePmctlpalettechanged)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLPRINTPREVIEW, OnSendmessagePmctlprintpreview)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLQUERYNEWPALETTE, OnSendmessagePmctlquerynewpalette)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLRENDERONTODC, OnSendmessagePmctlrenderontodc)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSETPALETTE, OnSendmessagePmctlsetpalette)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLVALIDATEMARGINS, OnSendmessagePmctlvalidatemargins)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLVSCROLL, OnSendmessagePmctlvscroll)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSIZE, OnSendmessagePmctlsize)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLMULTISEARCH, OnSendmessagePmctlmultisearch)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLCARETTOWORLD, OnSendmessagePmctlcarettoworld)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETCARETPOS, OnSendmessagePmctlgetcaretpos)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLGETDIMS, OnSendmessagePmctlgetdims)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSETCARETPOS, OnSendmessagePmctlsetcaretpos)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSETSELCARET, OnSendmessagePmctlsetselcaret)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSORT, OnSendmessagePmctlsort)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLWORLDTOCARET, OnSendmessagePmctlworldtocaret)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSETBLOCK, OnSendmessagePmctlsetblock)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSETIMAGEEX, OnSendmessagePmctlsetimageex)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSETLAYERSTATE, OnSendmessagePmctlsetlayerstate)
	ON_COMMAND(ID_SENDMESSAGE_PMCTLSETVIEW, OnSendmessagePmctlsetview)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDemoView construction/destruction

//------------------------------------------------------------------------------
CDemoView::CDemoView()
{
	hwnd		= NULL;
	m_hCurCtl	= NULL;

	m_rc.SetRectEmpty();
	m_rcOld.SetRectEmpty();

	m_ptBeg.x = 0;
	m_ptBeg.y = 0;
	m_ptOld = m_ptBeg;
	m_ptEnd = m_ptBeg;

	m_nScrollMode = FALSE;
	m_nSelectMode = FALSE;
}

//------------------------------------------------------------------------------
CDemoView::~CDemoView()
{
}

//------------------------------------------------------------------------------
int CDemoView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CView::OnCreate(lpCreateStruct) == -1) {
		return (-1);
	}

	TRY {
		m_pWndOut= new CWndOut;
	} CATCH(CMemoryException, memEx) {
		MessageBox("Out of Memory");
		return (-1);
	} END_CATCH

	if (!m_pWndOut->LoadFrame(IDR_OUTTYPE)) {
		MessageBox("Could not create Output Window", NULL, MB_OK | MB_ICONSTOP);
		return (-1);
	}

	m_pWndOut->ShowWindow(SW_SHOWNORMAL);
	return (0);
}

//------------------------------------------------------------------------------
void CDemoView::OnDestroy()
{
	CView::OnDestroy();
}

//------------------------------------------------------------------------------
void CDemoView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint)
{
	CPanCtRgn* pRgn = (CPanCtRgn*) pHint;
	if (pRgn == NULL) {
		Invalidate();
		return;
	}

	CDC* pDC = GetDC();

	if (pDC != NULL) {
		if (pRgn->GetDrawMode()) {
			Draw(pDC, pRgn);
		} else {
			Erase(pDC, pRgn);
		}
		ReleaseDC(pDC);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CDemoView message handlers

//------------------------------------------------------------------------------
//
// This functions is called by the Control notification procedure
// when a redraw of the frame must be done after the control area has been
// repainted.
void CDemoView::RedrawHndlRgn()
{
	CDC* pDC = GetDC();
	if (pDC != NULL) {
		OnDraw(pDC);
		ReleaseDC(pDC);
	}
}

//------------------------------------------------------------------------------
void CDemoView::OnDraw(CDC* pDC)
{
	CDemoDoc* pDoc = GetDocument();
	CObList* pList = pDoc->GetPanRgnList();

	if (pDC->IsPrinting()) {
		pDoc->PrintAll(pDC);
		return;
	}

	if (pList != NULL) {
		// Draw border for each inactive region.
		for (POSITION pos = pList->GetHeadPosition(); pos != NULL; ) {
			CPanCtRgn* pRgn = (CPanCtRgn*) pList->GetNext(pos);
			if (pRgn != NULL && pRgn->GetDrawMode()) {
				Draw(pDC, pRgn);
			}
		}
	}
}

//------------------------------------------------------------------------------
void CDemoView::Draw(CDC* pDC, CPanCtRgn* pRgn)
{
	if (pRgn == NULL) {
		return;
	}

	// Select pen for border.
	CPen* pOldPen = (CPen*) pDC->SelectStockObject(BLACK_PEN);

	if (!pRgn->GetSelected()) {
	        // Select brush for border.
		CBrush* pOldBrush = (CBrush*) pDC->SelectStockObject(NULL_BRUSH);

                // Draw border.
		CRect rcIn = pRgn->GetInnerRect();
		rcIn.InflateRect(1, 1);
		pDC->Rectangle(&rcIn);

		pDC->SelectObject(pOldBrush);
	} else {
	        // Select brush for border.
		CBrush pBrush(HS_FDIAGONAL, RGB(0,0,255));
		CBrush* pOldBrush = (CBrush*) pDC->SelectObject(&pBrush);

	        // Draw hatched border.
		CRect rcIn = pRgn->GetInnerRect();
		CRect rc;

		rc.SetRect(rcIn.left, rcIn.top - HNDLSIZE, rcIn.right, rcIn.top);
		pDC->Rectangle(&rc);

		rc.SetRect(rcIn.left - HNDLSIZE, rcIn.top, rcIn.left, rcIn.bottom);
		pDC->Rectangle(&rc);

		rc.SetRect(rcIn.left, rcIn.bottom, rcIn.right, rcIn.bottom + HNDLSIZE);
		pDC->Rectangle(&rc);

		rc.SetRect(rcIn.right, rcIn.top, rcIn.right + HNDLSIZE, rcIn.bottom);
		pDC->Rectangle(&rc);

		pDC->SelectObject(pOldBrush);

		// Select brush for handles.
		pOldBrush = (CBrush*) pDC->SelectStockObject(BLACK_BRUSH);

	        // Draw handles.
		for (int i =0; i< 8; i++){
	   		rc = pRgn->GetHandle(i);
			pDC->Rectangle(&rc);
		}
		pDC->SelectObject(pOldBrush);
	}
	pDC->SelectObject(pOldPen);
}

//------------------------------------------------------------------------------
void CDemoView::Erase(CDC* pDC, CPanCtRgn* pRgn)
{
	if (pRgn == NULL) {
		return;
	}

	// Use window color to "erase".
	COLORREF rgbBak = GetSysColor(COLOR_WINDOW);

	// Select pen.
	CPen pPen(PS_SOLID, 1, rgbBak);
	CPen* pOldPen = (CPen*) pDC->SelectObject(&pPen);

	CRect rcIn;

	if (!pRgn->GetSelected()) {
	        // Select brush for border.
		CBrush* pOldBrush = (CBrush*) pDC->SelectStockObject(NULL_BRUSH);

	        // Erase border.
		rcIn = pRgn->GetInnerRect();
		rcIn.InflateRect(1, 1);
		pDC->Rectangle(&rcIn);

		pDC->SelectObject(pOldBrush);
	} else {
	        // Select brush.
		CBrush pBrush(rgbBak);
		CBrush* pOldBrush = (CBrush*) pDC->SelectObject(&pBrush);

	        // Erase border.
		rcIn = pRgn->GetInnerRect();
		CRect rc;

		rc.SetRect(rcIn.left, rcIn.top - HNDLSIZE, rcIn.right, rcIn.top);
		pDC->Rectangle(&rc);

		rc.SetRect(rcIn.left - HNDLSIZE, rcIn.top, rcIn.left, rcIn.bottom);
		pDC->Rectangle(&rc);

		rc.SetRect(rcIn.left, rcIn.bottom, rcIn.right, rcIn.bottom + HNDLSIZE);
		pDC->Rectangle(&rc);

		rc.SetRect(rcIn.right, rcIn.top, rcIn.right + HNDLSIZE, rcIn.bottom);
		pDC->Rectangle(&rc);

	        // Erase handles.
		for (int i = 0; i < 8; ++i) {
			rc = pRgn->GetHandle(i);
			pDC->Rectangle(&rc);
		}
		pDC->SelectObject(pOldBrush);
	}
	pDC->SelectObject(pOldPen);

	// Update controls under erased areas.
	GetDocument()->UpdateRect(&rcIn, pRgn, UR_HANDLES);
}

//------------------------------------------------------------------------------
/*
** Handle left-button-down mouse event.
*/
void CDemoView::OnLButtonDown(UINT nFlags, CPoint point)
{
	CDemoDoc* pDoc = GetDocument();

	if (pDoc->GetMode() != IDDISABLE) {
		m_ptBeg = point;
		m_ptEnd	= point;

		CClientDC pDC(this);

		// Find region selected by user.
		CPanCtRgn* pOldRgn;
		CPanCtRgn* pRgn = pDoc->FindPickedRgn(point, &pOldRgn);

		// Deselect old region if different from new region.
		if (pOldRgn != NULL
			// && pOldRgn != pRgn
			) {
			pDoc->Deselect(pOldRgn, TRUE);
		} // if

		if (pRgn == NULL) {
			/*
			** User clicked on document window background.
			*/
			pDoc->SetMode(IDDRAWRECT);
			SetCapture();

			// Draw focus rectangle.
			m_rc.SetRect(m_ptBeg.x, m_ptBeg.y, m_ptEnd.x, m_ptEnd.y);
			pDC.DrawFocusRect(m_rc);

			/*
			** Select back the old region
			*/
			pDoc->Select(pOldRgn);


		} else {
			int handle = pRgn->GetActiveHandle();
			if (handle != IDNONE && handle != IDCONTROL) {
				/*
				** User clicked on handles border.
				*/
				pDoc->SetMode(IDMODIFY);
				SetCapture();

				// Draw focus rectangle.
				m_rc = pRgn->GetInnerRect();
				pDC.DrawFocusRect(m_rc);

//				if (pRgn != pOldRgn) {
					// Select region.
					pDoc->Select(pRgn);

					// Change cursor shape.
					OnSetCursor(NULL, HTCLIENT, 0);
//				}
			} else {
				/*
				** User clicked within a control.
				*/
				pDoc->SetMode(IDNOP);

//				if (pRgn != pOldRgn) {
					// Select region.
					pDoc->Select(pRgn);
//				}
			}
		} // if

		m_ptOld = m_ptEnd;
		m_rcOld = m_rc;
	} // if

	CView::OnLButtonDown(nFlags, point);

} // CDemoView::OnLButtonDown

//------------------------------------------------------------------------------
/*
** Handle mouse-move mouse event.
*/
void CDemoView::OnMouseMove(UINT nFlags, CPoint point)
{
	CDemoDoc* pDoc = GetDocument();
	int nMode = pDoc->GetMode();

	if (nMode != IDDISABLE && GetCapture() == this && point != m_ptOld) {
		m_ptEnd = point;

		CClientDC pDC(this);

		switch (nMode) {
		  case IDDRAWRECT:
		  	// Erase old focus rectangle.
			pDC.DrawFocusRect(m_rcOld);

			// Draw new focus rectangle.
			m_rc.SetRect(m_ptBeg.x, m_ptBeg.y, m_ptEnd.x, m_ptEnd.y);
			pDC.DrawFocusRect(m_rc);
			break;

		  case IDMODIFY:
			// Erase old focus rectangle.
			pDC.DrawFocusRect(m_rcOld);

			CPanCtRgn* pRgn = pDoc->GetCurrRgn();
			if (pRgn != NULL) {
				int handle = pRgn->GetActiveHandle();
				if (handle == IDALL) {
					// Move focus rectangle.
					CPoint pt = m_ptEnd - m_ptOld;
					m_rc.OffsetRect(pt);
				} else if (handle != IDNONE && handle != IDCONTROL) {
					// Resize focus rectangle.
					ResizeRect();
				}

				// Draw new focus rectangle.
				pDC.DrawFocusRect(m_rc);
			}
			break;
		} // switch

		m_ptOld = m_ptEnd;
		m_rcOld = m_rc;
	} // if

	CView::OnMouseMove(nFlags, point);

} // CDemoView::OnMouseMove

//------------------------------------------------------------------------------
/*
** Handle left-button-up mouse event.
*/
void CDemoView::OnLButtonUp(UINT nFlags, CPoint point)
{
	CDemoDoc* pDoc = GetDocument();
	int nMode = pDoc->GetMode();

	if (nMode != IDDISABLE && GetCapture() == this) {
		CPanCtRgn* pRgn;

		m_ptEnd = point;

		CClientDC pDC(this);

		switch (nMode) {
		  case IDDRAWRECT:
		  	// Erase old focus rectangle.
			pDC.DrawFocusRect(m_rcOld);

		  	if (m_ptEnd != m_ptBeg) {
				// Validate new region rectangle.
				m_rc.SetRect(m_ptBeg.x, m_ptBeg.y, m_ptEnd.x, m_ptEnd.y);
				NormalizeRect();

				if ((m_rc.right - m_rc.left) < MIN_BOXSIZE) {
					m_rc.right = m_rc.left + MIN_BOXSIZE;
				}
				if ((m_rc.bottom - m_rc.top) < MIN_BOXSIZE) {
					m_rc.bottom = m_rc.top + MIN_BOXSIZE;
				}

				// Create new region.
				TRY {
					pRgn = new CPanCtRgn(this, pDoc->GetCtrlID(), &m_rc);

				} CATCH(CMemoryException, memEx) {
					AfxMessageBox("Out of Memory");
					break;

				} END_CATCH

				CObList* pList = pDoc->GetPanRgnList();
				if (pList != NULL) {
					// Add region to list.
					pList->AddHead(pRgn);

	                                // Select new region.
					pDoc->Select(pRgn);
				}
			}
			break;

		  case IDMODIFY:
			// Erase old focus rectangle.
			pDC.DrawFocusRect(m_rcOld);

			pRgn = pDoc->GetCurrRgn();
			if (pRgn != NULL) {
				// Deactivate handle.
				pRgn->SetActiveHandle(IDNONE);

				if (m_ptEnd != m_ptBeg) {
					// Deselect region.
					pDoc->Deselect(pRgn, FALSE);

					// Move/resize control window.
					HWND hCtl = pRgn->GetCtlHandle();
					if (hCtl != NULL) {
						::MoveWindow(hCtl, m_rc.left, m_rc.top,
							m_rc.right - m_rc.left,
							m_rc.bottom - m_rc.top, TRUE);

						pRgn->SetInnerRect(m_rc);
					}

					// Select region.
					pDoc->Select(pRgn);
				}
			}
			break;
		} // switch

		pDoc->SetMode(IDNOP);
		ReleaseCapture();
	} // if

	CView::OnLButtonUp(nFlags, point);

} // CDemoView::OnLButtonUp

//------------------------------------------------------------------------------
BOOL CDemoView::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
	if (nHitTest != HTCLIENT) {
		return FALSE;
	}

	BOOL result = TRUE;

	// Default cursor shape is a cross.
	LPCSTR cursorShape = IDC_CROSS;

	// Get mouse position.
	MSG msg = *GetCurrentMessage();
	CPoint mousePos = msg.pt;
	::MapWindowPoints(HWND_DESKTOP, GetSafeHwnd(), (LPPOINT) &mousePos, 1);

	// Traverse list of regions.
	CDemoDoc* pDoc = GetDocument();
	CObList* pList = pDoc->GetPanRgnList();

	if (pList != NULL) {
		for (POSITION pos = pList->GetHeadPosition(); pos != NULL; ) {
			CPanCtRgn* pRgn = (CPanCtRgn*) pList->GetNext(pos);
			CRect rcInner = pRgn->GetInnerRect();
			CRect rcOuter = pRgn->GetOuterRect();

			if (pRgn->GetSelected()) {
				if (rcOuter.PtInRect(mousePos) && !rcInner.PtInRect(mousePos)) {
					switch (pRgn->IsPickPointOverHandles(mousePos)) {
					  case IDALL:
						cursorShape = MAKEINTRESOURCE(IDC_HAND);
						break;

					  case 0:
					  case 7:
						cursorShape = IDC_SIZENWSE;
						break;

					  case 1:
					  case 6:
						cursorShape = IDC_SIZENS;
						break;

					  case 2:
					  case 5:
						cursorShape = IDC_SIZENESW;
						break;

					  case 3:
					  case 4:
						cursorShape = IDC_SIZEWE;
						break;
					}
					break;
				}
			}

			if (rcInner.PtInRect(mousePos)) {
				result = FALSE;
			}
		}
	}

	if (result) {
		// Set new cursor shape.
		if (cursorShape == MAKEINTRESOURCE(IDC_HAND)) {
			::SetCursor(AfxGetApp()->LoadCursor(cursorShape));
		} else {
			::SetCursor(AfxGetApp()->LoadStandardCursor(cursorShape));
		}
	}
	return result;
}

//------------------------------------------------------------------------------
CRect CDemoView::GetOuterRect(CRect rcIn)
{
  CRect rcOut = rcIn;
  rcOut.left -= HNDLSIZE;
  rcOut.top -= HNDLSIZE;
  rcOut.right += HNDLSIZE;
  rcOut.bottom += HNDLSIZE;
  return (rcOut);
}

//------------------------------------------------------------------------------
void CDemoView::NormalizeRect()
{
	CRect rc	= m_rc;
	m_rc.left	= min(rc.left, rc.right);
	m_rc.top	= min(rc.top,  rc.bottom);
	m_rc.right	= max(rc.left, rc.right);
	m_rc.bottom	= max(rc.top,  rc.bottom);
}

//------------------------------------------------------------------------------
void CDemoView::ResizeRect()
{
	CDemoDoc* pDoc = GetDocument();
	CPanCtRgn* pRgn = pDoc->GetCurrRgn();

	if (pRgn == NULL) {
		return;
	}

	CPoint ptOld = m_ptOld;
	ClientToScreen (&ptOld);

	CPoint ptEnd = m_ptEnd;
	ClientToScreen (&ptEnd);

	int nActiveHandle = pRgn->GetActiveHandle();
	switch (nActiveHandle) {
	  case 0:
		m_rc.left = m_ptEnd.x;
		m_rc.top  = m_ptEnd.y;
		break;

	  case 1:
		m_rc.top = m_ptEnd.y;
		SetCursorPos(ptOld.x, ptEnd.y);
		break;

	  case 2:
		m_rc.right = m_ptEnd.x;
		m_rc.top   = m_ptEnd.y;
		break;

	  case 3:
		m_rc.left = m_ptEnd.x;
		SetCursorPos(ptEnd.x, ptOld.y);
		break;

	  case 4:
		m_rc.right = m_ptEnd.x;
		SetCursorPos(ptEnd.x, ptOld.y);
		break;

	  case 5:
		m_rc.left   = m_ptEnd.x;
		m_rc.bottom = m_ptEnd.y;

	  case 6:
		m_rc.bottom = m_ptEnd.y;
		SetCursorPos(ptOld.x, ptEnd.y);
		break;

	  case 7:
		m_rc.right  = m_ptEnd.x;
		m_rc.bottom = m_ptEnd.y;
		break;
	}
}

//------------------------------------------------------------------------------
BOOL CDemoView::GetFile(char* fname)
//
// Attempt to get a user defined file.
// This function is called in the OnFileOpen (below) and in the
// OnSendmessagePmclsetfile (file msghndl.cpp)
{
	OPENFILENAME ofn;

  	// build the selection list
	static char filter[200];
	strcpy(filter, "");
	memcpy(&filter[  0], filters[0], 24); // All list
	memcpy(&filter[ 24], filters[1], 26); // WPG list
	memcpy(&filter[ 50], filters[2], 26); // PCX list
	memcpy(&filter[ 76], filters[3], 26); // TXT list
	memcpy(&filter[102], filters[4], 25); // DB  list
	memcpy(&filter[127], filters[5], 26); // WB1 list
	memcpy(&filter[153], filters[6], 27); // ZIP list

	// file name = last filter
	strcpy(fname, &custFilter[1]);

	// fill the structure
	_fmemset(&ofn, 0, sizeof(OPENFILENAME));
	ofn.lStructSize	      = sizeof(OPENFILENAME);
	ofn.lpstrFilter	      = filter;
	ofn.lpstrCustomFilter = custFilter;
	ofn.nMaxCustFilter    = 60;
	ofn.nFilterIndex      = 0;
	ofn.lpstrFile	      = fname;
	ofn.nMaxFile	      = MAX_FILENAME;
	ofn.Flags 	      = OFN_FILEMUSTEXIST;

	return (GetOpenFileName(&ofn) != 0);
}

//------------------------------------------------------------------------------
/*
** Create a new control.
*/
void CDemoView::OnFileCreateCtl()
{
	CDemoDoc* pDoc = GetDocument();

	if (pDoc->GetCurrRgn() == NULL) {
		CRect rect(50, 50, 200, 200);
		CPanCtRgn *pRgn;

                // Create new region.
		TRY {
			pRgn = new CPanCtRgn(this, pDoc->GetCtrlID(), &rect);

		} CATCH(CMemoryException, memEx) {
			AfxMessageBox("Out of Memory");
			return;

		} END_CATCH

		CObList* pList = pDoc->GetPanRgnList();
		if (pList != NULL) {
			// Add region to list.
			pList->AddHead(pRgn);

                        // Select new region.
			pDoc->Select(pRgn);
		}
	}
}

//------------------------------------------------------------------------------
/*
** Destroy the active control.
*/
void CDemoView::OnFileDestroyCtl()
{
	CDemoDoc* pDoc = GetDocument();
	CPanCtRgn* pRgn = pDoc->GetCurrRgn();
	if (pRgn != NULL) {
		BOOL fClose = TRUE;
		HWND hCtl = pRgn->GetCtlHandle();
		if (hCtl != 0) {
			DWORD status = PAN_CTLSTATUSIDLE;

			::SendMessage(hCtl, PM_CTLGETSTATUS, 0, (LPARAM) &status);
			::SendMessage(hCtl, PM_CTLDESTROY, 0, 0);

			if (status != PAN_CTLSTATUSIDLE) {
				fClose = FALSE;

				PostMessage(WM_NULL, 0, 0);
				PostMessage(WM_NULL, 0, 0);
				PostMessage(WM_NULL, 0, 0);
				PostMessage(WM_NULL, 0, 0);
				PostMessage(WM_COMMAND, ID_FILE_DESTROYCONTROL, 0);
			}
		}
		if (fClose) {
			pDoc->Delete(pRgn);
		}
	}
}

//------------------------------------------------------------------------------
/*
** Handle key-up keyboard event.
*/
void CDemoView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	switch (nChar) {
	  case VK_INSERT:
	  	OnFileCreateCtl();
	  	break;

	  case VK_DELETE:
		OnFileDestroyCtl();
	  	break;
	}
	CView::OnKeyUp(nChar, nRepCnt, nFlags);
}

//------------------------------------------------------------------------------
LRESULT CDemoView::OnQueryNewPalette(WPARAM wParam, LPARAM lParam)
{
	CPanCtRgn*	pRgn;
	CDemoDoc*	pDoc = GetDocument();

	pRgn = pDoc->GetCurrRgn();

	if (pRgn == NULL) {
		CObList*	pList = pDoc->GetPanRgnList();

		if (pList != NULL) {
			POSITION	pos = pList->GetHeadPosition();

			if (pos != NULL) {
				pRgn = (CPanCtRgn*) pList->GetAt(pos);
			}
		}
	}

	if (pRgn != NULL) { // Got the first in the list
		HWND	hCtl = pRgn->GetCtlHandle();

		::SendMessage(hCtl, WM_QUERYNEWPALETTE, 0, 0L);
    }

	return (0L);
}


//------------------------------------------------------------------------------
void CDemoView::OnFileOpen()
//
// Attempt to get a user defined file. If a file is specified then ask the
// CPanCtRgn object to load that file in it's control window. Otherwise do
// nothing.
{
	CPanCtRgn* pRgn = GetDocument()->GetCurrRgn();
	if (pRgn == NULL) {
		return;
	}

	char currentFile[MAX_FILENAME];
	if (GetFile(currentFile)) {
		// a file is selected. Update the DC and load into the control
		pRgn->LoadCtrlData(currentFile);
	}
}

//------------------------------------------------------------------------------
void CDemoView::OnFilePrintctl()
//
// This function is defined only for consistency. The actual printing
// is performed by the object himself.
{
	CPanCtRgn* rgn = GetDocument()->GetCurrRgn();
	if (rgn) rgn->Print();
}

//------------------------------------------------------------------------------
void CDemoView::OnFileConvertctl()
//
// This function is defined only for consistency. The actual conversion
// is performed by the object himself.
{
	CPanCtRgn* rgn = GetDocument()->GetCurrRgn();
	if (rgn) rgn->Convert();
}

//------------------------------------------------------------------------------
void CDemoView::OnFileConvertdoc()
{
// To fill on a later version
}

//------------------------------------------------------------------------------
/*
** Enable or disable zooming for the active region.
*/
void CDemoView::OnEditZoom()
{
	CDemoDoc* pDoc = GetDocument();
	CPanCtRgn* pRgn = pDoc->GetCurrRgn();
	if (pRgn == NULL) {
		return;
	}

	DWORD curCaps = pRgn->GetCurCaps();
	WORD curLMB = pRgn->GetCurLMB();

	if ((curCaps & PAN_CTLCAPSZOOM) != 0 && curLMB == PAN_CTLLMBZOOM) {
		pRgn->Disable(PAN_CTLCAPSZOOM);
		pRgn->ChangeLMB(PAN_CTLLMBNONE);
	}
	else {
		pRgn->Disable(PAN_CTLCAPSCOPY);
		pRgn->Enable(PAN_CTLCAPSZOOM);
		pRgn->ChangeLMB(PAN_CTLLMBZOOM);
	}
	pRgn->SetCurCaps();
	pRgn->SetCurLMB();
}

//------------------------------------------------------------------------------
/*
** Enable/disable the scrolling capabilities of the active region.
*/
void CDemoView::OnViewScroll()
{
	CDemoDoc* pDoc = GetDocument();
	CPanCtRgn* pRgn = pDoc->GetCurrRgn();

	if (pRgn == NULL) {
		return;
	}

	DWORD curCaps = pRgn->GetCurCaps();
	if ((curCaps & PAN_CTLCAPSHSCROLL) || (curCaps & PAN_CTLCAPSVSCROLL)) {
		pRgn->Disable(PAN_CTLCAPSHSCROLL | PAN_CTLCAPSVSCROLL);
	}
	else {
		pRgn->Enable(PAN_CTLCAPSHSCROLL | PAN_CTLCAPSVSCROLL);
	}
	pRgn->SetCurCaps();
}

//------------------------------------------------------------------------------
void CDemoView::OnEditSelandcopy()
{
	CDemoDoc* pDoc = (CDemoDoc*)GetDocument();
	CPanCtRgn* pRgn = pDoc->GetCurrRgn();

	if (pRgn == NULL){
		return;
	}
	pDoc->SetMode(IDDISABLE);

	//pRgn->Enable(PAN_CTLCAPSCOPY);
	//pRgn->Enable(PAN_CTLCAPSMOUSE);
	//pRgn->ChangeLMB(PAN_CTLLMBSELECT);
}

//------------------------------------------------------------------------------
void CDemoView::OnEditSearch()
//
// This function will work only if a valid CPanCtRgn is selected and if it
// accept a search mode.
{
	CPanCtRgn* pRgn = GetDocument()->GetCurrRgn();
	// no currently control selected or it does not support the search
	if (pRgn != NULL) {
		pRgn->Search(); // initiate the search command
	}
}

//------------------------------------------------------------------------------
void CDemoView::OnEditGetString()
//
// This function will work only if a valid CPanCtRgn is selected and if it
// accept a search mode.
{
	CPanCtRgn* pRgn = GetDocument()->GetCurrRgn();
	// no currently control selected or it does not support the search
	if (pRgn != NULL) {
		pRgn->GetString(); // initiate the get string command
	}
}

//------------------------------------------------------------------------------
void CDemoView::OnEditGetEntity()
//
// This function will work only if a valid CPanCtRgn is selected and if it
// accept a search mode.
{
	CPanCtRgn* pRgn = GetDocument()->GetCurrRgn();
	// no currently control selected or it does not support the search
	if (pRgn != NULL) {
		pRgn->GetEntity(); // initiate the get entity command
	}
}

//------------------------------------------------------------------------------
void CDemoView::OnEditSelect()
{
	CDemoDoc* pDoc = GetDocument();
	CPanCtRgn* pRgn = pDoc->GetCurrRgn();
	if (pRgn == NULL) {
		return;
	}

	DWORD curCaps = pRgn->GetCurCaps();
	WORD curLMB = pRgn->GetCurLMB();

	if ((curCaps & PAN_CTLCAPSCOPY) != 0 && curLMB == PAN_CTLLMBSELECT) {
		pRgn->Disable(PAN_CTLCAPSCOPY);
		pRgn->ChangeLMB(PAN_CTLLMBNONE);
	}
	else {
		pRgn->Disable(PAN_CTLCAPSZOOM);
		pRgn->Enable(PAN_CTLCAPSCOPY);
		pRgn->ChangeLMB(PAN_CTLLMBSELECT);
	}
	pRgn->SetCurCaps();
	pRgn->SetCurLMB();
}

//------------------------------------------------------------------------------
/*
** Copy the selections in the active region to the clipboard.
*/
void CDemoView::OnEditCopy()
{
	CDemoDoc* pDoc = GetDocument();
	CPanCtRgn* pRgn = pDoc->GetCurrRgn();
	if (pRgn == NULL) {
		return;
	}

	HWND hCtl = pRgn->GetCtlHandle();
	if (hCtl == NULL) {
		return;
	}

	WORD numSels = 0;
	if (::SendMessage(hCtl, PM_CTLGETNUMSELS, 0, (LPARAM) &numSels) != PAN_CTLERRNONE) {
		return;
	}

	if (numSels > 0) {
		CopyToClpbrd();
	}
}


/////////////////////////////////////////////////////////////////////////////
// CDemoView printing

//------------------------------------------------------------------------------
BOOL CDemoView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

//------------------------------------------------------------------------------
void CDemoView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
}

//------------------------------------------------------------------------------
void CDemoView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
}


/////////////////////////////////////////////////////////////////////////////
// UPDATE OF MENU ITEMS

//------------------------------------------------------------------------------
void CDemoView::OnUpdateFileOpen(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(GetDocument()->GetCurrRgn() != NULL);
}

//------------------------------------------------------------------------------
void CDemoView::OnUpdateFileCreateCtl(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(GetDocument()->GetCurrRgn() == NULL);
}

//------------------------------------------------------------------------------
void CDemoView::OnUpdateFileDestroyCtl(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(GetDocument()->GetCurrRgn() != NULL);
}

//------------------------------------------------------------------------------
void CDemoView::OnUpdateFilePrintctl(CCmdUI* pCmdUI)
{
	CPanCtRgn* rgn = GetDocument()->GetCurrRgn();
	pCmdUI->Enable(rgn != NULL && rgn->GetHasFile());
}

//------------------------------------------------------------------------------
void CDemoView::OnUpdateFileConvertctl(CCmdUI* pCmdUI)
{
	CPanCtRgn* rgn = GetDocument()->GetCurrRgn();
	pCmdUI->Enable(rgn != NULL && rgn->GetHasFile());
}

//------------------------------------------------------------------------------
void CDemoView::OnUpdateEditZoom(CCmdUI* pCmdUI)
{
	CDemoDoc* pDoc = GetDocument();
	CPanCtRgn* pRgn = pDoc->GetCurrRgn();

	pCmdUI->Enable(pRgn != NULL && pRgn->GetHasFile() && pRgn->AcceptCaps(PAN_CTLCAPSZOOM));

        if (pRgn != NULL) {
		DWORD curCaps = pRgn->GetCurCaps();
		WORD curLMB = pRgn->GetCurLMB();

		pCmdUI->SetCheck((curCaps & PAN_CTLCAPSZOOM) != 0 && curLMB == PAN_CTLLMBZOOM);
	}
}

//------------------------------------------------------------------------------
void CDemoView::OnUpdateViewScroll(CCmdUI* pCmdUI)
{
	CDemoDoc* pDoc = GetDocument();
	CPanCtRgn* pRgn = pDoc->GetCurrRgn();

	pCmdUI->Enable(pRgn != NULL && pRgn->GetHasFile() &&
		pRgn->AcceptCaps(PAN_CTLCAPSHSCROLL | PAN_CTLCAPSVSCROLL));

        if (pRgn != NULL) {
		DWORD curCaps = pRgn->GetCurCaps();
		pCmdUI->SetCheck((curCaps & PAN_CTLCAPSHSCROLL) || (curCaps & PAN_CTLCAPSVSCROLL));
	}
}

//------------------------------------------------------------------------------
void CDemoView::OnUpdateEditSelandcopy(CCmdUI* pCmdUI)
{
	CPanCtRgn* rgn = GetDocument()->GetCurrRgn();
	pCmdUI->Enable( rgn!=NULL && rgn->GetHasFile() && rgn->AcceptCaps(PAN_CTLCAPSCOPY) );
}

//------------------------------------------------------------------------------
void CDemoView::OnUpdateEditSearch(CCmdUI* pCmdUI)
{
	CPanCtRgn* pRgn = GetDocument()->GetCurrRgn();
	DWORD curCaps = 0;
	if (pRgn != NULL) {
		curCaps = pRgn->GetCurCaps();
	}
	pCmdUI->Enable(pRgn != NULL && pRgn->GetHasFile() && (curCaps & PAN_CTLCAPSSEARCH));
}


//------------------------------------------------------------------------------
void CDemoView::OnUpdateEditSelect(CCmdUI* pCmdUI)
{
	CDemoDoc* pDoc = GetDocument();
	CPanCtRgn* pRgn = pDoc->GetCurrRgn();

	pCmdUI->Enable(pRgn != NULL && pRgn->GetHasFile() && pRgn->AcceptCaps(PAN_CTLCAPSCOPY));

        if (pRgn != NULL) {
		DWORD curCaps = pRgn->GetCurCaps();
		WORD curLMB = pRgn->GetCurLMB();

		pCmdUI->SetCheck((curCaps & PAN_CTLCAPSCOPY) != 0 && curLMB == PAN_CTLLMBSELECT);
	}
}

//------------------------------------------------------------------------------
void CDemoView::OnUpdateEditCopy(CCmdUI* pCmdUI)
{
	CDemoDoc* pDoc = GetDocument();
	CPanCtRgn* pRgn = pDoc->GetCurrRgn();
	WORD numSels = 0;
	DWORD curCaps = 0;
	WORD curLMB = PAN_CTLLMBNONE;

	if (pRgn != NULL) {
		HWND hCtl = pRgn->GetCtlHandle();
		if (hCtl != NULL) {
			::SendMessage(hCtl, PM_CTLGETNUMSELS, 0, (LPARAM) &numSels);
		}
		curCaps = pRgn->GetCurCaps();
		curLMB  = pRgn->GetCurLMB();
	}
	pCmdUI->Enable(pRgn != NULL &&
		(curCaps & PAN_CTLCAPSCOPY) && curLMB == PAN_CTLLMBSELECT && numSels != 0);
}

void CDemoView::OnUpdateFileConvertdoc(CCmdUI* pCmdUI)	  { pCmdUI->Enable(FALSE);}
void CDemoView::OnUpdateFilePrintSetup(CCmdUI* pCmdUI)		{ pCmdUI->Enable(TRUE) ;}

//------------------------------------------------------------------------------
void CDemoView::OnUpdateFilePrint(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(!GetDocument()->IsEmpty());
}

//------------------------------------------------------------------------------
/*
** Return the current view.
*/
CDemoView* GetCurrentView()
{
	return ((CDemoApp*) AfxGetApp())->GetCurrentView();
}

/////////////////////////////////////////////////////////////////////////////
// CDemoView diagnostics

#ifdef _DEBUG
void CDemoView::AssertValid() const
{
	CView::AssertValid();
}

void CDemoView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CDemoDoc* CDemoView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CDemoDoc)));
	return (CDemoDoc*) m_pDocument;
}

CDemoView* GetMyView()
{
	#define MDI  ((CMDIFrameWnd*)AfxGetApp()->m_pMainWnd)
	BOOL	maxim;
	CMDIChildWnd* childWnd = MDI->MDIGetActive(&maxim);
	if (childWnd == NULL) return NULL;
	CDemoView* view = (CDemoView*)(childWnd->GetActiveView());
	return view;
	#undef MDI
}

#endif //_DEBUG

