/*
**	Source listing for the DEMO program.
**	Copyright Oracle, 1993-2008, all rights reserved.
**	demoview.h : interface of the CDemoView class
*/

class CPanCtRgn;
class CWndOut;
/////////////////////////////////////////////////////////////////////////////
class CDemoView : public CView
{
protected: 
	CDemoView();                 
	DECLARE_DYNCREATE(CDemoView)
	void 	Draw (CDC* pDC, CPanCtRgn* pRgn);
	void 	Erase(CDC* pDC, CPanCtRgn* pRgn);
	void 	ResizeRect();
	void 	NormalizeRect();
	CRect  	GetOuterRect(CRect rcIn);
	void 	ErrorTrace(int err, UINT msg);
	BOOL 	SendMsg(UINT msg, WPARAM wp, LPARAM lp);
	void	RenderSelOnto(BOOL toDC);
	
public:
	CWndOut*	m_pWndOut;	// Message output window,
	
	HWND		hwnd;		// Handle to check if the control that sent the message
					// is the currently selected,
	HWND		m_hCurCtl;                    
	
	CRect		m_rc;
	CRect		m_rcOld;
	CPoint		m_ptBeg;
	CPoint		m_ptEnd;
	CPoint		m_ptOld;

	BOOL		m_nScrollMode;
	BOOL		m_nSelectMode;

// Operations
	CDemoDoc* 	GetDocument();

// Implementation
public:
	BOOL	GetFile(char* szFile);
	BOOL 	Validate();    // this function is used and defined 
	                       // in the msghndl code
	void	CopyToClpbrd(); // used also by the notification procedure.
	void	RedrawHndlRgn(); // Redraw the frame of the currRgn
	
	virtual ~CDemoView();
	virtual void OnDraw(CDC* pDC);
	virtual void OnUpdate (CView* pSender, LPARAM lHint = 0, CObject* pHint = NULL);
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Printing support
protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
 		
// Generated message map functions
//
protected:
	//{{AFX_MSG(CDemoView)
	afx_msg int  OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg LRESULT OnQueryNewPalette(WPARAM wParam, LPARAM lParam);
	afx_msg void OnFileOpen();
	afx_msg void OnFileCreateCtl();
	afx_msg void OnFileDestroyCtl();
	afx_msg void OnFilePrintctl();
	afx_msg void OnFileConvertctl();
	afx_msg void OnFileConvertdoc();
	afx_msg void OnEditZoom();
	afx_msg void OnEditSelandcopy();
	afx_msg void OnEditSearch();
	afx_msg void OnEditGetString();
	afx_msg void OnEditGetEntity();
	afx_msg void OnEditSelect();
	afx_msg void OnEditCopy();
	afx_msg void OnViewScroll();
	afx_msg void OnUpdateFileOpen(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileCreateCtl(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileDestroyCtl(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFilePrintctl(CCmdUI* pCmdUI);		
	afx_msg void OnUpdateFileConvertctl(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileConvertdoc(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditZoom(CCmdUI* pCmdUI);	
	afx_msg void OnUpdateEditSelandcopy(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditSearch(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditSelect(CCmdUI* pCmdUI);	
	afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);	
	afx_msg void OnUpdateViewScroll(CCmdUI* pCmdUI);
	afx_msg void OnSendmessagePmctlclearsels();
	afx_msg void OnSendmessagePmctlclienttoworld();
	afx_msg void OnSendmessagePmctlclonecontrol();
	afx_msg void OnSendmessagePmctlcopy(); 
	afx_msg void OnSendmessagePmctlgetbasefont();
	afx_msg void OnSendmessagePmctlgetblock();
	afx_msg void OnSendmessagePmctlgetblocknames();
	afx_msg void OnSendmessagePmctlgetcaps();
	afx_msg void OnSendmessagePmctlgetclpbrdfmts();
	afx_msg void OnSendmessagePmctlgetcolwidth();
	afx_msg void OnSendmessagePmctlgetentity();
	afx_msg void OnSendmessagePmctlgetfgbgcolor();
	afx_msg void OnSendmessagePmctlgetfile();
	afx_msg void OnSendmessagePmctlgetfilefmts();
	afx_msg void OnSendmessagePmctlgetimageex0();
	afx_msg void OnSendmessagePmctlgetimageex1();
	afx_msg void OnSendmessagePmctlgetimageex2();
	afx_msg void OnSendmessagePmctlgetinfo();
	afx_msg void OnSendmessagePmctlgetlayerstate();
	afx_msg void OnSendmessagePmctlgetlmbaction();
	afx_msg void OnSendmessagePmctlgetmode();
	afx_msg void OnSendmessagePmctlgetnumpages();
	afx_msg void OnSendmessagePmctlgetnumsels();
	afx_msg void OnSendmessagePmctlgetoffset();
	afx_msg void OnSendmessagePmctlgetpage();
	afx_msg void OnSendmessagePmctlgetpagesize();
	afx_msg void OnSendmessagePmctlgetresourceinfostate();
	afx_msg void OnSendmessagePmctlgetrowheight();
	afx_msg void OnSendmessagePmctlgetsels();
	afx_msg void OnSendmessagePmctlgetstatus();
	afx_msg void OnSendmessagePmctlgetstring();
	afx_msg void OnSendmessagePmctlgetview();
	afx_msg void OnSendmessagePmctlgetviewextents();
	afx_msg void OnSendmessagePmctlgetviewnames();
	afx_msg void OnSendmessagePmctlgetzoom();
	afx_msg void OnSendmessagePmctlprint();
	afx_msg void OnSendmessagePmctlregen();
	afx_msg void OnSendmessagePmctlsearch();
	afx_msg void OnSendmessagePmctlsetbasefont();
	afx_msg void OnSendmessagePmctlsetcaps();
	afx_msg void OnSendmessagePmctlsetfgbgcolor();
	afx_msg void OnSendmessagePmctlsetfile();
	afx_msg void OnSendmessagePmctlsetlmbaction();
	afx_msg void OnSendmessagePmctlsetmode();
	afx_msg void OnSendmessagePmctlsetoffset();
	afx_msg void OnSendmessagePmctlsetpage();
	afx_msg void OnSendmessagePmctlsetsel();
	afx_msg void OnSendmessagePmctlsetviewextents();
	afx_msg void OnSendmessagePmctlsetzoom();
	afx_msg void OnSendmessagePmctlworldtoclient();
	afx_msg void OnSendmessagePmctlflipNone();
	afx_msg void OnSendmessagePmctlflipX();
	afx_msg void OnSendmessagePmctlflipXandy();
	afx_msg void OnSendmessagePmctlflipY();
	afx_msg void OnSendmessagePmctlrotate0deg();
	afx_msg void OnSendmessagePmctlrotate180degrees();
	afx_msg void OnSendmessagePmctlrotate270degrees();
	afx_msg void OnSendmessagePmctlrotate90degrees();
	afx_msg void OnUpdateFilePrintSetup(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFilePrint(CCmdUI* pCmdUI);
	afx_msg void OnSendmessagePmctlpaint();
	afx_msg void OnSendmessagePmctlctldestroy();
	afx_msg void OnSendmessagePmctldestroydescendants();
	afx_msg void OnSendmessagePmctlgetdc();
	afx_msg void OnSendmessagePmctlgetfiletype();
	afx_msg void OnSendmessagePmctlgetpalette();
	afx_msg void OnSendmessagePmctlhscroll();
	afx_msg void OnSendmessagePmctlpalettechanged();
	afx_msg void OnSendmessagePmctlprintpreview();
	afx_msg void OnSendmessagePmctlquerynewpalette();
	afx_msg void OnSendmessagePmctlrenderontodc();
	afx_msg void OnSendmessagePmctlsetpalette();
	afx_msg void OnSendmessagePmctlvalidatemargins();
	afx_msg void OnSendmessagePmctlvscroll();
	afx_msg void OnSendmessagePmctlsize();
	afx_msg void OnSendmessagePmctlmultisearch();
	afx_msg void OnSendmessagePmctlcarettoworld();
	afx_msg void OnSendmessagePmctlgetcaretpos();
	afx_msg void OnSendmessagePmctlgetdims();
	afx_msg void OnSendmessagePmctlsetcaretpos();
	afx_msg void OnSendmessagePmctlsetselcaret();
	afx_msg void OnSendmessagePmctlsort();
	afx_msg void OnSendmessagePmctlworldtocaret();	
	afx_msg void OnSendmessagePmctlsetblock();
	afx_msg void OnSendmessagePmctlsetimageex();
	afx_msg void OnSendmessagePmctlsetlayerstate();
	afx_msg void OnSendmessagePmctlsetview();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG	// debug version in demoview.cpp
inline CDemoDoc* CDemoView::GetDocument()
   { return (CDemoDoc*) m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
#define MAX_FILENAME  1024	// used for GetFile() 
CDemoView* GetCurrentView();
CDemoView* GetMyView();
