/*
**	Source listing for the DEMO program.
**	Copyright Oracle, 1993-2008, all rights reserved.
**
**	diags.cpp : implementation file
**
**	This file implements the dialog classes used for setting
**	parameters in the AutoVue 19.3 demo program.
*/

#include "stdafx.h"
#include "demo.h"

#include <stdlib.h>		// needed for atol, atof, atoi
#include <malloc.h>
#include "pctl.h"
#include "diags.h"
                              

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCapsDiag dialog

CCapsDiag::CCapsDiag(CWnd* pParent /*=NULL*/)
	: CDialog(CCapsDiag::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCapsDiag)
	m_copy = FALSE;
	m_hscroll = FALSE;
	m_keybd = FALSE;
	m_mouse = FALSE;
	m_page = FALSE;
	m_search = FALSE;
	m_size = FALSE;
	m_vscroll = FALSE;
	m_zoom = FALSE;
	//}}AFX_DATA_INIT
}

void CCapsDiag::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCapsDiag)
	DDX_Check(pDX, IDK_CAPSCOPY, m_copy);
	DDX_Check(pDX, IDK_CAPSHSCROLL, m_hscroll);
	DDX_Check(pDX, IDK_CAPSKEYBD, m_keybd);
	DDX_Check(pDX, IDK_CAPSMOUSE, m_mouse);
	DDX_Check(pDX, IDK_CAPSPAGE, m_page);
	DDX_Check(pDX, IDK_CAPSSEARCH, m_search);
	DDX_Check(pDX, IDK_CAPSSIZE, m_size);
	DDX_Check(pDX, IDK_CAPSVSCROLL, m_vscroll);
	DDX_Check(pDX, IDK_CAPSZOOM, m_zoom);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCapsDiag, CDialog)
	//{{AFX_MSG_MAP(CCapsDiag)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCapsDiag message handlers

// clpbdiag.cpp : implementation file
//
/*

	Source listing for the DEMO program.
	Copyright Oracle, 1993-2008, all rights reserved.

	This file implement the class for the dialog used for:
		setting the clipboard formats
*/

/////////////////////////////////////////////////////////////////////////////
// CClpbDiag dialog

CClpbDiag::CClpbDiag(CWnd* pParent /*=NULL*/)
	: CDialog(CClpbDiag::IDD, pParent)
{
	//{{AFX_DATA_INIT(CClpbDiag)
	m_bmap = FALSE;
	m_dib = FALSE;
	m_heading = FALSE;
	m_meta = FALSE;
	m_pal = FALSE;
	m_rtf = FALSE;
	m_text = FALSE;
	//}}AFX_DATA_INIT
}

void CClpbDiag::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CClpbDiag)
	DDX_Check(pDX, IDC_BMAP, m_bmap);
	DDX_Check(pDX, IDC_DIB, m_dib);
	DDX_Check(pDX, IDC_HEADINGS, m_heading);
	DDX_Check(pDX, IDC_META, m_meta);
	DDX_Check(pDX, IDC_PAL, m_pal);
	DDX_Check(pDX, IDC_RTF, m_rtf);
	DDX_Check(pDX, IDC_TEXT, m_text);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CClpbDiag, CDialog)
	//{{AFX_MSG_MAP(CClpbDiag)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CClpbDiag message handlers

// colrdiag.cpp : implementation file
//

/////////////////////////////////////////////////////////////////////////////
// CColrDiag dialog

CColrDiag::CColrDiag(CWnd* pParent /*=NULL*/)
	: CDialog(CColrDiag::IDD, pParent)
{
	//{{AFX_DATA_INIT(CColrDiag)
	m_bgB = 0;
	m_bgG = 0;
	m_bgR = 0;
	m_fgB = 0;
	m_fgG = 0;
	m_fgR = 0;
	//}}AFX_DATA_INIT
}

void CColrDiag::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CColrDiag)
	DDX_Text(pDX, IDC_BGB, m_bgB);
	DDV_MinMaxInt(pDX, m_bgB, 0, 255);
	DDX_Text(pDX, IDC_BGG, m_bgG);
	DDV_MinMaxInt(pDX, m_bgG, 0, 255);
	DDX_Text(pDX, IDC_BGR, m_bgR);
	DDV_MinMaxInt(pDX, m_bgR, 0, 255);
	DDX_Text(pDX, IDC_FGB, m_fgB);
	DDV_MinMaxInt(pDX, m_fgB, 0, 255);
	DDX_Text(pDX, IDC_FGG, m_fgG);
	DDV_MinMaxInt(pDX, m_fgG, 0, 255);
	DDX_Text(pDX, IDC_FGR, m_fgR);
	DDV_MinMaxInt(pDX, m_fgR, 0, 255);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CColrDiag, CDialog)
	//{{AFX_MSG_MAP(CColrDiag)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CColrDiag message handlers

// lmbdiag.cpp : implementation file
//
/*

	Source listing for the DEMO program.
	Copyright Oracle, 1993-2008, all rights reserved.

	This file implement the class for the dialog used for:
		setting the action of the Left mouse button when
		trapped by a control.
*/

/////////////////////////////////////////////////////////////////////////////
// CLmbDiag dialog

CLmbDiag::CLmbDiag(CWnd* pParent /*=NULL*/)
	: CDialog(CLmbDiag::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLmbDiag)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void CLmbDiag::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLmbDiag)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLmbDiag, CDialog)
	//{{AFX_MSG_MAP(CLmbDiag)
	ON_BN_CLICKED(ID_LMBNONE, OnClickedLmbnone)
	ON_BN_CLICKED(ID_LMBSELECT, OnClickedLmbselect)
	ON_BN_CLICKED(ID_LMBZOOM, OnClickedLmbzoom)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLmbDiag message handlers

void CLmbDiag::OnClickedLmbnone()
{
	lmb = 0;
}

void CLmbDiag::OnClickedLmbselect()
{
	lmb = 1;
}

void CLmbDiag::OnClickedLmbzoom()
{
	lmb = 2;
}


void CLmbDiag::Default(int lmbp)
{
	ASSERT(lmbp==0 || lmbp==1 || lmbp==2);
	lmb = lmbp;						   

}
BOOL CLmbDiag::OnInitDialog()
{
	CDialog::OnInitDialog();

	UINT def;
	switch (lmb) {
		case 0: def = ID_LMBNONE  ; break;
		case 1: def = ID_LMBSELECT; break;
		case 2: def = ID_LMBZOOM  ; break;
	}
	CheckRadioButton(ID_LMBNONE, ID_LMBZOOM, def);
	return TRUE;  // return TRUE  unless you set the focus to a control
}
				  
// modediag.cpp : implementation file
//
/*

	Source listing for the DEMO program.
	Copyright Oracle, 1993-2008, all rights reserved.

	This file implement the class for the dialog used for:
		getting the values for setting the mode of the control.
*/

/////////////////////////////////////////////////////////////////////////////
// CModeDiag dialog

CModeDiag::CModeDiag(CWnd* pParent /*=NULL*/)
	: CDialog(CModeDiag::IDD, pParent)
{
	//{{AFX_DATA_INIT(CModeDiag)
	m_aniso = FALSE;
	m_drag = FALSE;
	m_exscr = FALSE;
	m_noredr = FALSE;
	m_opaq = FALSE;
	//}}AFX_DATA_INIT
}

void CModeDiag::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CModeDiag)
	DDX_Check(pDX, ID_MODEANISO, m_aniso);
	DDX_Check(pDX, ID_MODEDRAGDROP, m_drag);
	DDX_Check(pDX, ID_MODEEXCSCROLL, m_exscr);
	DDX_Check(pDX, ID_MODENOREDRAW, m_noredr);
	DDX_Check(pDX, ID_MODEOPAQUE, m_opaq);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CModeDiag, CDialog)
	//{{AFX_MSG_MAP(CModeDiag)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CModeDiag message handlers

// numdiag.cpp
/*

	Source listing for the DEMO program.
	Copyright Oracle, 1993-2008, all rights reserved.

	This file implement the class for the dialog used for:
		getting an integer numeric value without titled field.
*/

/////////////////////////////////////////////////////////////////////////////
// CNumdiag dialog

CNumdiag::CNumdiag(CWnd* pParent /*=NULL*/)
	: CDialog(CNumdiag::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNumdiag)
	m_num = 0;
	//}}AFX_DATA_INIT
}

void CNumdiag::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNumdiag)
	DDX_Text(pDX, IDC_EDIT1, m_num);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CNumdiag, CDialog)
	//{{AFX_MSG_MAP(CNumdiag)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNumdiag message handlers				  

// pagediag.cpp : implementation file
//
/*

	Source listing for the DEMO program.
	Copyright Oracle, 1993-2008, all rights reserved.

	This file implement the class for the dialog used for:
		getting a new page number.
*/

/////////////////////////////////////////////////////////////////////////////
// CPageDiag dialog

CPageDiag::CPageDiag(CWnd* pParent /*=NULL*/)
	: CDialog(CPageDiag::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPageDiag)
	m_page = 1;
	//}}AFX_DATA_INIT
}

void CPageDiag::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPageDiag)
	DDX_Text(pDX, IDE_PAGE, m_page);
	DDV_MinMaxUInt(pDX, m_page, 0, 64000);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPageDiag, CDialog)
	//{{AFX_MSG_MAP(CPageDiag)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPageDiag message handlers


// prndiag.cpp : implementation file
/*

	Source listing for the DEMO program.
	Copyright Oracle, 1993-2008, all rights reserved.

	This file implement the class for the dialog used for:
		getting the printing options.
*/
//

/////////////////////////////////////////////////////////////////////////////
// CPrnDiag dialog

CPrnDiag::CPrnDiag(CWnd* pParent /*=NULL*/)
	: CDialog(CPrnDiag::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPrnDiag)
	m_hdBotCent = "BC";
	m_hdBotLeft = "BL";
	m_hdBotRight = "BR";
	m_hdTopCent = "TC";
	m_hdTopLeft = "TL";
	m_hdTopRight = "TR";
	m_graphics = 1;
	m_paper = 1;
	//}}AFX_DATA_INIT
	fit			= TRUE;
	units		  = PIXELS;  
	marginsChanged = FALSE;
	hdrFont		   = NULL;
	prnDlg 		   = NULL;
}

void CPrnDiag::DoDataExchange(CDataExchange* pDX)
{				  
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPrnDiag)
	DDX_Text(pDX, IDE_FOOTERCENTER, m_hdBotCent);
	DDX_Text(pDX, IDE_FOOTERLEFT, m_hdBotLeft);
	DDX_Text(pDX, IDE_FOOTERRIGHT, m_hdBotRight);
	DDX_Text(pDX, IDE_HEADERCENTER, m_hdTopCent);
	DDX_Text(pDX, IDE_HEADERLEFT, m_hdTopLeft);
	DDX_Text(pDX, IDE_HEADERRIGHT, m_hdTopRight);
	DDX_Text(pDX, IDE_OPTIONS_GRAPHICUNIT, m_graphics);
	DDX_Text(pDX, IDE_OPTIONS_PAPERUNIT, m_paper);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPrnDiag, CDialog)
	//{{AFX_MSG_MAP(CPrnDiag)
	ON_BN_CLICKED(IDB_HDRFTRFONT, OnClickedHdrftrfont)
	ON_BN_CLICKED(IDB_OPTIONS_MARGINS, OnClickedOptionsMargins)
	ON_BN_CLICKED(IDB_PRINT_PRINTER, OnClickedPrintPrinter)
	ON_BN_CLICKED(IDC_CMS, OnClickedCms)
	ON_BN_CLICKED(IDC_INCHES, OnClickedInches)
	ON_BN_CLICKED(IDC_PIXELS, OnClickedPixels)
	ON_BN_CLICKED(IDR_OPTIONS_FITTOPAGE, OnClickedOptionsFittopage)
	ON_BN_CLICKED(IDR_OPTIONS_SCALE, OnClickedOptionsScale)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPrnDiag message handlers

// --------------------------------------------------------------------------
void CPrnDiag::OnClickedHdrftrfont()
{
	CHOOSEFONT cf;

	if (hdrFont == NULL) return;  
	/* Set all structure fields to zero. */
	memset(&cf, 0, sizeof(CHOOSEFONT));

	cf.lStructSize = sizeof(CHOOSEFONT);
	cf.hwndOwner = NULL;
	cf.lpLogFont = hdrFont;
	cf.Flags = CF_SCREENFONTS | CF_EFFECTS | CF_INITTOLOGFONTSTRUCT;
	cf.rgbColors = RGB(0, 0, 0); /* black */
	cf.nFontType = SCREEN_FONTTYPE;
	ChooseFont(&cf);
}

// --------------------------------------------------------------------------
void CPrnDiag::OnClickedOptionsMargins()
{
	marginsChanged = (margins.DoModal()==IDOK);
}

// --------------------------------------------------------------------------
void CPrnDiag::OnClickedPrintPrinter()
{   
	if (prnDlg==NULL) return;

	prnDlg->Flags &= ~PD_RETURNDEFAULT;	//::
	PrintDlg(prnDlg);
}

// --------------------------------------------------------------------------
void CPrnDiag::OnClickedCms() { units = CMS; }
void CPrnDiag::OnClickedInches() { units = INCHES; }
void CPrnDiag::OnClickedPixels() { units = PIXELS; }
void CPrnDiag::OnClickedOptionsFittopage() { fit = TRUE; }
void CPrnDiag::OnClickedOptionsScale() { fit = FALSE; }


// --------------------------------------------------------------------------
BOOL CPrnDiag::OnInitDialog()
{
	CDialog::OnInitDialog();
	CheckRadioButton(IDR_OPTIONS_FITTOPAGE, 
						   IDR_OPTIONS_SCALE, IDR_OPTIONS_FITTOPAGE); 
	CheckRadioButton(IDC_CMS, IDC_PIXELS, IDC_PIXELS);						   
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// prnmrgn.cpp : implementation file
/*

	Source listing for the DEMO program.
	Copyright Oracle, 1993-2008, all rights reserved.

	This file implement the class for the dialog used for:
		getting the printer margins.
*/
//

/////////////////////////////////////////////////////////////////////////////
// Cprnmrgn dialog

Cprnmrgn::Cprnmrgn(CWnd* pParent /*=NULL*/)
	: CDialog(Cprnmrgn::IDD, pParent)
{
	units = INCHES;
	//{{AFX_DATA_INIT(Cprnmrgn)
	m_bottom = 0.75;
	m_left = 0.75;
	m_right = 0.75;
	m_top = 0.75;
	//}}AFX_DATA_INIT
}

void Cprnmrgn::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(Cprnmrgn)
	DDX_Text(pDX, IDE_MARGINS_BOTTOM, m_bottom);
	DDX_Text(pDX, IDE_MARGINS_LEFT, m_left);
	DDX_Text(pDX, IDE_MARGINS_RIGHT, m_right);
	DDX_Text(pDX, IDE_MARGINS_TOP, m_top);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(Cprnmrgn, CDialog)
	//{{AFX_MSG_MAP(Cprnmrgn)
	ON_BN_CLICKED(IDR_MARGINS_UNITINCH, OnClickedMarginsUnitinch)
	ON_BN_CLICKED(IDR_MARGINS_UNITMM, OnClickedMarginsUnitmm)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Cprnmrgn message handlers

void Cprnmrgn::OnClickedMarginsUnitinch()
{
	units = INCHES;
}

void Cprnmrgn::OnClickedMarginsUnitmm()
{
	units = CMS;
} 

BOOL Cprnmrgn::OnInitDialog()
{
	CDialog::OnInitDialog();
	CheckRadioButton(IDR_MARGINS_UNITINCH, IDR_MARGINS_UNITMM,
			 				  IDR_MARGINS_UNITINCH);
	return TRUE;  // return TRUE  unless you set the focus to a control
}


// pxyzdiag.cpp : implementation file
//

/////////////////////////////////////////////////////////////////////////////
// CPxyzDiag dialog

CPxyzDiag::CPxyzDiag(CWnd* pParent /*=NULL*/)
	: CDialog(CPxyzDiag::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPxyzDiag)
	m_posx = 0;
	m_posy = 0;
	m_posz = 0;
	//}}AFX_DATA_INIT
}

void CPxyzDiag::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPxyzDiag)
	DDX_Text(pDX, IDE_PANPOSX, m_posx);
	DDX_Text(pDX, IDE_PANPOSY, m_posy);
	DDX_Text(pDX, IDE_PANPOSY2, m_posz);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPxyzDiag, CDialog)
	//{{AFX_MSG_MAP(CPxyzDiag)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPxyzDiag message handlers

// seldiag.cpp : implementation file
//
/*

	Source listing for the DEMO program.
	Copyright Oracle, 1993-2008, all rights reserved.

	This file implement the class for the dialog used for:
		getting a new selection rectangle for the control.
*/


/////////////////////////////////////////////////////////////////////////////
// CSelDiag dialog

CSelDiag::CSelDiag(CWnd* pParent /*=NULL*/)
	: CDialog(CSelDiag::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSelDiag)
	m_page = 1;
	m_selendy = 0;
	m_selstartx = 0;
	m_selstarty = 0;
	m_selendx = 0;
	m_clrFlg = FALSE;
	//}}AFX_DATA_INIT
}

void CSelDiag::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelDiag)
	DDX_Text(pDX, IDE_SELPAGE, m_page);
	DDV_MinMaxUInt(pDX, m_page, 1, 65000);
	DDX_Text(pDX, IDE_SELENDY, m_selendy);
	DDX_Text(pDX, IDE_SELSTARTX, m_selstartx);
	DDX_Text(pDX, IDE_SELSTARTY, m_selstarty);
	DDX_Text(pDX, IDE_SELENDX, m_selendx);
	DDX_Check(pDX, IDC_SELCLEAR, m_clrFlg);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSelDiag, CDialog)
	//{{AFX_MSG_MAP(CSelDiag)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelDiag message handlers


/////////////////////////////////////////////////////////////////////////////
// CCrSelDiag dialog

CCrSelDiag::CCrSelDiag(CWnd* pParent /*=NULL*/)
	: CDialog(CCrSelDiag::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCrSelDiag)
	m_fromFlow = 0;
	m_fromOffset = 0;
	m_fromPage = 0;
	m_toFlow = 0;
	m_toPage = 0;
	m_toOffset = 0;                   
	m_clrFlg = FALSE;
	//}}AFX_DATA_INIT
}

void CCrSelDiag::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCrSelDlg)
	DDX_Text(pDX, IDE_SELFROMFLOW, m_fromFlow);
	DDX_Text(pDX, IDE_SELFROMOFFSET, m_fromOffset);
	DDX_Text(pDX, IDE_SELFROMPAGE, m_fromPage);
	DDX_Text(pDX, IDE_SELTOFLOW, m_toFlow);
	DDX_Text(pDX, IDE_SELTOPAGE, m_toPage);
	DDX_Text(pDX, IDE_SELTOOFFSET, m_toOffset);
	DDX_Check(pDX, IDC_CARETSELCLEAR, m_clrFlg);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCrSelDiag, CDialog)
	//{{AFX_MSG_MAP(CCrSelDiag)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CCrSelDiag message handlers


// srchdiag.cpp : implementation file
//
/*

	Source listing for the DEMO program.
	Copyright Oracle, 1993-2008, all rights reserved.

	This file implement the class for the dialog used for:
		getting a search string.
*/


/////////////////////////////////////////////////////////////////////////////
// CSrchDiag dialog

CSrchDiag::CSrchDiag(CWnd* pParent /*=NULL*/)
	: CDialog(CSrchDiag::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSrchDiag)
	m_txt = "";
	m_wrap = FALSE;
	m_matchCase = FALSE;
	m_matchWord = FALSE;
	m_direction_up = FALSE;
	m_findAll = FALSE;
	m_flow = 1;
	m_offs = 0;
	m_page = 1;
	//}}AFX_DATA_INIT
}

void CSrchDiag::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSrchDiag)
	DDX_Text(pDX, IDE_SEARCH, m_txt);
	DDV_MaxChars(pDX, m_txt, 35);
	DDX_Check(pDX, IDC_SEARCHWRAP, m_wrap);
	DDX_Check(pDX, IDC_SEARCHMATCHCASE, m_matchCase);
	DDX_Check(pDX, IDC_SEARCHMATCHWORD, m_matchWord);
	DDX_Check(pDX, IDC_SEARCHFINDALL, m_findAll);
	DDX_Text(pDX, IDE_SEARCHSPFLOW, m_flow);
	DDV_MinMaxDWord(pDX, m_flow, 1, 1000000000);
	DDX_Text(pDX, IDE_SEARCHSPOFFS, m_offs);
	DDX_Text(pDX, IDE_SEARCHSPPAGE, m_page);
	DDV_MinMaxDWord(pDX, m_page, 1, 1000000);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSrchDiag, CDialog)
	//{{AFX_MSG_MAP(CSrchDiag)
	ON_BN_CLICKED(IDC_SEARCHUP, OnClickedSearchup)
	ON_BN_CLICKED(IDC_SEARCHDOWN, OnClickedSearchdown)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSrchDiag message handlers  
BOOL CSrchDiag::OnInitDialog()
{
	CDialog::OnInitDialog();
	
    if (m_direction_up) {
		CheckRadioButton(IDC_SEARCHUP, IDC_SEARCHDOWN, IDC_SEARCHUP);
	} else {
		CheckRadioButton(IDC_SEARCHUP, IDC_SEARCHDOWN, IDC_SEARCHDOWN);	
	}
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSrchDiag::OnClickedSearchup()
{
	m_direction_up = TRUE;
}

void CSrchDiag::OnClickedSearchdown()
{
	m_direction_up = FALSE;
}


// szediag.cpp : implementation file
//
/*

	Source listing for the DEMO program.
	Copyright Oracle, 1993-2008, all rights reserved.

	This file implement the class for the dialog used for:
		getting the new extents for the control.
*/

/////////////////////////////////////////////////////////////////////////////
// CSzeDiag dialog

CSzeDiag::CSzeDiag(CWnd* pParent /*=NULL*/)
	: CDialog(CSzeDiag::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSzeDiag)
	m_x = 0; m_x1 = 0;
	m_y = 0; m_y1 = 0;
	//}}AFX_DATA_INIT
}

void CSzeDiag::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSzeDiag)
	DDX_Text(pDX, IDE_HEIGHT, m_y1);
	DDX_Text(pDX, IDE_WIDTH, m_x1);
	DDX_Text(pDX, IDE_X, m_x);
	DDX_Text(pDX, IDE_Y, m_y);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSzeDiag, CDialog)
	//{{AFX_MSG_MAP(CSzeDiag)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSzeDiag message handlers

// zoomdiag.cpp : implementation file
//
/*

	Source listing for the DEMO program.
	Copyright Oracle, 1993-2008, all rights reserved. 

	This file implement the class for the dialog used for:
		getting the zoom factors for the control.

*/

/////////////////////////////////////////////////////////////////////////////
// CZoomDiag dialog

CZoomDiag::CZoomDiag(CWnd* pParent /*=NULL*/)
	: CDialog(CZoomDiag::IDD, pParent)
{
	//{{AFX_DATA_INIT(CZoomDiag)
	m_both = FALSE;
	m_x = FALSE;
	m_y = FALSE;
	m_zoom = 0;
	//}}AFX_DATA_INIT
}

void CZoomDiag::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CZoomDiag)
	DDX_Check(pDX, IDK_ZOOMBOTH, m_both);
	DDX_Check(pDX, IDK_ZOOMX, m_x);
	DDX_Check(pDX, IDK_ZOOMY, m_y);
	DDX_Text(pDX, IDE_ZOOMFACTOR, m_zoom);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CZoomDiag, CDialog)
	//{{AFX_MSG_MAP(CZoomDiag)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CZoomDiag message handlers

				  
// wndsze.cpp : implementation file
//                                                                                                                  
/*

	Source listing for the DEMO program.
	Copyright Oracle, 1993-2008, all rights reserved. 

	This file implement the class for the dialog used for:
		getting the new size of the control window.

*/
/////////////////////////////////////////////////////////////////////////////
// wndsze dialog

wndsze::wndsze(CWnd* pParent /*=NULL*/)
	: CDialog(wndsze::IDD, pParent)
{
	//{{AFX_DATA_INIT(wndsze)
	m_height = 0;
	m_width = 0;
	//}}AFX_DATA_INIT
}

void wndsze::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(wndsze)
	DDX_Text(pDX, ID_SIZEWINDOW_HEIGHT, m_height);
	DDX_Text(pDX, ID_SIZEWINDOW_WIDTH, m_width);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(wndsze, CDialog)
	//{{AFX_MSG_MAP(wndsze)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// wndsze message handlers 


/*

	Source listing for the DEMO program.
	Copyright Oracle, 1993-2008, all rights reserved. 

	This file implement the class for the dialog used for:
		getting the new size of the control window.

*/
/////////////////////////////////////////////////////////////////////////////
// wndscrl dialog

wndscrl::wndscrl(CWnd* pParent /*=NULL*/)
	: CDialog(wndscrl::IDD, pParent)
{
	//{{AFX_DATA_INIT(wndscrl)
	m_thmbpos  = 0;
	scrollCode = SB_TOP;
	//}}AFX_DATA_INIT
}

void wndscrl::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(wndscrl)
	DDX_Text(pDX, ID_WINDOWSCROLL_THPOSNUM, m_thmbpos);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(wndscrl, CDialog)
	//{{AFX_MSG_MAP(wndscrl)
	ON_BN_CLICKED(ID_WINDOWSCROLL_BOT, OnClickedWindowscrollBot)
	ON_BN_CLICKED(ID_WINDOWSCROLL_ENDS, OnClickedWindowscrollEnds)
	ON_BN_CLICKED(ID_WINDOWSCROLL_LDN, OnClickedWindowscrollLdn)
	ON_BN_CLICKED(ID_WINDOWSCROLL_LUP, OnClickedWindowscrollLup)
	ON_BN_CLICKED(ID_WINDOWSCROLL_PDN, OnClickedWindowscrollPdn)
	ON_BN_CLICKED(ID_WINDOWSCROLL_PUP, OnClickedWindowscrollPup)
	ON_BN_CLICKED(ID_WINDOWSCROLL_THTRK, OnClickedWindowscrollThtrk)
	ON_BN_CLICKED(ID_WINDOWSCROLL_TOP, OnClickedWindowscrollTop)
	ON_BN_CLICKED(ID_WINDOWSCROLL_THPOS, OnClickedWindowscrollThpos)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// wndscrl message handlers

void wndscrl::OnClickedWindowscrollBot()
{
	scrollCode = SB_BOTTOM;
}

void wndscrl::OnClickedWindowscrollEnds()
{
	scrollCode = SB_ENDSCROLL;
}

void wndscrl::OnClickedWindowscrollLdn()
{
	scrollCode = SB_LINEDOWN;
}

void wndscrl::OnClickedWindowscrollLup()
{
	scrollCode = SB_LINEUP;
}

void wndscrl::OnClickedWindowscrollPdn()
{
	scrollCode = SB_PAGEDOWN;
}

void wndscrl::OnClickedWindowscrollPup()
{
	scrollCode = SB_PAGEUP;
}

void wndscrl::OnClickedWindowscrollThtrk()
{
	scrollCode = SB_THUMBTRACK;
}

void wndscrl::OnClickedWindowscrollTop()
{
	scrollCode = SB_TOP;
}

void wndscrl::OnClickedWindowscrollThpos()
{
	scrollCode = SB_THUMBPOSITION;
}				 

/////////////////////////////////////////////////////////////////////////////
// CRowCol dialog

CRowCol::CRowCol(CWnd* pParent /*=NULL*/)
	: CDialog(CRowCol::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRowCol)
	m_entityNumber  = 0;
	unitCode = CTLUNIT_TWIPS;
	//}}AFX_DATA_INIT
}

void CRowCol::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(wndscrl)
	DDX_Text(pDX, ID_ROWCOLUMN_ENTITYNUMBER, m_entityNumber);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CRowCol, CDialog)
	//{{AFX_MSG_MAP(wndscrl)
	ON_BN_CLICKED(ID_ROWCOLUMN_PIXELS, OnClickedRowColumnPixels)
	ON_BN_CLICKED(ID_ROWCOLUMN_TWIPS, OnClickedRowColumnTwips)
	ON_BN_CLICKED(ID_ROWCOLUMN_INCHES, OnClickedRowColumnInches)
	ON_BN_CLICKED(ID_ROWCOLUMN_MILLIMETERS, OnClickedRowColumnMillimeters)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRowCol message handlers

void CRowCol::OnClickedRowColumnPixels()
{
	unitCode = CTLUNIT_PIXEL;
}

void CRowCol::OnClickedRowColumnTwips()
{
	unitCode = CTLUNIT_TWIPS;
}

void CRowCol::OnClickedRowColumnInches()
{
	unitCode = CTLUNIT_INCH;
}

void CRowCol::OnClickedRowColumnMillimeters()
{
	unitCode = CTLUNIT_MM;
}

// --------------------------------------------------------------------------
BOOL CRowCol::OnInitDialog()
{
	CDialog::OnInitDialog();
	CheckRadioButton(ID_ROWCOLUMN_PIXELS, ID_ROWCOLUMN_MILLIMETERS,
		 ID_ROWCOLUMN_TWIPS);						   
	return TRUE;  // return TRUE  unless you set the focus to a control
}


/////////////////////////////////////////////////////////////////////////////
// CPrntPrvw dialog


CPrntPrvw::CPrntPrvw(CWnd* pParent /*=NULL*/)
	: CDialog(CPrntPrvw::IDD, pParent)
{
	printPreview = NULL;
	//{{AFX_DATA_INIT(CPrntPrvw)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void CPrntPrvw::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPrntPrvw)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CPrntPrvw, CDialog)
	//{{AFX_MSG_MAP(CPrntPrvw)
	ON_WM_DRAWITEM()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CPrntPrvw message handlers
void CPrntPrvw::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct)
{
        if (printPreview != NULL) {
		CDC	dc;
		int	dcID, ox, oy, w, h;
		
	        dc.m_hDC = lpDrawItemStruct->hDC;
	        dcID = dc.SaveDC();
                
                dc.SetMapMode(MM_ANISOTROPIC);

		w  = (int)(printPreview->allPagesRect.right - printPreview->allPagesRect.left + 1);
		h  = (int)(printPreview->allPagesRect.bottom - printPreview->allPagesRect.top + 1);
		dc.SetWindowExt(w, h);
		w  = lpDrawItemStruct->rcItem.right - lpDrawItemStruct->rcItem.left - 10;
		h  = lpDrawItemStruct->rcItem.bottom - lpDrawItemStruct->rcItem.top - 10;
		dc.SetViewportExt(w, h);
		ox = (int)printPreview->allPagesRect.left;
		oy = (int)printPreview->allPagesRect.top;
		dc.SetWindowOrg(ox, oy);
		ox = 5 + lpDrawItemStruct->rcItem.left;
		oy = 5 + lpDrawItemStruct->rcItem.top;
		dc.SetViewportOrg(ox, oy);
	
		// Draw logical pages
		CRect		logPage(0, 0, 0, 0);
		LPRECT		lpRect;
		WORD 		i;	
		int		x, y;
		
		lpRect = (LPRECT) GlobalLock(printPreview->clipRects);
		
		dc.SelectStockObject(NULL_PEN);
		dc.SelectStockObject(LTGRAY_BRUSH);
		
		w = printPreview->deviceRect.right - printPreview->deviceRect.left + 1;
		h = printPreview->deviceRect.bottom - printPreview->deviceRect.top + 1;
		for (y = 0; y < printPreview->nVertPages; y++) {
			for (x = 0; x < printPreview->nHorzPages; x++) {
				i = y * printPreview->nHorzPages + x;
				
				logPage.left    = (int)(lpRect[i].left   + x * w);
				logPage.top     = (int)(lpRect[i].top    + y * h);	
				logPage.right  	= (int)(lpRect[i].right  + x * w);
				logPage.bottom	= (int)(lpRect[i].bottom + y * h);

				dc.Rectangle(logPage); 
			}
		}			
		GlobalUnlock(printPreview->clipRects);
		
		// Draw Physical pages
		dc.SelectStockObject(NULL_BRUSH);
		dc.SelectStockObject(BLACK_PEN);

		
		// Draw bounding box
		logPage.left  = (int) printPreview->allPagesRect.left;
		logPage.top   = (int) printPreview->allPagesRect.top;
		logPage.right = (int) printPreview->allPagesRect.right;
		logPage.bottom= (int) printPreview->allPagesRect.bottom;
		dc.Rectangle(logPage);
		
		// Draw inner lines
		ox = logPage.left;
		oy = logPage.top;

		h  = (int)(printPreview->allPagesRect.bottom - printPreview->allPagesRect.top + 1);		
		h  /= printPreview->nVertPages;
		w  = (int)(printPreview->allPagesRect.right - printPreview->allPagesRect.left + 1);
		for (i = 1; i < printPreview->nVertPages; i++) {
			dc.MoveTo(ox  , oy + i * h);
			dc.LineTo(ox+w, oy + i * h);
		}

		h  = (int)(printPreview->allPagesRect.bottom - printPreview->allPagesRect.top + 1);
		w  = (int)(printPreview->allPagesRect.right - printPreview->allPagesRect.left + 1);
		w  /= printPreview->nHorzPages;		
		for (i = 1; i < printPreview->nHorzPages; i++) {
			dc.MoveTo(ox + i * w, oy  );
			dc.LineTo(ox + i * w, oy+h);
		}
		
		dc.RestoreDC(dcID);
	}

	CDialog::OnDrawItem(nIDCtl, lpDrawItemStruct);
}


/////////////////////////////////////////////////////////////////////////////
// CSortDlg dialog


CSortDlg::CSortDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSortDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSortDlg)
	m_fromRange = 1;
	m_key1Flow = 1;
	m_key2Flow = 1;
	m_key3Flow = 1;
	m_toRange = 1;
	//}}AFX_DATA_INIT  
	
	m_sortBy = PAN_SORTROWS;
	m_key1Dir= PAN_SORTDOWN;
	m_key2Dir= PAN_SORTNONE;
	m_key3Dir= PAN_SORTNONE;
}

void CSortDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSortDlg)
	DDX_Text(pDX, IDC_SORT_FROMRANGE, m_fromRange);
	DDX_Text(pDX, IDC_SORT_KEY1FLOW, m_key1Flow);
	DDX_Text(pDX, IDC_SORT_KEY2FLOW, m_key2Flow);
	DDX_Text(pDX, IDC_SORT_KEY3FLOW, m_key3Flow);
	DDX_Text(pDX, IDC_SORT_TORANGE, m_toRange);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSortDlg, CDialog)
	//{{AFX_MSG_MAP(CSortDlg)
	ON_BN_CLICKED(IDC_SORT_BYCOLS, OnSortBycols)
	ON_BN_CLICKED(IDC_SORT_BYROWS, OnSortByrows)
	ON_BN_CLICKED(IDC_SORT_KEY1DIRDOWN, OnSortKey1dirdown)
	ON_BN_CLICKED(IDC_SORT_KEY1DIRNONE, OnSortKey1dirnone)
	ON_BN_CLICKED(IDC_SORT_KEY1DIRUP, OnSortKey1dirup)
	ON_BN_CLICKED(IDC_SORT_KEY2DIRDOWN, OnSortKey2dirdown)
	ON_BN_CLICKED(IDC_SORT_KEY2DIRNONE, OnSortKey2dirnone)
	ON_BN_CLICKED(IDC_SORT_KEY2DIRUP, OnSortKey2dirup)
	ON_BN_CLICKED(IDC_SORT_KEY3DIRDOWN, OnSortKey3dirdown)
	ON_BN_CLICKED(IDC_SORT_KEY3DIRNONE, OnSortKey3dirnone)
	ON_BN_CLICKED(IDC_SORT_KEY3DIRUP, OnSortKey3dirup)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSortDlg message handlers

void CSortDlg::OnSortBycols()
{
	m_sortBy = PAN_SORTCOLS;
}

void CSortDlg::OnSortByrows()
{
	m_sortBy = PAN_SORTROWS;
}

void CSortDlg::OnSortKey1dirdown()
{
	m_key1Dir = PAN_SORTDOWN;
	EnableKey2();
}

void CSortDlg::OnSortKey1dirnone()
{
	m_key1Dir = PAN_SORTNONE;
	DisableKey2();
	DisableKey3();
}

void CSortDlg::OnSortKey1dirup()
{
	m_key1Dir = PAN_SORTUP;
	EnableKey2();
}

void CSortDlg::OnSortKey2dirdown()
{
	m_key2Dir = PAN_SORTDOWN;
	EnableKey3();
}

void CSortDlg::OnSortKey2dirnone()
{
	m_key2Dir = PAN_SORTNONE;
	DisableKey3();
}

void CSortDlg::OnSortKey2dirup()
{
	m_key2Dir = PAN_SORTUP;
	EnableKey3();
}

void CSortDlg::OnSortKey3dirdown()
{
	m_key3Dir = PAN_SORTDOWN;
}

void CSortDlg::OnSortKey3dirnone()
{
	m_key3Dir = PAN_SORTNONE;
}

void CSortDlg::OnSortKey3dirup()
{
	m_key3Dir = PAN_SORTUP;
}

// Private functions
void CSortDlg::EnableKey2()
{
	CWnd *item;
	
	item = GetDlgItem(IDC_SORT_KEY2FLOW)	; item->EnableWindow(TRUE);
	item = GetDlgItem(IDC_SORT_KEY2DIRNONE)	; item->EnableWindow(TRUE);
	item = GetDlgItem(IDC_SORT_KEY2DIRUP)	; item->EnableWindow(TRUE);
	item = GetDlgItem(IDC_SORT_KEY2DIRDOWN)	; item->EnableWindow(TRUE);
}

void CSortDlg::DisableKey2()
{
	CWnd *item;
	
	item = GetDlgItem(IDC_SORT_KEY2FLOW)	; item->EnableWindow(FALSE);
	item = GetDlgItem(IDC_SORT_KEY2DIRNONE)	; item->EnableWindow(FALSE);
	item = GetDlgItem(IDC_SORT_KEY2DIRUP)	; item->EnableWindow(FALSE);
	item = GetDlgItem(IDC_SORT_KEY2DIRDOWN)	; item->EnableWindow(FALSE);
}

void CSortDlg::EnableKey3()
{
	CWnd *item;
	
	item = GetDlgItem(IDC_SORT_KEY3FLOW)	; item->EnableWindow(TRUE);
	item = GetDlgItem(IDC_SORT_KEY3DIRNONE)	; item->EnableWindow(TRUE);
	item = GetDlgItem(IDC_SORT_KEY3DIRUP)	; item->EnableWindow(TRUE);
	item = GetDlgItem(IDC_SORT_KEY3DIRDOWN)	; item->EnableWindow(TRUE);
}

void CSortDlg::DisableKey3()
{   
	CWnd *item;
	
	item = GetDlgItem(IDC_SORT_KEY3FLOW)	; item->EnableWindow(FALSE);
	item = GetDlgItem(IDC_SORT_KEY3DIRNONE)	; item->EnableWindow(FALSE);	
	item = GetDlgItem(IDC_SORT_KEY3DIRUP)	; item->EnableWindow(FALSE);
	item = GetDlgItem(IDC_SORT_KEY3DIRDOWN)	; item->EnableWindow(FALSE);
}

BOOL CSortDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CButton *item;
	
	// Check radio buttons to the default values.
	item = (CButton *)GetDlgItem(IDC_SORT_BYROWS)		; item->SetCheck(2);
	item = (CButton *)GetDlgItem(IDC_SORT_KEY1DIRDOWN)	; item->SetCheck(2);	
	item = (CButton *)GetDlgItem(IDC_SORT_KEY2DIRNONE)	; item->SetCheck(2);
	item = (CButton *)GetDlgItem(IDC_SORT_KEY3DIRNONE)	; item->SetCheck(2);	
	
	// Disable key2 and Key3 fields
	DisableKey3();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
// CImgExDlg dialog


CImgExDlg::CImgExDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CImgExDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CImgExDlg)
	m_antiAlias = TRUE;
	m_invert	= FALSE;
	m_x = 0;
	//}}AFX_DATA_INIT
}

void CImgExDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CImgExDlg)
	DDX_Check(pDX, IDK_SETIMAGEEX_ANTIALIAS, m_antiAlias);
	DDX_Check(pDX, IDK_SETIMAGEEX_INVERT, m_invert);
	DDX_Text(pDX, IDE_X, m_x);
	DDV_MinMaxInt(pDX, m_x, -100, 100);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CImgExDlg, CDialog)
	//{{AFX_MSG_MAP(CImgExDlg)

	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CImgExDlg message handlers

BOOL CImgExDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CButton *item;	

	if (m_antiAlias) {
		item = (CButton *)GetDlgItem(IDK_SETIMAGEEX_ANTIALIAS); 
		item->SetCheck(m_antiAlias);
	}
	
	if( m_invert ) {
		item = (CButton *)GetDlgItem(IDK_SETIMAGEEX_INVERT);
		item->SetCheck(m_invert);					
	}	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
// CSetBlockDlg dialog


CSetBlockDlg::CSetBlockDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSetBlockDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetBlockDlg)
	m_x = 0;
	//}}AFX_DATA_INIT
}

void CSetBlockDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetBlockDlg)
	DDX_Text(pDX, IDE_X, m_x);
	DDV_MinMaxInt(pDX, m_x, -1, 32767);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSetBlockDlg, CDialog)
	//{{AFX_MSG_MAP(CSetBlockDlg)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSetBlockDlg message handlers


/////////////////////////////////////////////////////////////////////////////
// CSetLayerDlg dialog


CSetLayerDlg::CSetLayerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSetLayerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetLayerDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_hwnd      = 0;
	m_list      = 0;               
	m_numLayers = 0;
	m_layers 	= 0;
}

CSetLayerDlg::~CSetLayerDlg() 
{
	if (m_layers) {   
		delete m_layers;
		m_layers = 0;
	}
}
		
void CSetLayerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetLayerDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSetLayerDlg, CDialog)
	//{{AFX_MSG_MAP(CSetLayerDlg)
	ON_LBN_DBLCLK(IDC_LIST1, OnDblclkList1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSetLayerDlg message handlers

BOOL CSetLayerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	if (m_hwnd) {
		int 	indx;
		char 	str[30];

		//delete old layer buffer
		if (m_layers) {
			delete m_layers;
			m_layers = 0;
		}

		//Get number of layers
		m_numLayers = ::SendMessage(m_hwnd, PM_CTLGETLAYERSTATE, 0, NULL);
		if (m_numLayers <= 0) return TRUE;

		//Create buffer
		m_layers = (PAN_LAYER FAR*) new char[ m_numLayers * sizeof(PAN_LAYER) ]; 
		
		//Get all layers
		m_numLayers = ::SendMessage(m_hwnd, PM_CTLGETLAYERSTATE, (WPARAM)m_numLayers,
									(LPARAM) ((PAN_LAYER FAR *) m_layers));

		if (m_numLayers <= 0) return TRUE;      
		m_list = (CListBox *)GetDlgItem(IDC_LIST1);
		if (m_list == 0 || m_layers == 0) return TRUE;
		
		for (indx = 0; indx < m_numLayers; indx++) {
			wsprintf((LPSTR)str, "Layer: %3d   Status: ", indx);
			if (m_layers[indx].bState)
				lstrcat((LPSTR)str, "ON");
			else 	
				lstrcat((LPSTR)str, "OFF");		
				
			// Add string to the list
			m_list->AddString((LPSTR)str);	
		}
	}
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSetLayerDlg::OnDblclkList1()
{
	if (m_list && m_layers) {
		int 	curSel = m_list->GetCurSel();
		char 	str[30];
	
		wsprintf((LPSTR)str, "Layer: %3d   Status:", curSel);
		if (m_layers[curSel].bState) {
			// Toggle to OFF
			m_layers[curSel].bState = FALSE;
			lstrcat((LPSTR)str, "OFF");			
		} else {
			// Toggle to ON
			m_layers[curSel].bState = TRUE;
			lstrcat((LPSTR)str, "ON");
		}
		
		m_list->DeleteString(curSel);
		m_list->InsertString(curSel, (LPSTR)str);
	}	
}

/////////////////////////////////////////////////////////////////////////////
// CSetViewDlg dialog


CSetViewDlg::CSetViewDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSetViewDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetViewDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_hwnd = 0;
	m_curSel = 0;
}

void CSetViewDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetViewDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSetViewDlg, CDialog)
	//{{AFX_MSG_MAP(CSetViewDlg)
	ON_CBN_SELCHANGE(IDC_COMBO1, OnSelchangeCombo1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSetViewDlg message handlers

BOOL CSetViewDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	int indx, numAvail;
	PAN_VIEW ViewBuf[64]; 
	
	if (m_hwnd) {
		CComboBox *combo;
		
		numAvail = ::SendMessage(m_hwnd, PM_CTLGETVIEWNAMES, (WPARAM)64,
					(LPARAM) ((PAN_VIEW FAR *) ViewBuf));
		if (numAvail <= 0) return TRUE;
		
		combo = (CComboBox *)GetDlgItem(IDC_COMBO1);
		if (combo == 0) return TRUE;
	
		combo->AddString((LPSTR) "DEFAULT");
		for (indx = 0; indx < numAvail; indx++) {
			combo->AddString((LPSTR)ViewBuf[indx].name);
		}
		combo->SetCurSel(m_curSel);
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}


void CSetViewDlg::OnSelchangeCombo1()
{
	CComboBox *combo;
	
	combo = (CComboBox *)GetDlgItem(IDC_COMBO1);
	m_curSel = combo->GetCurSel();
}

/////////////////////////////////////////////////////////////////////////////
// CFlowDiag dialog


CFlowDiag::CFlowDiag(CWnd* pParent /*=NULL*/)
	: CDialog(CFlowDiag::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFlowDiag)
	m_flow = 1;
	//}}AFX_DATA_INIT
}


void CFlowDiag::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFlowDiag)
	DDX_Text(pDX, IDC_EDIT2, m_flow);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFlowDiag, CDialog)
	//{{AFX_MSG_MAP(CFlowDiag)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CFlowDiag message handlers


/////////////////////////////////////////////////////////////////////////////
// CGetStringDlg dialog


CGetStringDlg::CGetStringDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CGetStringDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGetStringDlg)
	m_x = 0;
	//}}AFX_DATA_INIT
}

void CGetStringDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGetStringDlg)
	DDX_Text(pDX, IDE_X, m_x);
	DDV_MinMaxInt(pDX, m_x, -1, 32767);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CGetStringDlg, CDialog)
	//{{AFX_MSG_MAP(CGetStringDlg)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CGetStringDlg message handlers


