/*
**	Source listing for the DEMO program.
**	Copyright Oracle, 1993-2008, all rights reserved.
** mainfrm.cpp : implementation of the CMainFrame class
*/

#include "stdafx.h"
#include "pctl.h"
#include "demo.h"
#include "demodoc.h"
#include "demoview.h"

#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

////////////////////////////////////////////////////////////////////////////////
// CMyMDIChildWnd

IMPLEMENT_DYNCREATE(CMyMDIChildWnd, CMDIChildWnd)

BEGIN_MESSAGE_MAP(CMyMDIChildWnd, CMDIChildWnd)
	//{{AFX_MSG_MAP(CMyMDIChildWnd)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

////////////////////////////////////////////////////////////////////////////////
// Try closing the MDI child window.
// Return TRUE if the window is successfully closed, FALSE otherwise.
//
BOOL CMyMDIChildWnd::Close()
{
	OnClose();
	return m_fClose;
}

////////////////////////////////////////////////////////////////////////////////
// Try closing the MDI child window.
// Set m_fClose to TRUE if all contained regions are successfully destroyed,
// to FALSE otherwise.
//
void CMyMDIChildWnd::OnClose()
{
	// Assume child window can be closed.
	m_fClose = TRUE;

	// Get list of regions.
	CDemoView* pView = GetCurrentView();
	CDemoDoc* pDoc = pView->GetDocument();
	CObList* pList = pDoc->GetPanRgnList();

	if (pList != 0) {
		// Try destroying each region.
		for (POSITION pos = pList->GetHeadPosition(); pos != 0; ) {
			CPanCtRgn* pRgn = (CPanCtRgn*) pList->GetNext(pos);
			if (pRgn != 0) {
				DWORD status = PAN_CTLSTATUSIDLE;
				HWND  hCtl   = pRgn->GetCtlHandle();

				if (hCtl != 0) {
					::SendMessage(hCtl, PM_CTLGETSTATUS, 0, (LPARAM) &status);
					::SendMessage(hCtl, PM_CTLDESTROY, 0, 0);
				}

				if (status == PAN_CTLSTATUSIDLE) {
					pDoc->Delete(pRgn);
				} else {
					m_fClose = FALSE;
				}
			}
		}
	}

	if (m_fClose) {
		// Close child window.
		CMDIChildWnd::OnClose();
	} else {
		// Postpone closing.
		PostMessage(WM_NULL,  0, 0);
		PostMessage(WM_NULL,  0, 0);
		PostMessage(WM_NULL,  0, 0);
		PostMessage(WM_NULL,  0, 0);
		PostMessage(WM_CLOSE, 0, 0);
	}
}     

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_UPDATE_COMMAND_UI(ID_FILE_OPEN, OnUpdateFileOpen)
	ON_WM_PALETTECHANGED()
	ON_WM_QUERYNEWPALETTE()
	ON_WM_SETFOCUS()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize control bars

// toolbar buttons - IDs are command buttons
static UINT BASED_CODE buttons[] =
{
	// same order as in the bitmap 'toolbar.bmp'
	ID_FILE_NEW,
	ID_FILE_OPEN,
		ID_SEPARATOR,
	ID_FILE_PRINT,
	ID_APP_ABOUT,
};

static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,			// status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	CDemoApp* pApp = (CDemoApp*)AfxGetApp();

	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadBitmap(IDR_MAINFRAME) ||
		!m_wndToolBar.SetButtons(buttons,
		  sizeof(buttons)/sizeof(UINT)))
	{
		TRACE("Failed to create toolbar\n");
		return -1;		// fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE("Failed to create status bar\n");
		return -1;		// fail to create
	}
	CRect rc;
	rc.left = pApp->GetProfileInt("MainWindow", "Left", 5);
	rc.top = pApp->GetProfileInt("MainWindow", "Top",  5);
	rc.right = pApp->GetProfileInt("MainWindow", "Right",300);
	rc.bottom = pApp->GetProfileInt("MainWindow", "Bottom",300);
	MoveWindow(rc.left, rc.top, rc.right - rc.left, rc.bottom- rc.top, TRUE);

	return 0;
}

//------------------------------------------------------------------------------
void CMainFrame::OnClose()
{
	BOOL fClose = TRUE;
	BOOL bidon;
	CMyMDIChildWnd* pChildWnd;

	while ((pChildWnd = (CMyMDIChildWnd*) MDIGetActive(&bidon)) != 0) {
		MDINext();

		if (! pChildWnd->Close()) {
			fClose = FALSE;
		}
	}		

	if (fClose) {
		/*
		** Save frame window position and size.
		*/
		CRect wndRect;
		GetWindowRect(&wndRect);
		CDemoApp* pApp = (CDemoApp*) AfxGetApp();
		pApp->WriteProfileInt("MainWindow", "Left",   wndRect.left);
		pApp->WriteProfileInt("MainWindow", "Top",    wndRect.top);
		pApp->WriteProfileInt("MainWindow", "Right",  wndRect.right);
		pApp->WriteProfileInt("MainWindow", "Bottom", wndRect.bottom);

		/*
		** Close frame window.
		*/
		CMDIFrameWnd::OnClose();
	} else {
		/*
		** Postpone closing.
		*/
		PostMessage(WM_NULL,  0, 0);
		PostMessage(WM_NULL,  0, 0);
		PostMessage(WM_NULL,  0, 0);
	 	PostMessage(WM_NULL,  0, 0);
		PostMessage(WM_CLOSE, 0, 0);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

void CMainFrame::OnUpdateFileOpen(CCmdUI* pCmdUI)
{
	pCmdUI->Enable(GetActiveDocument()!=NULL);
}

/*----------------------------------------------------------------------------*/
void CMainFrame::OnPaletteChanged(CWnd* pFocusWnd)
{
        CMDIFrameWnd::OnPaletteChanged(pFocusWnd);

        // always realize the palette for the active view
        CMDIChildWnd* pMDIChildWnd = MDIGetActive();
        if (pMDIChildWnd == NULL)    
                return; // no active MDI child frame
        CView* pView = pMDIChildWnd->GetActiveView();
        ASSERT(pView != NULL);

        // notify all child windows that the palette has changed
      	SendMessageToDescendants(WM_PALETTECHANGED, (WPARAM)pView->m_hWnd);
}
/*----------------------------------------------------------------------------*/

BOOL CMainFrame::OnQueryNewPalette()
{
        // always realize the palette for the active view
        CMDIChildWnd* pMDIChildWnd = MDIGetActive();

        if (pMDIChildWnd == NULL)
                return (FALSE); // no active MDI child frame (no new palette)

        CView*	pView = pMDIChildWnd->GetActiveView();

        ASSERT(pView != NULL);

        // just notify the target view
        pView->SendMessage(WM_QUERYNEWPALETTE);

        return (TRUE);
}

/*----------------------------------------------------------------------------*/
void CMainFrame::OnSetFocus(CWnd *pOldWnd)
{
    // Set focus to the active control
    CMDIChildWnd* pMDIChildWnd = MDIGetActive();
    if (pMDIChildWnd != NULL) {
        CView* pView = pMDIChildWnd->GetActiveView();
	    if (pView != NULL) {
			CDemoDoc* pDoc = (CDemoDoc *)pView->GetDocument();
			if (pDoc != NULL ) {
				CPanCtRgn* pRgn = pDoc->GetCurrRgn();
                if( pRgn != NULL ) {
                 	pDoc->Select( pRgn );
                }
	    	}
        }
   }
}
/*----------------------------------------------------------------------------*/
