/*
**	Source listing for the DEMO program.
**	Copyright Oracle, 1993-2008, all rights reserved.
**
**	This file implement the class for the dialog used for:
**		getting the new enabled/disabled capabilities of the
**		control.
** WndOut.cpp : implementation file
*/

#include "stdafx.h"
#include <commdlg.h>
#include <stdarg.h>

#include "resource.h"
#include "demo.h"
#include "outwnd.h"

#ifdef _DEBUG						  
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif		 

/////////////////////////////////////////////////////////////////////////////
IMPLEMENT_DYNCREATE(CWndOut, CFrameWnd)


CWndOut::CWndOut()
{  
	m_noOutput = FALSE;
}

CWndOut::~CWndOut()
{ 
}


BEGIN_MESSAGE_MAP(CWndOut, CFrameWnd)
	//{{AFX_MSG_MAP(CWndOut)
	ON_WM_CREATE()
	ON_WM_DESTROY() 
	ON_WM_SIZE()
	ON_COMMAND(ID_EDIT_CLEARALL, OnClearBuffer)
	ON_WM_SETFOCUS()
	ON_COMMAND(ID_OPTIONS_NOOUTPUT, OnOptionsNooutput)
	ON_UPDATE_COMMAND_UI(ID_OPTIONS_NOOUTPUT, OnUpdateOptionsNooutput)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWndOut message handlers

static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,			// status line indicator
};

int CWndOut::OnCreate(LPCREATESTRUCT lpCreateStruct)
{						  
	CRect		rc;

	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	GetDesktopWindow()->GetWindowRect(&rc);

	CDemoApp	*pApp = (CDemoApp*)AfxGetApp();

#if 0
	if (!m_wndStatusBar.Create(this) || !m_wndStatusBar.SetIndicators(indicators, sizeof(indicators)/sizeof(UINT)))
	{
		TRACE("Failed to create status bar\n");
		return -1;		// fail to create
	}
	m_wndStatusBar.SetPaneInfo(0, 0, SBPS_STRETCH, 0);
#endif

	if (! CreateListBox()) {
		TRACE("Failed to create Listbox\n");
		return -1;	  // fail to create
	}

	rc.top = rc.bottom -100;
	rc.left = pApp->GetProfileInt("OutWindow", "Left",rc.left );
	rc.top = pApp->GetProfileInt("OutWindow", "Top",rc.top  );
	rc.right = pApp->GetProfileInt("OutWindow", "Right",rc.right);
	rc.bottom = pApp->GetProfileInt("OutWindow", "Bottom",rc.bottom);

	// position the window at the lower left corner of workspace
	MoveWindow(rc.left, rc.top, rc.right - rc.left, rc.bottom- rc.top, TRUE);

	return 0;
}
   
   
void CWndOut::OnClearBuffer()
{
	if (this == NULL) {
		return;
	}
	m_wndListBox.ResetContent();
}


void CWndOut::SendToOutput(char* fmt, ...)
//
// Output the formatted string 
{
	if (this == NULL || m_noOutput) {
		return;
	}

	va_list args;
	static  char buff[1025];
	char*   pt;

	strcpy(buff,"");

	/* Format message string. */
	va_start(args, fmt);
	vsprintf(buff, fmt, args);			  
	va_end(args);
 
 	pt = strstr(buff, "\r"); if (pt) *pt='\0';
 	pt = strstr(buff, "\n"); if (pt) *pt='\0';

	if (!::IsWindow(m_wndListBox.m_hWnd)) {
		return;
	}
	int err = m_wndListBox.AddString(buff); // append new string
	if (err==LB_ERRSPACE) {			// list is full
		m_wndListBox.DeleteString(0);	// remove first el. of list
		m_wndListBox.AddString(buff);	// append new item
	}
	// scroll list so that the last	12 items are visible
	int	nHeightItem = m_wndListBox.GetItemHeight(0);
	CRect rc ;
	m_wndListBox.GetClientRect(&rc);
	int nListBoxHeight = rc.bottom - rc.top;

	int nShownLines = nListBoxHeight/ nHeightItem;
	int nCount =m_wndListBox.GetCount(); 
	m_wndListBox.SetTopIndex(nCount > nShownLines?  nCount-nShownLines: nCount);
}


BOOL CWndOut::CreateListBox()
{				 
	if (::IsWindow(m_wndListBox.m_hWnd)) {
		m_wndListBox.DestroyWindow();
	}
	
	CRect rc;
	GetClientRect(&rc);
	
	if (!m_wndListBox.Create(WS_CHILD|WS_VISIBLE|WS_HSCROLL|WS_VSCROLL, rc, this, IDR_OUTTYPE)) {
		return (FALSE);
	}
	Invalidate();
	return (TRUE);
}				   

void CWndOut::OnSize(UINT nType, int cx, int cy)
{	 
	CWnd::OnSize(nType, cx, cy);
	
	CRect rc;
	m_wndListBox.GetWindowRect(rc);
	ScreenToClient(rc);
	rc.SetRect(rc.left, rc.top, cx, cy);
	m_wndListBox.MoveWindow(rc, TRUE);
}

void CWndOut::OnDestroy()
{
	CRect rc;
	GetWindowRect(rc);
	CDemoApp* pApp = (CDemoApp*)AfxGetApp();
	pApp->WriteProfileInt("OutWindow", "Left", rc.left);
	pApp->WriteProfileInt("OutWindow", "Top", rc.top);
	pApp->WriteProfileInt("OutWindow", "Right", rc.right);
	pApp->WriteProfileInt("OutWindow", "Bottom", rc.bottom);
}

void CWndOut::OnOptionsNooutput()
{
	if (m_noOutput == FALSE) {
		m_noOutput = TRUE;
	} else {
		m_noOutput = FALSE;
	}				
	
}

void CWndOut::OnUpdateOptionsNooutput(CCmdUI* pCmdUI)
{
	pCmdUI->SetCheck(m_noOutput);	
}
