// view.cpp : implementation of the CSampView class
//

#include "stdafx.h"
#include "app.h"

#include "doc.h"
#include "view.h"

#include "pan.h"
#include "ftype.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSampView

IMPLEMENT_DYNCREATE(CSampView, CFormView)

BEGIN_MESSAGE_MAP(CSampView, CFormView)
	//{{AFX_MSG_MAP(CSampView)
	ON_BN_CLICKED(IDTEST, OnTest)
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSampView construction/destruction

CSampView::CSampView()
	: CFormView(CSampView::IDD)
{
	//{{AFX_DATA_INIT(CSampView)
	m_strFile = _T("");
	m_outFile = _T("");
	m_outDMType = _T("");
	m_outType = _T("");
	//}}AFX_DATA_INIT
	// TODO: add construction code here
}

CSampView::~CSampView()
{
}

void CSampView::OnInitialUpdate()
{
	// called first time after construct
	ResizeParentToFit(FALSE);
	CFormView::OnInitialUpdate();
}

void CSampView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSampView)
	DDX_Text(pDX, IDC_INTPUTFILE, m_strFile);
	DDX_Text(pDX, IDC_OUT_FILE, m_outFile);
	DDX_Text(pDX, IDC_OUT_DMTYPE, m_outDMType);
	DDX_Text(pDX, IDC_OUT_TYPE, m_outType);
	//}}AFX_DATA_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CSampView diagnostics

#ifdef _DEBUG
void CSampView::AssertValid() const
{
	CFormView::AssertValid();
}

void CSampView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CSampDoc* CSampView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSampDoc)));
	return (CSampDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSampView message handlers


void CSampView::OnTest() 
{
	UpdateData(TRUE);
	struct stat	sb;

	memset(&sb, 0, sizeof(sb));
	if (stat(m_strFile, &sb) != 0) {
		AfxMessageBox("The file does not exist!");
		return;
	}
	HCURSOR	hOldCursor = ::SetCursor(LoadCursor(0, IDC_WAIT));
	char	szVCETType[_MAX_PATH] = "";
	char	szMappedType[_MAX_PATH] = "";
	FileType(m_strFile, szVCETType, szMappedType);
	m_outFile = m_strFile;
	m_outType = szVCETType;
	m_outDMType = szMappedType;
	::SetCursor(hOldCursor);
	UpdateData(FALSE);
}

void CSampView::OnBrowse() 
{
	// TODO: Add your control notification handler code here
	CFileDialog fDlg(TRUE, 0, "*.*", OFN_FILEMUSTEXIST | OFN_HIDEREADONLY, "All Files (*.*)|*.*||", this);
	if (fDlg.DoModal() != IDOK) {
		return;
	}
	m_strFile = fDlg.GetPathName();
	UpdateData(FALSE);
	OnTest();
}
