// Markup Control Wrapper For AutoVue Implementation File -- MRKPCTL.CPP 
//
#include "stdafx.h"

#include <vector>

BOOL	CMrkpLibrary::fInitialized = FALSE;


// Class CMarkupControl -- public functions -- implementation of some of them

IMPLEMENT_DYNCREATE(CMarkupControl, CWnd)

BOOL CMarkupControl::Create(const RECT& rect, CWnd* pParentWnd, HWND hCtl)
{
	if (hCtl == NULL) {
		// There is no underlying control
		m_fValid = FALSE;
		return FALSE;
	}

	HWND	hMrkWnd = CreateMarkupCtl(pParentWnd->GetSafeHwnd(), rect.left, rect.top, rect.right-rect.left, rect.bottom-rect.top);
	if (hMrkWnd == NULL) {
		ASSERT(m_hWnd);		// at least notification comes up
		m_fValid = FALSE;
		return FALSE;
	}

	//	Attach the control window handle to this object
	if (! Attach(hMrkWnd)) {
		::DestroyWindow(hMrkWnd);
		m_fValid = FALSE;
		return FALSE;
	}

	m_fValid = TRUE;	// Looks like major problems passed

	ASSERT_VALID(this);
	return TRUE;
}

BOOL CMarkupControl::DestroyWindow()
{
	ASSERT_VALID(this);
	HWND	hwndCtl = GetSafeHwnd();

	if (!hwndCtl || !IsWindow(hwndCtl)) {
		// Already physically destroyed.
		return TRUE;
	}

	if (! m_fLogicallyDestroyed) {
		//	Logically destroy the control window
		Quit();
	}

	HWND  hwndMrk = Detach();
	::DestroyWindow(hwndMrk);
	
	return TRUE;
}

#ifdef _DEBUG
void CMarkupControl::AssertValid() const
{
	CWnd::AssertValid();
	ASSERT(m_fValid);
}
#endif


LRESULT CMarkupControl::SendMessage(UINT msg, WPARAM wParam, LPARAM lParam)
{
	if (m_hWnd && ::IsWindow(m_hWnd)) {
		return CWnd::SendMessage(msg, wParam, lParam);
	} else {
		return 1;
	}
}

LRESULT CMarkupControl::OnNotification(UINT msg, WPARAM wParam, LPARAM lParam)
{
	return 0;
}

int CMarkupControl::OnEvent()
{
	return 0;
}

BEGIN_MESSAGE_MAP(CMarkupControl, CWnd)
	//{{AFX_MSG_MAP(CMarkupControl)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void	CMarkupControl::GetMarkupInfo(
				CString &strUser,
				CString &strDepartment,
				CString &strCompany,
				CString &strLocation,
				CString &strTelephone)
{
	char	*szInfoData = new char[1024];
	char	*p;
	int 	i;

	// Get buffer
	GetCurrentMarkupInfo(szInfoData);

	// Split it here
	CString*	pstrs[] = {
		&strUser,
		&strDepartment,
		&strCompany,
		&strLocation,
		&strTelephone,
	};

	// Skip first five short strings
	for (i=0; i < 5; i++) {
		strtok(i ? NULL : szInfoData, "\n");
	}

	for (i=0; i < 5; i++) {
		*pstrs[i] = (p = strtok(NULL, "\n")) == NULL ? "" : p;
		*pstrs[i] = (*pstrs[i]).SpanExcluding("\r");
	}

	delete [] szInfoData;
}

void	CMarkupControl::SetMarkupInfo(
				const CString &strUser,
				const CString &strDepartment,
				const CString &strCompany,
				const CString &strLocation,
				const CString &strTelephone)
{
	CString str = " \n \n \n \n \n";
	str += strUser + " \n";
	str += strDepartment + " \n";
	str += strCompany + " \n";
	str += strLocation + " \n";
	str += strTelephone;

	SetCurrentMarkupInfo(str);
}



void	CMarkupControl::GetSelectedFont(CMrkFont& font
										) {
	ASSERT(lf != 0);

	int	nEntities = GetSelCount();

	if (nEntities == 0) {
		GetFont(font);
	} else {
		std::vector<ENTHANDLE> entities(nEntities);
		GetSels(nEntities, &entities[0]);
		for (int i=0; i<nEntities; i++) {
			MRK_EntitySpec es;
			memset(&es, 0, sizeof(es));
			es.Com.Handle = entities[i];
			LockEntity(&es);
			font = es.Com.Font;
			if ( !*font.GetLOGFONT().lfFaceName) {
				font.SetFaceName("Arial");
			}
			UnlockEntity(&es, FALSE);
		}
	}
}

COLORREF	CMarkupControl::GetSelectedColor()
{
	COLORREF	ret = RGB(255, 0, 0);
	int	nEntities = GetSelCount();

	if (nEntities == 0) {
		return GetCurrentColor();
	} else {
		LPENTHANDLE 	pEntities = new ENTHANDLE[nEntities];
		if (pEntities == 0) {
			return GetCurrentColor();
		}
		GetSels(nEntities, pEntities);
		for (int i=0; i<nEntities; i++) {
			MRK_EntitySpec es;
			memset(&es, 0, sizeof(es));
			es.Com.Handle = pEntities[i];
			LockEntity(&es);
			ret = es.Com.LineColor;
			UnlockEntity(&es, FALSE);
		}
		delete [] pEntities;
	}
	return ret;
}

int		CMarkupControl::GetSelectedPenStyle()
{
	int	ret = PS_SOLID;
	int	nEntities = GetSelCount();

	if (nEntities == 0) {
		return GetPenStyle();
	} else {
		LPENTHANDLE 	pEntities = new ENTHANDLE[nEntities];
		if (pEntities == 0) {
			return ret;
		}
		GetSels(nEntities, pEntities);
		for (int i=0; i<nEntities; i++) {
			MRK_EntitySpec es;
			memset(&es, 0, sizeof(es));
			es.Com.Handle = pEntities[i];
			LockEntity(&es);
			ret = es.Com.PenStyle;
			UnlockEntity(&es, FALSE);
		}
		delete [] pEntities;
	}
	return ret;
}

int		CMarkupControl::GetSelectedPenWidth()
{
	int	ret = 0;
	int	nEntities = GetSelCount();

	if (nEntities == 0) {
		return GetLineWidth();
	} else {
		LPENTHANDLE 	pEntities = new ENTHANDLE[nEntities];
		if (pEntities == 0) {
			return ret;
		}
		GetSels(nEntities, pEntities);
		for (int i=0; i<nEntities; i++) {
			MRK_EntitySpec es;
			memset(&es, 0, sizeof(es));
			es.Com.Handle = pEntities[i];
			LockEntity(&es);
			ret = abs((int)es.Com.PenWidth);
			UnlockEntity(&es, FALSE);
		}
		delete [] pEntities;
	}
	return ret;
}


void	CMarkupControl::SetSelectedFont(const CMrkFont& font
										) {
	ASSERT(lf != 0);

	int	nEntities = GetSelCount();

	if (nEntities == 0) {
		SetFont(font);
	} else {
		std::vector<ENTHANDLE> 	entities(nEntities);
		GetSels(nEntities, &entities[0]);
		for (int i=0; i<nEntities; i++) {
			MRK_EntitySpec es;
			memset(&es, 0, sizeof(es));
			es.Com.Handle = entities[i];
			LockEntity(&es);
			es.Com.Font = font;
			UnlockEntity(&es, TRUE);
		}
	}
}

void	CMarkupControl::SetSelectedColor(COLORREF col)
{
	int	nEntities = GetSelCount();

	if (nEntities == 0) {
		SetCurrentColor(col);
	} else {
		LPENTHANDLE 	pEntities = new ENTHANDLE[nEntities];
		if (pEntities == 0) {
			SetCurrentColor(col);
			return;
		}
		GetSels(nEntities, pEntities);
		for (int i=0; i<nEntities; i++) {
			MRK_EntitySpec es;
			memset(&es, 0, sizeof(es));
			es.Com.Handle = pEntities[i];
			LockEntity(&es);
			es.Com.LineColor = col;
			UnlockEntity(&es, TRUE);
		}
		delete [] pEntities;
	}
}

void	CMarkupControl::SetSelectedFillColor(COLORREF col)
{
	int	nEntities = GetSelCount();

	if (nEntities == 0) {
		SetCurrentFillColor(col);
	} else {
		LPENTHANDLE 	pEntities = new ENTHANDLE[nEntities];
		if (pEntities == 0) {
			SetCurrentFillColor(col);
			return;
		}
		GetSels(nEntities, pEntities);
		for (int i=0; i<nEntities; i++) {
			MRK_EntitySpec es;
			memset(&es, 0, sizeof(es));
			es.Com.Handle = pEntities[i];
			LockEntity(&es);
			es.Com.FillColor = col;
			UnlockEntity(&es, TRUE);
		}
		delete [] pEntities;
	}
}

void		CMarkupControl::SetSelectedPenStyle(int penStyle)
{
	int	nEntities = GetSelCount();

	if (nEntities == 0) {
		SetPenStyle(penStyle);
	} else {
		LPENTHANDLE 	pEntities = new ENTHANDLE[nEntities];
		if (pEntities == 0) {
			SetPenStyle(penStyle);
			return;
		}
		GetSels(nEntities, pEntities);
		for (int i=0; i<nEntities; i++) {
			MRK_EntitySpec es;
			memset(&es, 0, sizeof(es));
			es.Com.Handle = pEntities[i];
			LockEntity(&es);
			es.Com.PenStyle = penStyle;
			UnlockEntity(&es, TRUE);
		}
		delete [] pEntities;
	}
}

void	CMarkupControl::SetSelectedPenWidth(int penWidth)
{
	int	ret = 0;
	int	nEntities = GetSelCount();

	if (nEntities == 0) {
		SetLineWidth(penWidth);
	} else {
		LPENTHANDLE 	pEntities = new ENTHANDLE[nEntities];
		if (pEntities == 0) {
			SetLineWidth(penWidth);
			return;
		}
		GetSels(nEntities, pEntities);
		for (int i=0; i<nEntities; i++) {
			MRK_EntitySpec es;
			memset(&es, 0, sizeof(es));
			es.Com.Handle = pEntities[i];
			LockEntity(&es);
			es.Com.PenWidth = -(abs(penWidth));
			UnlockEntity(&es, TRUE);
		}
		delete [] pEntities;
	}
}



