#include "stdafx.h"

UINT	CVCETLibrary::m_version = 0;
//	Class CVCETLibrary - Static public functions

BOOL	CVCETLibrary::Initialize(LPCSTR profileName, LPCSTR regName)
{
	//	Initialize the VCET DLL
	return	PAN_LoadControls(profileName, regName);
}

void CVCETLibrary::CleanUp()
{
	//	Free resources allocated by the VCET DLL
	::PAN_FreeControls();
}



//	Class CVCETControl

IMPLEMENT_DYNCREATE(CVCETControl, CWnd)

//	Class CVCETControl - Private static functions

#if TARGET==WIN16
Public LRESULT __loadds CALLBACK
#else
Public LRESULT CALLBACK
#endif
CVCETControl::DefNotifProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	PAN_MANAGE_MFCSTATE

	ASSERT(::IsWindow(hWnd));
	CVCETControl* pCtl = (CVCETControl*) CWnd::FromHandlePermanent(hWnd);
	if (pCtl == NULL) {
		//	The window handle is not attached to a CVCETControl object
		return 0;
	}
	ASSERT_VALID(pCtl);
	ASSERT(pCtl->IsKindOf(RUNTIME_CLASS(CVCETControl)));
	return pCtl->OnNotification(msg, wParam, lParam);
}

#if TARGET==WIN16
Public int __loadds CALLBACK
#else
Public int CALLBACK
#endif
CVCETControl::DefEventProc(HWND hWnd)
{
	PAN_MANAGE_MFCSTATE

	ASSERT(::IsWindow(hWnd));
	CVCETControl* pCtl = (CVCETControl*) CWnd::FromHandlePermanent(hWnd);
	if (pCtl == NULL) {
		//	The window handle is not attached to a CVCETControl object
		return 0;
	}
	ASSERT_VALID(pCtl);
	ASSERT(pCtl->IsKindOf(RUNTIME_CLASS(CVCETControl)));
	return pCtl->OnEvent();
}

//	Class CVCETControl - Private functions

//	Class CVCETControl - Protected functions

LRESULT CVCETControl::SendMessage(UINT message, WPARAM wParam, LPARAM lParam)
{
	if (m_hWnd == 0) {
		return 0;		// don't be ridiculous
	}
	LRESULT result = CWnd::SendMessage(message, wParam, lParam);
	return result;
}

//	Class CVCETControl - Public functions

void CVCETControl::Create(const RECT& rect, CWnd* pParentWnd,
	UINT ctlID, FARPROC pEventProc, WNDPROC pNotifyProc)
{
	ASSERT_VALID(this);

	if (pNotifyProc == NULL) {
		//	Since a notification procedure was not specified, we use a default
		//	notification procedure which invokes OnNotification()
		pNotifyProc = m_lpfnNotifyProc;
	}

	if (pEventProc == NULL) {
		//	Since a event procedure was not specified, we use a default
		//	event procedure which invokes OnEvent()
		pEventProc = m_lpfnEventProc;
	}

	//	Create the VCET control window
	RECT ctlRect = rect;
	HWND hCtlWnd = ::PAN_CreateControl(
		pParentWnd->GetSafeHwnd(), ctlID, &ctlRect, pEventProc, pNotifyProc);

	//	Attach the control window handle to this object
	if (! Attach(hCtlWnd)) {
		::SendMessage(hCtlWnd, PM_CTLDESTROY, 0, 0);
		::DestroyWindow(hCtlWnd);
	}
}

// Create without any notification procedures
void CVCETControl::Create(const RECT& rect, CWnd* pParentWnd, UINT ctlID)
{
	ASSERT_VALID(this);

	//	Create the VCET control window
	RECT ctlRect = rect;
	HWND hCtlWnd = ::PAN_CreateControl(
			pParentWnd->GetSafeHwnd(), ctlID, &ctlRect, 0, 0);

	//	Attach the control window handle to this object
	if (! Attach(hCtlWnd)) {
		::SendMessage(hCtlWnd, PM_CTLDESTROY, 0, 0);
		::DestroyWindow(hCtlWnd);
	}
}

CVCETControl* CVCETControl::Clone(CWnd* pParentWnd, UINT ctlID)
{
	ASSERT_VALID(this);

	//	Clone the control window
	HWND hCtlWnd = pParentWnd->GetSafeHwnd();
	SendMessage(PM_CTLCLONECONTROL, (WPARAM) ctlID, (LPARAM) &hCtlWnd);

	//	Allocate a new control object
	CVCETControl* pCtl = NULL;
	TRY {
		pCtl = new CVCETControl;

	} CATCH(CMemoryException, memE) {
		::SendMessage(hCtlWnd, PM_CTLDESTROY, 0, 0);
		::DestroyWindow(hCtlWnd);
	} END_CATCH

	if (pCtl == NULL) {
		return NULL;
	}

	//	Attach the control window handle to the control object
	if (! pCtl->Attach(hCtlWnd)) {
		delete pCtl;
		::SendMessage(hCtlWnd, PM_CTLDESTROY, 0, 0);
		::DestroyWindow(hCtlWnd);
	}

	return pCtl;
}

BOOL CVCETControl::DestroyWindow()
{
	ASSERT_VALID(this);
	HWND	hwndCtl = GetSafeHwnd();

	if (!hwndCtl || !IsWindow(hwndCtl)) {
		// Already physically destroyed.
		return TRUE;
	}

	if (! m_fLogicallyDestroyed) {
		//	Logically destroy the control window
		SendMessage(PM_CTLDESTROY);
		m_fLogicallyDestroyed = TRUE;
	}

	/*
	** Check if ready for physical destruction.
	*/
	if (GetStatus() == (DWORD) -1L) {
		hwndCtl = Detach();
		::DestroyWindow(hwndCtl);

		//	The control window has been physically destroyed
		//	The user must NOT call any other member functions
		//	except possibly CVCETControl::Create()
		return TRUE;
	}

	//	The control window has not yet been physically destroyed
	//	The user must call CVCETControl::DestroyWindow() again
	return FALSE;
}

LRESULT CVCETControl::OnNotification(UINT msg, WPARAM wParam, LPARAM lParam)
{
	ASSERT_VALID(this);

	/*
	** Normally we should not do anything here; But since the bird's eye
	** window needs to know when its control got repainted so it can
	** redraw the tracker rect, we are forced to do this.
	*/
	if (msg == PNM_CTLPAINT) {
		CWnd* pParent = GetParent();
		ASSERT_VALID(pParent);
		pParent->SendMessage(msg, wParam, lParam);
	}
	return 0;
}

int CVCETControl::OnEvent()
{
	//	Do nothing by default
	ASSERT_VALID(this);
	return 0;
}

#ifdef _DEBUG
void CVCETControl::AssertValid() const
{
	CWnd::AssertValid();
}
#endif

//	vcetctl.cpp


Public void CCALLBACK
PanAssert(BOOL fExpr, LPCSTR fileName, int lineNum, LPCSTR exprStr)
{
#if	defined(_DEBUG) && (TARGET == WIN16 || TARGET == WIN32S || defined(_WIN64))
	if (! fExpr) {
		char msgStr[256];

		wsprintf(msgStr,
			"Assertion failed!\rFile %s, Line %d\r%s",
			fileName, lineNum, exprStr);

		AfxMessageBox(msgStr);
	}
#endif
}

