class CCvtDIB;
class CConvert : public CObject {
public:
	CConvert(HWND hCtl = 0, HWND hMrkCtl = 0);
	~CConvert();
public:
	BOOL	Convert(
				LPCSTR			inputFileName,
				LPCSTR			outputFileName,
				PAN_CtlRange	inputRange,
				Real			outWidth,
				Real			outHeight,
				int				units,
				Real			stepPerInch,
				int				outputType,
				int				outputFormat,
				int				outputSubFormat,
				WORD			outputColorDepth);
private:
	BOOL	InitDIB(PAN_CtlFileInfo *fileInfo);
	BOOL	RenderDIB(PAN_CtlFileInfo *fileInfo);
	BOOL	FreeDIB();
private:
	HWND	m_hCtl;
	HWND	m_hMrkCtl;
private:
	struct CConvertSettings {
		char			inputFile[_MAX_PATH];
		char			outputFile[_MAX_PATH];
		PAN_CtlRange	inputRange;
		Real			outputWidth;
		Real			outputHeight;
		int				units;
		Real			stepsPerInch;
		int				outputType;
		int				outputFormat;
		int				outputSubFormat;
		int				outputColorDepth;
	};

	CConvertSettings	m_settings;

private:
	// Output to raster bitmap
	CCvtDIB*			m_pCvtDIB;

private:
	// EXPORT PAFS callbacks
	CString		m_profileName;
	struct CCallbackData {
		// All callbacks.
		CVTPANX		callbacks;
		BOOL (CALLBACK *PANCVT_ABORT)(LONG, LPCVTPANX);
		CConvert*	pThis;

		// PANCVT_GetNextCommand().
		LONG	yOffset;	// Position in bitmap of next bit line.
		LONG	xOffset;	// Start position in line of next vector line.
		char*	pLine;	// Bit line.
	};

	void	MakeCallbacks(LPCVTPANX pCallbacks, BOOL fExtended);
	void	FreeCallbacks(LPCVTPANX pCallbacks, BOOL fExtended);

	static BOOL CALLBACK __loadds PANCVT_ABORT(
										LONG	ID,
										LPCVTPANX pCallbacks);

	static BOOL CALLBACK __loadds PANCVT_SetOptionInt(
										LONG	ID,
										LPCVTPANX pCallbacks,
										LPSTR	moduleName,
										LPSTR	sectionName,
										LPSTR	optionName,
										int 	Value);

	static BOOL CALLBACK __loadds PANCVT_GetOptionInt(
										LONG	ID,
										LPCVTPANX pCallbacks,
										LPSTR	moduleName,
										LPSTR	sectionName,
										LPSTR	optionName,
										int 	defaultValue,
										LPINT	pValue);

	static BOOL CALLBACK __loadds PANCVT_SetOptionReal(
										LONG	ID,
										LPCVTPANX pCallbacks,
										LPSTR	moduleName,
										LPSTR	sectionName,
										LPSTR	optionName,
										Real	Value);

	static BOOL CALLBACK __loadds PANCVT_GetOptionReal(
										LONG	ID,
										LPCVTPANX pCallbacks,
										LPSTR	moduleName,
										LPSTR	sectionName,
										LPSTR	optionName,
										Real	defaultValue,
										Real FAR* pValue);

	static BOOL CALLBACK __loadds PANCVT_SetOptionString(
										LONG	ID,
										LPCVTPANX pCallbacks,
										LPSTR	moduleName,
										LPSTR	sectionName,
										LPSTR	optionName,
										LPSTR	defaultValue,
										LPSTR	pValue);

	static BOOL CALLBACK __loadds PANCVT_GetOptionString(
										LONG	ID,
										LPCVTPANX pCallbacks,
										LPSTR	moduleName,
										LPSTR	sectionName,
										LPSTR	optionName,
										LPSTR	defaultValue,
										LPSTR	pValue,
										int 	maxLen);

	static BOOL CALLBACK __loadds PANCVT_GetOutputSize(
										LONG	ID,
										LPCVTPANX pCallbacks,
										LPWORD	pUnits,
										Real FAR* pStepsPerInch,
										Real FAR* pWidth,
										Real FAR* pHeight);

	static BOOL CALLBACK __loadds PANCVT_GetOutputColormap(
										LONG	ID,
										LPCVTPANX pCallbacks,
										LPINT	pBitsPerPixel,
										LPPANCMAP pColormap);

	static BOOL CALLBACK __loadds PANCVT_GetPixel(
										LONG	ID,
										LPCVTPANX pCallbacks,
										LONG	x,
										LONG	y,
										LPDWORD	pPixel);

	static BOOL CALLBACK __loadds PANCVT_GetBitLine(
										LONG	ID,
										LPCVTPANX pCallbacks,
										LONG	x,
										LONG	y,
										LONG	nBytes,
										LPBYTE	pLine);

	static BOOL CALLBACK __loadds PANCVT_GetPenMapping(
										LONG	ID,
										LPCVTPANX pCallbacks,
										WORD	fromPen,
										LPWORD	pToPen,
										Real FAR* pThickness,
										LPWORD	pSpeed);

	static BOOL CALLBACK __loadds PANCVT_GetNextCommand(
										LONG			ID,
										LPCVTPANX		pCallbacks,
										LPPANMETARECORD pMetaRec);
};
