////////////////////////////////////////////////////////////////////////////////
// cvtcbs.cpp
////////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "export.h"
#include "cvtdib.h"
#include "cvt.h"

////////////////////////////////////////////////////////////////////////////////
// PRIVATE SECTION
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
void CConvert::MakeCallbacks(LPCVTPANX pCallbacks, BOOL fExtended)
{
#define _MM_(fn)	MakeProcInstance((FARPROC) fn, hInstance)
#define _FF_(ptr)	*((FARPROC FAR*) &ptr)

	_fmemset(pCallbacks, 0, sizeof *pCallbacks);

	HINSTANCE hInstance = AfxGetInstanceHandle();

	_FF_(pCallbacks->PANCVT_ABORT)				= _MM_(PANCVT_ABORT);
	_FF_(pCallbacks->PANCVT_SetOptionInt)		= _MM_(PANCVT_SetOptionInt);
	_FF_(pCallbacks->PANCVT_GetOptionInt)		= _MM_(PANCVT_GetOptionInt);
	_FF_(pCallbacks->PANCVT_SetOptionReal)		= _MM_(PANCVT_SetOptionReal);
	_FF_(pCallbacks->PANCVT_GetOptionReal)		= _MM_(PANCVT_GetOptionReal);
	_FF_(pCallbacks->PANCVT_SetOptionString)	= _MM_(PANCVT_SetOptionString);
	_FF_(pCallbacks->PANCVT_GetOptionString)	= _MM_(PANCVT_GetOptionString);
	_FF_(pCallbacks->PANCVT_GetOutputSize)		= _MM_(PANCVT_GetOutputSize);
	_FF_(pCallbacks->PANCVT_GetOutputColormap) = _MM_(PANCVT_GetOutputColormap);

	if (fExtended) {
		// Raster callbacks.
		_FF_(pCallbacks->PANCVT_GetPixel)		= _MM_(PANCVT_GetPixel);
		_FF_(pCallbacks->PANCVT_GetBitLine) 	= _MM_(PANCVT_GetBitLine);

		// Vector callbacks.
		_FF_(pCallbacks->PANCVT_GetPenMapping)	= _MM_(PANCVT_GetPenMapping);
		_FF_(pCallbacks->PANCVT_GetNextCommand) = _MM_(PANCVT_GetNextCommand);
	}

#undef _MM_
#undef _FF_

} // CConvert::MakeCallbacks()

////////////////////////////////////////////////////////////////////////////////
void CConvert::FreeCallbacks(LPCVTPANX pCallbacks, BOOL fExtended)
{
	FreeProcInstance((FARPROC) pCallbacks->PANCVT_ABORT);
	FreeProcInstance((FARPROC) pCallbacks->PANCVT_SetOptionInt);
	FreeProcInstance((FARPROC) pCallbacks->PANCVT_GetOptionInt);
	FreeProcInstance((FARPROC) pCallbacks->PANCVT_SetOptionReal);
	FreeProcInstance((FARPROC) pCallbacks->PANCVT_GetOptionReal);
	FreeProcInstance((FARPROC) pCallbacks->PANCVT_SetOptionString);
	FreeProcInstance((FARPROC) pCallbacks->PANCVT_GetOptionString);
	FreeProcInstance((FARPROC) pCallbacks->PANCVT_GetOutputSize);
	FreeProcInstance((FARPROC) pCallbacks->PANCVT_GetOutputColormap);

	if (fExtended) {
		// Raster callbacks.
		FreeProcInstance((FARPROC) pCallbacks->PANCVT_GetPixel);
		FreeProcInstance((FARPROC) pCallbacks->PANCVT_GetBitLine);

		// Vector callbacks.
		FreeProcInstance((FARPROC) pCallbacks->PANCVT_GetPenMapping);
		FreeProcInstance((FARPROC) pCallbacks->PANCVT_GetNextCommand);
	}

} // CConvert::FreeCallbacks()

////////////////////////////////////////////////////////////////////////////////
BOOL CALLBACK __loadds CConvert::PANCVT_ABORT(LONG ID, LPCVTPANX pCallbacks)
{
	PAN_MANAGE_MFCSTATE

	/*
	** You can implement a modeless "Cancel" dialog box. If the
	** user hits the cancel button, PANCVT_ABORT() should return TRUE
	*/
	return FALSE;
} // CConvert::PANCVT_ABORT()

////////////////////////////////////////////////////////////////////////////////
BOOL CALLBACK __loadds CConvert::PANCVT_SetOptionInt(
	LONG		ID,
	LPCVTPANX	pCallbacks,
	LPSTR		moduleName,
	LPSTR		sectionName,
	LPSTR		optionName,
	int			pValue)
{
	PAN_MANAGE_MFCSTATE

	return FALSE;
} // CConvert::PANCVT_SetOptionInt()

////////////////////////////////////////////////////////////////////////////////
BOOL CALLBACK __loadds CConvert::PANCVT_GetOptionInt(
	LONG		ID,
	LPCVTPANX	pCallbacks,
	LPSTR		moduleName,
	LPSTR		sectionName,
	LPSTR		optionName,
	int 		defaultValue,
	LPINT		pValue)
{
	PAN_MANAGE_MFCSTATE

	char buf[32];
	char bufTrueOptionName[64];
	BOOL fFound = FALSE;

	if (strcmp(optionName, "TILESIZEX") == 0 ||
		strcmp(optionName, "TILESIZEY") == 0)
	{
		strcpy(bufTrueOptionName, "TILESIZE");
	} else {
		strcpy(bufTrueOptionName, optionName);
	}

	if (PANCVT_GetOptionString(ID, pCallbacks, moduleName, sectionName,
		bufTrueOptionName, "", buf, sizeof buf - 1) && *buf != 0)
	{
		fFound = TRUE;

		if (strcmp(optionName, "TILESIZEX") == 0) {
			int tx, ty;

			if (sscanf(buf, "%dX%d", &tx, &ty) == 2) {
				*pValue = tx;
			}
		} else if (strcmp(optionName, "TILESIZEY") == 0) {
			int tx, ty;

			if (sscanf(buf, "%dX%d", &tx, &ty) == 2) {
				*pValue = ty;
			}
		} else if (strcmp(optionName, "SKIPMODE") == 0) {
			if (stricmp(buf, "and")) {
				*pValue = STRETCH_ANDSCANS;
			} else if (stricmp(buf, "or")) {
				*pValue = STRETCH_ORSCANS;
			} else if (stricmp(buf, "skip")) {
				*pValue = STRETCH_DELETESCANS;
			} else if (stricmp(buf, "auto")) {
				*pValue = STRETCH_DELETESCANS;
			} else {
				*pValue = defaultValue;
			}
		} else {
			if (stricmp(buf, "on")) {
				*pValue = TRUE;
			} else if (stricmp(buf, "off")) {
				*pValue = FALSE;
			} else {
				*pValue = atoi(buf);
			}
		}
	}

	if (! fFound) {
		*pValue = defaultValue;
		return FALSE;
	}

	return TRUE;

} // CConvert::PANCVT_GetOptionInt()

////////////////////////////////////////////////////////////////////////////////
BOOL CALLBACK __loadds CConvert::PANCVT_SetOptionReal(
	LONG		ID,
	LPCVTPANX	pCallbacks,
	LPSTR		moduleName,
	LPSTR		sectionName,
	LPSTR		optionName,
	Real		Value)
{
	PAN_MANAGE_MFCSTATE

	return FALSE;
} // CConvert::PANCVT_SetOptionReal()

////////////////////////////////////////////////////////////////////////////////
BOOL CALLBACK __loadds CConvert::PANCVT_GetOptionReal(
	LONG		ID,
	LPCVTPANX	pCallbacks,
	LPSTR		moduleName,
	LPSTR		sectionName,
	LPSTR		optionName,
	Real		defaultValue,
	Real FAR* pValue)
{
	PAN_MANAGE_MFCSTATE

	char buf[64];
	Bool fFound = FALSE;

	if (PANCVT_GetOptionString(ID, pCallbacks, moduleName, sectionName,
		optionName, "", buf, sizeof buf - 1) && *buf != 0)
	{
		fFound = TRUE;
		*pValue = atof(buf);
	}

	if (! fFound) {
		*pValue = defaultValue;
		return FALSE;
	}

	return TRUE;

} // CConvert::PANCVT_GetOptionReal()

////////////////////////////////////////////////////////////////////////////////
BOOL CALLBACK __loadds CConvert::PANCVT_SetOptionString(
	LONG		ID,
	LPCVTPANX	pCallbacks,
	LPSTR		moduleName,
	LPSTR		sectionName,
	LPSTR		optionName,
	LPSTR		defaultValue,
	LPSTR		pValue)
{
	PAN_MANAGE_MFCSTATE

	return FALSE;
} // CConvert::PANCVT_SetOptionString()

////////////////////////////////////////////////////////////////////////////////
BOOL CALLBACK __loadds CConvert::PANCVT_GetOptionString(
	LONG		ID,
	LPCVTPANX	pCallbacks,
	LPSTR		moduleName,
	LPSTR		sectionName,
	LPSTR		optionName,
	LPSTR		defaultValue,
	LPSTR		pValue,
	int 		maxLen)
{
	PAN_MANAGE_MFCSTATE

	CConvert* pThis = ((CCallbackData*) pCallbacks)->pThis;
	if (pThis == 0) {
		return FALSE;
	}

	/*
	** try application ini file.
	*/
	BOOL 	fFound = FALSE;
	CWinApp	*pApp = AfxGetApp();
	CString	tmp_str = pApp->GetProfileString(sectionName, optionName, "");

	if (!tmp_str.IsEmpty()) {
		fFound = TRUE;
		strncpy(pValue, (LPSTR) (LPCSTR) tmp_str, maxLen);
	}

	/*
	** try tmp ini file.
	*/
	CString	buf = pApp->GetProfileString(sectionName, optionName, "");

	if (*buf != 0) {
		fFound = TRUE;
		strncpy(pValue, buf, maxLen);
	}

	if (! fFound) {
		strcpy(pValue, defaultValue);
		return FALSE;
	}

	return TRUE;

} // CConvert::PANCVT_GetOptionString()

////////////////////////////////////////////////////////////////////////////////
BOOL CALLBACK __loadds CConvert::PANCVT_GetOutputSize(
	LONG	  ID,
	LPCVTPANX pCallbacks,
	LPWORD	  pUnits,
	Real FAR* pStepsPerInch,
	Real FAR* pWidth,
	Real FAR* pHeight)
{
	PAN_MANAGE_MFCSTATE

	CConvert* pThis = ((CCallbackData*) pCallbacks)->pThis;
	if (pThis == 0) {
		return FALSE;
	}

	if (pThis->m_pCvtDIB->GetDIB() == 0) {
		return FALSE;
	}

	*pUnits 	   = PC_UNIT_PIXEL;
	*pStepsPerInch = 1.0;
	*pWidth 	   = pThis->m_settings.outputWidth;
	*pHeight	   = pThis->m_settings.outputHeight;

	return TRUE;

} // CConvert::PANCVT_GetOutputSize()

////////////////////////////////////////////////////////////////////////////////
BOOL CALLBACK __loadds CConvert::PANCVT_GetOutputColormap(
	LONG	  ID,
	LPCVTPANX pCallbacks,
	LPINT	  pBitsPerPixel,
	LPPANCMAP pColormap)
{
	PAN_MANAGE_MFCSTATE

	CConvert* pThis = ((CCallbackData*) pCallbacks)->pThis;
	LPBITMAPINFO pDIB = pThis->m_pCvtDIB->GetDIB();

	if (pThis == 0) {
		return FALSE;
	}

	if (pDIB == 0) {
		return FALSE;
	}

	*pBitsPerPixel = (int) pDIB->bmiHeader.biBitCount;
	pColormap->ncolours = 1 << *pBitsPerPixel;

	if (*pBitsPerPixel != 24) {
		if (pColormap->ncolours == 2) {
			/*
			** Some encoders automatically assume that 0 is white and
			** 1 is black.  So we must send a color map that follows
			** this convention.  Note that the bits are also inverted.
			*/
			pColormap->r[0] = pColormap->g[0] = pColormap->b[0] = 255;
			pColormap->r[1] = pColormap->g[1] = pColormap->b[1] = 0;
		} else {
			for (int i = 0; i < pColormap->ncolours; i++) {
				pColormap->r[i] = pDIB->bmiColors[i].rgbRed;
				pColormap->g[i] = pDIB->bmiColors[i].rgbGreen;
				pColormap->b[i] = pDIB->bmiColors[i].rgbBlue;
			}
		}
	}

	return TRUE;

} // PANCVT_GetOutputColormap()

////////////////////////////////////////////////////////////////////////////////
BOOL CALLBACK __loadds CConvert::PANCVT_GetPixel(
	LONG	  ID,
	LPCVTPANX pCallbacks,
	LONG	  x,
	LONG	  y,
	LPDWORD   pPixel)
{
	PAN_MANAGE_MFCSTATE

	CConvert* pThis = ((CCallbackData*) pCallbacks)->pThis;
	LPBITMAPINFO pDIB = pThis->m_pCvtDIB->GetDIB();
	BYTE huge*	 pDIBBits = pThis->m_pCvtDIB->GetBitsDIB();

	if (pThis == 0) {
		return FALSE;
	}

	if (pDIB == 0) {
		return FALSE;
	}

	if (x < 0 || x >= pThis->m_pCvtDIB->GetWidthDIB() || y < 0 || y >= pThis->m_pCvtDIB->GetHeightDIB()) {
			return FALSE;
	}

	LONG	width = pThis->m_pCvtDIB->GetWidthInBytes(
						pDIB->bmiHeader.biWidth,
						pDIB->bmiHeader.biBitCount);

#if	TARGET == WIN32S || defined(_WIN64)
	y =  pDIB->bmiHeader.biHeight - 1 - y;
#else
	if (pDIB->bmiHeader.biBitCount != 24 && pDIB->bmiHeader.biBitCount != 1) {
		y =  pDIB->bmiHeader.biHeight - 1 - y;
	}
#endif

	BYTE huge* pLine = pDIBBits + y * width;

	switch (pDIB->bmiHeader.biBitCount) {
	case 1:
		*pPixel = (pLine[x / 8] >> (7 - x % 8)) & 0x01;
		break;

	case 4:
		*pPixel = (pLine[x / 2] >> (x % 2 == 0 ? 4 : 0)) & 0x0F;
		break;

	case 8:
		*pPixel = pLine[x] & 0xFF;
		break;

	default:
		return FALSE;
	}

	/*
	**	Windows follows the convention that White==1 and Black==0,
	**	while we follow the opposite (bits get inverted when we render
	**  onto screen compatible DC).
	*/
//	if (pDIB->bmiHeader.biBitCount == 1) {
//		*pPixel = *pPixel ? 0 : 1;
//	}


	return TRUE;

} // CConvert::PANCVT_GetPixel()

////////////////////////////////////////////////////////////////////////////////
BOOL CALLBACK __loadds CConvert::PANCVT_GetBitLine(
	LONG	  ID,
	LPCVTPANX pCallbacks,
	LONG	  x,
	LONG	  y,
	LONG	  nBytes,
	LPBYTE	  pLine)
{
	PAN_MANAGE_MFCSTATE

	CConvert* pThis = ((CCallbackData*) pCallbacks)->pThis;
	LPBITMAPINFO pDIB = pThis->m_pCvtDIB->GetDIB();
	BYTE huge*	 pDIBBits = pThis->m_pCvtDIB->GetBitsDIB();

//	BYTE huge*	 pDIBBits = pThis->FindDIBBits(y);

	if (pThis == 0) {
		return FALSE;
	}

	if (pDIB == 0) {
		return FALSE;
	}

	if (x < 0 || x >= pThis->m_pCvtDIB->GetWidthDIB() || y < 0 || y >= pThis->m_pCvtDIB->GetHeightDIB()) {
			return FALSE;
	}

	LONG	width = pThis->m_pCvtDIB->GetWidthInBytes(
							pDIB->bmiHeader.biWidth,
							pDIB->bmiHeader.biBitCount);

#if	TARGET == WIN32S || defined(_WIN64)
	y =  pDIB->bmiHeader.biHeight - 1 - y;
#else
	if (pDIB->bmiHeader.biBitCount != 24 && pDIB->bmiHeader.biBitCount != 1) {
		y = pDIB->bmiHeader.biHeight - 1 - y;
	}
#endif

	LONG pos;

	switch (pDIB->bmiHeader.biBitCount) {
	case 1:
		pos = y * width + x / 8;
		break;

	case 4:
		pos = y * width + x / 2;
		break;

	case 8:
	default:
		pos = y * width + x;
		break;
	}

	hmemcpy(pLine, pDIBBits + pos, (size_t) nBytes);

	/*
	**	Windows follows the convention that White==0 and Black==1,
	**	while we follow the opposite.
	*/
//	if (pDIB->bmiHeader.biBitCount == 1) {
//		for (int i = 0; i < nBytes; i++) {
//			pLine[i] = ~pLine[i];
//		}
//	}

	return TRUE;

} // CConvert::PANCVT_GetBitLine()

////////////////////////////////////////////////////////////////////////////////
BOOL CALLBACK __loadds CConvert::PANCVT_GetPenMapping(
	LONG	  ID,
	LPCVTPANX pCallbacks,
	WORD	  fromPen,
	LPWORD	  pToPen,
	Real FAR* pThickness,
	LPWORD	  pSpeed)
{
	PAN_MANAGE_MFCSTATE

	CConvert* pThis = ((CCallbackData*) pCallbacks)->pThis;
	if (pThis == 0) {
		return FALSE;
	}

	*pToPen 	= fromPen;
	*pThickness = 0.01 * pThis->m_settings.stepsPerInch;
	*pSpeed 	= 36;

	return TRUE;

} // CConvert::PANCVT_GetPenMapping()

////////////////////////////////////////////////////////////////////////////////
BOOL CALLBACK __loadds CConvert::PANCVT_GetNextCommand(
	LONG			ID,
	LPCVTPANX		pCallbacks,
	LPPANMETARECORD pMetaRec)
{
	Long i;
	PAN_MANAGE_MFCSTATE

	CCallbackData* pData = (CCallbackData*) pCallbacks;
	CConvert* pThis = pData->pThis;
	LPBITMAPINFO pDIB = pThis->m_pCvtDIB->GetDIB();
	BYTE huge*	 pDIBBits = pThis->m_pCvtDIB->GetBitsDIB();

	if (pThis == 0) {
		return FALSE;
	}

	if (pDIB == 0 || pDIBBits == 0) {
		return FALSE;
	}

	if (pData->yOffset >= pThis->m_pCvtDIB->GetHeightDIB()) {
		// We've reached the end of the bitmap.
		pMetaRec->type = PANMETAREC_EOM;
		return TRUE;
	}

	// Get bitmap width and height.
	LONG width	= pThis->m_pCvtDIB->GetWidthDIB();
	LONG height = pThis->m_pCvtDIB->GetHeightDIB();

	// Allocate bit line if necessary.
	if (pData->pLine == 0) {
		pData->pLine = (char*) PanMalloc((size_t) width);
		if (pData->pLine == 0) {
			return FALSE;
		}
	}

	// Get bit line.
	if (pData->xOffset == 0) {
		DWORD pixel;
		for (LONG i = 0; i < width; i++) {
			PANCVT_GetPixel(ID, pCallbacks, i, pData->yOffset, &pixel);
			pData->pLine[i] = (BYTE) pixel;
		}
	}

	// Split bit line into one or more vector lines.
	// A vector line consists of one or more bits of the same color.

	for (i = pData->xOffset;
		 i < width && pData->pLine[i] == pData->pLine[pData->xOffset]; i++)
	{
		// Do nothing.
	}

	// Get x and y scaling factors.
	Real xScale = (pThis->m_settings.outputWidth / width);
	Real yScale = (pThis->m_settings.outputHeight / height);

	// Initialize metafile record.
	pMetaRec->type = PANMETAREC_LINE;

	pMetaRec->rec.line.p1.x = pData->xOffset * xScale;
	pMetaRec->rec.line.p1.y = pData->yOffset * yScale;
	pMetaRec->rec.line.p1.z = 0.0;

	pMetaRec->rec.line.p2.x = i * xScale;
	pMetaRec->rec.line.p2.y = pMetaRec->rec.line.p1.y;
	pMetaRec->rec.line.p2.z = pMetaRec->rec.line.p1.z;

//	pMetaRec->rec.line.LineColor = pThis->m_aPen[pData->pLine[pData->xOffset]];
	pMetaRec->rec.line.LineColor = pData->pLine[pData->xOffset];

	if (i < width) {
		// Still some bits left on current line.
		pData->xOffset = i;
	} else {
		// Current line exhausted.
		pData->yOffset++;
		pData->xOffset = 0;
	}

	return TRUE;

} // CConvert::PANCVT_GetNextCommand()

////////////////////////////////////////////////////////////////////////////////
// cvtcbs.cpp
////////////////////////////////////////////////////////////////////////////////
