////////////////////////////////////////////////////////////////////////////////
// cvtdib.h
////////////////////////////////////////////////////////////////////////////////

#ifndef cvtdib_h
#define cvtdib_h

#define ROUND(type, value)  ((type) ((Real) (value) + 0.5))

////////////////////////////////////////////////////////////////////////////////
class	CCvtDIB : public CObject
{
// construction
public: 
	CCvtDIB();
	~CCvtDIB();
	BOOL			CreateDIB(LONG width, LONG height,
						int in_colorDepth, int out_colorDepth,
						WORD in_Type, WORD out_Type, LOGPALETTE *pPalette);
	BOOL			DestroyDIB();
	BOOL			FillOutputDIB();
	HDC				GetHDC()			{return m_hDC;}
	LONG			GetWidthDIB()		{return (m_pDIB ? m_pixelWidth : 0L);}
	LONG			GetHeightDIB()		{return (m_pDIB ? m_pixelHeight : 0L);}
	LONG			GetDepthDIB()		{return (m_pDIB ? m_pixelDepth : 0L);}
	LPBITMAPINFO	GetDIB()			{return m_pDIB;}
	BYTE huge*		GetBitsDIB()		{return m_pDIBBits;}
	LONG 			GetWidthInBytes(LONG width, int depth);
private:
	BOOL			CreateScreenCompatibleDC(LONG width, LONG height, int in_colorDepth, int out_colorDepth, WORD out_Type, LOGPALETTE *pPalette);
	BOOL			CreateDefaultPalette(int out_nColors);
	BYTE huge*		InitDIB(LOGPALETTE *pPalette, int in_colorDepth, int out_colorDepth, BOOL forceToByteBoundary = FALSE);

private:
	HDC				m_hDC;			// Handle to DC
	HANDLE			m_hDIB;			// Handle to memory - DIB
 	LPBITMAPINFO	m_pDIB;			// Memory-DIB handle locked
	BYTE huge		*m_pDIBBits;	// Memory-DIB bits
	HBITMAP			m_hBitmap;
	LONG			m_pixelWidth;	// True width in pixels (header biWidth is this value padded to an eight byte boundary).
	LONG			m_pixelHeight;	// True height in pixels (header biHeight is (m_pixelHeight+1)/2)
	LONG			m_pixelDepth;	// Bits per pixel: 1, 4, 8, or 24

	// apply source pallette on target palette, overriding color entries as required
	void SetColorTable(LOGPALETTE *pSrcPalette, BITMAPINFO* pDestBmpInfo, const short nDestColorDepth);


}; // class CCvtDIB

#endif // ndef cvtdib_h

////////////////////////////////////////////////////////////////////////////////
// cvtdib.h
////////////////////////////////////////////////////////////////////////////////
