// cvtdlg.cpp : implementation file
//

#include "stdafx.h"

#include <math.h>

#include "mfcmark.h"
#include "cvtutil.h"
#include "cvtdlg.h"

#include "cvt.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCvtDlg dialog

#define	IDS_INCH	"inches"
#define	IDS_MM		"mms"
#define	IDS_PIXEL	"pixels"

#define	IDS_AUTO	"Auto"

/*
** Standard imperial pagesizes in inches
*/
static const double impPageSizes[][2] =
{
	{10.5,  8.0},
	{16.0, 10.0},
	{21.0, 16.0},
	{33.0, 21.0},
	{43.0, 33.0},
};
/*
** Standard metric pagesizes in millimeters
*/
static const double metricPageSizes[][2] =
{
	{ 235.0,  198.0},
	{ 396.0,  273.0},
	{ 570.0,  396.0},
	{ 817.0,  570.0},
	{1165.0,  817.0},
};


CCvtDlg::CCvtDlg(CWnd* pParent /*=NULL*/, HWND hCtl, HWND hMrkCtl)
	: CDialog(CCvtDlg::IDD, pParent)
{
	ASSERT(hCtl != 0);
	m_hCtl = hCtl;
	m_hMrkCtl = hMrkCtl;
	//{{AFX_DATA_INIT(CCvtDlg)
	m_fDisplay = -1;
	m_colorDepth = -1;
	m_format = -1;
	m_subFormat = -1;
	m_size = -1;
	m_units = -1;
	m_saveAs = _T("");
	m_sizeX = 0.0;
	m_sizeY = 0.0;
	m_stepsPerUnit = 0.0;
	//}}AFX_DATA_INIT
}


void CCvtDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCvtDlg)
	DDX_Radio(pDX, IDR_EXTENTS, m_fDisplay);
	DDX_CBIndex(pDX, IDC_COLORDEPTH, m_colorDepth);
	DDX_CBIndex(pDX, IDC_FORMATS, m_format);
	DDX_CBIndex(pDX, IDC_SUBFORMATS, m_subFormat);
	DDX_CBIndex(pDX, IDC_OUTSIZE, m_size);
	DDX_CBIndex(pDX, IDC_UNITS, m_units);
	DDX_Text(pDX, IDE_SAVEAS, m_saveAs);
	DDX_Text(pDX, IDE_X, m_sizeX);
	DDX_Text(pDX, IDE_Y, m_sizeY);
	DDX_Text(pDX, IDE_STEPSPERINCH, m_stepsPerUnit);
	DDV_MinMaxDouble(pDX, m_stepsPerUnit, 1., 4096.);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCvtDlg, CDialog)
	//{{AFX_MSG_MAP(CCvtDlg)
#if defined(TWIN32)
	#define theDerivedClass CCvtDlg ::
#endif
	ON_CBN_SELCHANGE(IDC_FORMATS, OnSelchangeFormats)
	ON_CBN_SELCHANGE(IDC_SUBFORMATS, OnSelchangeSubformats)
	ON_CBN_SELCHANGE(IDC_UNITS, OnSelchangeUnits)
	//}}AFX_MSG_MAP
#undef  theDerivedClass
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CCvtDlg: Updating dialog controls
/////////////////////////////////////////////////////////////////////////////

BOOL	CCvtDlg::GetCurrentFormat(CCvtUtil &cut)
{
	CString 	strFormat;
	CComboBox* 	pC = (CComboBox*) GetDlgItem(IDC_FORMATS);
	pC->GetLBText(pC->GetCurSel(), strFormat);
	return cut.GetFormatFromName(strFormat);
}

BOOL	CCvtDlg::GetCurrentSubFormat(CCvtUtil &cut)
{
	CString 	strFormat;
	CComboBox* 	pC = (CComboBox*) GetDlgItem(IDC_FORMATS);
	pC->GetLBText(pC->GetCurSel(), strFormat);
	cut.GetFormatFromName(strFormat);
	if (cut.m_nbSubFmts <= 1) {
		// No subformats: Query base format
		cut.QuerySubFormat(cut.m_wFmtID, 0);
	} else {
		// Get subformat index.
		CComboBox*	pCSub = (CComboBox*) GetDlgItem(IDC_SUBFORMATS);
		int			nSubIndex = pCSub->GetCurSel();

		// Query subformat.
		cut.QuerySubFormat(cut.m_wFmtID, nSubIndex);
	}
	return TRUE;
}

int	CCvtDlg::GetCurrentUnits()
{
	CComboBox*	pC = (CComboBox*) GetDlgItem(IDC_UNITS);
	int			iCurSel = pC->GetCurSel();

	if (iCurSel == CB_ERR) {
		return CTLUNIT_PIXEL;
	}

	CString	strUnits;
	pC->GetLBText(iCurSel, strUnits);

	if (!stricmp(strUnits, IDS_INCH)) {
		return CTLUNIT_INCH;
	} else if (!stricmp(strUnits, IDS_MM)) {
		return CTLUNIT_MM;
	} else if (!stricmp(strUnits, IDS_PIXEL)) {
		return CTLUNIT_PIXEL;
	} else {
		// Something funny happened
		ASSERT(0);
		return CTLUNIT_PIXEL;
	}
}

void	CCvtDlg::UpdateFormatsComboBox()
{
	CComboBox* pC = (CComboBox*) GetDlgItem(IDC_FORMATS);
	pC->SetRedraw(FALSE);
	pC->ResetContent();

	CCvtUtil	cut(m_hCtl);
	WORD nbFmts = cut.GetNbFormats();
	for (WORD i = 0; i < nbFmts; i++) {
		cut.QueryFormat(i);
		pC->AddString(cut.m_szDescription);
	}

	pC->SetCurSel(0);
	m_format = 0;
	pC->SetRedraw(TRUE);
	pC->Invalidate();
}

void	CCvtDlg::UpdateSubFormatsComboBox()
{
	CComboBox*	pC = (CComboBox*) GetDlgItem(IDC_SUBFORMATS);
	CStatic*	pS = (CStatic*) GetDlgItem(IDT_SUBFORMATS);

	CCvtUtil	cut(m_hCtl);
	GetCurrentFormat(cut);

	if (cut.m_nbSubFmts <= 1) {
		// No subformats
		pS->ShowWindow(SW_HIDE);
		pC->ShowWindow(SW_HIDE);

		/*
		** Needed to prevent having an empty combo box in which case
		** m_subFormat will be set to -1 during an UpdateData();
		*/
		pC->ResetContent();
		pC->AddString("");
		m_subFormat = 0;
	} else {
		// Show subformats
		pS->ShowWindow(SW_SHOW);
		pC->ShowWindow(SW_SHOW);

		pC->SetRedraw(FALSE);
		pC->ResetContent();

		for (int i = 0; i < cut.m_nbSubFmts; i++) {
			cut.QuerySubFormat(cut.m_wFmtID, i);
			pC->AddString(cut.m_szSubFormat);
		}

		pC->SetCurSel(0);
		m_subFormat = 0;
		pC->SetRedraw(TRUE);
		pC->Invalidate();
	}
}

void	CCvtDlg::UpdateStepsPerInch()
{
	CCvtUtil		cut(m_hCtl);
	GetCurrentFormat(cut);

	CStatic*	pS = (CStatic *) GetDlgItem(IDT_STEPSPERINCH);
	CEdit*		pE = (CEdit*) GetDlgItem(IDE_STEPSPERINCH);

	if (cut.m_wOutType == PC_VECTOR) {
		switch (GetCurrentUnits()) {
		  case CTLUNIT_INCH:
			pS->SetWindowText("Steps per inch");
			break;
		  case CTLUNIT_MM:
			pS->SetWindowText("Steps per mm");
			break;
		  case CTLUNIT_PIXEL:
		  default:
			pS->SetWindowText("Steps per pixel");
			break;
		}
		pS->ShowWindow(SW_SHOW);
		pE->ShowWindow(SW_SHOW);
	} else {
		pS->ShowWindow(SW_HIDE);
		pE->ShowWindow(SW_HIDE);
	}
}

void CCvtDlg::UpdateColorDepthComboBox()
{
	CStatic*	pS = (CStatic *) GetDlgItem(IDT_COLORDEPTH);
	CComboBox* 	pC = (CComboBox*) GetDlgItem(IDC_COLORDEPTH);
	
	/*
	** Query current subformat.
	*/
	CCvtUtil		cut(m_hCtl);
	GetCurrentSubFormat(cut);

	if (cut.m_wOutType == PC_RASTER) {
		pS->ShowWindow(SW_SHOW);
		pC->ShowWindow(SW_SHOW);

		pC->SetRedraw(FALSE);
		pC->ResetContent();
		
		for (int i = 0; i < cut.m_wNumDepth; i++) {
			char	szbuf[10];

			wsprintf(szbuf, "%d", (int)cut.m_wColorDepth[i]);
			pC->AddString(szbuf);
		}
		pC->AddString(IDS_AUTO);

		/*
		** Set current selection.
		*/
		pC->SetCurSel(cut.m_wNumDepth);
		m_colorDepth = cut.m_wNumDepth;

		pC->SetRedraw(TRUE);
		pC->Invalidate();
	} else {
		pS->ShowWindow(SW_HIDE);
		pC->ShowWindow(SW_HIDE);
	}
}

void	CCvtDlg::UpdateOutputUnits()
{
	CCvtUtil		cut(m_hCtl);
	GetCurrentFormat(cut);

	CComboBox* 		pC = (CComboBox*)GetDlgItem(IDC_UNITS);

	if (cut.m_wOutType == PC_VECTOR) {		
		pC->ResetContent();		
		pC->AddString(IDS_INCH);
		pC->AddString(IDS_MM);
		pC->SetCurSel(0);
		m_units = 0;
		pC->EnableWindow(TRUE);
	} else {
		pC->ResetContent();		
		pC->AddString(IDS_PIXEL);
		pC->SetCurSel(0);
		m_units = 0;
		pC->EnableWindow(FALSE);
	}
}

void CCvtDlg::UpdateOutputSize()
{
	CEdit* pEX = (CEdit*) GetDlgItem(IDE_X);
	CEdit* pEY = (CEdit*) GetDlgItem(IDE_Y);
	
	CCvtUtil	cut(m_hCtl);
	if (! GetCurrentSubFormat(cut)) {
		pEX->SetWindowText("");
		pEY->SetWindowText("");
		return;
	}

	pEX->EnableWindow(TRUE);
	if (cut.m_Width != PC_DONTCARE) {
		m_sizeX = cut.m_Width;
		pEX->EnableWindow(FALSE);
	}

	pEY->EnableWindow(TRUE);
	if (cut.m_Height != PC_DONTCARE) {
		m_sizeY = cut.m_Height;
		pEY->EnableWindow(FALSE);
	}

	UINT	uShow = SW_SHOW;
	switch (cut.m_wOutType) {
	  case PC_RASTER:
		uShow = SW_SHOW;
		break;
	  case PC_VECTOR:
	  	switch (cut.m_iPageFmt) {
		  case PC_HINT_XBYY:
			uShow = SW_SHOW;
			break;
		  case PC_HINT_ATOE:
		  	uShow = SW_HIDE;
			break;
		}
	}

	pEX->ShowWindow(uShow);
	pEY->ShowWindow(uShow);

	CStatic* pSX = (CStatic*) GetDlgItem(IDT_X);
	pSX->ShowWindow(uShow);
	CStatic* pSY = (CStatic*) GetDlgItem(IDT_Y);
	pSY->ShowWindow(uShow);


	CComboBox* pCOutSize = (CComboBox*) GetDlgItem(IDC_OUTSIZE);
	CStatic* pSSize = (CStatic*) GetDlgItem(IDT_OUTSIZE);
	if (uShow == SW_SHOW){
		pCOutSize->ShowWindow(SW_HIDE);
		pSSize->ShowWindow(SW_HIDE);
		pEX->SetFocus();	  	
	} else {
		char szPageBuf[10];
		
		pCOutSize->ResetContent();
		for (int i = 0; i < 5; i++) {
			if (GetCurrentUnits() == CTLUNIT_MM) {
				sprintf(szPageBuf, "%c%d", 'A', 4-i);
			} else {
				sprintf(szPageBuf, "%c", 'A'+i);
			}
			pCOutSize->AddString(szPageBuf);
		}
		pCOutSize->SetCurSel(0);
		pCOutSize->ShowWindow(SW_SHOW);
		pSSize->ShowWindow(SW_SHOW);
	}
	m_size = 0;
}

void CCvtDlg::UpdateDefaultOutputFile()
{
	m_saveAs = "c:\\tmp\\foo.out";
}

/////////////////////////////////////////////////////////////////////////////
// CCvtDlg message handlers

void CCvtDlg::OnSelchangeFormats() 
{
	UpdateData(TRUE);

	// Set state/contents of subformat combo box.
	UpdateSubFormatsComboBox();

	// Set state/contents of steps per inch edit box.
	UpdateStepsPerInch();
	
	// Set state/contents of color depth combo box.
	UpdateColorDepthComboBox();

	// Output units
	UpdateOutputUnits();

	// Output size.	
	UpdateOutputSize();
	
	// Set reasonable output filename
	UpdateDefaultOutputFile();

	UpdateData(FALSE);
}

void CCvtDlg::OnSelchangeSubformats() 
{
	UpdateData(TRUE);

	// Set state/contents of color depth combo box.
	UpdateColorDepthComboBox();

	// Output size.	
	UpdateOutputSize();

	UpdateData(FALSE);
}

void CCvtDlg::OnSelchangeUnits() 
{
	UpdateData(TRUE);

	UpdateStepsPerInch();	
}

BOOL CCvtDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	PAN_CtlFileInfo	fileInfo;
	memset(&fileInfo, 0, sizeof(fileInfo));
	::SendMessage(m_hCtl, PM_CTLGETFILE, 0, (LPARAM)&fileInfo);

	// STEP 1: Fill in file formats combo box
	UpdateFormatsComboBox();

	// STEP 2: Set reasonable default values for controls
	m_fDisplay = FALSE;
	m_format = 0;
	m_subFormat = 0;
	m_size = 0;
	m_units = 0;
	m_saveAs = "";
	m_stepsPerUnit = 1016.0;
	if (fileInfo.type == PAN_RasterFile) {
		// Set the default output size to match input dimensions
		m_sizeX = fileInfo.dimensions.max.x;
		m_sizeY = fileInfo.dimensions.max.y;
	} else {
		// Set the default output size to match input dimensions aspect-ratio
		WORD	curPage = 1;
		::SendMessage(m_hCtl, PM_CTLGETPAGE, 0, (LPARAM) &curPage);
		PAN_CtlRange	rg;
		memset(&rg, 0, sizeof(rg));
		::SendMessage(m_hCtl, PM_CTLGETPAGESIZE, curPage, (LPARAM)&rg);
		m_sizeX = 1024.0;
		m_sizeY = (rg.max.x - rg.min.x) <= 0.0 ?
					m_sizeX :
					m_sizeX * (rg.max.y - rg.min.y) / (rg.max.x - rg.min.x);
		m_sizeX = (double)(int)fabs(m_sizeX);
		m_sizeY = (double)(int)fabs(m_sizeY);
	}

	UpdateData(FALSE);

	// STEP 3: Update controls.
	OnSelchangeFormats();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CCvtDlg::OnOK() 
{
	UpdateData(TRUE);

	PAN_CtlFileInfo	fileInfo;
	memset(&fileInfo, 0, sizeof(fileInfo));
	::SendMessage(m_hCtl, PM_CTLGETFILE, 0, (LPARAM)&fileInfo);

	// Query conversion filters for currently selected output type/subtype
	CCvtUtil	cut(m_hCtl);
	GetCurrentFormat(cut);
	GetCurrentSubFormat(cut);

	// CALCULATE: Input range
	PAN_CtlRange	rgIn;
	memset(&rgIn, 0, sizeof(rgIn));
	if (m_fDisplay) {
		::SendMessage(m_hCtl, PM_CTLGETVIEWEXTENTS, 0, (LPARAM)&rgIn);
	} else {
		WORD	curPage = 1;
		::SendMessage(m_hCtl, PM_CTLGETPAGE, 0, (LPARAM) &curPage);
		::SendMessage(m_hCtl, PM_CTLGETPAGESIZE, curPage, (LPARAM)&rgIn);
	}

	// CALCULATE: Output size based on settings in the dialog
	PAN_CtlRange	rgOut;
	memset(&rgOut, 0, sizeof(rgOut));

	switch (cut.m_wOutType) {
	  case PC_RASTER:
		rgOut.max.x = m_sizeX;
		rgOut.max.y = m_sizeY;
		break;
	  case PC_VECTOR:
	  	switch (cut.m_iPageFmt) {
		  case PC_HINT_XBYY:
			rgOut.max.x = m_sizeX * m_stepsPerUnit;
			rgOut.max.y = m_sizeY * m_stepsPerUnit;
			break;
		  case PC_HINT_ATOE:
			{{{
			ASSERT(m_size >= 0 && m_size < 5);
			int		units = GetCurrentUnits();
			ASSERT(units == CTLUNIT_INCH || units == CTLUNIT_MM);
			if (units == CTLUNIT_INCH) {
				rgOut.max.x = impPageSizes[m_size][0] * m_stepsPerUnit;
				rgOut.max.y = impPageSizes[m_size][1] * m_stepsPerUnit;
			} else {
				rgOut.max.x = metricPageSizes[m_size][0] * m_stepsPerUnit;
				rgOut.max.y = metricPageSizes[m_size][1] * m_stepsPerUnit;
			}
			}}}
			break;
		  default:
			// Something funny happened
			ASSERT(0);
			break;
		}
		break;
	  default:
		// Something funny happened
		ASSERT(0);
		break;
	}

	CConvert	cvt(m_hCtl, m_hMrkCtl);
	cvt.Convert(
		fileInfo.name,
		m_saveAs,
		rgIn,
		rgOut.max.x, rgOut.max.y,
		GetCurrentUnits(),
		1.0,
		cut.m_wOutType,
		cut.m_wFmtID,
		m_subFormat,
		m_colorDepth>= cut.m_wNumDepth ? 0 : cut.m_wColorDepth[m_colorDepth]
		);
		
	CDialog::OnOK();
}

