#ifndef	__CVTDLG_H__
#define	__CVTDLG_H__

// cvtdlg.h : header file
//
class	CCvtUtil;

/////////////////////////////////////////////////////////////////////////////
// CCvtDlg dialog

class CCvtDlg : public CDialog
{
// Construction
public:
	CCvtDlg(CWnd* pParent = NULL, HWND hCtl = 0, HWND hMrkCtl = 0);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CCvtDlg)
	enum { IDD = IDD_CONVERTFILE };
	int		m_fDisplay;
	int		m_colorDepth;
	int		m_format;
	int		m_subFormat;
	int		m_size;
	int		m_units;
	CString	m_saveAs;
	double	m_sizeX;
	double	m_sizeY;
	double	m_stepsPerUnit;
	//}}AFX_DATA


// Overrides
public:

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CCvtDlg)
	afx_msg void OnSelchangeFormats();
	afx_msg void OnSelchangeSubformats();
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	afx_msg void OnSelchangeUnits();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

// Implementation
private:
	BOOL	GetCurrentFormat(CCvtUtil &cut);
	BOOL	GetCurrentSubFormat(CCvtUtil &cut);
	int		GetCurrentUnits();
	void	UpdateFormatsComboBox();
	void	UpdateSubFormatsComboBox();
	void	UpdateStepsPerInch();
	void	UpdateColorDepthComboBox();
	void	UpdateOutputUnits();
	void	UpdateOutputSize();
	void	UpdateDefaultOutputFile();

private:
	HWND	m_hCtl;
	HWND	m_hMrkCtl;
};

#endif	/* __CVTDLG_H__ */

