#include "stdafx.h"

#include "cvtutil.h"

//////////////////////////////////////////////////////////////////////////
// Utility class that acts as a wrapper around the VCET conversion API
//////////////////////////////////////////////////////////////////////////

CCvtUtil::CCvtUtil(HWND hCtl)
{
	ASSERT(hCtl != 0);

	m_hCtl = hCtl;

	m_iPageFmt = PC_HINT_XBYY;
	m_wOutType = 0;
   
	memset(m_szModule, 0, sizeof(m_szModule));
	memset(m_szDescription, 0, sizeof(m_szDescription));
	memset(m_szSubFormat, 0, sizeof(m_szSubFormat));
	memset(m_szFilter, 0, sizeof(m_szFilter));
	memset(m_szExt, 0, sizeof(m_szExt));

	m_wFmtID	  = 0;
	m_nbSubFmts   = 0;
	m_wNumDepth   = 0;
	m_wColorDepth = 0;
	m_dwOutCaps   = 0;
	m_wUnits	  = PC_DONTCARE;
	m_Width 	  = PC_DONTCARE;
	m_Height	  = PC_DONTCARE;
}

////////////////////////////////////////////////////////////////////////////////
void CCvtUtil::QueryFormat(WORD fmtID)
{
#if	TARGET == WIN16
	BOOL (*lpfnIdentify)(...);
#else
	BOOL (__stdcall *lpfnIdentify)(LPWORD, LPWORD, LPWORD);
#endif

	// Get number of sub-formats and output type for selected format.
	::SendMessage(m_hCtl, PM_CTLCONVERT,
		GET_PAFSEXPORT_IDENTIFY_HANDLE, (LPARAM) (FARPROC FAR*) &lpfnIdentify);

	lpfnIdentify((LPWORD) &fmtID, (LPWORD) &m_nbSubFmts, (LPWORD) &m_wOutType);
	m_wFmtID = fmtID;

#if	TARGET == WIN16
	BOOL (*lpfnQuery)(...);
#else
	BOOL (__stdcall *lpfnQuery)(LONG, LPCVTPANX, DWORD, LPSTR, LPSTR);
#endif

	::SendMessage(m_hCtl, PM_CTLCONVERT,
		GET_PAFSEXPORT_QUERYFORMAT_HANDLE, (LPARAM) (FARPROC FAR*) &lpfnQuery);

	lpfnQuery((LONG) 0, (LPCVTPANX) 0,
		(DWORD) fmtID, (LPSTR) m_szModule, (LPSTR) m_szDescription);
}

////////////////////////////////////////////////////////////////////////////////
void CCvtUtil::QuerySubFormat(WORD fmtID, WORD subFmtID)
{
#if	TARGET == WIN16
	BOOL (*lpfn)(...);
#else
	BOOL (__stdcall *lpfn)(LONG, LPCVTPANX, DWORD, DWORD,
							LPSTR, LPSTR, LPSTR,
							LPWORD, LPWORD *, LPDWORD, LPWORD, Real *, Real *);
#endif

	if (subFmtID > m_nbSubFmts) {
		return;
	}

	m_wFmtID = fmtID;
	::SendMessage(m_hCtl, PM_CTLCONVERT,
		GET_PAFSEXPORT_QUERYSUBFORMAT_HANDLE, (LPARAM) (FARPROC FAR*) &lpfn);

	lpfn((LONG) 0, (LPCVTPANX) 0, (DWORD) fmtID, (DWORD) subFmtID,
		(LPSTR) m_szSubFormat, (LPSTR) m_szFilter, (LPSTR) m_szExt,
		(LPWORD) &m_wNumDepth, (LPWORD FAR*) &m_wColorDepth,
		(LPDWORD) &m_dwOutCaps, (LPWORD)&m_wUnits,
		(Real FAR*) &m_Width, (Real FAR*) &m_Height);

	m_iPageFmt = PC_HINT(m_dwOutCaps, PC_HINT_ATOE) ? PC_HINT_ATOE : PC_HINT_XBYY;
}

WORD CCvtUtil::GetNbFormats()
{
#if	TARGET == WIN16
	BOOL (*lpfn)(...);
#else
	BOOL (__stdcall *lpfn)(LPWORD, LPWORD, LPWORD);
#endif

	::SendMessage(m_hCtl, PM_CTLCONVERT,
		GET_PAFSEXPORT_IDENTIFY_HANDLE, (LPARAM) (FARPROC FAR*) &lpfn);

	WORD	wFormat = 0;
	if (lpfn((LPWORD) &wFormat, (LPWORD) 0, (LPWORD) 0)) {
		return wFormat;
	} else {
		return (WORD) -1;
	}
}

BOOL	CCvtUtil::GetFormatFromName(LPCSTR szFormatName)
{
	WORD	nbFmts = GetNbFormats();

	// Loop through filters to locate the appropriate encoder.
	for (int i = 0; i < nbFmts; i++) {
		QueryFormat(i);

		if (!lstrcmpi(szFormatName, m_szDescription)) {
			/*
			** Found it! Query first subformat (or the main format if
			** format does not have any subformats).
			*/
			QuerySubFormat(i, 0);
			return TRUE;
		}
	}
	return FALSE;
}

