// doc.cpp : implementation of the CSampDoc class
//

#include "stdafx.h"
#include "mfcmark.h"

#if defined(TWIN32)
#include "kerndef.h"
#endif
#include "doc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSampDoc

IMPLEMENT_DYNCREATE(CSampDoc, CDocument)

#define	theDerivedClass	CSampDoc::
BEGIN_MESSAGE_MAP(CSampDoc, CDocument)
	//{{AFX_MSG_MAP(CSampDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#undef	theDerivedClass

/////////////////////////////////////////////////////////////////////////////
// CSampDoc construction/destruction

CSampDoc::CSampDoc()
{
	// TODO: add one-time construction code here
	m_pCtl = 0;
	memset(&m_fileInfo, 0, sizeof(m_fileInfo));
	m_pMarkupCtl = NULL;
	
	m_3DFlag = False;
}

CSampDoc::~CSampDoc()
{
}

BOOL CSampDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}

BOOL CSampDoc::OnOpenDocument(LPCSTR pathName)
{   
	// store the base document file name         
	m_docFileName = pathName;
	
	/*
	**	Set the file.
	*/
	m_pCtl->SetFile(pathName);

	/*
	** Cache file info
	*/
	SetControlFileInfo();

	/*
	**	Enable all caps on the control
	*/
	DWORD	dwCaps = 0L;
	dwCaps = m_pCtl->GetCaps(TRUE);
	m_pCtl->SetCaps(FALSE, dwCaps);

	/*
	**  Set the Left mouse action
	*/
	PAN_CtlFileInfo fileInfo;
	memset(&fileInfo, 0, sizeof(fileInfo));
	m_pCtl->GetFile(&fileInfo);
	if (fileInfo.type == PAN_RasterFile || fileInfo.type == PAN_VectorFile) {
		m_pCtl->SetLMBAction(PAN_CTLLMBZOOM);
		m_pCtl->SetRMBAction(PAN_CTLLMBZOOM);
	} else {
		m_pCtl->SetLMBAction(PAN_CTLLMBSELECT);
		m_pCtl->SetRMBAction(PAN_CTLLMBNONE);
	}
	// Set the modes
	if (fileInfo.dwHints & CTL_FILE_HINT_SHADEDVIEW) {
		if (!Is3DDoc()) {
			Set3D(TRUE);
		}
	} else {
		if (Is3DDoc()) {
			Set3D(False);
		}
	}

	/*
	** For Document files set the INI file option
	** [Options]
	** FORMATDEVICE=DISPLAY
	** to use the display driver rather than the default printer
	** to calculate the text metrics
	*/
	CString	str = AfxGetApp()->GetProfileString("Options", "FORMATDEVICE", "");
	if (str == "DISPLAY") {
		m_pCtl->SendMessage(PM_CTLSETDEVICE, PAN_CTLDEVICESCREEN, 0);
	}
	
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CSampDoc serialization

void CSampDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CSampDoc diagnostics

#ifdef _DEBUG
void CSampDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CSampDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSampDoc commands
CVCETControl	*CSampDoc::GetControl()
{
	return m_pCtl;
}
void	CSampDoc::SetControl(CVCETControl *pCtl)
{
	m_pCtl = pCtl;
}
void	CSampDoc::GetControlFileInfo(PAN_CtlFileInfo *fi)
{
	ASSERT(m_pCtl != 0);
	ASSERT(fi != 0);
	memset(fi, 0, sizeof(PAN_CtlFileInfo));
	*fi = m_fileInfo;
}
void	CSampDoc::SetControlFileInfo()
{
	ASSERT(m_pCtl != 0);
	memset(&m_fileInfo, 0, sizeof(m_fileInfo));
	m_pCtl->GetFile(&m_fileInfo);
}


/**************************************\
** BEGIN: Get the document file names **
\**************************************/
CString CSampDoc::GetDocFileName()
{
	// Return: d:/xxx/yyy/fff.eee
	return m_docFileName;
}
CString CSampDoc::GetDocDirectory()
{
	// Return: d:/xxx/yyy/
	char	filename[_MAX_PATH], drive[_MAX_DRIVE], dir[_MAX_DIR], name[_MAX_FNAME], ext[_MAX_EXT];

	lstrcpy(filename, (LPCSTR) m_docFileName);
	_splitpath(filename, drive, dir, name, ext);
	_makepath(filename, drive, dir, "", "");
	return CString(filename);
}
CString CSampDoc::GetDocShortName()
{
	// Return: fff.eee
	char	filename[_MAX_PATH], drive[_MAX_DRIVE], dir[_MAX_DIR], name[_MAX_FNAME], ext[_MAX_EXT];

	if (!m_docVisibleName.IsEmpty()) {
		lstrcpy(filename, m_docVisibleName);
	} else {
		lstrcpy(filename, m_docFileName);
	}

	_splitpath(filename, drive, dir, name, ext);
	_makepath(filename, "", "", name, ext);
	return CString(filename);
}
CString CSampDoc::GetDocBaseName()
{
	// Return: fff
	char	filename[_MAX_PATH], drive[_MAX_DRIVE], dir[_MAX_DIR], name[_MAX_FNAME], ext[_MAX_EXT];

	lstrcpy(filename, (LPCSTR) m_docFileName);
	_splitpath(filename, drive, dir, name, ext);
	return CString(name);
}

// Return: fff.eee in DOS 8.3 format
CString	CSampDoc::GetDoc83ShortName()	
{
	char	filename[_MAX_PATH], drive[_MAX_DRIVE], dir[_MAX_DIR], name[_MAX_FNAME], ext[_MAX_EXT];

	if (!m_docVisibleName.IsEmpty()) {
		lstrcpy(filename, m_docVisibleName);
	} else {
		lstrcpy(filename, m_docFileName);
	}

	_splitpath(filename, drive, dir, name, ext);
	_makepath(filename, "", "", name, ext);
	return CString(filename);
}

// Return: fff DOS 8.3 format
CString	CSampDoc::GetDoc83BaseName()
{
	char	filename[_MAX_PATH], drive[_MAX_DRIVE], dir[_MAX_DIR], name[_MAX_FNAME], ext[_MAX_EXT];

	lstrcpy(filename, (LPCSTR) m_docFileName);

	_splitpath(filename, drive, dir, name, ext);
	return CString(name);
}

// Return: eee
CString	CSampDoc::GetDocExtension()
{
	char	filename[_MAX_PATH], drive[_MAX_DRIVE], dir[_MAX_DIR], name[_MAX_FNAME], ext[_MAX_EXT];

	lstrcpy(filename, (LPCSTR) m_docFileName);
	_splitpath(filename, drive, dir, name, ext);
	return CString(ext);	
}

/*
** Returns default markup directory: Subdirectory avred of base document.
*/
CString	CSampDoc::GetMarkupDirectory()
{
	CString	str = GetDocDirectory() + CString("avred");
	return str;
}
