// doc.h : interface of the CSampDoc class
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _doc_h_
#define _doc_h_

#include "mfcmark.h"

class CMarkupControl;

class CSampDoc : public CDocument
{
protected: // create from serialization only
	CSampDoc();
	DECLARE_DYNCREATE(CSampDoc)

// Attributes
public:

private:
	CString				m_docFileName;
	BOOL				m_3DFlag; // Flag for 3D

// Operations
public:
	void		SetDocFileName(CString &s) {m_docFileName = s;}

	CString		GetDocFileName();	// Return: d:/xxx/yyy/fff.eee
	CString		GetDocDirectory();	// Return: d:/xxx/yyy/
	CString		GetDocShortName();	// Return: fff.eee
	CString		GetDocBaseName();	// Return: fff
	CString		GetDoc83ShortName();	// Return: fff.eee in DOS 8.3 format
	CString		GetDoc83BaseName();	// Return: fff DOS 8.3 format
	CString		GetDocExtension();	// Return: eee
	
	//
	void		Set3D(BOOL flag) { m_3DFlag = flag; }
	BOOL		Is3DDoc() { return m_3DFlag; }

public:
	void	SetDocVisibleName(const char* pszName)
	{
		if (pszName != NULL) {
			m_docVisibleName = pszName;
		} else {
			m_docVisibleName.Empty();
		}
		// Force update of titlebar
		SetTitle(0);
	}

	CString	GetDocVisibleName()	
	{
		return m_docVisibleName;
	}
private:
	CString 	m_docVisibleName;			// File name we want displayed to the user:
											// holds entry file name for exploded zip file
	
// Implementation
public:
	virtual ~CSampDoc();
	virtual void Serialize(CArchive& ar);   // overridden for document i/o
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	virtual BOOL OnNewDocument();
	virtual BOOL OnOpenDocument(LPCSTR pathName);

// Generated message map functions
protected:
	//{{AFX_MSG(CSampDoc)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
// Implementation
public:
	// For VCET
	CVCETControl	*GetControl();
	void			SetControl(CVCETControl *pCtl);
	void			GetControlFileInfo(PAN_CtlFileInfo *fi);
	void			SetControlFileInfo();

private:
	CVCETControl		*m_pCtl;
	PAN_CtlFileInfo		m_fileInfo;

public:
	// For Markups
	CMarkupControl*	GetMarkupControl() const
	{
		ASSERT_VALID(this);
		return m_pMarkupCtl;
	}
	void	SetMarkupControl(CMarkupControl*	pMarkupCtl)
	{
		ASSERT_VALID(this);
		m_pMarkupCtl = pMarkupCtl;
	}
	CString		GetMarkupDirectory();


private:
	CMarkupControl*		m_pMarkupCtl;
};

#endif
/////////////////////////////////////////////////////////////////////////////
