// mainfrm.cpp : implementation of the CSampMainFrame class
//

#include "stdafx.h"

#include "mfcmark.h"
#include "doc.h"
#include "view.h"
#include "mview.h"
#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSampMainFrame

IMPLEMENT_DYNCREATE(CSampMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CSampMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CSampMainFrame)
#if defined(TWIN32)
	#define theDerivedClass CSampMainFrame ::
#endif
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_WM_PALETTECHANGED()
	ON_WM_QUERYNEWPALETTE()
	//}}AFX_MSG_MAP
#undef	theDerivedClass
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize control bars

// toolbar buttons - IDs are command buttons
static UINT BASED_CODE buttons[] =
{
	// same order as in the bitmap 'toolbar.bmp'
	ID_FILE_OPEN,
	ID_MARKUP_SAVE,
		ID_SEPARATOR,
	ID_FILE_PRINT,
	ID_FILE_PRINT_PREVIEW,
		ID_SEPARATOR,
	ID_FILE_MARKUP,
		ID_SEPARATOR,
	ID_APP_ABOUT,
};

// toolbar buttons - IDs are command buttons
static UINT BASED_CODE buttonsMrk[] =
{
	// same order as in the bitmap 'tb_ment.bmp'
	ID_ENTITIES_LINE, 
	ID_ENTITIES_POLYLINE,
	ID_ENTITIES_BOX,
	ID_ENTITIES_FILLED_BOX,          
	ID_ENTITIES_CIRCLE,
	ID_ENTITIES_ARC,
	ID_ENTITIES_FREESTYLE,                      
	ID_ENTITIES_CLOUD,	
	ID_ENTITIES_TEXT,                
	ID_ENTITIES_LEADER,	
	ID_ENTITIES_HIGHLIGHT,             
	
	ID_ENTITIES_NOTE,	            
	ID_ENTITIES_OLE,                 
};

static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CSampMainFrame construction/destruction

CSampMainFrame::CSampMainFrame()
{
	m_fPreviewMode = FALSE;
}

CSampMainFrame::~CSampMainFrame()
{
}

int CSampMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadBitmap(IDR_MAINFRAME) ||
		!m_wndToolBar.SetButtons(buttons,
		  sizeof(buttons)/sizeof(UINT)))
	{
		TRACE("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndMarkupBar.Create(this, WS_CHILD|CBRS_TOP, AFX_IDW_TOOLBAR+3) ||
		!m_wndMarkupBar.LoadBitmap(IDB_TB_MENT) ||
		!m_wndMarkupBar.SetButtons(buttonsMrk,
		  sizeof(buttonsMrk)/sizeof(UINT)))
	{
		TRACE("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE("Failed to create status bar\n");
		return -1;      // fail to create
	}

	/*
	** Reset cursor to Arrow: Without this the cursor will
	** remain as hour glass until the user moves it. bug 9295
	*/
	SetCursor(AfxGetApp()->LoadStandardCursor(IDC_ARROW));

	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CSampMainFrame diagnostics

#ifdef _DEBUG
void CSampMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CSampMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSampMainFrame message handlers

/************************************************************************
** Begin Save-State Stuff
************************************************************************/
int		CSampMainFrame::IntFromString(LPSTR FAR *lplpsz)
{
	LPSTR	lpsz = *lplpsz;
	int		i = 0;
	char	ch;
	BOOL	fNeg;

	while (*lpsz == ' ') {
		lpsz++;
	}

	fNeg = FALSE;
	while (ch = *lpsz++) {
		if (ch == '-') {
			fNeg = !fNeg;
			continue;
		}

		if ((ch < '0') || (ch > '9')) {
			break;
		}

		i = (i * 10) + (ch - '0');
	}

	*lplpsz = lpsz;

	return (fNeg ? -i : i);
}

/*
**	Saves the state (position) of the window to the ini file
*/
BOOL	CSampMainFrame::SaveState(void)
{
	WINDOWPLACEMENT wpl;
	char		sz[128];

	wpl.length = sizeof(wpl);

	if (!GetWindowPlacement(&wpl)) {
		/*
		**	Impossible to get window placement.
		**	New window placement is not stored.
		*/
		return FALSE;
	}

	wsprintf(sz, "%d %d %d %d %d %d %d %d %d %d %d",
		12,
		wpl.flags,
		wpl.showCmd,
		wpl.ptMinPosition.x,
		wpl.ptMinPosition.y,
		wpl.ptMaxPosition.x,
		wpl.ptMaxPosition.y,
		wpl.rcNormalPosition.left,
		wpl.rcNormalPosition.top,
		wpl.rcNormalPosition.right,
		wpl.rcNormalPosition.bottom
	);

	CWinApp	*pApp = AfxGetApp();
	pApp->WriteProfileString("MainWindow", "Position",	sz);

	return TRUE;
}

/*
**	Restores the state (position) of the window to the ini file
*/
WINDOWPLACEMENT	CSampMainFrame::ReadState(void)
{
	CWinApp	*pApp = AfxGetApp();
	WINDOWPLACEMENT wpl;
	char		ach[128];
	LPSTR		lpsz;
	int 		cxScreen, cyScreen;
	int 		x, y, cx, cy, tmp;

	/*
	**	For future extensions...
	*/
	strcpy (ach, pApp->GetProfileString("MainWindow", "Position", ""));

	lpsz = (LPSTR) ach;
	cxScreen = GetSystemMetrics(SM_CXSCREEN);
	cyScreen = GetSystemMetrics(SM_CYSCREEN);
	cx = cxScreen - 100;
	x = 50;
	cy = cyScreen - GetSystemMetrics(SM_CYICONSPACING) - 20;
	y = 0;

	memset(&wpl, 0, sizeof(wpl));
	wpl.length = sizeof(wpl);

	wpl.rcNormalPosition.left = x;
	wpl.rcNormalPosition.top = y;
	wpl.rcNormalPosition.right = x + cx;
	wpl.rcNormalPosition.bottom = y + cy;
	wpl.ptMinPosition.x = -1;
	wpl.ptMinPosition.y = -1;
	wpl.ptMaxPosition.x = -1;
	wpl.ptMaxPosition.y = -1;

	if (! *ach || IntFromString(&lpsz) != 12) {
		/*
		**	JWR (Mar 15, 1993): Set reasonable values for flags and
		**	showCmd field when panview.ini isn't found.
		*/
		wpl.flags = WPF_SETMINPOSITION;
		wpl.showCmd = SW_SHOW;
	} else {
		wpl.flags	= (UINT) IntFromString(&lpsz);
		wpl.showCmd = (UINT) IntFromString(&lpsz);

		if ((tmp = IntFromString(&lpsz)) <= cxScreen && tmp != -1)
			wpl.ptMinPosition.x = tmp;
		if ((tmp = IntFromString(&lpsz)) <= cyScreen && tmp != -1)
			wpl.ptMinPosition.y = tmp;

		if ((tmp = IntFromString(&lpsz)) <= cxScreen && tmp != -1)
			wpl.ptMaxPosition.x = tmp;
		if ((tmp = IntFromString(&lpsz)) <= cyScreen && tmp != -1)
			wpl.ptMaxPosition.y = tmp;
		wpl.ptMaxPosition.x = wpl.ptMaxPosition.y = 0 - 1;	// always to -1 for natural look

		if ((tmp = IntFromString(&lpsz)) <= cxScreen && tmp != -1)
			wpl.rcNormalPosition.left = tmp;
		if ((tmp = IntFromString(&lpsz)) <= cyScreen && tmp != -1)
			wpl.rcNormalPosition.top = tmp;
		if ((tmp = IntFromString(&lpsz)) <= cxScreen && tmp != -1)
			wpl.rcNormalPosition.right = tmp;
		if ((tmp = IntFromString(&lpsz)) <= cyScreen && tmp != -1)
			wpl.rcNormalPosition.bottom = tmp;
	}
	return wpl;
}
/************************************************************************
** End Save-State Stuff
************************************************************************/


void CSampMainFrame::OnClose()
{
	SaveState();
	
	CSampMarkupView*  pView = (CSampMarkupView*)GetActiveView();

	if (pView->GetMarkupControl() && !m_fPreviewMode) {
		pView->ExitMarkup();	
		PostMessage(WM_CLOSE, 0, 0);		
	} else {
		if (m_fPreviewMode) {
			m_fPreviewMode = FALSE;
		}
		CFrameWnd::OnClose();
	}
}

/////////////////////////////////////////////////////////////////////////////
// CSampMainFrame palette message handling

void CSampMainFrame::OnPaletteChanged(CWnd* pFocusWnd)
{
	CSampView* pView = (CSampView*)GetActiveView();
	CSampDoc* pDoc = pView->GetDocument();

	pDoc->GetControl()->PaletteChanged(pFocusWnd);
}

BOOL CSampMainFrame::OnQueryNewPalette()
{
	CSampView* pView = (CSampView*)GetActiveView();
	CSampDoc* pDoc = pView->GetDocument();

	return ((BOOL)pDoc->GetControl()->QueryNewPalette(0));
}

void CSampMainFrame::ShowMarkupToolbar(BOOL fShow /*TRUE*/)
{                                    
	if (fShow) {
		m_wndMarkupBar.ShowWindow(SW_SHOW);
	} else {
		m_wndMarkupBar.ShowWindow(SW_HIDE);
	}
	RecalcLayout();
}

void CSampMainFrame::UpdateMenu(BOOL fMarkupMode /*FALSE*/, BOOL f3DMarkUp /*FALSE*/)
{         
	CMenu*	pMenu = GetMenu();

	pMenu->Detach();
	if (fMarkupMode) {		
		if (f3DMarkUp)
		{
			pMenu->LoadMenu(IDR_3DMARKUPMENU); // Change this to 3D Menu
		} else { 
			pMenu->LoadMenu(IDR_MARKUPMENU);
		}
	} else {
		pMenu->LoadMenu(IDR_MAINFRAME);
	}
	
	SetMenu(pMenu);
	pMenu->Detach();
}
