// mainfrm.h : interface of the CSampMainFrame class
//
/////////////////////////////////////////////////////////////////////////////

class CSampMainFrame : public CFrameWnd
{
friend class CSampMarkupView;
	
protected: // create from serialization only
	CSampMainFrame();
	DECLARE_DYNCREATE(CSampMainFrame)

// Attributes
public:
	BOOL		m_fFirstTime;	// TRUE: first time call OnPreparePrinting().
								// condition used for the toolbar updating.
	
private:
	BOOL		m_fPreviewMode;

// Operations
public:
	void		SetPreviewMode(BOOL flag) { m_fPreviewMode = flag;}
	BOOL		GetPreviewMode() { return m_fPreviewMode; }

// Implementation
public:
	virtual ~CSampMainFrame();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:  // control bar embedded members
	CStatusBar  m_wndStatusBar;
	CToolBar    m_wndToolBar;
	CToolBar    m_wndMarkupBar;

// Generated message map functions
protected:
	//{{AFX_MSG(CSampMainFrame)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnClose();
	afx_msg void OnPaletteChanged(CWnd* pFocusWnd);
	afx_msg BOOL OnQueryNewPalette();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
// Implementation
private:
	int					IntFromString(LPSTR FAR *lplpsz);
public:
	BOOL				SaveState(void);
	WINDOWPLACEMENT		ReadState(void);

public:
	void				ShowMarkupToolbar(BOOL fShow = TRUE);
	void				UpdateMenu(BOOL fMarkupMode = FALSE, BOOL f3DMarkUp = FALSE);
};

/////////////////////////////////////////////////////////////////////////////
