///////////////////////////////////////////////////////////////////////////////
// reddlgs.cpp
////////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include <stdlib.h>
#include <stdio.h>

#include "mview.h"
#include "mdlgs.h"
#include "doc.h"

#include "resource.h"

////////////////////////////////////////////////////////////////////////////////
// CRedFiles dialog
// Choose existing markups
////////////////////////////////////////////////////////////////////////////////

CSelectMarkupDlg::CSelectMarkupDlg(CWnd* pParent)
	: CDialog(CSelectMarkupDlg::IDD, pParent)
{
	ASSERT_VALID(pParent);

	//{{AFX_DATA_INIT(CSelectMarkupDlg)
	m_strFile = "";
	//}}AFX_DATA_INIT
	m_fNew = FALSE;
}

void CSelectMarkupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelectMarkupDlg)
	DDX_CBString(pDX, IDC_FILES, m_strFile);
	//}}AFX_DATA_MAP
}

#define	theDerivedClass	CSelectMarkupDlg::
BEGIN_MESSAGE_MAP(CSelectMarkupDlg, CDialog)
	//{{AFX_MSG_MAP(CSelectMarkupDlg)
	ON_BN_CLICKED(IDB_NEW, OnClickedRedlinenew)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#undef	theDerivedClass

/////////////////////////////////////////////////////////////////////////////
// CRedFiles message handlers
// CASE 2: File has existing markups
/////////////////////////////////////////////////////////////////////////////

BOOL CSelectMarkupDlg::OnInitDialog()
{
	CSampMarkupView*	pView = (CSampMarkupView *)m_pParentWnd;
	CSampDoc* 			pDoc = pView->GetDocument();
	CMarkupControl*	pMarkupCtl = pDoc->GetMarkupControl();

	CDialog::OnInitDialog();

	// Fill combo box with list of availabe markups.
	CComboBox* pC = (CComboBox*) GetDlgItem(IDC_FILES);
	FillComboBox(pC);

	CStatic* pStatic = (CStatic*) GetDlgItem(IDT_PATH);
	pStatic->SetWindowText(pDoc->GetMarkupDirectory());

	return TRUE;
}

int CSelectMarkupDlg::FillComboBox(CComboBox* pC)
{
	ASSERT(m_pParentWnd->IsKindOf(RUNTIME_CLASS(CSampMarkupView)));
	CSampApp*			pApp = (CSampApp*)AfxGetApp();
	CSampMarkupView*	pView = (CSampMarkupView*) m_pParentWnd;
	CSampDoc* 			pDoc = pView->GetDocument();
	CMarkupControl*		pMarkupCtl = pDoc->GetMarkupControl();
	CString				mrkDir = pDoc->GetMarkupDirectory();

	CString strFilter;
	_makepath(strFilter.GetBuffer(_MAX_PATH), "",
				mrkDir, pDoc->GetDocBaseName(), ".*");
	strFilter.ReleaseBuffer();

#if TARGET == WIN32S || defined(_WIN64) || TARGET == TWUNIX
	WIN32_FIND_DATA 		findInfo = {0};
	HANDLE			       	hFind = 0;
#	define	MYNAME			cFileName
#	define	ISDIR(xx)		((xx.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) ? TRUE : FALSE)
#	define	SETDIRFLAG(xx)	/**/

	if ((hFind = FindFirstFile(strFilter, &findInfo)) != INVALID_HANDLE_VALUE) {
		do {
			if (ISDIR(findInfo)) {
				// Skip directories.
				continue;
			}
			pC->AddString(findInfo.MYNAME);
		} while (FindNextFile(hFind, &findInfo));
		FindClose(hFind);
	}
#else
	pC->Dir(CFile::normal, strFilter);
#endif

	// Remove .BAK extension from list
	CString str = pDoc->GetDocBaseName() + ".BAK";
	int nIndex = pC->FindString(-1, str);
	if (nIndex != LB_ERR) {
		pC->DeleteString(nIndex);
	}

	if (mrkDir == pDoc->GetDocDirectory()) {
		// Redline Dir is the same as current Dir,
		// remove base file from list box.
		str    = pDoc->GetDocShortName();
		nIndex = pC->FindString(-1, str);
		if (nIndex != LB_ERR) {
			pC->DeleteString(nIndex);
		}
	}

	// Set the first item as selected.
	pC->SetCurSel(0);

	return pC->GetCount();
}

void CSelectMarkupDlg::OnClickedRedlinenew()
{
	// Create a new untitled markup file
	m_markupFile.Empty();
	m_fNew = TRUE;

	// Close dialog!
	OnOK();
}

void CSelectMarkupDlg::OnOK()
{
	UpdateData(TRUE);

	CComboBox*		pList = (CComboBox*)GetDlgItem(IDC_FILES);

	if (!m_fNew) {  	// NEW button is not clicked
		// User did not select new: Fill with the
		// currently selected item in combo box.
		CString strExt;
		int i = m_strFile.Find('.');
		if (i >= 1) {
			strExt = m_strFile.Right(m_strFile.GetLength() - i);
		} else {
			strExt = "001";
		}

		// Fill in public information
		CSampApp	*pApp = (CSampApp*)AfxGetApp();
		CSampMarkupView*	pView = (CSampMarkupView *)m_pParentWnd;
		CMarkupControl*		pMrkCtl = pView->GetMarkupControl();
		CSampDoc* 			pDoc = pView->GetDocument();
		// Create markup file object
		CString 	markupFilename = CSampMarkupView::GetFilenameFromID(
										pDoc->GetDocFileName(),
										pDoc->GetMarkupDirectory(),
										strExt);
		m_markupFile = markupFilename;
	} else {
		// User selected NEW
		m_markupFile.Empty();
	}

	CDialog::OnOK();
}


/////////////////////////////////////////////////////////////////////////////
// CMarkupSaveDlg dialog
/////////////////////////////////////////////////////////////////////////////

CMarkupSaveDlg::CMarkupSaveDlg(CWnd* pParent /*=NULL*/, BOOL fHideCancel /*=FALSE*/, LPCSTR szMarkupID /*=0*/)
	: CDialog(CMarkupSaveDlg::IDD, pParent)
{
	m_fHideCancel = fHideCancel;
	m_pParent = pParent;
	if (szMarkupID) {
		m_strMarkupID = szMarkupID;
	}

	//{{AFX_DATA_INIT(CMarkupSaveDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void CMarkupSaveDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMarkupSaveDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

#define	theDerivedClass	CMarkupSaveDlg::
BEGIN_MESSAGE_MAP(CMarkupSaveDlg, CDialog)
	//{{AFX_MSG_MAP(CMarkupSaveDlg)
	ON_BN_CLICKED(IDNO, OnNo)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#undef	theDerivedClass


/////////////////////////////////////////////////////////////////////////////
// CMarkupSaveDlg message handlers
/////////////////////////////////////////////////////////////////////////////

BOOL CMarkupSaveDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	CSampApp	*pApp = (CSampApp*)AfxGetApp();

	CButton*	pB	= (CButton*) GetDlgItem(IDCANCEL);
	pB->EnableWindow(m_fHideCancel ? FALSE : TRUE);

	CStatic *pS = (CStatic*) GetDlgItem(IDC_MARKUPID);
	pS->SetWindowText(m_strMarkupID);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMarkupSaveDlg::OnNo()
{
	EndDialog(IDNO);
}

void CMarkupSaveDlg::OnOK()
{
	CDialog::OnOK();
}

void CMarkupSaveDlg::OnCancel()
{
	CDialog::OnCancel();
}

/////////////////////////////////////////////////////////////////////////////
// CHyperEstablishDlg dialog
/////////////////////////////////////////////////////////////////////////////

CHyperEstablishDlg::CHyperEstablishDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CHyperEstablishDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHyperEstablishDlg)
	m_field1 = _T("");
	m_field2 = _T("");
	m_field3 = _T("");
	m_field4 = _T("");
	m_strName = _T("");
	m_strDesc = _T("");
	m_linkTo = -1;
	//}}AFX_DATA_INIT

	m_saveType = linktoFile;
}

void CHyperEstablishDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHyperEstablishDlg)
	DDX_Text(pDX, IDE_FIELD1, m_field1);
	DDV_MaxChars(pDX, m_field1, 256);
	DDX_Text(pDX, IDE_FIELD2, m_field2);
	DDV_MaxChars(pDX, m_field2, 256);
	DDX_Text(pDX, IDE_FIELD3, m_field3);
	DDV_MaxChars(pDX, m_field3, 256);
	DDX_Text(pDX, IDE_FIELD4, m_field4);
	DDV_MaxChars(pDX, m_field4, 256);
	DDX_Text(pDX, IDE_HYPERLINK_NAME, m_strName);
	DDV_MaxChars(pDX, m_strName, 80);
	DDX_Text(pDX, IDE_HYPERLINK_DESC, m_strDesc);
	DDV_MaxChars(pDX, m_strDesc, 256);
	DDX_CBIndex(pDX, IDC_LINKTO, m_linkTo);
	//}}AFX_DATA_MAP
}

#define	theDerivedClass	CHyperEstablishDlg::
BEGIN_MESSAGE_MAP(CHyperEstablishDlg, CDialog)
	//{{AFX_MSG_MAP(CHyperEstablishDlg)
	ON_BN_CLICKED(IDB_BROWSE_FILE, OnBrowseFile)
	ON_CBN_SELCHANGE(IDC_LINKTO, OnSelchangeLinkto)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#undef	theDerivedClass



BOOL CHyperEstablishDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_strName = m_saveName;
	m_strDesc = m_saveDesc;
	m_linkTo  = (int) m_saveType;
	SetFields();
	UpdateData(FALSE);	// Update to controls
	UpdateUI();			// Show/hide/label controls appropriately
	UpdateData(FALSE);	// Update to controls

	return TRUE;  // return TRUE  unless you set the focus to a control
}


void CHyperEstablishDlg::OnOK()
{
	UpdateData(TRUE);	// Update from controls

	m_saveType = (CHyperEstablishDlg::LinkType)m_linkTo;

	if (m_strName.IsEmpty()) {
		m_strName.LoadString(AFX_IDS_UNTITLED);
	}

	UpdateData(FALSE);	// Update to controls

	CDialog::OnOK();
}


void CHyperEstablishDlg::OnBrowseFile()
{
	UpdateData(TRUE);	// Update from controls

	CString	strFilter;
	switch ((CHyperEstablishDlg::LinkType)m_linkTo) {
		case linktoFile:
			strFilter.LoadString(IDS_ALLFILES_FILTER);
			break;
		default:
			strFilter.LoadString(IDS_ALLFILES_FILTER);
			break;
	}

	CFileDialog dlg(TRUE, 0, 0,
			OFN_FILEMUSTEXIST | OFN_HIDEREADONLY,
			strFilter, 0);

	if (dlg.DoModal() == IDOK) {
		m_field1 = dlg.GetPathName();
		UpdateData(FALSE);	// Update to controls
		SetFocus();
		SetActiveWindow();
	}
}


void CHyperEstablishDlg::OnSelchangeLinkto()
{
	UpdateData(TRUE);	// Update from controls

	// Clear
  	m_field1.Empty();
  	m_field2.Empty();
  	m_field3.Empty();
  	m_field4.Empty();

	if ((CHyperEstablishDlg::LinkType)m_linkTo == m_saveType) {
		// Restore defaults.
		SetFields();
	}

	UpdateUI();
	UpdateData(FALSE);	// Update to controls
}

void CHyperEstablishDlg::SetFields()
{
	CString	str1, str2, str3;

	switch (m_saveType) {
	  case linktoFile:
	  	m_field1 = m_saveS1;
		break;
	  case linktoApp:
	  	m_field1 = m_saveS1;
	  	m_field2 = m_saveS2;
		break;
	  case linktoScript:
	  	m_field1 = m_saveS1;
		break;
	  case linktoDDE:
		ThreeWaySplit(m_saveS1, str1, str2, str3);
	  	m_field1 = str1;
	  	m_field2 = str2;
	  	m_field3 = str3;
	  	m_field4 = m_saveS2;
		break;
	  case linktoDLL:
	  	m_field1 = m_saveS1;
	  	m_field2 = m_saveS2;
		break;
	  default:
		ASSERT(0);
		break;
	}
}

void CHyperEstablishDlg::SetValues(int hType, LPCSTR szName, LPCSTR szDesc, LPCSTR sz1 /*=0*/, LPCSTR sz2 /*=0*/)
{
	m_saveType = MarkupToDlgType(hType);
	m_saveName = szName;
	m_saveDesc = szDesc;
	m_saveS1 = sz1;
	m_saveS2 = sz2;
}

void CHyperEstablishDlg::ShowControl(UINT ctlID, UINT swFlag, UINT label /*=0*/)
{
	CWnd* pC = (CEdit*) GetDlgItem(ctlID);
	if (pC) {
		pC->ShowWindow(swFlag);
		if (label) {
			CString	str;
			str.LoadString(label);
			pC->SetWindowText(str);
		}
	}
}

void CHyperEstablishDlg::UpdateUI()
{
	switch ((CHyperEstablishDlg::LinkType)m_linkTo) {
	  case linktoFile:
		ShowControl(IDC_FIELD1, SW_SHOW, IDS_DATAFILE);
		ShowControl(IDE_FIELD1, SW_SHOW);
		ShowControl(IDC_FIELD2, SW_HIDE);
		ShowControl(IDE_FIELD2, SW_HIDE);
		ShowControl(IDC_FIELD3, SW_HIDE);
		ShowControl(IDE_FIELD3, SW_HIDE);
		ShowControl(IDC_FIELD4, SW_HIDE);
		ShowControl(IDE_FIELD4, SW_HIDE);
		break;
	  case linktoApp:
		ShowControl(IDC_FIELD1, SW_SHOW, IDS_APPLICATION);
		ShowControl(IDE_FIELD1, SW_SHOW);
		ShowControl(IDC_FIELD2, SW_SHOW, IDS_COMMANDLINE);
		ShowControl(IDE_FIELD2, SW_SHOW);
		ShowControl(IDC_FIELD3, SW_HIDE);
		ShowControl(IDE_FIELD3, SW_HIDE);
		ShowControl(IDC_FIELD4, SW_HIDE);
		ShowControl(IDE_FIELD4, SW_HIDE);
		break;
	  case linktoScript:
		ShowControl(IDC_FIELD1, SW_SHOW, IDS_SCRIPTFILE);
		ShowControl(IDE_FIELD1, SW_SHOW);
		ShowControl(IDC_FIELD2, SW_HIDE);
		ShowControl(IDE_FIELD2, SW_HIDE);
		ShowControl(IDC_FIELD3, SW_HIDE);
		ShowControl(IDE_FIELD3, SW_HIDE);
		ShowControl(IDC_FIELD4, SW_HIDE);
		ShowControl(IDE_FIELD4, SW_HIDE);
		break;
	  case linktoDDE:
		ShowControl(IDC_FIELD1, SW_SHOW, IDS_DDESERVERAPPLICATION);
		ShowControl(IDE_FIELD1, SW_SHOW);
		ShowControl(IDC_FIELD2, SW_SHOW, IDS_DDESERVERNAME);
		ShowControl(IDE_FIELD2, SW_SHOW);
		ShowControl(IDC_FIELD3, SW_SHOW, IDS_DDETOPIC);
		ShowControl(IDE_FIELD3, SW_SHOW);
		ShowControl(IDC_FIELD4, SW_SHOW, IDS_COMMANDS);
		ShowControl(IDE_FIELD4, SW_SHOW);
		break;
	  case linktoDLL:
		ShowControl(IDC_FIELD1, SW_SHOW, IDS_DLLFILE);
		ShowControl(IDE_FIELD1, SW_SHOW);
		ShowControl(IDC_FIELD2, SW_SHOW, IDS_DLLENTRYPOINT);
		ShowControl(IDE_FIELD2, SW_SHOW);
		ShowControl(IDC_FIELD3, SW_HIDE);
		ShowControl(IDE_FIELD3, SW_HIDE);
		ShowControl(IDC_FIELD4, SW_HIDE);
		ShowControl(IDE_FIELD4, SW_HIDE);
		break;
	  default:
		ASSERT(0);
		break;
	}
}

void CHyperEstablishDlg::GetValues(int &hType, CString *szName /*=0*/, CString *szDesc /*=0*/, CString *sz1 /*=0*/, CString *sz2 /*=0*/)
{
	CString	semiColon(";");

	hType = DlgToMarkupType(m_saveType);
	if (szName != NULL) {
		*szName = m_strName;
	}
	if (szDesc != NULL) {
		*szDesc = m_strDesc;
	}
	if (sz1 != NULL) {
		switch (m_saveType) {
		  case linktoFile:
		  case linktoApp:
		  case linktoScript:
		  case linktoDLL:
			*sz1 = m_field1;
			break;
		  case linktoDDE:
			*sz1 = m_field1 + semiColon + m_field2 + semiColon + m_field3;
			break;
		  default:
			ASSERT(0);
			break;
		}
	}
	if (sz2 != NULL) {
		switch (m_saveType) {
		  case linktoFile:
		  case linktoApp:
		  case linktoScript:
		  case linktoDLL:
			*sz2 = m_field2;
			break;
		  case linktoDDE:
			*sz2 = m_field4;
			break;
		  default:
			ASSERT(0);
			break;
		}
	}
}

CHyperEstablishDlg::LinkType	CHyperEstablishDlg::MarkupToDlgType(int hType)
{
	switch (hType) {
	  case MLINK_TO_FILE:	return linktoFile;
	  case MLINK_TO_APP:	return linktoApp;
	  case MLINK_TO_SCRIPT:	return linktoScript;
	  case MLINK_TO_DDE:	return linktoDDE;
	  case MLINK_TO_DLL:	return linktoDLL;
	  default:
		ASSERT(0);
		return linktoFile;
	}
}

int			CHyperEstablishDlg::DlgToMarkupType(LinkType hType)
{
	switch (hType) {
	  case linktoFile:		return MLINK_TO_FILE;
	  case linktoApp:		return MLINK_TO_APP;
	  case linktoScript:	return MLINK_TO_SCRIPT;
	  case linktoDDE:		return MLINK_TO_DDE;
	  case linktoDLL:		return MLINK_TO_DLL;
	  default:
		ASSERT(0);
		return MLINK_TO_FILE;
	}
}

/*static*/
void CHyperEstablishDlg::ThreeWaySplit(const CString &_str, CString &str1, CString &str2, CString &str3)
{
	CString	str(_str);	// make a copy
	LPSTR	ptr = str.GetBuffer(str.GetLength()+1);
	char	seps[] = ";";

	ptr = strtok(ptr, seps);
	if (ptr) {
		str1 = ptr;
		ptr = strtok(0, seps);
		if (ptr) {
			str2 = ptr;
			ptr = strtok(0, seps);
			if (ptr) {
				str3 = ptr;
			}
		}
	}
	str.ReleaseBuffer();
}

