#ifndef __MRKPDLGS_H__
#define __MRKPDLGS_H__

#include "stdafx.h"
#include "resource.h"

class CMarkupView;


/////////////////////////////////////////////////////////////////////////////
// CMarkupSaveDlg dialog
/////////////////////////////////////////////////////////////////////////////
class CMarkupSaveDlg : public CDialog
{
// Construction
public:
	CMarkupSaveDlg(CWnd* pParent = NULL,  BOOL hHideCancel = FALSE, LPCSTR szMarkupID = 0);

// Dialog Data
	//{{AFX_DATA(CMarkupSaveDlg)
	enum { IDD = IDD_MARKUP_SAVE };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

// Implementation
protected:
	BOOL 		m_fHideCancel;
	CWnd		*m_pParent;
	CString		m_strMarkupID;

	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CMarkupSaveDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnNo();
	virtual void OnOK();
	virtual void OnCancel();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////
// CSelectMarkupDlg: Selection of markup
////////////////////////////////////////////////////////////////////////////////
class CSelectMarkupDlg : public CDialog
{
// Construction
public:
	CSelectMarkupDlg(CWnd* pParent);

private:
	int		FillComboBox(CComboBox* pC);

// Dialog Data
	//{{AFX_DATA(CSelectMarkupDlg)
	enum { IDD = IDD_MARKUP_SELECTFILE };
	CString	m_strFile;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CSelectMarkupDlg)
	afx_msg void OnClickedRedlinenew();
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
// Implementation

private:
	BOOL					m_fNew;
	CString					m_markupFile;

public:
	CString					GetMarkupFile()  {return m_markupFile;}
};


/////////////////////////////////////////////////////////////////////////////
// CHyperEstablishDlg dialog
/////////////////////////////////////////////////////////////////////////////

class CHyperEstablishDlg : public CDialog
{
// Construction
public:
	CHyperEstablishDlg(CWnd* pParent = NULL);	// standard constructor

protected:
	// Important: Must match order of combo box.
	enum LinkType {
		linktoFile   = 0,
		linktoApp    = 1,
		linktoScript = 2,
		linktoDDE    = 3,
		linktoDLL    = 4
	};

public:
	void	SetFields();
	void	SetValues(int hType, LPCSTR szName, LPCSTR szDescription, LPCSTR sz1 = 0, LPCSTR sz2 = 0);
	void	GetValues(int &hType, CString *szName = 0, CString *szDescription = 0, CString *sz1 = 0, CString *sz2 = 0);
	static	void	ThreeWaySplit(const CString &str, CString &str1, CString &str2, CString &str3);

private:
	LinkType	m_saveType;
	CString		m_saveName;
	CString		m_saveDesc;
	CString		m_saveS1;
	CString		m_saveS2;

protected:
	LinkType		MarkupToDlgType(int hType);
	int				DlgToMarkupType(enum LinkType hType);
	void			UpdateUI();
	void			ShowControl(UINT ctlID, UINT swFlag, UINT label = 0);

protected:
// Dialog Data
	//{{AFX_DATA(CHyperEstablishDlg)
	enum { IDD = IDD_HYPERLINK_ESTABLISH };
	CString	m_field1;
	CString	m_field2;
	CString	m_field3;
	CString	m_field4;
	CString	m_strName;
	CString	m_strDesc;
	int		m_linkTo;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CHyperEstablishDlg)
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	afx_msg void OnBrowseFile();
	afx_msg void OnSelchangeLinkto();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif /* __MRKPDLGS_H__ */
