// ../markup/mrkpview.h : header file
//

#ifndef __MVIEW_H__
#define __MVIEW_H__

#include "doc.h"
#include "view.h"

enum {
	ENTTYPE_UDE_FIRST = ENTTYPE_UDE_BASE + 1000,
	ENTTYPE_UDE_LEADER,
	ENTTYPE_UDE_CLOUD,
	ENTTYPE_UDE_DISTANCE,
	ENTTYPE_UDE_CUMDISTANCE,
	ENTTYPE_UDE_AREA,
	ENTTYPE_UDE_OLE,
	ENTTYPE_UDE_LAST,
};

Public char FAR*	MrsAlloc(const char FAR* lpString);

/////////////////////////////////////////////////////////////////////////////
// CSampMarkupView view
/////////////////////////////////////////////////////////////////////////////

class CSampMarkupView : public CSampView
{
protected:
	DECLARE_DYNCREATE(CSampMarkupView)
	CSampMarkupView();			// protected constructor used by dynamic creation

// Operations
public:
	virtual void OnInitialUpdate();

public:
	// Create and destroy markup control
	BOOL	CreateMarkupControl();
	void	DestroyMarkupControl();

public:
	// Ask user to select one markups:
	BOOL	AskForMarkupName();
	void	ExitMarkup();

public:
	// Printing Support
	virtual void RenderMarkupFile(CDC* pDC, CPrintInfo* pInfo,
			 const PAN_CtlPrintOptions& options, UINT pageNum, UINT tileNum,
			 BOOL fForcetoblack = FALSE);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);

// Implementation
protected:
	virtual ~CSampMarkupView();
	virtual void OnDraw(CDC* pDC);		// overridden to draw this view

	// Generated message map functions
protected:
	//{{AFX_MSG(CSampMarkupView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnClose();
	afx_msg void OnDestroy();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnUpdateLineThickness(CCmdUI* pCmdUI);
	afx_msg void OnFilePrintPreview();
	afx_msg void OnViewToolbar();
	afx_msg void OnUpdateViewToolbar(CCmdUI* pCmdUI);
	afx_msg void OnViewStatusbar();
	afx_msg void OnUpdateViewStatusbar(CCmdUI* pCmdUI);	
	afx_msg void OnMarkupOpen();	
	afx_msg void OnUpdateMarkupOpen(CCmdUI* pCmdUI);
	afx_msg void OnMarkupExit();
	afx_msg void OnUpdateMarkupExit(CCmdUI* pCmdUI);
	afx_msg void OnMarkupSave();
	afx_msg void OnUpdateMarkupSave(CCmdUI* pCmdUI);
	afx_msg void OnModifyEntityFont();
	afx_msg void OnUpdateModifyEntityFont(CCmdUI* pCmdUI);
	afx_msg void OnModifyMarkupOnoff();
	afx_msg void OnUpdateModifyMarkupOnoff(CCmdUI* pCmdUI);
	afx_msg void OnModifyDelete();
	afx_msg void OnUpdateModifyDelete(CCmdUI* pCmdUI);
	afx_msg void OnModifyDeleteAll();
	afx_msg void OnUpdateModifyDeleteAll(CCmdUI* pCmdUI);	
	afx_msg void OnModifyUndo();
	afx_msg void OnUpdateModifyUndo(CCmdUI* pCmdUI);
	afx_msg void OnModifyRedo();
	afx_msg void OnUpdateModifyRedo(CCmdUI* pCmdUI);
  	afx_msg void OnModifyLineStyleDash();
	afx_msg void OnUpdateModifyLineStyleDash(CCmdUI* pCmdUI);
	afx_msg void OnModifyLineStyleDot();
	afx_msg void OnUpdateModifyLineStyleDot(CCmdUI* pCmdUI);
	afx_msg void OnModifyLineStyleDsdd();
	afx_msg void OnUpdateModifyLineStyleDsdd(CCmdUI* pCmdUI);
	afx_msg void OnModifyLineStyleDshd();
	afx_msg void OnUpdateModifyLineStyleDshd(CCmdUI* pCmdUI);
	afx_msg void OnModifyLineStyleSolid();
	afx_msg void OnUpdateModifyLineStyleSolid(CCmdUI* pCmdUI);
	afx_msg void OnModifyLineWidth1();
	afx_msg void OnUpdateModifyLineWidth1(CCmdUI* pCmdUI);
	afx_msg void OnModifyLineWidth2();
	afx_msg void OnUpdateModifyLineWidth2(CCmdUI* pCmdUI);
	afx_msg void OnModifyLineWidth3();
	afx_msg void OnUpdateModifyLineWidth3(CCmdUI* pCmdUI);
	afx_msg void OnModifyLineWidth4();
	afx_msg void OnUpdateModifyLineWidth4(CCmdUI* pCmdUI);
	afx_msg void OnModifyLineWidth5();
	afx_msg void OnUpdateModifyLineWidth5(CCmdUI* pCmdUI);	
	afx_msg void OnHyperlinkEdit();
	afx_msg void OnUpdateHyperlinkEdit(CCmdUI* pCmdUI);
	afx_msg void OnHyperlinkEstablish();
	afx_msg void OnUpdateHyperlinkEstablish(CCmdUI* pCmdUI);	
	afx_msg void OnHyperlinkFire();
	afx_msg void OnUpdateHyperlinkFire(CCmdUI* pCmdUI);	
	afx_msg void OnEntitiesArc();
	afx_msg void OnUpdateEntitiesArc(CCmdUI* pCmdUI);
	afx_msg void OnEntitiesBox();
	afx_msg void OnUpdateEntitiesBox(CCmdUI* pCmdUI);
	afx_msg void OnEntitiesCircle();
	afx_msg void OnUpdateEntitiesCircle(CCmdUI* pCmdUI);	
	afx_msg void OnEntitiesCloud();                      
	afx_msg void OnUpdateEntitiesCloud(CCmdUI* pCmdUI);
	afx_msg void OnEntitiesFilledBox();
	afx_msg void OnUpdateEntitiesFilledBox(CCmdUI* pCmdUI);	
	afx_msg void OnEntitiesFreeStyle();
	afx_msg void OnUpdateEntitiesFreeStyle(CCmdUI* pCmdUI);
	afx_msg void OnEntitiesHighlight();
	afx_msg void OnUpdateEntitiesHighlight(CCmdUI* pCmdUI);
	afx_msg void OnEntitiesLeader();
	afx_msg void OnUpdateEntitiesLeader(CCmdUI* pCmdUI);	
	afx_msg void OnEntitiesLine();
	afx_msg void OnUpdateEntitiesLine(CCmdUI* pCmdUI);	
	afx_msg void OnEntitiesPolyline();
	afx_msg void OnUpdateEntitiesPolyline(CCmdUI* pCmdUI);	
	afx_msg void OnEntitiesText();
	afx_msg void OnUpdateEntitiesText(CCmdUI* pCmdUI);
	afx_msg void OnEntitiesNote();
	afx_msg void OnUpdateEntitiesNote(CCmdUI* pCmdUI);
	afx_msg void OnEntitiesOle();
	afx_msg void OnUpdateEntitiesOle(CCmdUI* pCmdUI);	
	afx_msg void OnEntitiesSymbol();
	afx_msg void OnUpdateEntitiesSymbol(CCmdUI* pCmdUI);	
	afx_msg void OnUpdateColorBlue(CCmdUI* pCmdUI);
	afx_msg void OnColorBlue();
	afx_msg void OnUpdateColorRed(CCmdUI* pCmdUI);
	afx_msg void OnColorRed();
	afx_msg void OnUpdateColorGreen(CCmdUI* pCmdUI);
	afx_msg void OnColorGreen();
	//}}AFX_MSG
	afx_msg LRESULT OnNotifCancel(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnNotifEdit(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnNotifFirelink(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnNotifEntityadded(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnNotifSelchanged(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnNotifModified(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnNotifCursor(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnSampFireHyperlink(WPARAM wParam, LPARAM lParam);
	DECLARE_MESSAGE_MAP()

protected:
	// HELPER FUNCTIONS
	BOOL	IsMenuEnabled(void (CSampMarkupView::*fnOnUpdate) (CCmdUI *));
	
	// Do we have at least one entity of the given type. 
	BOOL	IsEntityTypeAvailable(int Type, BOOL fAllMarkups = TRUE);
	BOOL	IsEntityAvailable(int nEntityID);
	
	BOOL	HyperlinkEstablish(LPMRK_EntitySpec lpEntity, BOOL fLoadData = FALSE);
	virtual	BOOL	HyperlinkFire(int hType, CString &strTitle, CString &strDesc, CString &S1, CString &S2, CString &S3);
	void	StartAddingEntity(int nEntityID, BOOL fExternalUDE = FALSE);
	void	EndAddingEntity();
	void	OnUpdateEntitiesXXX(CCmdUI* pCmdUI, int entID, int FillType = -1);
	void	OnEntitiesXXX(void (CSampMarkupView::*fnOnUpdate) (CCmdUI *), int entID, int FillType = MRK_FILLNONE);
	int 	GetUdeRuntimeID(int nInternalID);
	void	OnUpdateExternalUde(CCmdUI* pCmdUI, int nExtUdeNum);
	void	LoadUdesInfo(); 	// Currently available UDEs information loading
	void	SetDefaultMarkupLayerName();

	BOOL	SaveMarkupFile(LPCSTR lpszNewName = NULL);
	void	SetPage(int numPage);
	BOOL	SetMarkup(CString selectedMarkup);

public:
	static	CString	GetFilenameFromID(LPCSTR baseName, LPCSTR markupDir, LPCSTR ext);


protected:
	// Utility function to set viewextents and to size markup control
	virtual void	SetMarkupViewExtents();
	virtual void	SetMarkupClientRect();
	virtual void	SetMarkupDefaultExtents();

public:
	virtual BOOL	GetTrueExtents(PAN_CtlRange* pTrueExtentsPlusMarkups);

public:
	// Markup control access
	CMarkupControl*		GetMarkupControl() {
		return GetDocument()->GetMarkupControl();
	}

protected:
	// For delayed markup properties modification
	enum GroupAction {
		CHANGE_NONE   = 0,
		HYPERLINK_EDIT,
		HYPERLINK_FIRE,
		HYPERLINK_DELETE,
		HYPERLINK_ESTABLISH,
	} ;
	int	m_notifyAction;


	typedef struct {
		char	szMenuDesc[80]; 	// Buffer storing menu entry string
		UINT	idNum;				// Markup control assigned UDE index
		BOOL	fExternalUde;		// Flag indicating external UDE status
		int 	nMenuNumber;		// Ordinal menu number for object
		int 	idInternal; 		// One of the identificators ENTTYPE_UDE_...
	} UdeInfo;
	int 		m_nUdes;
	UdeInfo*	m_pUdes;

private:
	BOOL		GetEntityInteractively(LPMRK_EntitySpec lpEntity, int Type);

	BOOL		GetHyperlinkSelection(LPMRK_EntitySpec pEntitySpec);
};

#endif // __MVIEW_H__

/////////////////////////////////////////////////////////////////////////////
