// view.cpp : implementation of the CSampView class
//

#include "stdafx.h"

#include "mfcmark.h"
#include "mainfrm.h"
#include "doc.h"
#include "view.h"
                  
// Header file for markup viewing                  
#include "mview.h"

// Conversion
#include "cvtdlg.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSampView

IMPLEMENT_DYNCREATE(CSampView, CView)

#define	theDerivedClass	CSampView::
BEGIN_MESSAGE_MAP(CSampView, CView)
	//{{AFX_MSG_MAP(CSampView)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_SIZE()
	ON_COMMAND(ID_FILE_CONVERT, OnFileConvert)
	ON_UPDATE_COMMAND_UI(ID_FILE_CONVERT, OnUpdateFileConvert)
	ON_COMMAND(ID_EDIT_SELECT, OnEditSelect)
	ON_UPDATE_COMMAND_UI(ID_EDIT_SELECT, OnUpdateEditSelect)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateEditCopy)
	ON_UPDATE_COMMAND_UI(ID_FILE_PRINT, OnUpdateFilePrint)
	ON_UPDATE_COMMAND_UI(ID_FILE_PRINT_PREVIEW, OnUpdateFilePrintPreview)
	ON_UPDATE_COMMAND_UI(ID_VIEW_PAGE_PREV, OnUpdateViewPagePrev)
	ON_COMMAND(ID_VIEW_PAGE_PREV, OnViewPagePrev)
	ON_UPDATE_COMMAND_UI(ID_VIEW_PAGE_NEXT, OnUpdateViewPageNext)
	ON_COMMAND(ID_VIEW_PAGE_NEXT, OnViewPageNext)
	ON_COMMAND(ID_FILE_MARKUP, OnFileMarkup)
	ON_UPDATE_COMMAND_UI(ID_FILE_MARKUP, OnUpdateFileMarkup)
	ON_UPDATE_COMMAND_UI(ID_FILE_OPEN, OnUpdateFileOpen)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()
#undef	theDerivedClass

/////////////////////////////////////////////////////////////////////////////
// CSampView construction/destruction
/////////////////////////////////////////////////////////////////////////////

CSampView::CSampView()
{
	// Used by printing code
	m_nOptions = 0;
	m_pOptions = 0;
}

CSampView::~CSampView()
{
}

/////////////////////////////////////////////////////////////////////////////
// CSampView drawing

void CSampView::OnDraw(CDC* pDC)
{
	CSampDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// Nothing to do! VCET handles the drawing
}

int	CSampView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CView::OnCreate(lpCreateStruct) == -1) {
		return (-1);
	}

	CSampDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	ASSERT(pDoc->GetControl() == NULL);

	// Create the VCET control
	CRect	rcClient(0, 0, 100, 100);
	GetClientRect(rcClient);
	WNDPROC	lpfnNotifyProc = (WNDPROC) MakeProcInstance((FARPROC) __VCETNotifyProc, AfxGetInstanceHandle());
	CVCETControl	*pCtl = new CVCETControl;
	pCtl->Create(rcClient, this, 99, NULL, lpfnNotifyProc);

	// Enable a sensible mode
	DWORD	dwMode = PAN_CTLMODEOPAQUE | PAN_CTLMODEDRAGDROP;
	pCtl->SetMode(FALSE, dwMode);

	// Show the VCET control
	::ShowWindow(pCtl->GetSafeHwnd(), SW_SHOW);
	pDoc->SetControl(pCtl);

	return (0);
}

void	CSampView::OnDestroy()
{
	//	Destroy the VCET control
	CSampDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	if (pDoc->GetControl() != NULL) {
		::SendMessage(pDoc->GetControl()->GetSafeHwnd(), PM_CTLDESTROY, 0, 0L);
		::DestroyWindow(pDoc->GetControl()->GetSafeHwnd());
		pDoc->SetControl(0);
	}

 	CView::OnDestroy();
}

void CSampView::OnSize(UINT nType, int cx, int cy) 
{
	CView::OnSize(nType, cx, cy);
	
	if (cx <= 0 || cy <= 0) {
		//	Ignore bogus sizes
		return;
	}

	CSampDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	CVCETControl	*pCtl = pDoc->GetControl();
	if (pCtl != NULL) {
		//	Resize the VCET control
		::MoveWindow(pCtl->GetSafeHwnd(), 0, 0, cx, cy, TRUE);
	}
}


/////////////////////////////////////////////////////////////////////////////
// CSampView message handlers
/////////////////////////////////////////////////////////////////////////////

/************************************************************************
** Begin VCET Notification handler
************************************************************************/
LRESULT	CSampView::VCETNotifyProc(HWND hCtl, UINT msg, WPARAM wParam, LPARAM lParam)
{
	/*
	** VCET Notifcations end up here!
	*/
	if (GetDocument() == 0 || GetDocument()->GetControl() == 0) {
		// We get a size notification as soon as we create the control,
		// but before we have had a chance to attach the control to the
		// document...return immediately
		return 0L;
	}
	if (hCtl != GetDocument()->GetControl()->GetSafeHwnd()) {
		return 0L;
	}

	CMarkupControl*	pMrkpCtl = GetDocument()->GetMarkupControl();
	
	PAN_CtlFileInfo	fi;
	GetDocument()->GetControlFileInfo(&fi);

	//	Process the message
	switch (msg) {
	  case PNM_CTLPAINT:
		if (pMrkpCtl != NULL) {
			if (fi.type != PAN_DocumentFile) {
				WORD	 pageNum = GetDocument()->GetControl()->GetPage();
				if (pageNum == 0) {
					pageNum = 1;
				}
				pMrkpCtl->SetPage(pageNum-1);
			} else {
				pMrkpCtl->SetPage(0);
			}
		
			RECT	rcInvalid;
			if (lParam == 0) {
				pMrkpCtl->GetClientRect(&rcInvalid);
			} else {
				rcInvalid = *((LPRECT)lParam);
			}
			GetDocument()->GetControl()->MapWindowPoints(pMrkpCtl, &rcInvalid);
			pMrkpCtl->InvalidateRect(&rcInvalid, FALSE);
			pMrkpCtl->UpdateWindow();			
		}
		break;
	  case PNM_CTLSETSEL:
		// A Selection was set
		switch (fi.type) {
		  case PAN_RasterFile:
		  case PAN_VectorFile:
		  	{
			// Get current caps
			DWORD	dwCaps = GetDocument()->GetControl()->GetCaps(FALSE);

		  	// Restore mouse caps to zoom
			dwCaps |= (PAN_CTLCAPSZOOM | PAN_CTLCAPSMOUSE);
			GetDocument()->GetControl()->SetCaps(FALSE, dwCaps);

			// Set LMB Action to zoom
			GetDocument()->GetControl()->SetLMBAction(PAN_CTLLMBZOOM);
			}
			break;

		  default:
		  	// Keep in select mode
		  	break;
		}
		break;

	  case PNM_CTLSETVIEWEXTENTS:
	  	// virtual function: Adjusts markup view extents.
		if (IsKindOf(RUNTIME_CLASS(CSampMarkupView))) {
			SetMarkupViewExtents();
		}
		break;

	  case PNM_CTLSIZE:
		if (IsKindOf(RUNTIME_CLASS(CSampMarkupView))) {
			SetMarkupClientRect();
		}
		break;

	  case PNM_CTLSETFILE:
		break;

	  case PNM_CTLSTATUS:
		break;

	  case PNM_CTLHELPSTRING:
		break;

	  case PNM_CTLARCFILE:
		break;

	  case PNM_CTLDROPFILE:
		if (wParam != 0) {
			// Only accept single files
			return 0L;
		}
		AfxGetApp()->OpenDocumentFile((LPCSTR)lParam);
		break;
	}
	return 0L;
}

#if TARGET==WIN16
Public LRESULT __loadds CALLBACK
#else
Public LRESULT CALLBACK
#endif
CSampView::__VCETNotifyProc(HWND hCtl, UINT msg, WPARAM wParam, LPARAM lParam)
{
	PAN_MANAGE_MFCSTATE

	if (AfxGetApp()->m_pMainWnd == 0) {
		return 0;
	}
	CFrameWnd* pMainWnd = (CFrameWnd*) AfxGetMainWnd();
	if (pMainWnd) {
		CFrameWnd* pFrameWnd = pMainWnd->GetActiveFrame();
		if (pFrameWnd) {
			CSampView* pView = (CSampView *) pMainWnd->GetActiveView();
			if (pView) {
				return pView->VCETNotifyProc(hCtl, msg, wParam, lParam);
			}
		}
	}

	return 0L;
}
/************************************************************************
** End VCET Notification handler
************************************************************************/

/************************************************************************
** Begin File menu
************************************************************************/
void CSampView::OnUpdateFileConvert(CCmdUI* pCmdUI) 
{
	PAN_CtlFileInfo	fi;
	GetDocument()->GetControlFileInfo(&fi);
	pCmdUI->Enable(fi.type == 0 ? FALSE : TRUE);
}

void CSampView::OnFileConvert() 
{
	// TODO: Add your command handler code here
	CCvtDlg	dlg(this, GetDocument()->GetControl()->GetSafeHwnd(), GetDocument()->GetMarkupControl()->GetSafeHwnd());
	dlg.DoModal();
}
/************************************************************************
** End File menu
************************************************************************/

/************************************************************************
** Begin Clipboard
************************************************************************/
void CSampView::OnUpdateEditSelect(CCmdUI* pCmdUI) 
{
	PAN_CtlFileInfo	fi;
	GetDocument()->GetControlFileInfo(&fi);

	switch (fi.type) {
	  case PAN_RasterFile:
	  case PAN_VectorFile:
		pCmdUI->Enable(TRUE);
		break;
	  default:
	  	// These are in selection mode, by default.
		pCmdUI->Enable(FALSE);
		break;
	}
}

void CSampView::OnEditSelect() 
{
	// Get current caps
	DWORD	dwCaps = GetDocument()->GetControl()->GetCaps(FALSE);

	// Add selection + mouse caps
	dwCaps |= (PAN_CTLCAPSCOPY | PAN_CTLCAPSMOUSE);

	GetDocument()->GetControl()->SetCaps(FALSE, dwCaps);

	// Set LMB Action to select
	GetDocument()->GetControl()->SetLMBAction(PAN_CTLLMBSELECT);
}

void CSampView::OnUpdateEditCopy(CCmdUI* pCmdUI) 
{
	// Check if the control has a file and if there is anything selected.
	PAN_CtlFileInfo	fi;
	GetDocument()->GetControlFileInfo(&fi);

	WORD nSels = GetDocument()->GetControl()->GetNumSels();

	pCmdUI->Enable((0 != fi.type) && (0 != nSels));
}

void CSampView::OnEditCopy() 
{
	PAN_CtlFileInfo	fi;
	GetDocument()->GetControlFileInfo(&fi);

	// Copy everything that VCET supports!
	DWORD	dwOptions = 0;

	switch (fi.type) {
	  case PAN_RasterFile:
		dwOptions = PAN_CTLCLPBRDDIB | PAN_CTLCLPBRDBITMAP | PAN_CTLCLPBRDMETAFILE | PAN_CTLCLPBRDPALETTE;
		break;

	  case PAN_VectorFile:
		dwOptions = PAN_CTLCLPBRDDIB | PAN_CTLCLPBRDBITMAP | PAN_CTLCLPBRDMETAFILE | PAN_CTLCLPBRDPALETTE;
		break;

	  case PAN_DocumentFile:
		dwOptions = PAN_CTLCLPBRDTEXT | PAN_CTLCLPBRDRTF;
		break;

	  case PAN_ArchiveFile:
	  case PAN_DatabaseFile:
	  case PAN_SpreadsheetFile:
		dwOptions = PAN_CTLCLPBRDTEXT | PAN_CTLCLPBRDRTF | PAN_CTLCLPBRDHEADINGS;
		break;
	}

	GetDocument()->GetControl()->Copy(dwOptions);
}
/************************************************************************
** End Clipboard
************************************************************************/


/************************************************************************
** Begin Printing
************************************************************************/
// Just do the update handlers: Let MFC handle the guts
void CSampView::OnUpdateFilePrint(CCmdUI* pCmdUI) 
{
	PAN_CtlFileInfo	fi;
	GetDocument()->GetControlFileInfo(&fi);
	pCmdUI->Enable(fi.type == 0 ? FALSE : TRUE);
}

void CSampView::OnUpdateFilePrintPreview(CCmdUI* pCmdUI) 
{
	PAN_CtlFileInfo	fi;
	GetDocument()->GetControlFileInfo(&fi);
	pCmdUI->Enable(fi.type == 0 ? FALSE : TRUE);
}
/************************************************************************
** End Printing
************************************************************************/

/************************************************************************
** Begin Paging
************************************************************************/
void CSampView::OnUpdateViewPagePrev(CCmdUI* pCmdUI) 
{
	PAN_CtlFileInfo	fi;
	GetDocument()->GetControlFileInfo(&fi);
	if (fi.type == 0) {
		pCmdUI->Enable(FALSE);
		return;
	}

	WORD	curPage = GetDocument()->GetControl()->GetPage();
	pCmdUI->Enable(curPage > 1 ? TRUE : FALSE);
}

void CSampView::OnViewPagePrev() 
{
	WORD	curPage = GetDocument()->GetControl()->GetPage();
	curPage--;
	GetDocument()->GetControl()->SetPage(curPage);
}

void CSampView::OnUpdateViewPageNext(CCmdUI* pCmdUI) 
{
	PAN_CtlFileInfo	fi;
	GetDocument()->GetControlFileInfo(&fi);
	if (fi.type == 0) {
		pCmdUI->Enable(FALSE);
		return;
	}

	int	numPages = GetDocument()->GetControl()->GetNumPages();

	WORD	curPage = GetDocument()->GetControl()->GetPage();
	pCmdUI->Enable(numPages < 0 || curPage < numPages ? TRUE : FALSE);
}

void CSampView::OnViewPageNext() 
{
	WORD	curPage = GetDocument()->GetControl()->GetPage();
	curPage++;
	GetDocument()->GetControl()->SetPage(curPage);
}
/************************************************************************
** End Paging
************************************************************************/


/************************************************************************
** Begin Markup
************************************************************************/
void CSampView::OnFileMarkup()
{   	
	CSampDoc *pDoc = GetDocument();
	
	// Time to create markup control
    CSampMarkupView	*pMarkupView = (CSampMarkupView*)this;	// Alias
	if (!pMarkupView->CreateMarkupControl()) {
		AfxMessageBox("The markup functionality is available with the Professional \nEdition of AutoVue.\nPlease contact your local Reseller or Cimmetry Systems.\n");
		return;
	}

	CMarkupControl*	pMarkupCtl = GetDocument()->GetMarkupControl();
	ASSERT(pMarkupCtl != 0);
	
	if (pMarkupView->AskForMarkupName() != FALSE) {
		// Update menu and toolbar for markup control 
		CSampMainFrame	*pMainWnd = (CSampMainFrame*) AfxGetMainWnd();
		pMainWnd->ShowMarkupToolbar();
		pMainWnd->UpdateMenu(TRUE, pDoc->Is3DDoc());
	} else {
		// Close Markup: User cancelled open-markup operation
		if (pMarkupView->GetMarkupControl()) {
			pMarkupView->DestroyMarkupControl();
			GetDocument()->SetMarkupControl(NULL);
		}
	}
}

void CSampView::OnUpdateFileMarkup(CCmdUI* pCmdUI)
{
	if (GetDocument()->GetMarkupControl()) {
		pCmdUI->Enable(FALSE);
	} else {
		PAN_CtlFileInfo	fi;
		GetDocument()->GetControlFileInfo(&fi);
		pCmdUI->Enable(fi.type == 0 ? FALSE : TRUE);
	}
}
    
void CSampView::OnUpdateFileOpen(CCmdUI* pCmdUI) 
{
	if (GetDocument()->GetMarkupControl()) {
		pCmdUI->Enable(FALSE);
	}
}

BOOL	CSampView::HyperlinkFire(
	int linkType, LPCSTR defStr, LPCSTR defStr2, LPCSTR defStr3)
{
	return (1);
}

BOOL CSampView::GetTrueExtents(PAN_CtlRange *Extents)
{
	CSampDoc		*pDoc = GetDocument();
	CVCETControl	*pCtl = pDoc->GetControl();
	if (pCtl == NULL) {
		return (FALSE);
	}

	pCtl->GetPageSize(Extents);
	return TRUE;
}
/************************************************************************
** End Markup
************************************************************************/


/////////////////////////////////////////////////////////////////////////////
// CSampView diagnostics
/////////////////////////////////////////////////////////////////////////////

#ifdef _DEBUG
void CSampView::AssertValid() const
{
	CView::AssertValid();
}

void CSampView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CSampDoc* CSampView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSampDoc)));
	return (CSampDoc*)m_pDocument;
}
#endif //_DEBUG

