/////////////////////////////////////////////////////////////////////////////
// view.h : interface of the CSampView class
/////////////////////////////////////////////////////////////////////////////
#ifndef	 _view_h_
#define	 _view_h_

class CSampDoc;
class CSampMarkupFile;

class CSampView : public CView
{
friend class CMrkSymbolsDlgP1;
	
protected: // create from serialization only
	CSampView();
	DECLARE_DYNCREATE(CSampView)

// Operations
public:
	BOOL	GetTrueExtents(PAN_CtlRange*	Extents);

// Implementation
public:
	virtual ~CSampView();
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

// markup virtuals
public:
	virtual void	SetMarkupViewExtents()	{;}
	virtual void	SetMarkupClientRect()	{;}
	virtual	BOOL	HyperlinkFire(int linkType, LPCSTR defStr, LPCSTR defStr2, LPCSTR defStr3);
	// printing support
	virtual	void	RenderMarkupFile(CDC* pDC, CPrintInfo*  pInfo,
						const PAN_CtlPrintOptions& options, UINT pageNum,
						UINT tileNum, BOOL fForcetoblack = FALSE)	{;}

protected:
	// Printing support
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);

// Generated message map functions
protected:
	//{{AFX_MSG(CSampView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCS);
	afx_msg void OnDestroy();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnFileConvert();
	afx_msg void OnUpdateFileConvert(CCmdUI* pCmdUI);
	afx_msg void OnEditSelect();
	afx_msg void OnUpdateEditSelect(CCmdUI* pCmdUI);
	afx_msg void OnEditCopy();
	afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFilePrint(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFilePrintPreview(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewPagePrev(CCmdUI* pCmdUI);
	afx_msg void OnViewPagePrev();
	afx_msg void OnUpdateViewPageNext(CCmdUI* pCmdUI);
	afx_msg void OnViewPageNext();
	afx_msg void OnFileMarkup();
	afx_msg void OnUpdateFileMarkup(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileOpen(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

// Implementation
	// VCET notification procedure
protected:
	LRESULT		VCETNotifyProc(HWND hCtl, UINT msg, WPARAM wParam, LPARAM lParam);
#if TARGET==WIN16
	static	LRESULT __loadds CALLBACK
#else
	static	LRESULT	CALLBACK
#endif
	__VCETNotifyProc(HWND hCtl, UINT msg, WPARAM wParam, LPARAM lParam);
	
	// Printing helper functions
	BOOL	GetPrintPreview(CPrintInfo *pInfo, PRINTDLG *pd);
	void	GetCurrentPageAndTile(CPrintInfo *pInfo, UINT *pageNum, UINT *tileNum);
	void	GetImageAndClipRects(const PAN_CtlPrintOptions& options,
				UINT tileNum, PAN_CtlRange& imageRect, CRect& clipRect);
	void RenderHeadersFooters(CDC* pDC, CPrintInfo* pInfo,
				const PAN_CtlPrintOptions& options);
	void RenderBaseFile(CDC* pDC, CPrintInfo* pInfo,
				const PAN_CtlPrintOptions& options, UINT pageNum, UINT tileNum,
				BOOL fForcetoblack = FALSE);
				
	int						m_nOptions;
	PAN_CtlPrintOptions*	m_pOptions;

// Attributes
public:
	CSampDoc* 			GetDocument();
 	PAN_CtlFileInfo 	m_ctlInfo;		// Cached copy of the active control's info.	
		
};

#ifndef _DEBUG  // debug version in view.cpp
inline CSampDoc* CSampView::GetDocument()
   { return (CSampDoc*)m_pDocument; }
#endif

	class	CDummyCmdUI : public CCmdUI
	{
		public:
			CDummyCmdUI()							{m_fEnabled = TRUE;}
			virtual ~CDummyCmdUI()							{;}
			virtual void Enable(BOOL bOn = TRUE)	{m_fEnabled = bOn;}
			virtual void SetCheck(int nCheck = 1)	{;}
			virtual void SetRadio(BOOL bOn = TRUE)	{;}
			virtual void SetText(LPCSTR lpszText)	{;}
		public:
			BOOL	IsEnabled() 					{return (m_fEnabled);}
		private:
			BOOL	m_fEnabled;
	};

#endif
