// view.cpp : implementation of the CSampView class
//

#include "stdafx.h"
#include "app.h"

#include "doc.h"
#include "view.h"

#include "pan.h"
#include "outtext.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSampView

IMPLEMENT_DYNCREATE(CSampView, CFormView)

BEGIN_MESSAGE_MAP(CSampView, CFormView)
	//{{AFX_MSG_MAP(CSampView)
	ON_BN_CLICKED(IDC_BROWSE_INPUT, OnBrowseInput)
	ON_BN_CLICKED(IDC_BROWSE_OUTPUT, OnBrowseOutput)
	ON_BN_CLICKED(IDEXTRACT, OnExtract)
	ON_BN_CLICKED(IDC_DISPLAY_OUTPUT, OnDisplayOutput)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSampView construction/destruction

CSampView::CSampView()
	: CFormView(CSampView::IDD)
{
	//{{AFX_DATA_INIT(CSampView)
	m_strContents = _T("");
	m_fDisplayOutput = TRUE;
	m_inputFile2 = _T("");
	m_inputFile = _T("");
	m_outputFile = _T("c:\\temp\\text.out");
	//}}AFX_DATA_INIT
	// TODO: add construction code here
}

CSampView::~CSampView()
{
}

void CSampView::OnInitialUpdate()
{
	// called first time after construct
	ResizeParentToFit(FALSE);
	CFormView::OnInitialUpdate();
}

void CSampView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSampView)
	DDX_Text(pDX, IDC_CONTENTS, m_strContents);
	DDX_Check(pDX, IDC_DISPLAY_OUTPUT, m_fDisplayOutput);
	DDX_Text(pDX, IDC_INPUTFILE2, m_inputFile2);
	DDX_Text(pDX, IDC_INTPUTFILE, m_inputFile);
	DDX_Text(pDX, IDC_OUTPUTFILE, m_outputFile);
	//}}AFX_DATA_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CSampView diagnostics

#ifdef _DEBUG
void CSampView::AssertValid() const
{
	CFormView::AssertValid();
}

void CSampView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CSampDoc* CSampView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSampDoc)));
	return (CSampDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSampView message handlers



void CSampView::OnBrowseInput() 
{
	CFileDialog fDlg(TRUE, 0, "*.*", OFN_FILEMUSTEXIST | OFN_HIDEREADONLY, "All Files (*.*)|*.*||", this);
	if (fDlg.DoModal() != IDOK) {
		return;
	}
	m_inputFile = fDlg.GetPathName();
	UpdateData(FALSE);
}

void CSampView::OnBrowseOutput() 
{
	CFileDialog fDlg(FALSE, 0, "*.*", OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, "All Files (*.*)|*.*||", this);
	if (fDlg.DoModal() != IDOK) {
		return;
	}
	m_outputFile = fDlg.GetPathName();
	UpdateData(FALSE);
}

void CSampView::OnExtract() 
{
	UpdateData(TRUE);

	struct stat sb;
	memset(&sb, 0, sizeof(sb));
	if (stat(m_inputFile, &sb) != 0) {
		AfxMessageBox("The file does not exist!");
		return;
	}

	if (m_fDisplayOutput) {
		m_nContentSize = 0;
		m_inputFile2  = "Processing ";
		m_inputFile2 += m_inputFile;
		m_inputFile2 += " ...";
		m_strContents = "";
	}
	UpdateData(FALSE);

	HCURSOR	hOldCursor = ::SetCursor(LoadCursor(0, IDC_WAIT));
	OutText(m_inputFile, m_outputFile, (WNDPROC)__CallBackFunction);
	::SetCursor(hOldCursor);

	if (m_fDisplayOutput) {
		m_inputFile2  = "Text from ";
		m_inputFile2 += m_inputFile;
		m_inputFile2 += ":";
	}
	
	UpdateData(FALSE);
}

void CSampView::OnDisplayOutput() 
{
	UpdateData(TRUE);
	if (! m_fDisplayOutput) {
		m_inputFile2 = "";
		m_strContents = "";
		m_nContentSize = 0;
	}
	UpdateData(FALSE);
}

/*
**  The Windows EDIT control expects "\r\n" to terminate lines.
**  We get funny chacarchers with just "\n"
*/
void	CSampView::UnixToDosString(LPCSTR strUnix, LPSTR strDos)
{
	char	lastChar = 0;
	for (; *strUnix; strUnix++) {
		if (*strUnix == '\n' && lastChar != '\r') {
			*strDos++ = '\r';
		}
		*strDos++ = (lastChar = *strUnix);
	}
	*strDos = '\0';
}
LRESULT	CSampView::CallBackFunction(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	UINT	size = (UINT)wParam;
	LPCSTR	str = (LPCSTR)lParam;
	if (!m_fDisplayOutput || m_nContentSize > 0x7FFF) {
		return 0L;
	}
	UnixToDosString(str, m_buf);
	m_strContents += m_buf;
	m_nContentSize += size;
	UpdateData(FALSE);
	
	return 0L;
}

#if TARGET==WIN16
LRESULT __loadds CALLBACK
#else
LRESULT	CALLBACK
#endif
CSampView::__CallBackFunction(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	AFX_MANAGE_STATE(AfxGetAppModuleState());

	UINT	size = (UINT)wParam;
	LPCSTR	str = (LPCSTR)lParam;


	CFrameWnd* pMainWnd = (CFrameWnd*) AfxGetMainWnd();
	if (pMainWnd) {
		CFrameWnd* pFrameWnd = pMainWnd->GetActiveFrame();
		if (pFrameWnd) {
			CSampView* pView = (CSampView *) pMainWnd->GetActiveView();
			if (pView) {
				return pView->CallBackFunction(hWnd, msg, wParam, lParam);
			}
		}
	}

	return 0L;
}
