// ExampleDLL.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "ExampleDLL.h"
#include "UserResLocateDefs.h"

#define RI_VECTOR_EXTERNAL_REFERENCE 3

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}

/**
 * Implements this callback function to locate resource
 */
extern "C" EXAMPLEDLL_API BOOL UserResLocateProc(BOOL bPreLocate, const ResLocateInfoStruct* pResLocateInfo, ResLocatedStruct* pResLocated)
{
	if ( bPreLocate && pResLocateInfo->nType == RI_VECTOR_EXTERNAL_REFERENCE ) {
		wchar_t resolvedPath[_MAX_PATH] = L"";
		if ( GetPrivateProfileStringW(L"Mapping", pResLocateInfo->resPath, L"", resolvedPath, _MAX_PATH, L"c:/test.map") ) {
			// Resource located by user
			pResLocated->AddResolvedPathProc(pResLocated->privateContext, resolvedPath);
			return TRUE;
		}
	}
	// Resource is not located by user, let AutoVue handles it.
	return FALSE;
}