#ifndef _USERRESLOCATEDEFS_H_
#define _USERRESLOCATEDEFS_H_

#include <stdlib.h>	// for "_MAX_PATH" define


/**
 * Information about the resource AutoVue try to locate
 */
typedef struct _ResLocateInfoStruct {
	wchar_t baseFilename[_MAX_PATH];		// Full path of the base file
	wchar_t resName[_MAX_PATH];				// Resource name
	wchar_t resPath[_MAX_PATH];				// Resource file path
	int nType;								// Resource type (RI_XXX enum in avdefs.h)
	struct {
		wchar_t pattern[_MAX_PATH];			// regular expression pattern
		size_t maxResults;					// maximum number of files that should be located
		char magicString[_MAX_PATH];		// MagicString
	} hints;
} ResLocateInfoStruct;

/**
 * Information about the located resource
 */
typedef struct _ResLocatedStruct {	
	void* privateContext;					// Context to be passed in 'AddResolvedPathProc' callback

	/**
	 * Callback to add resolved path
	 * @param privateContext Context for the callback
	 * @param resolvedPath Resolved path to be added
	 * @return TRUE if successful, FALSE otherwise
	 */
	BOOL (*AddResolvedPathProc)(void* privateContext, const wchar_t* resolvedPath);
} ResLocatedStruct;

/**
 * Function prototype of the DLL callback function. 
 * @param bPreLocate TRUE if the callback function is called before AutoVue try to locate the resource
 * @param pResLocateInfo [in] Pointer to structure contains information about the resource AutoVue try to locate
 * @param pResLocated [out] Pointer to structure contains information about the located resource
 * @return TRUE if resource is located by the user, FALSE otherwise
 */
typedef BOOL	(*DLLLocateProc)(BOOL bPreLocate, const ResLocateInfoStruct* pResLocateInfo, ResLocatedStruct* pResLocated);


#endif // _USERRESLOCATEDEFS_H_

