
/*===========================================================================*/
/*                                                                           */
/* SMPLVIEW: A Sample AutoVue 19.3 Application                               */
/*                                                                           */
/* Copyright Oracle, 1995-2008, all rights reserved.                         */
/*                                                                           */
/*===========================================================================*/

#include <windows.h>			/* required for all Windows applications */

#include "pctl.h"

#include "generic.h"			/* specific to this program		*/

/****************************************************************************
	FUNCTION:	NotifyWndProc(HWND hWnd, UINT msg, WORD wParam, LONG lParam)
	PURPOSE:	The VCET Controls notification procedure
	COMMENTS:	The function is passed as an argument to PAN_CreateControl()
				It is called by the controls whenever the state of the
				control has changed in a "major" way. The PNM_ notifications
				sent are listed in the header file, "pctl.h".
****************************************************************************/
Public	LONG __loadds CALLBACK NotifyWndProc(HWND hWnd, UINT msg, WORD wParam, LONG lParam)
{
	/*
	**	If a window is not visible, return immediately.
	**	Its possible that we recieved a notification message
	**	immediately after creating a contol, but before
	**	we have finished our own  initialisations.
	*/
	if (! IsWindowVisible(hWnd)) {
		return(0L);
	}

	switch (msg) {
	  case PNM_CTLSIZE:
		break;
	  case PNM_CTLHSCROLL:
	  case PNM_CTLVSCROLL:
	  case PNM_CTLSETVIEWEXTENTS:
		break;
	  case PNM_CTLDROPFILE:
		if (wParam != 0) {
			return 0;
		}
		VCET_DisplayFile(hCtl, (LPCSTR)lParam);
		break;
	  default:
		break;
	}

	return 0;
}

