/*===========================================================================*/
/*                                                                           */
/* SMPLVIEW: A Sample AutoVue 19.3 Application                               */
/*                                                                           */
/* Copyright Oracle, 1995-2008, all rights reserved.                         */
/*                                                                           */
/*===========================================================================*/

// INCLUDES

#include <windows.h>			/* required for all Windows applications */

#include "pctl.h"

#include "generic.h"			/* specific to this program		*/


//******************************************************************************
// PRIVATE MACROS

// Swap two values.
#define SWAP(x, y)	((x) ^= (y) ^= (x) ^= (y))

//******************************************************************************
// PRIVATE CONSTANTS


//******************************************************************************
// PRIVATE FUNCTIONS

//******************************************************************************
Private void NormalizeRect(
	LPRECT	lprc)
{
	if (lprc->right < lprc->left) {
		SWAP(lprc->right, lprc->left);
	}
	if (lprc->bottom < lprc->top) {
		SWAP(lprc->bottom, lprc->top);
	}
}

//******************************************************************************
Private void DrawSelect(
	HDC 	hdc,
	LPRECT	rcClip,
	BOOL	fDraw)
{
	char	sz[80];
	SIZE	cSize;
	int 	len, dx, dy;
	HDC 	hdcBits;
	HBITMAP hbm;
	POINT	pt;

	if (!IsRectEmpty(rcClip)) {
		// If a rectangular clip region has been selected, draw it.
		PatBlt(hdc, rcClip->left, rcClip->top,
			rcClip->right - rcClip->left, 1, DSTINVERT);

		PatBlt(hdc, rcClip->left, rcClip->bottom, 1,
			-(rcClip->bottom - rcClip->top), DSTINVERT);

		PatBlt(hdc, rcClip->right - 1, rcClip->top, 1,
			rcClip->bottom - rcClip->top, DSTINVERT);

		PatBlt(hdc, rcClip->right, rcClip->bottom - 1,
			-(rcClip->right - rcClip->left), 1, DSTINVERT);

		// Format the dimensions string...
		wsprintf(sz, "%dx%d",
			rcClip->right - rcClip->left,
			rcClip->bottom - rcClip->top);

		len = lstrlen(sz);

		// ... and center it in the rectangle.
		GetTextExtentPoint(hdc, sz, len, &cSize);
		dx = cSize.cx;
		dy = cSize.cy;
		pt.x = (rcClip->right + rcClip->left - dx) / 2;
		pt.y = (rcClip->bottom + rcClip->top - dy) / 2;

		hdcBits = CreateCompatibleDC(hdc);
		if (hdcBits) {
			SetTextColor(hdcBits, 0xFFFFFFL);
			SetBkColor(hdcBits, 0x000000L);

			// Output the text to the DC.
			hbm = CreateBitmap(dx, dy, 1, 1, 0);
			if (hbm){
				hbm = SelectObject(hdcBits, hbm);
				ExtTextOut(hdcBits, 0, 0, 0, 0, sz, len, 0);
				BitBlt(hdc, pt.x, pt.y, dx, dy, hdcBits, 0, 0, SRCINVERT);
				hbm = SelectObject(hdcBits, hbm);
				DeleteObject(hbm);
			}
			DeleteDC(hdcBits);
		}
	}
}

//******************************************************************************
// PUBLIC FUNCTIONS

//******************************************************************************
Public BOOL MyTrackMouse(HWND hwnd, LPRECT lprcBox)
{
	BOOL	result = FALSE;
	RECT	rcClient;
	POINT   pt;
	HDC 	hdc;
	MSG 	msg;

	SetCapture(hwnd);

	GetClientRect(hwnd, &rcClient);

	// Point at which mouse button was clicked.
	pt.x = lprcBox->left;
	pt.y = lprcBox->top;

	// Set cursor
	SetCursor(LoadCursor(0, IDC_CROSS));
	result = TRUE;

	// Eat mouse messages until a WM_LBUTTONUP is encountered.
	// Meanwhile continue to draw a rubberbanding rectangle and display
	// its dimensions.
	for (;;) {
		if (PeekMessage(&msg, 0, WM_MOUSEFIRST, WM_MOUSELAST, PM_REMOVE)) {
			hdc = GetDC(hwnd);
			DrawSelect(hdc, lprcBox, FALSE);
			ReleaseDC(hwnd, hdc);

			// Get Device coordinates.
			if ((int) LOWORD(msg.lParam) < pt.x) {
				lprcBox->left   = LOWORD(msg.lParam);
			} else {
				lprcBox->right  = LOWORD(msg.lParam);
			}
			if ((int)HIWORD(msg.lParam) < pt.y) {
				lprcBox->top    = HIWORD(msg.lParam);
			} else {
				lprcBox->bottom = HIWORD(msg.lParam);
			}
			NormalizeRect(lprcBox);

			hdc = GetDC(hwnd);
			DrawSelect(hdc, lprcBox, TRUE);
			ReleaseDC(hwnd, hdc);

			if (msg.message == WM_LBUTTONUP) {
				result = TRUE;
				break;
			}
			if (msg.message == WM_RBUTTONUP) {
				result = FALSE;
				break;
			}
			continue;
		}
	}
	SetCursor(LoadCursor(0, IDC_ARROW));

	hdc = GetDC(hwnd);
	DrawSelect(hdc, lprcBox, TRUE);
	ReleaseDC(hwnd, hdc);

	ReleaseCapture();

	return result;
}

//******************************************************************************
