#ifndef AVDEFS_H
#define AVDEFS_H


/*
**	Miscellaneous defines  and	Compiler dependencies.
**	-------------------------------------------------
*/

#define CSI_WINDOWS

/***************************************************************************
**	UNIX : UNIX with wine Libraries
****************************************************************************/
#ifdef CSI_UNIX
# define PCALLBACK		CALLBACK
# define CCALLBACK		CALLBACK
# define PCALLBACKFN	CALLBACK
# define CCALLBACKFN	CALLBACK
# define __near 		/**/
# define __far			/**/
# define _huge			/**/
# define __huge			/**/
# define huge			/**/
# define _loadds		/**/
# define __loadds		/**/
# define _export		/**/
# define __pascal		/**/
# define READ			_O_RDONLY
# define WRITE			_O_WRONLY
# define _inline		__inline
# define _cexit()		exit(1)
# define _fcalloc		calloc
# define _fmemset		memset
# define hmemcpy		MoveMemory
# define _fmemcpy		memcpy
# define _fmalloc		malloc
# define _frealloc		realloc
# define _fmemcmp		memcmp
# define _ffree 		free
# define _fstrcat		strcat
# define _fstrdup		_strdup
# define _fstrncat		strncat
# define _fstrchr		strchr
# define _fstrrchr		strrchr
# define _fstrcmp		strcmp
# define _fstricmp		_stricmp
# define _fstrncmp		strncmp
# define _fstrcpy		strcpy
# define _fstrncpy		strncpy
# define _fstrnicmp 	_strnicmp
# define _fstrlen		strlen
# define _fstrstr		strstr
# define _fstrtok		strtok
# define _fstrupr		_strupr
# define _halloc(n, x)	malloc((n) * (x))
# define _hfree			free
# define _stat			stat
# define _msize			sizeof
# define LockData(x)	/**/
# define UnlockData(x)	/**/
# define _Windows		/**/
#ifndef WIN32
# define WIN32			1
#endif
#if MACHINE == M_SPARC
# define _S_IFDIR		S_IFDIR
# define _isnan         isnan
# define _finite        finite
#endif
#if MACHINE == M_LINUX
# define _isnan         isnan
# define _finite        finite
#endif
#if MACHINE == M_AIX
# define _gcvt                  gcvt
# define _fileno                fileno
# define _isatty                isatty
# define _fcvt                  fcvt
# define _ecvt                  ecvt
# define _unlink                unlink
# define _isnan(x)              (!(finite(x)))
#endif
#if MACHINE == M_HPUX
# define _isnan(x)		(isnan(x))
# define _finite(x)        	(isfinite(x))
#endif
#endif	/* UNIX */


/***************************************************************************
**	WIN32S / NT API
****************************************************************************/
#ifdef CSI_WINDOWS
# define LittleEndian	1
# define PCALLBACK		CALLBACK
# define CCALLBACK		CALLBACK
# define PCALLBACKFN	CALLBACK
# define CCALLBACKFN	CALLBACK
# define _near			/**/
# define __near 		/**/
# define _far			/**/
# define __far			/**/
# define _huge			/**/
# define __huge			/**/
# define huge			/**/
# define _loadds		/**/
# define __loadds		/**/
# define _export		/**/
# define __export		/**/
# define _pascal		/**/
# define __pascal		/**/
# define READ			_O_RDONLY
# define WRITE			_O_WRONLY
# define _fcalloc		calloc
# define _fmemset		memset
# define _fmemcpy		memcpy
# define _fmalloc		malloc
# define _frealloc		realloc
# define _fmemcmp		memcmp
# define _ffree 		free
# define _fstrcat		strcat
# define _fstrdup		_strdup
# define _fstrncat		strncat
# define _fstrchr		strchr
# define _fstrrchr		strrchr
# define _fstrcmp		strcmp
# define _fstricmp		_stricmp
# define _fstrncmp		strncmp
# define _fstrcpy		strcpy
# define _fstrncpy		strncpy
# define _fstrnicmp 	_strnicmp
# define _fstrlen		strlen
# define _fstrstr		strstr
# define _fstrtok		strtok
# define _fstrupr		_strupr
# define _halloc(n, x)	malloc((n) * (x))
# define _hfree			free
# define hmemcpy		MoveMemory
# define LockData(x)	/**/
# define UnlockData(x)	/**/
# define _Windows		/**/
# define WIN32			1
#endif	/* WIN32S */

/**
 * HyperLink possible types
 */
// Page link
#define PAN_LINK_PAGE		0x00000000
// Link is defined by a rectangular range
#define PAN_LINK_RANGE		0x00000001
// Start of a block of records to attach to a link
#define PAN_LINK_BEGIN		0x00000002
// End of a block of records to attach to a link
#define PAN_LINK_END		0x00000003
// Attach the link to the current block
#define PAN_LINK_BLOCK		0x00000004
// Add new link
#define PAN_LINK_NEW		0x00000008
// Link types
#define PAN_LINK_TYPE		(PAN_LINK_PAGE | PAN_LINK_RANGE | PAN_LINK_BEGIN |	\
							 PAN_LINK_END | PAN_LINK_BLOCK)
// Attach link to the current text run
#define PAN_LINK_DOCRUN		0x00000010
// Attach link to the current APO container
#define PAN_LINK_DOCAPO		0x00000020
// Document control link types
#define PAN_LINK_DOCTYPE	(PAN_LINK_DOCRUN | PAN_LINK_DOCAPO)

#define  LINK_SEP "\n"
#define  WLINK_SEP L"\n"
/*
**	Create a valid IEEE double and floating point values
*/
#ifdef CSI_UNIX
#define FixFloat(x) {;}
#define FixDouble(x) {;}
#else
#define FixFloat(x) {									\
		float	F = (float)0.0; 						\
		_xdr_ieee_to_float(&F, (int *) &(x)); 	\
		_xdr_float_to_ieee(&F, (int *) &(x)); 	\
		}
#define FixDouble(x)	{								\
		double	D = 0.0;								\
		_xdr_ieee_to_double(&D, (int *) &(x));	\
		_xdr_double_to_ieee(&D, (int *) &(x));	\
		}
#endif

/*
**	Useful typedefs.
*/
#define Public		/**/
#define Private 	static

/*
**	Some defines
*/
#define 	False		 0
#define 	True		 1
#define 	Maybe		-1
#define 	DontCare	-2
#define 	Fifteen 	15

#define 	STRLEN80		80
#define 	STRLEN240		240
#define		PAN_MAX_PATH	320


#define 	STRLEN_DRIVE	_MAX_DRIVE
#define 	STRLEN_DIR		_MAX_DIR
#if 	defined(UNIX)
# define	STRLEN_FNAME	512
# define	STRLEN_EXT		512
#else
# define	STRLEN_FNAME	_MAX_FNAME
# define	STRLEN_EXT		_MAX_EXT
#endif
#define 	STRLEN_NAME		_MAX_PATH


#define TooBig				32766

#define ExtremelyVerySmallSquared	1.e-024
#define ExtremelyVerySmall	1.e-012
#define VerySmall			1.e-04
#define Small				1.e-03
#define Large				1.e06
#define VeryLarge			1.e12

#define	SMALL10TOMINUS1		1.0e-1
#define	SMALL10TOMINUS2		1.0e-2
#define	SMALL10TOMINUS3		1.0e-3
#define	SMALL10TOMINUS4		1.0e-4
#define	SMALL10TOMINUS5		1.0e-5
#define	SMALL10TOMINUS6		1.0e-6
#define	SMALL10TOMINUS7		1.0e-7
#define	SMALL10TOMINUS8		1.0e-8
#define	SMALL10TOMINUS9		1.0e-9
#define	SMALL10TOMINUS10	1.0e-10
#define	SMALL10TOMINUS11	1.0e-11
#define	SMALL10TOMINUS12	1.0e-12
#define	SMALL10TOMINUS13	1.0e-13
#define	SMALL10TOMINUS14	1.0e-14
#define	SMALL10TOMINUS15	1.0e-15

#define	LARGE10TOPLUS1		1.0e+1
#define	LARGE10TOPLUS2		1.0e+2
#define	LARGE10TOPLUS3		1.0e+3
#define	LARGE10TOPLUS4		1.0e+4
#define	LARGE10TOPLUS5		1.0e+5
#define	LARGE10TOPLUS6		1.0e+6
#define	LARGE10TOPLUS7		1.0e+7
#define	LARGE10TOPLUS8		1.0e+8
#define	LARGE10TOPLUS9		1.0e+9
#define	LARGE10TOPLUS10		1.0e+10
#define	LARGE10TOPLUS11		1.0e+11
#define	LARGE10TOPLUS12		1.0e+12
#define	LARGE10TOPLUS13		1.0e+13
#define	LARGE10TOPLUS14		1.0e+14
#define	LARGE10TOPLUS15		1.0e+15

#define Pi					3.14159265358979320
#define PiT2				6.28318530717958600
#define PiB2				1.57079632679489700
#define PiB3				1.04719755119659770
#define PiB4				0.78539816339744830
#define PiB5				0.62831853071795860
#define PiB6				0.52359877559829880
#define PiB8				0.39269908169872410
#define PiB10				0.31415926535897930
#define PiB12				0.26179938779914940
#define PiB16				0.19634954084936210
#define PiB36				0.08726646259971647
#define TenDegrees			0.17453292519943290
#define Sqrt2				1.41421356237309500
#define Sqrt2B2 			0.70710678118654760
#define RadToDeg			57.2957795130823200
#define DegToRad			0.01745329251994330
#define RadToDeg256 		40.7436654315252100 /* 256 / (2pi)	*/
#define RadToDeg512 		81.4873308630504200 /* 512 / (2pi)	*/
#define Deg256ToRad 		0.02454369260617026
#define Deg512ToRad 		0.01227184630308513

#define Abs(x)				((x)<0 ? -(x) : (x))
#define Fabs(x) 			((x)<0.? -(x) : (x))
#define Min(a, b)			((a)<(b) ? (a) : (b))
#define Max(a, b)			((a)>(b) ? (a) : (b))

/*
**	Memory allocation
*/
#define Nil(x)				((x *) NULL)
#define New(x)				(x *) malloc(sizeof(x))
#define NNew(y, x)			(x *) malloc((size_t)(((size_t)!(y)?1:(y)) * sizeof(x)))
#if !(defined(CSI_UNIX) && defined(ELIMINATE_WINE_IMALLOC_CONFLICT))
   /* Eliminate these redefinitions on Unix in instances 
    * where they would conflict with the pure virtual functions
    * of the same name defined for struct IMalloc in Wine-generated
    * objidl.h.
    */
#  define Realloc(x, y)		((x) ? realloc(x, y) : malloc(y))
#  define Free(x) 			if ((x)!=NULL) {free(x);}
#endif
#define PanMalloc(x)		malloc((!(x) ? 1 : (x)))
#define PanFree(x)			if ((x)!=NULL) {free(x);}
#define FNew(x) 			(x *) _fmalloc(sizeof(x))
#define FNNew(y, x) 		(x *) _fmalloc((size_t)((!(y)?1:(y)) * sizeof(x)))
#define FFree(x)			if ((x)!=NULL) {_ffree(x);}
#define PanFMalloc(x)		_fmalloc((!(x) ? 1 : (x)))
#define PanFFree(x) 		if ((x)!=NULL) {_ffree(x);}


#define	pixels2bytes(x)		(((x) & 0x07) ? ((x) >> 3) + 1 : (x) >> 3)
#define	IIndirect(z, y, x)	( *(*((z) + (y)) + (x)) )

#define Sqrt(x) 			((x)>0.0 ? sqrt(x) : 0.0)
#define Sin(x)				PAN_Sin(x)
#define Cos(x)				PAN_Cos(x)
#define Atan2(x, y)			(((x)==0.0&&(y)==0.0) ? 0.0 : atan2(x, y))

/*
**	Convert a double to two longs
*/
#define D2LL(val)	(long) val, (long)((val<0.0? -1 : 1) * ((val - (long) val)*1000.0))

/*
**	Encoding / Decoding functions to read/write serial numbers from the
**	registration file
**	ENCTONUM converts an encoded value (two letters) to a number (0..9)
**	NUMTOENC converts a digit (0..9) two a two-letter ascii encoded value.
*/
#define ENCTONUM2(x)	( 10*((x)[0] - '0' - 32) + ((x)[1] - '0' - 32) )
#define NUMTOENC2(x, y) (x)[0] = (((y) % 100) / 10) + '0' + 32; \
						(x)[1] =  ((y) % 10) + '0' + 32;

/*
**	AD930531: Anyone who writes an import library needs to know the maximum
**	allowable priority level.
*/
#define PAN_MAX_PRIORITY		32000

/*
**	The return values from the reading functions
*/
#define PROCESS_ERROR		0
#define PROCESS_OK			1
#define PROCESS_KBHIT		2
#define PROCESS_DEMOFILE	3
#define PROCESS_DONE		4

/************************************************************************
** BEGIN Drawing Hints for PAN_QueryFile()
*************************************************************************/
#define PAN_NoHints 				0x0000

#define PAN_RasterInterlaced		0x0001
#define PAN_RasterBottomUp			0x0002
#define PAN_RasterRuns				0x0004

#define PAN_VectorSupportsEdat		0x00000001
#define PAN_VectorWindowsMeta		0x00000002
#define PAN_VectorStitchLSLines		0x00000004 //if set, stitch lines even with line style
#define PAN_VectorStitchLSPolys		0x00000008 //if set, stitch poly even with line style
#define PAN_VectorHasPens			0x00000010
#define PAN_VectorYOrgBottom		0x00000020
#define PAN_VectorXOrgRight 		0x00000040
#define PAN_VectorTrueColor 		0x00000080
#define PAN_VectorRGBColors 		0x00000100
#define PAN_VectorFrozenLayers 		0x00000200
#define PAN_VectorShadedView		0x00000400
#define PAN_VectorVScrollPage		0x00000800
#define PAN_VectorMesh				0x00004000
#define PAN_VectorSupportsMesh		0x00008000
#define PAN_VectorSupportsBRep		0x00010000
#define PAN_Vector2DAnd3DPages		0x00020000
#define PAN_VectorWmfToEmf			0x00040000
#define PAN_VectorEcadSchematic		0x00080000
#define PAN_VectorEcadPCB			0x00100000
#define PAN_VectorViewPoint			0x00200000
#define PAN_VectorNoTriStrip		0x00400000
#define PAN_VectorPrecisionLong	    0x00800000  // If set, file data are stored in long values in order to reduce memory usage
#define PAN_VectorEcadArtwork		0x01000000
#define PAN_VectorAutoZoomFit       0x02000000

#define PAN_VectorStitch			PAN_VectorStitchLSLines|PAN_VectorStitchLSPolys

#define PAN_ArchiveByRow			0x0001
#define PAN_ArchiveByCol			0x0002
#define PAN_ArchiveByBlock			0x0004

#define PAN_DatabaseByRow			0x0001
#define PAN_DatabaseByCol			0x0002
#define PAN_DatabaseByBlock			0x0004

#define PAN_SpreadsheetByRow		0x0001
#define PAN_SpreadsheetByCol		0x0002
#define PAN_SpreadsheetByBlock		0x0004

#define PAN_MultiPage				0x00001000
#define PAN_NoPrint					0x20000000
#define PAN_NoCopy					0x40000000
#define	PAN_PasswordProtected		0x80000000

#define	PAN_FLIPNONE				0x0000
#define	PAN_FLIPX					0x0001
#define	PAN_FLIPY					0x0002
#define	PAN_FLIPXY					0x0003

// Length Units.
#define	PAN_UNITUNKNOWN			0xffff
#define	PAN_UNITPIXEL			0		// Pixel.
#define	PAN_UNITINCH			1		// Inch.
#define	PAN_UNITMM				2		// Millimeters
#define	PAN_UNITRELATIVE		3		// No longer used.
#define	PAN_UNITTWIPS			4		// Twips.
#define	PAN_UNITCMETER			5		// Centimeter.
#define	PAN_UNITDMETER			6		// Decimeter.
#define	PAN_UNITMETER			7		// Meter.
#define	PAN_UNITKMETER			8		// Kilometer
#define	PAN_UNITFOOT			9		// Feet.
#define	PAN_UNITYARD			10		// Yard	
#define	PAN_UNITMILE			11		// Mile
#define	PAN_UNITTHOUSANDTHINCH	12		// Thousandth of an inch
#define PAN_UNITTENTHOUSANDTHINCH 13	// Ten Thousandth of an inch
#define	PAN_UNITMICRON			14		// Micron
#define	PAN_UNITMICROINCH		15		// Microinch
#define PAN_UNITMINRANGE		PAN_UNITPIXEL
#define	PAN_UNITMAXRANGE		PAN_UNITMICROINCH

// Mass Units
#define	PAN_UNITGRAM			0		// gram
#define	PAN_UNITKILOGRAM		1		// kilogram
#define	PAN_UNITMILIGRAM		2		// miligram
#define	PAN_UNITPOUND			3		// pound
#define	PAN_UNITTONNE			4		// tonne (I.S.)
#define	PAN_UNITTON				5		// ton (Imperial system)
#define	PAN_UNITOUNCE			6		// Ounce
#define	PAN_UNITSLUG			7		// Slug
#define PAN_UNITMASSMINRANGE	PAN_UNITGRAM
#define PAN_UNITMASSMAXRANGE	PAN_UNITSLUG

//Angle Units
#define PAN_UNITRADIAN			0
#define PAN_UNITDEGREE			1

// Group types (3D vector control)
enum	PanGroupType
{
	PAN_GROUPTYPE_BLOCK = 0,
	PAN_GROUPTYPE_BODY,
	PAN_GROUPTYPE_ASSEMBLY,	// Group of bodies, parts and other assemblies:
							// Sub-entities can be disassembled.
	PAN_GROUPTYPE_PART,		// Group of bodies that makeup a rigid part.
	PAN_GROUPTYPE_PMI,		// PMI entities group type
	// TODO:  Add as needed.
};

/************************************************************************
** END Drawing Hints for PAN_QueryFile()
*************************************************************************/

/************************************************************************
** Begin raster-specific defines
************************************************************************/

/************************************************************************
** End raster-specific defines
************************************************************************/

/************************************************************************
** Begin vector-specific defines
************************************************************************/
#define PAN_SETHANDLE		0x00000001
#define PAN_PUSHBLOCK		0x00000002
#define PAN_POPBLOCK		0x00000004
#define PAN_BEGINBLOCK		0x00000008
#define PAN_ENDBLOCK		0x00000010
#define PAN_BEGINXREF		0x00000020
#define PAN_ENDXREF			0x00000040
#define PAN_BEGINDIMENSION	0x00000080
#define PAN_ENDDIMENSION	0x00000100
#define PAN_BEGINTEXT		0x00000200
#define PAN_ENDTEXT			0x00000400
#define PAN_BEGINLINESTYLE	0x00000800
#define PAN_ENDLINESTYLE	0x00001000
#define PAN_BEGINVTEXT		0x00002000
#define PAN_ENDVTEXT		0x00004000
#define PAN_BEGINFILL		0x00008000
#define PAN_ENDFILL			0x00010000
#define PAN_BEGINTTEXT		0x00020000
#define PAN_ENDTTEXT		0x00040000
#define PAN_BEGINALTTEXT	0x00080000
#define PAN_ENDALTTEXT		0x00100000


#define	PAN_CADOPTIONS_NOFILLS			0x00000001
#define	PAN_CADOPTIONS_NOTEXT			0x00000002
#define	PAN_CADOPTIONS_NOFONTS			0x00000004
#define	PAN_CADOPTIONS_NODIMENSIONS		0x00000008
#define	PAN_CADOPTIONS_NOXREFS			0x00000010
#define	PAN_CADOPTIONS_NOLINESTYLES		0x00000020
#define PAN_CADOPTIONS_FULLDISPLAY		0x00000040
#define	PAN_CADOPTIONS_NOLINEWEIGHTS	0x00000080
#define	PAN_CADOPTIONS_FASTDISPLAY		0x00000100

// Layer Association
#define	PAN_ENTITYLAYER		0x00000000
#define	PAN_BLOCKLAYER		0x00000001
#define	PAN_XREFLAYER		0x00000002

#define	PAN_SETLAYERS		0
#define PAN_ADDLAYERS		1

/** PANX_VText generation flags */
#define	PAN_VTEXT_MIRRORX	0x0002				// Flipped text along X-axis
#define	PAN_VTEXT_MIRRORY	0x0004				// Flipped text along Y-axis
#define	PAN_VTEXT_VERTICAL	0x4000				// Vertical text
#define	PAN_VTEXT_DRAW		0x0800				// Text must always be drawn (even if fonts are disabled)
#define	PAN_VTEXT_SEARCH	0x8000				// Text for searching purpose OR have an alternative rendering

/*	Resource Info Structure Data Types */
enum	{
	RI_TEXTFONT,
	RI_LINESTYLE,
	RI_SHAPE,
	RI_VECTOR_EXTERNAL_REFERENCE,
	RI_RASTER_EXTERNAL_REFERENCE,
	RI_UNKNOWN,
	LAST
};

#define	PAN_THICKPOLY_FIXEDWIDTH		0x0001		// Thickness should remain constant when zoom changes.
#define	PAN_THICKPOLY_PIXELWIDTH		0x0002		// Thickness is given in pixels.
#define	PAN_THICKPOLY_CAPROUND			0x0004		// Round cap.
#define	PAN_THICKPOLY_CAPSQUARE			0x0008		// Square cap.
#define	PAN_THICKPOLY_CAPFLAT			0x0010		// Flat cap.
#define	PAN_THICKPOLY_JOINBEVEL			0x0020		// Bevel joints.
#define	PAN_THICKPOLY_JOINMITER			0x0040		// Miter joints.
#define	PAN_THICKPOLY_JOINROUND			0x0080		// Round joints.
#define PAN_THICKPOLY_CURRENTTHICKNESS	0x0100		// Use the state thickness
#define PAN_THICKPOLY_DASHCAPS			0x0200		// Enable end caps for each segment of the line.

// Fill modes
#define PAN_FILL_NONE			0x00000000L		// No filling
#define PAN_FILL_ALTERNATE		0x00000001L		// Alternate filling mode
#define PAN_FILL_WINDING		0x00000002L		// Winding filling mode

// Clip region flags
#define	PAN_CLIPRGN_WINDING		0x00000080L		// Winding Poly region.  Alternate by default.

#define	PAN_CLIPRGN_NONE 		0x00000001L		// Unselect any selected clip rgn.
#define	PAN_CLIPRGN_SET			0x00000002L		// Set given clip region.
	
#define	PAN_CLIPRGN_AND			0x00000004L		// Combine with exiting clip rgn using the given operator.
#define	PAN_CLIPRGN_DIFF		0x00000008L
#define	PAN_CLIPRGN_OR			0x00000010L
#define	PAN_CLIPRGN_XOR			0x00000020L

// Vector font types.
#define	PAN_FONTTYPE_TYPE1			0x00000001L		// Type1 font.
#define PAN_FONTTYPE_TRUETYPE		0x00000002L		// True Type font
#define PAN_FONTTYPE_TRUETYPESYS	0x00000002L		// Installed True Type font (same as TRUETYPE)
#define PAN_FONTTYPE_TRUETYPEEMB	0x00000004L		// Embedded True Type font
#define PAN_FONTTYPE_CID			0x00000008L		// CID font

// Vector font text display modes
#define PAN_TEXTEXMODE_CHARBYCHAR	0x00000001L		// Each character has a corresponding point in the points array
#define PAN_TEXTEXMODE_HIDDEN		0x00000002L		// Text should not be displayed
#define PAN_TEXTEXMODE_SIZEONLY		0x00000004L		// Do not display, only calculate extents

// Vector font encoding modes
typedef enum {
	ftmCharCode,
	ftmCodeMap,
	ftmCodeMapDirect,
	ftmCIDToGIDMap,
	ftmCFFCharset,
} PAN_FontIndexMode;

// Vector font properties
#define PAN_FONTWIDTH_NARROW		0x00000001L		// Font is narrow/condensed
#define	PAN_FONTWIDTH_WIDE			0x00000002L		// Font is wide/extended


// Vector font flags.
#define	PAN_FONTFLAG_DELETEFILE				0x00000001L		// Delete font file when done using it.
#define	PAN_FONTFLAG_DEFAULTCHARWIDTHS		0x00000002L		// Use default font charwidths.  Should be
															// set if the character widths are not specified
															// in PAN_FONT's CharWidths buffer.

//flags for PANX_DefineLineStyle function
#define PAN_LS_SCALESTYLE        0x00000001L  //Dashes are scaled
#define PAN_LS_LINEALIGN         0x00000002L  //Add padding dashes for every line 
#define PAN_LS_POLYEDGEALIGN     0x00000004L  //Add padding dashes for start and end in polyline 
#define PAN_LS_POLYALLALIGN      0x00000008L  //Add padding dashes for every link in polyline;
											  //NOTE: in case of small links last flag may cause solid
											  //line drawing instead of dashes
											  
#define PAN_LS_ALWAYSTHICKLINE  0x00000010L  //Allways draw this style using
											  //thick line drawing, i.e. Brush instead of Pen	
#define PAN_LS_AUTOTHICKLINE     0x00000020L  //Allowed control choose drawing method

//flags for PANX_SetLineStyle function
#define PAN_LS_SETSTYLE		 0x00000001L
#define PAN_LS_GETSTYLE		 0x00000002L
//flags PAN_LS_ALLWAYSTHICKLINE and PAN_LS_AUTOTHICKLINE
//for PANX_DefineLineStyle
//can be used in PANX_SetLineStyle too
#define PAN_LS_NOTHICKLINE   0x00000004L

// Maximum size of string options in profile files
#define PAN_PROFILE_MAX_STRING_SIZE	8192


#define _MAX_SEARCHPATHS 4096
#define _MAX_SEARCHHINTS 4096

/*
 * Path separator : always use a single char as a path separator
 */
#define  PATH_SEP ";"
#define  WPATH_SEP L";"

#ifdef CSI_UNIX

#define FILE_SEP "/"
#define WFILE_SEP L"/"

#else

#define FILE_SEP "\\"
#define WFILE_SEP L"\\"

#endif

// Default search for XRef and Font paths (keep the string and wide-string versions synchronized) 
#define DEFAULT_SEARCH_REF_PATHS "$(DIRECT)" PATH_SEP "$(BASEFILE)" PATH_SEP "$(PATHS=XREFPATHS)"
#define WDEFAULT_SEARCH_REF_PATHS L"$(DIRECT)" WPATH_SEP L"$(BASEFILE)" WPATH_SEP L"$(PATHS=XREFPATHS)"

#define DEFAULT_SEARCH_FONT_PATHS "$(DIRECT)" PATH_SEP "$(BASEFILE)" PATH_SEP "$(PATHS=XFONTPATHS)" PATH_SEP "$(MODULE)" PATH_SEP "$(MODULE)" FILE_SEP "fonts"
#define WDEFAULT_SEARCH_FONT_PATHS L"$(DIRECT)" WPATH_SEP L"$(BASEFILE)" WPATH_SEP L"$(PATHS=XFONTPATHS)" WPATH_SEP L"$(MODULE)" WPATH_SEP L"$(MODULE)" WFILE_SEP L"fonts"

// Flags for PANX_PlayMetafile.
#define	PAN_PLAYMETAFILE_DIB		0x00000001
#define	PAN_PLAYMETAFILE_EMF		0x00000002

/************************************************************************
** End vector-specific defines
************************************************************************/


/************************************************************************
** Begin AB/SS/AR-specific defines
************************************************************************/

/*
** Structures used to describe Spreadsheet cell data
*/
#define PAN_SSFLOAT 					1
#define PAN_SSINT						2
#define PAN_SSSTRING					3
#define PAN_SSMULTIRUNUNICODETEXT		7

/*
**	Format definitions:
**	Don't change the values for the following flags because
**	they have correspondent  flags in the Table code (toolbox.h)
*/
#define PAN_SSFORMAT_FIXED				0
#define PAN_SSFORMAT_SCIENTIFIC 		1
#define PAN_SSFORMAT_CURRENCY			2
#define PAN_SSFORMAT_COMMA				3
#define PAN_SSFORMAT_PERCENT			4
#define PAN_SSFORMAT_SPECIAL			7

#define PAN_SSSPECIAL_PLUSMINUS 		0
#define PAN_SSSPECIAL_GENERAL			1
#define PAN_SSSPECIAL_DDMMMYY			2
#define PAN_SSSPECIAL_DDMMM 			3
#define PAN_SSSPECIAL_MMMYY 			4
#define PAN_SSSPECIAL_TEXT				5
#define PAN_SSSPECIAL_HIDDEN			6
#define PAN_SSSPECIAL_HHMMSS			7
#define PAN_SSSPECIAL_HHMM				8
#define PAN_SSSPECIAL_DATEINT1			9
#define PAN_SSSPECIAL_DATEINT2			10
#define PAN_SSSPECIAL_TIMEINT1			11
#define PAN_SSSPECIAL_TIMEINT2			12
#define PAN_SSSPECIAL_LABEL 			13
#define PAN_SSSPECIAL_AUTOMATIC 		14
#define PAN_SSSPECIAL_DEFAULT			15

#define PAN_SSFRMTFLG_REV				0x0100			// Color cell contents if negative.
#define PAN_SSFRMTFLG_PAREN				0x0200			// Put output in parentheses.
#define PAN_SSFRMTFLG_HILITE			0x0400			// Hilight cell contents.
#define PAN_SSFRMTFLG_FILL				0x0800			// Fill alignment
#define PAN_SSFRMTFLG_DISTRIBUTEDINDENT	0x1000			// Horizontal distributed indent alignment
#define PAN_SSFRMTFLG_CENTERACROSSSEL	0x2000			// Centered Across Selection alignment

// Border flags:
#define PAN_SSBORDER_NONE				0
#define PAN_SSBORDER_LEFT				1
#define PAN_SSBORDER_RIGHT				2
#define PAN_SSBORDER_TOP				4
#define PAN_SSBORDER_BOTTOM 			8
#define PAN_SSBORDER_OUTLINE	   		16
#define PAN_SSBORDER_DOWN		   		32
#define PAN_SSBORDER_UP			   		64

// Border styles:
#define PAN_SSBORDERSTYLE_NONE				0
#define PAN_SSBORDERSTYLE_SOLID 			1
#define PAN_SSBORDERSTYLE_DASH				2
#define PAN_SSBORDERSTYLE_DOT				4
#define PAN_SSBORDERSTYLE_DASHDOT			8
#define PAN_SSBORDERSTYLE_DASHDOTDOT		16
#define PAN_SSBORDERSTYLE_BLANK 			32
#define PAN_SSBORDERSTYLE_DOUBLE 			64
#define	PAN_SSBORDERSTYLE_MEDIUM			0x0080
#define PAN_SSBORDERSTYLE_THICK				0x0100
#define PAN_SSBORDERSTYLE_MEDIUM_DASH		0x0200
#define PAN_SSBORDERSTYLE_MEDIUM_DASHDOT	0x0400
#define PAN_SSBORDERSTYLE_MEDIUM_DASHDOTDOT	0x0800
#define PAN_SSBORDERSTYLE_SLANTED_DASHDOT	0x1000
#define PAN_SSBORDERSTYLE_HAIR				0x2000

// PAN_CellAttrib dwDefaultFlags
#define	PAN_SSATTRIBDEFAULT_FILL			0x000000001		// indicates fill has not been set
#define	PAN_SSATTRIBSET_BORDERS				0x000000002		// indicates border MUST be applied, whether it is default or user defined
#define	PAN_SSATTRIBSET_BORDERRECT			0x000000004		// indicate border rectangle has been set
#define PAN_SSATTRIBDEFAULT_FONTCOLOR		0x000000008		// indicate that the font colour has not been set
#define PAN_SSATTRIBDEFAULT_FONTSIZE		0x000000010		// indicate font size has not been set
#define PAN_SSATTRIBDEFAULT_FONTITALIC		0x000000020		// indicate italic has not been set
#define PAN_SSATTRIBDEFAULT_FONTBOLD		0x000000040		// indicate bold has not been set
#define PAN_SSATTRIBDEFAULT_FONTUNDERLINE	0x000000080		// indicate underline has not been set
#define PAN_SSATTRIBDEFAULT_FONTSTRIKE		0x000000100		// indicate strikethrough has not been set
#define PAN_SSATTRIBDEFAULT_FONTNAME		0x000000200		// indicate font facename has not been set
#define PAN_SSATTRIBDEFAULT_FONTPROPS		(PAN_SSATTRIBDEFAULT_FONTSIZE | PAN_SSATTRIBDEFAULT_FONTITALIC | PAN_SSATTRIBDEFAULT_FONTBOLD |		\
											PAN_SSATTRIBDEFAULT_FONTUNDERLINE | PAN_SSATTRIBDEFAULT_FONTSTRIKE | PAN_SSATTRIBDEFAULT_FONTNAME)

/*
** Properties:
**	lpPropVal points to BOOL variable:
*/
#define PAN_PROP_OVERFLOW				1		// Allow cell overflow.
#define PAN_PROP_RESIZE 				2		// Allow column/row resize.
#define PAN_PROP_MULTIBLK				3		// Allow multi-block selections.
#define PAN_PROP_GRID					4		// Show grid.
#define PAN_PROP_CHEADERS				5		// Display column headers.
#define PAN_PROP_RHEADERS				6		// Display row headers.

// lpPropVal points to COLORREF
#define PAN_PROP_GCOLOR 				10		// Grid colour.

// lpPropVal points to WORD
#define PAN_PROP_GTYPE					11		// Grid style.

// lpPropVal points to array of two COLORREFS: background, foreground.
#define PAN_PROP_GREY					12		// Grey color.

// lpPropVal points to array of four COLORREFS:
//  shadow, shadow text, shadow dark, shadow light.
#define PAN_PROP_SHADOW 				13		// Shadow color.

// Used only with PANX_GetSSProps.
// need to specified col, row and lpPropVal must be a pointer to a double
#define PAN_SSCOLWIDTH					14
#define PAN_SSROWHEIGHT 				15
#define PAN_SSDEFAULTFONT				16

// For Merged Cell implementation.
#define	PAN_SSMERGEDCELLS				17

// For page breaking support
#define	PAN_SSPAGEBREAK					18

// For print area support
#define PAN_SSPRINTAREA					19

// Use controls text formatting to render Escher text boxes for the decoder
#define PAN_SSTEXTBOX					20

// For comment support in the Spreadsheet Control
#define PAN_SSCOMMENT					21

// Will take a PAN_SSTextBox structure, and insert newline characters where text should wrap
#define PAN_SSCOMMENTINSERTNEWLINES		22

// For conditional formatting support in the Spreadsheet Control
#define PAN_SSCONDITIONALFORMAT			23

// Used to indicate if filled cells should use their fill colour to draw their default borders, or
// if they should use the default gridline colour
#define PAN_SSDRAWFILLEDCELLDEFAULTBORDER	24

// Used to indicate that default gridlines should be printed, not just displayed
#define PAN_SSPRINTDEFAULTGRIDLINES			25

// Unicode version of PAN_SSDEFAULTFONT
#define PAN_SSDEFAULTFONTW					26

// Default spreadsheet text colour
#define PAN_SSDEFAULTTEXTCOLOR				27

// Default row height
#define PAN_SSDEFAULTROWHEIGHT				28

// Default column width
#define PAN_SSDEFAULTCOLUMNWIDTH			29

// If the decoder finds that the extents should be made larger than originally calculated, 
// send the new extents through here
#define PAN_SSEXTENDSHEETEXTENTS			30


// Underline styles - used in conjunction with other PAN_ATTR_XXX flags.
// Overwrites the ones spreadsheets will never use (such as bold or italic)
#define PAN_SSATTR_ACCT_SINGLE_UNDERLINE_NUM	0x00000001		// single accounting underline for numbers
#define PAN_SSATTR_ACCT_DOUBLE_UNDERLINE_NUM	0x00000002		// double accounting underline for numbers
#define PAN_SSATTR_ACCT_SINGLE_UNDERLINE_TXT	0x00000004		// single accounting underline for text	
#define PAN_SSATTR_ACCT_DOUBLE_UNDERLINE_TXT	0x00000008		// double accounting underline for text
//#define PAN_ATTR_SUBSCRIPT					0x00000010
//#define PAN_ATTR_SUPERSCRIPT					0x00000020
#define PAN_SSATTR_FILL							0x00000040		// duplicates this run to fill a cell

// Support of default settings
#define PAN_SSDEFAULTROWCOL		-10

// Support of stretching and cropping for CCALLBACK GetBITMAPFromFile in support/bmpfill.cpp
#define PAN_BMPDESTPERCENT 0x0001
#define PAN_BMPSRCPERCENT  0x0002


/************************************************************************
** End DB/SS/AR-specific defines
************************************************************************/


/************************************************************************
** Begin document-specific defines
************************************************************************/

/***********************************************************************
** BEGIN Document Format Constants
************************************************************************/
/* text attributes */
#define PAN_ATTR_NORMAL 			0x00000000
#define PAN_ATTR_BOLD				0x00000001
#define PAN_ATTR_ITALIC 			0x00000002
#define PAN_ATTR_UNDERLINE			0x00000004
#define PAN_ATTR_STRIKEOUT			0x00000008
#define PAN_ATTR_SUBSCRIPT			0x00000010
#define PAN_ATTR_SUPERSCRIPT		0x00000020
#define PAN_ATTR_WORD_UNDERLINE 	0x00000040
#define PAN_ATTR_DOUBLE_UNDERLINE	0x00000080
#define PAN_ATTR_SMALL_CAPS 		0x00000100
#define PAN_ATTR_CAPS				0x00000200
#define PAN_ATTR_OUTLINE			0x00000400
#define PAN_ATTR_SHADOW 			0x00000800
#define PAN_ATTR_ALL_LOWERCASE		0x00001000
#define PAN_ATTR_INITIAL_CAPS		0x00002000
#define PAN_ATTR_DOT_UNDERLINE		0x00004000
#define PAN_ATTR_SERIFS 			0x00008000
#define PAN_ATTR_VARIABLE_PITCH 	0x00010000
#define	PAN_ATTR_NOADJUSTAVGWIDTH	0x00020000		// Do not adjust font avg width to equal height.		
#define PAN_ATTR_CHARHEIGHT		 	0x00040000		// Indicates that the height passed is
													// the character height and not the cell height.

#define PAN_ATTR_UNDERLINES 	(PAN_ATTR_UNDERLINE | \
								PAN_ATTR_WORD_UNDERLINE | \
								PAN_ATTR_DOUBLE_UNDERLINE | \
								PAN_ATTR_DOT_UNDERLINE)

#define	PAN_ATTR_CHARSETPITCHANDFAMILY 0x00080000	//Decoder specify character set and PitchAndFamily for TT Font
                                                    //params stored after font name and separated by "|"  i.e.
													// "fontname|c|b"

#define	PAN_ATTR_CONVERTBACKSLASHINTOYEN 0x00100000	//For "Convert backslash characters into yen signs" compatibility option support

//Next flags can be used only in PANX_TTextLF
#define PAN_ATTR_SETPITCHANDFAMILY	   0x00100000	//PitchAndFamily was set - don't guess about it
#define PAN_ATTR_SETCHARSET			   0x00200000	//CharSet was set - don't guess about it
#define PAN_ATTR_MIRRORX			   0x00400000	       
#define PAN_ATTR_MIRRORY			   0x00800000	
#define PAN_ATTR_STRINGWIDTH           0x01000000	//return string size without text drawing

#define PAN_ATTR_FIXED_PITCH		   0x02000000	// Indicates a fixed pitch font

#define PAN_ATTR_SHADING			   0x04000000	//Added to provide Text Shading and Text Highlighting support. Mar-27-2003,E.A.

#define PAN_ATTR_AUTORESOURCE		   0x08000000	// Automatic resource info generation (vector control)

#define PAN_ATTR_TEXTWRAPPINGBREAK     0x10000000	// Used to indicate that the character 0x0B is not a line break, but a text wrapping break

#define PAN_ATTR_LISTTEXT			   0x20000000	// used to indicate that the characters are bullets/autonumbering

/* tab stop types */
#define PAN_TAB_LDR_NO_LEADER		0
#define PAN_TAB_LDR_DOTTED			1
#define PAN_TAB_LDR_HYPHENATED		2
#define PAN_TAB_LDR_UNDERLINE		3
#define PAN_TAB_LDR_THICK_LINE		4
#define PAN_TAB_LDR_MIDDLE_DOT		5
#define PAN_TAB_LDR_EQUAL_SIGN		6

#define PAN_TAB_LEFT				1
#define PAN_TAB_RIGHT				2
#define PAN_TAB_CENTER				3
#define PAN_TAB_DECIMAL 			4
#define PAN_TAB_BAR 				5
#define PAN_TAB_DEFAULT				6
#define PAN_TAB_HANGINGINDENT		7
#define PAN_TAB_LEGACYINDENT		8
#define PAN_TAB_LEGACYSPACE			9

/* Table alignment values */

#define PAN_TBL_ALIGN_LEFT			0
#define PAN_TBL_ALIGN_RIGHT 		1
#define PAN_TBL_ALIGN_CENTER		2

/* Section break codes */

#define PAN_BRK_NONE				0
#define PAN_BRK_NEW_COLUMN			1
#define PAN_BRK_NEW_PAGE			2
#define PAN_BRK_EVEN_PAGE			3
#define PAN_BRK_ODD_PAGE			4

/* Constants used to describe border */
#define PAN_BRD_NO_BORDER		0
#define PAN_BRD_SINGLE_LINE 	1
#define PAN_BRD_THICK_LINE		2	// Cannot be defined as SINGLE + big width
#define PAN_BRD_DOUBLE_LINE 	3
#define PAN_BRD_DASH_LINE		4
#define PAN_BRD_DOTTED_LINE 	5
#define PAN_BRD_DASHDOT_LINE	6
#define PAN_BRD_HAIR_LINE		7	// Cannot be defined as SINGLE + zero width
// Specail to Word Borders
#define PAN_BRD_DOT_DOT_DASH_LINE					9
#define	PAN_BRD_TRIPLE_LINE							10
#define PAN_BRD_THIN_THICK_SMALL_GAP_LINE			11
#define	PAN_BRD_THICK_THIN_SMALL_GAP_LINE			12
#define PAN_BRD_THIN_THICK_THIN_SMALL_GAP_LINE		13
#define PAN_BRD_THIN_THICK_MEDIUM_GAP_LINE			14
#define PAN_BRD_THICK_THIN_MEDIUM_GAP_LINE			15
#define PAN_BRD_THIN_THICK_THIN_MEDIUM_GAP_LINE		16
#define	PAN_BRD_THIN_THICK_LARGE_GAP_LINE			17
#define	PAN_BRD_THICK_THIN_LARGE_GAP_LINE			18
#define	PAN_BRD_THIN_THICK_THIN_LARGE_GAP_LINE		19
#define	PAN_BRD_WAVE_LINE							20
#define	PAN_BRD_DOUBLE_WAVE_LINE					21
#define	PAN_BRD_DASH_SMALL_GAP_LINE					22
#define	PAN_BRD_DASH_DOT_STROKED_LINE				23
#define	PAN_BRD_EMBOSS_3D_LINE						24
#define	PAN_BRD_ENGRAVE_3D_LINE						25
#define	PAN_BRD_DARK_LIGHT_LINE						26
#define	PAN_BRD_LIGHT_DARK_LINE						27


/* Page Border Constants */
#define PAN_PAGEBORDER_FROMTEXT		0
#define PAN_PAGEBORDER_FROMPAGE		1

/* APO constants */
#define PAN_RELPOS_HORZ_COLUMN	0
#define PAN_RELPOS_HORZ_MARGIN	1
#define PAN_RELPOS_HORZ_PAGE	2
#define PAN_RELPOS_VERT_MARGIN	0
#define PAN_RELPOS_VERT_PAGE	1
#define PAN_RELPOS_VERT_PARA	2

#define PAN_RELPOS_LAYOUT_IN_CELL	4	// if set, the anchoring is relative to table cell

#define PAN_APOPOS_FORCE_ON_PAGE	1
#define PAN_APO_IS_FRAME			2
#define PAN_APO_IS_NESTED_TABLE		4
#define PAN_APO_RESET_POSITION		8

#define PAN_POS_CURRENT 		 -1
#define PAN_POSX_LEFT			  0
#define PAN_POSX_CENTER 		 -4
#define PAN_POSX_RIGHT			 -8
#define PAN_POSX_INSIDE 		-12
#define PAN_POSX_OUTSIDE		-16
#define PAN_POSY_UNCONSTRAINED	0
#define PAN_POSY_TOP			-4
#define PAN_POSY_CENTER 		-8
#define PAN_POSY_BOTTOM 		-12

#define PAN_WR_NOWRAP			1
#define PAN_WR_AROUND			2
#define PAN_WR_SIDEBYSIDE		3
#define PAN_WR_OVERLAP			4
#define	PAN_WR_LEFT				5
#define	PAN_WR_RIGHT			6
#define	PAN_WR_EITHER			7
#define	PAN_WR_WIDER			8

/*
** Table breaking flags:
*/
// How intersection with a rigid element should be handled.
#define	PAN_TABLEBREAK_OVERLAP		0x0000		// Default:  Just overlap.
#define	PAN_TABLEBREAK_SPLIT		0x0001 		// Split the table.
#define PAN_TABLEBREAK_EXPANDROW	0x0002		// Expand first row that intersects the rigid element.
// How to split table:  Sould not overlap above flags. 
#define PAN_TABLEBREAK_ROWBOUNDARY	0x0000		// Default:  Break at row boundary.
#define PAN_TABLEBREAK_KEEPTOGETHER	0x0004		// Table should not be split.
#define	PAN_TABLEMERG_EQUELROWS		0x0008		// Vertical merged rows expanding
												//if set on use WP style otherwise
												//WW97 style

#define PAN_TR_OPAQUE			0
#define PAN_TR_TRANSPARENT		1
#define PAN_TR_UNDERLIE 		2

/* Cell contents flags */
#define PAN_TBL_CELL_TEXT		0
#define PAN_TBL_CELL_IMAGE		1

/* Shading patterns */
// 'F' means forward,  or a diagonal from bottom left to top right
// 'B' means backward, or a diagonal from top left to bottom right
// 'DK' means dark
#define PAN_PAT_NUMERICAL		 0
#define PAN_PAT_HORIZ			 1
#define PAN_PAT_VERT			 2
#define PAN_PAT_FDIAG			 3
#define PAN_PAT_BDIAG			 4
#define PAN_PAT_CROSS			 5
#define PAN_PAT_DCROSS			 6
#define PAN_PAT_DKHORIZ 		 7
#define PAN_PAT_DKVERT			 8
#define PAN_PAT_DKFDIAG 		 9
#define PAN_PAT_DKBDIAG 		10
#define PAN_PAT_DKCROSS 		11
#define PAN_PAT_DKDCROSS		12
#define PAN_PAT_5PERCENT		13
#define PAN_PAT_10PERCENT		14
#define PAN_PAT_20PERCENT		15
#define PAN_PAT_25PERCENT		16
#define PAN_PAT_30PERCENT		17
#define PAN_PAT_35PERCENT		18
#define PAN_PAT_40PERCENT		19
#define PAN_PAT_50PERCENT		20
#define PAN_PAT_60PERCENT		21
#define PAN_PAT_70PERCENT		22
#define PAN_PAT_75PERCENT		23
#define PAN_PAT_80PERCENT		24
#define PAN_PAT_85PERCENT		25
#define PAN_PAT_90PERCENT		26
#define PAN_PAT_FORMFIELD		27

/* embedded text codes */
#define	PAN_CHAR_FLUSH_RIGHT		0x03
#define PAN_CHAR_BACK_TAB			0x08
#define PAN_CHAR_TAB				0x09
#define PAN_CHAR_END_OF_PAR 		0x0A
#define PAN_CHAR_FORCED_LINE_BREAK	0x0B
#define PAN_CHAR_END_OF_PAGE		0x0C
#define PAN_CHAR_COLUMN_BREAK		0x0E
#define PAN_CHAR_SECTION_MARK		0x0F
#define PAN_CHAR_HYPHEN_USER		0x1E
#define PAN_CHAR_HYPHEN_KEYBOARD	0x1F

/* special characters */
#define	PAN_SCHAR_SOFT_COLUMN_BREAK	0x01
#define	PAN_SCHAR_SOFT_PAGE_BREAK	0x02
#define	PAN_SCHAR_SECTION_BREAK		0x03
#define	PAN_SCHAR_PAGE_ESC			0x04

/* paragraph alignment */
#define PAN_ALIGN_LEFT			0x0000
#define PAN_ALIGN_RIGHT 		0x0001
#define PAN_ALIGN_CENTER		0x0002
#define PAN_ALIGN_JUSTIFY		0x0003
#define PAN_ALIGN_DISTRIBUTED	0x0100

// RR: 10/14/94 (used with spreadsheet cells)
#define PAN_ALIGN_TOP				0x08
#define PAN_ALIGN_BOTTOM			0x04
#define PAN_ALIGN_VCENTER			0x10
#define PAN_ALIGN_WRAP				0x20	// wrap cell contents
#define PAN_ALIGN_VJUSTIFY			0x40	// [AB] March 11, 2002 
#define PAN_ALIGN_TOPTOBOTTOM		0x80	// RUM: Excel, top to bottom text

#define PAN_ALIGN_HORZ_MASK		0x03
#define	PAN_ALIGN_VERT_MASK		0x5C



// Used in Pan_Column member wFlags
#define PAN_DEFAULT_XLS_COLWIDTH		0x0001		// [AB] Excel default column width


/* misc... */
#define PAN_ABS_SPACING_BIT 			0x8000	// At least line spacing in twips.	
#define PAN_EXACT_SPACING_BIT			0x4000	// Exactly line spacing in twips.

/* Predefined border length types */
#define PAN_BL_MARGINS			1
#define PAN_BL_TEXT 			2
#define PAN_BL_CUSTOM			3

/* Shadow existence and/or direction */
#define PAN_SHADOW_NONE 		 0
#define PAN_SHADOW_ALL			 1
#define PAN_SHADOW_LEFT 		 2
#define PAN_SHADOW_ABOVE		 3
#define PAN_SHADOW_RIGHT		 4
#define PAN_SHADOW_BELOW		 5
#define PAN_SHADOW_LA			 6
#define PAN_SHADOW_LR			 7
#define PAN_SHADOW_LB			 8
#define PAN_SHADOW_AR			 9
#define PAN_SHADOW_AB			10
#define PAN_SHADOW_RB			11
#define PAN_SHADOW_LAR			12
#define PAN_SHADOW_LAB			13
#define PAN_SHADOW_LRB			14
#define PAN_SHADOW_ARB			15

/* The start page to which the header and footer will be applied */
#define	PAN_CURRENT_PAGE		0
#define	PAN_FIRST_PAGE			-1
#define	PAN_NEXT_PAGE			-2
#define	PAN_LAST_PAGE			-3

/* Doc image flags */
#define	PAN_IMAGEFLAGS_NOCOPYFILE		0x00000001L		// Do not create a local copy of the image file.
#define	PAN_IMAGEFLAGS_DELETEFILE		0x00000002L		// Delete the image file when no longer needed.
														// E.g. Used when image is stored in a tmp file.				
#define PAN_IMAGEFLAGS_FLIPX			0x00000004L
#define PAN_IMAGEFLAGS_FLIPY			0x00000008L
#define PAN_IMAGEFLAGS_FLIPXY			0x00000010L
#define PAN_IMAGEFLAGS_ROTATE90			0x00000020L
#define PAN_IMAGEFLAGS_ROTATE180		0x00000040L
#define PAN_IMAGEFLAGS_ROTATE270		0x00000080L
#define	PAN_IMAGEFLAGS_BEHINDTEXT		0x00000100L
#define	PAN_IMAGEFLAGS_CALCDESTINATION	0x00000200L		// Destination rectangle is unknown, use the source extents

#define PAN_FONTFLAGS_SCALEWIDTH		0x00010000L
/***********************************************************************
** END Document Format Constants
************************************************************************/

/*
** Element type
*/
typedef enum {
	PAN_DOC_ETYPE_TEXT = 1,
	PAN_DOC_ETYPE_FRAME,
	PAN_DOC_ETYPE_TABLE,
	PAN_DOC_ETYPE_GRAPHIC,
	PAN_DOC_ETYPE_UNKNOWN
} PAN_DocElemType ;

/*
** Flow identifier
*/
typedef enum {
	PAN_DOC_FLOW_MAIN		= 1,
	PAN_DOC_FLOW_HEADALL ,
	PAN_DOC_FLOW_HEADEVEN,
	PAN_DOC_FLOW_HEADODD,
	PAN_DOC_FLOW_HEADFIRST,
	PAN_DOC_FLOW_FOOTALL,
	PAN_DOC_FLOW_FOOTEVEN,
	PAN_DOC_FLOW_FOOTODD,
	PAN_DOC_FLOW_FOOTFIRST,
	PAN_DOC_FLOW_PAGENUM,
	PAN_DOC_FLOW_USER		= 128
} FlowID;


#define	PAN_ZORDER_BELOWTEXT	0x00001000
#define	PAN_ZORDER_TEXTLEVEL	0x00002000
#define	PAN_ZORDER_ABOVETEXT	0x00004000

// Used with the the document control callback PANX_SetDocProps
#define PAN_DOC_PROP_DEFAULTPARAGRAPH	0x0001
#define PAN_DOC_PROP_RESETPARAGRAPH		0x0002
#define PAN_DOC_PROP_SHOWTABLEGRID		0x0003
#define PAN_DOC_PROP_BOOKMARK			0x0004

/*
** Structure used to describe Overlay/OLE objects
*/
#define OVERLAY_OBJECT			-1
#define OLE_OBJECT_STATIC		 0
#define OLE_OBJECT_LINKED		 1
#define OLE_OBJECT_EMBEDDED 	 2

#define OBJECTFLAG_EXTRACT			0x0001
#define OBJECTFLAG_DELETE			0x0002
#define OBJECTFLAG_TRANSPARENT		0x0004
#define OBJECTFLAG_INSERTIONPOINT	0x0008
#define OBJECTFLAG_NOVIEWPORTS		0x0010
#define OBJECTFLAG_NOPALETTE		0x0020
#define OBJECTFLAG_ISOTROPIC		0x0040
#define OBJECTFLAG_FORCETOTRANSFORM	0x0080
#define OBJECTFLAG_CROPPED          0x0100
#define OBJECTFLAG_AUTOMATICEXTENTS 0x0200
#define OBJECTFLAG_CONVERTWMFTOEMF	0x0400


#define	FLAG_HEADER_ROW		0x80	// Flag saying that the first TAble row is a header
#define	FLAG_ROW_NOSPLIT	0x40	// Flag saying that the row can't be split across pages

/*
** Document Table Cell.
*/

#define PAN_CELL_FIRSTMERGED			0x00000001
#define PAN_CELL_MERGED 				0x00000002
#define PAN_CELL_VERTFIRSTMERGED 		0x00000004
#define PAN_CELL_VERTMERGED		 		0x00000008
#define PAN_CELL_CENTERTEXT             0x00000010
#define PAN_CELL_BOTTOMTEXT             0x00000020

// Flags for vertical text support in table cells, text boxes (eschers) and frames in documents
// Values of these flags are chosen in such a way that they can be combined with PAN_APO_... and PAN_CELL_... flags
#define PAN_HORZTEXT_NONATFONT				0x00000000
#define PAN_VERTTEXT_TOPTOBOTTOM_NONATFONT	0x00000040
#define PAN_VERTTEXT_BOTTOMTOTOP_NONATFONT	0x00000080
#define PAN_VERTTEXT_TOPTOBOTTOM_ROTATEFONT	0x00000100
#define PAN_HORZTEXT_ROTATEFONT				0x00000200

/************************************************************************
** End document-specific defines
************************************************************************/

////////////////////////////////////////////////////////////////////////////////////
//	Some definitions for the drawing objects
////////////////////////////////////////////////////////////////////////////////////

/* Constants to handle special color settings */

/**
 * No color (transparent)
 */
#define COLOR_NONE				(COLORREF)-1
/**
 * Background color
 * @note Will not be overriden for entity highlight
 */
#define COLOR_USE_BACKGROUND	(COLORREF)-2
/**
 * White color
 * @note Will remain white even if background is white
 */
#define COLOR_ALTERNATE_WHITE	(COLORREF)-3
/**
 * Black color
 * @note Will remain black even if background is black
 */
#define COLOR_ALTERNATE_BLACK	(COLORREF)-4
/**
 * Color by layer
 * @note A variable color that will match the current layer's color
 */
#define COLOR_BY_LAYER			(COLORREF)-5
/**
 * Color by block
 * @note A variable color that will match inserted block color
 * @note The inserted block color must be set in PANX_InsertBlock with
 *		1- A 'VCET_ATTRIB_COLOUR' attribute or
 *		2- A 'VCET_MODIFIER_COLOR' attribute that
 *		   replaces 'COLOR_BY_BLOCK' by another color
 */
#define COLOR_BY_BLOCK			(COLORREF)-6
 /**
 * Current Settings
 * @note Use the current state settings
 */
#define COLOR_CURRENT			(COLORREF)-7
/**
 * Lowest special color index.
 * @note Not a real color. Don't use it.
 */
#define COLOR_SPECIAL_MIN		(COLORREF)-8

/**
 * This color (almost black) chosen as Automatic color in order to
 * distinguish it from Black color in VCET Controls. Oct-16-2003,E.A.
 */
#define COLOR_AUTOMATIC			RGB(1, 1, 1)


/* Constants to handle layers */
#define LAYER_NONE              (int)-1

/* Constants to describe a linestyle */
#define	PAN_LINESTYLE_SOLID			0
#define	PAN_LINESTYLE_DASHED		1
#define	PAN_LINESTYLE_DOTTED		2
#define	PAN_LINESTYLE_DASHDOT		3
#define	PAN_LINESTYLE_DASHDOTDOT	4
#define	PAN_LINESTYLE_HOLLOW		5

// Drawing object types.
typedef enum {
	PAN_DO_LINE = 1,
	PAN_DO_RECTANGLE,
	PAN_DO_ARC,
	PAN_DO_ELLIPSE,
	PAN_DO_POLYLINE,
	PAN_DO_TEXTBOX,
	PAN_DO_POLYPOLYGON
} PAN_DrawingObjType ;


#define	PAN_FILE_ERROR	-1L	// panfile uses -1 as error code


////////////////////////////////////////////////////////////////////////////////////
// End of the definitions for the drawing objects
////////////////////////////////////////////////////////////////////////////////////

#endif	/* AVDEFS_H */
