/* avlink.h */

#ifndef avlink_h
#define avlink_h

#include "pan.h"

// Under WIN16 PCALLBACK is defined to be:
//		_far _pascal __export _loadds
// Under WIN32 PCALLBACK is defined to be:
//		CALLBACK
#ifndef	PCALLBACK
# ifdef	_WIN32
#  define	PCALLBACK_DEFINED
#  define	PCALLBACK	CALLBACK
# else
#  define	PCALLBACK_DEFINED
#  define	PCALLBACK	_far _pascal __export _loadds
# endif
#endif

#ifdef __cplusplus
extern "C" {
#endif 

extern BOOL PCALLBACK AVLINK_Start(LPRECT rcPos);
extern BOOL PCALLBACK AVLINK_End(void);
extern BOOL PCALLBACK AVLINK_TransmitCommand(LPCSTR szCommand);
extern BOOL PCALLBACK AVLINK_Activate(int nChild);
extern BOOL PCALLBACK AVLINK_Compare(LPCSTR szFileName);
extern BOOL PCALLBACK AVLINK_Markup(LPCSTR szMarkupID);
extern BOOL PCALLBACK AVLINK_Overlay(LPCSTR szFileName);
extern BOOL PCALLBACK AVLINK_Properties(void);
extern BOOL PCALLBACK AVLINK_ShowWindow(int nCmdShow);
extern BOOL PCALLBACK AVLINK_ShowViewWindow(int nCmdShow);
extern BOOL PCALLBACK AVLINK_View(LPCSTR szFileName);

#ifdef __cplusplus
}
#endif

#ifdef	PCALLBACK_DEFINED
#undef	PCALLBACK
#undef	PCALLBACK_DEFINED
#endif

#endif /* ndef avlink_h */
