#ifndef	AVMSG_H
#define	AVMSG_H

/*
**  AutoVue messages
*/

// wParam flags
#define	AVMSG_NOCURSOR					0x8000	// cursor will not be set
#define	AVMSG_CLOSED					0x4000

// Select a point
//	wParam: if AVMSG_NOCURSOR bit is set, cursor will not be set
//	lParam: (LPPOINT) lpPoint
#define	AVM_GETPOINT					WM_USER + 0x300 + 2

// Select a rectangle in AutoVue
//	wParam: 0: Rectangle rubberband
//			1: Line rubberband
//			if AVMSG_NOCURSOR bit is set, cursor will not be set
//	lParam: (LPRECT) lpRect
#define	AVM_GETRECT						WM_USER + 0x300 + 3

// Select a rectangle in AutoVue
//	wParam: MaxPoints
//			if AVMSG_NOCURSOR bit is set, cursor will not be set
//			if AVMSG_CLOSE bit is set, polygon will be shown closed
//	lParam: (LPPOINT) lpPoint
#define	AVM_GETPOINTS					WM_USER + 0x300 + 4

// Display a file in AutoVue
//	wParam: 0 = Use current window,  1 = show in new window
//	lParam: (LPCSTR) fileName
#define	AVM_SETFILE						WM_USER + 0x300 + 5

// Display a file in AutoVue
//	wParam: 0 = Get AVWIN.INI,  1 = Get AVWINREG.INI
//	lParam: (LPSTR) Autovue's INI fileName
#define	AVM_GETINIFILE					WM_USER + 0x300 + 6

// Queue a script command in AutoVue
//	wParam:  0 (Default) Add to the tail
//			 1 Add to the head
//	lParam: (LPSTR) Script command to queue
#define	AVM_SCRIPTCOMMAND				WM_USER + 0x300 + 7

// Show a help string
//	wParam: One of AVHELP_xxx
//	lParam: (LPCSTR) message
#define	AVM_SETHELPSTRING				WM_USER + 0x300 + 8

// Returns the current help string
//	wParam: Length of the buffer provided by caller
//  lParam: (LPSTR) lpszHelpString
#define AVM_GETHELPSTRING				WM_USER + 0x300 + 9

// Selfposted hyperlink firing message for secure markup control termination
//  wParam: currently unused
//  lParam: (LPCSTR)filename
#define AVM_FIREHYPERLINK				WM_USER + 0x300 + 10

// Selfposted base file link firing message
//  wParam: currently unused
//  lParam: a pointer to CPanLink
#define AVM_FIREFILELINK				WM_USER + 0x300 + 11

// Go to the previous page: Used for switching page through scrolling.
// Keep msg ID 1 less than that of AVM_VSCROLLPAGENEXT.  Message range
// for PeekMessage in the code relies on it.
//  wParam: currently unused
//  lParam: currently unused 
#define AVM_VSCROLLPAGEPREV				WM_USER + 0x300 + 12

// Go to the next page:  Used for switching page through scrolling.
//  wParam: currently unused
//  lParam: currently unused 
#define AVM_VSCROLLPAGENEXT				WM_USER + 0x300 + 13

// Get Command Line Parameter in AutoVue
//  wParam: currently unused
//  lParam: (LPCSTR)cmdline 
#define AVM_GETCMDLINE					WM_USER + 0x300 + 14

// Get Property.
//  wParam: buffer size
//  lParam: (LPSTR)property name on input and returns the property value.  
#define AVM_GETPROPERTY					WM_USER + 0x300 + 15


/*
** 3D related messages
*/

#define WM_EXIT3DTOOLDLG				WM_USER + 0x300 + 100

#define WM_EXITLIGHTDLG					WM_USER + 0x300 + 101

#define WM_EXITTRANPDLG					WM_USER + 0x300 + 102

#define WM_EXIT3DRECENTERDLG			WM_USER + 0x300 + 103

#define AVM_DESTROYMASSPROPDLG			WM_USER + 0x300 + 104

#define AVM_DESTROY3DMEASUREDLG		    WM_USER + 0x300 + 105

#define AVM_DESTROY3DSECTDLG			WM_USER + 0x300 + 106

#define AVM_DESTROY3DHEALINGDLG			WM_USER + 0x300 + 107

#define AVM_DESTROY3DUCSDLG				WM_USER + 0x300 + 108

#define AVM_DESTROY3DPARTALIGNDLG		WM_USER + 0x300 + 109

#define AVM_DESTROY3DCLEARANCEDLG		WM_USER + 0x300 + 110

#define AVM_DESTROY3DEXPLODEDLG			WM_USER + 0x300 + 111

#define AVM_DESTROY3DBOMDLG				WM_USER + 0x300 + 112

#define AVM_DESTROY3DENTITYPROPDLG		WM_USER + 0x300 + 113

#define AVM_DESTROY3DNODECOMDLG			WM_USER + 0x300 + 114	// 3D Compare dlg

#define AVM_DESTROY3DSEARCHDLG			WM_USER + 0x300 + 115


/*
** 2D / EDA related messages
*/

#define AVM_DESTROYECADSEARCHDLG		WM_USER + 0x300 + 300

#define AVM_DESTROYECADLAYERDLG			WM_USER + 0x300 + 301

#define	AVM_DESTROYECADENTITYSVDLG		WM_USER + 0x300 + 302

#define AVM_DESTROYECAD2DMEASUREDLG		WM_USER + 0x300 + 303

#define AVM_DESTROYECAD2DBOMDLG			WM_USER + 0x300 + 304

#define AVM_DESTROYECADENTITYPROPDLG	WM_USER + 0x300 + 305

#define AVM_DESTROYECADDRCREPORTDLG		WM_USER + 0x300 + 306

// Cross Probe Event Notify.
//  wParam: 0 (not used)
//  lParam: pointer to CCrossProbeSignal object
#define AVM_CROSSPROBE_NOTIFY			WM_USER + 0x300 + 307


/*
** Measurement / snapping messages
*/

// Notify a snap is done
//  lParam: pointer to CSnap derived object
#define AVM_SNAPDONE					WM_USER + 0x300 + 500

// Returns the 2D snapping info
//  wParam: 0 - Remove
//          1 - Add snappped entity or geometry
//  lParam: pointer to C2DSnap derived object
#define AVM_2DSNAPDONE					WM_USER + 0x300 + 501

// Returns the 3d measurements info
//  wParam: See below
//  lParam: One of the Measurements info structures 
#define AVM_MEASUREMENTDONE				WM_USER + 0x300 + 502

// lParam for AVM_MEASUREMENTDONE
#define AVM_DISTANCEINFO				0
#define AVM_ARCINFO						1
#define AVM_ANGLEINFO					2
#define AVM_VERTEXINFO					3

#define AVM_ECAD_DISTANCEINFO			4
#define AVM_ECAD_CUMDISTANCEINFO		5
#define AVM_ECAD_AREAINFO				6

// Notify application if a hyperlink is snapped
//  wParam: 0 - hyperlink is not snapped
//          1 - hyperlink is snapped
//  lParam: not used
#define AVM_2DHYPERLINKSNAP				WM_USER + 0x300 + 503


/*
** Messages send to AutoVueX
*/

// AvMarkupX notify AutoVueX
#define AVM_MARKUPNOTIFY				WM_USER + 0x300 + 1200

// wParam for AVM_MARKUPNOTIFY
#define AVM_RECENTERMODEL					0
#define AVM_EXITMEASUREMENT					1
#define AVM_3DMEASUREMENTVERTEXCOORDINATE	2
#define AVM_3DMEASUREMENTDISTANCE			3
#define AVM_3DMEASUREMENTANGLE				4
#define AVM_3DMEASUREMENTARC				5
#define AVM_GETPROPERCURSOR					6
#define AVM_GETTREE							7
#define AVM_MEASURECUMDISTANCERESET			8
#define AVM_MEASUREAREARESET				9
#define AVM_EXIT2DMEASUREMENT				10
#define AVM_UPDATEUSERDATAUI				11
#define AVM_APPLYVIEWSTATE					12
#define AVM_SETLASTVIEWSTATE				13
#define AVM_CREATEVIEWSTATE					14
#define AVM_PROCESSIMPORTEDDESIGNS			15
#define AVM_RESETLASTVIEWSTATE				16

// Return the IPanView interface pointer
//  wParam: not used
//  lParam: pointer to IPanView
#define AVM_GETIPANVIEW					WM_USER + 0x300 + 1201

// Return the user data manager
//  wParam: not used
//  lParam: pointer to CUserDataMngr
#define AVM_GETUSERDATAMNGR				WM_USER + 0x300 + 1202

#define AVM_PRPPEV_IS_3D_VIEW			WM_USER + 0x300 + 1203

#define AVM_PRPPEV_GET_DEF_UNITS		WM_USER + 0x300 + 1204

#define AVM_PP_GET_TRUE_EXTENTS			WM_USER + 0x300 + 1205

#define AVM_PP_COMPUTE_3DCLIPBOX_EXT	WM_USER + 0x300 + 1206

#define AVM_PP_COMPUTE_3DCLIPBOX_DIS	WM_USER + 0x300 + 1207

#define AVM_PP_COMPUTE_3DCLIPBOX_SEL	WM_USER + 0x300 + 1208

#define AVM_PP_COMPUTE_3DCLIPBOX_ENT	WM_USER + 0x300 + 1209

#define AVM_PP_SET_PRINT_SELECT_MODE	WM_USER + 0x300 + 1210

#define AVM_PP_GET_PRINT_SELECT_MODE	WM_USER + 0x300 + 1211

#define AVM_RENDER_OVERLAYS				WM_USER + 0x300 + 1212


/*
** Messages send to AvMarkupX
*/

#define AVM_MRKTREENOTIFICATION			WM_USER + 0x300 + 1400

// wParam for AVM_MRKTREENOTIFICATION
#define AVM_POPULATEMRKTREE				0
#define AVM_UPDATEMRKENTSELECTION		1

#define AVM_SETPAGEINFO					WM_USER + 0x300 + 1401

#define AVM_ONUPDATE_GEOMETRYLINESTYLE	WM_USER + 0x300 + 1402

#define AVM_SETVIEWMODESEL				WM_USER + 0x300 + 1403

#define AVM_GETMRKUSERDATAMNGR			WM_USER + 0x300 + 1404

#define AVM_ONCLOSE3DUCSDLG				WM_USER + 0x300 + 1405

#define AVM_MARKUPSTARTNEWENTITY		WM_USER + 0x300 + 1406


/*
**  Notification messages for DLL Level 2
*/

#define	ANM_FILEREAD					WM_USER + 200
#define	ANM_FILEWRITE					WM_USER + 201

// wParam
#define ANM_FILEREAD_BASE				0
#define ANM_FILEREAD_REDLINE			1
#define ANM_FILEREAD_OVERLAY			2

#define ANM_ANALYSISRESULTS				WM_USER + 202

// wParam
#define ANM_ANALYSISRESULTS_3DEDGELENGTH	0
#define ANM_ANALYSISRESULTS_3DSURFACEAREA	1
#define ANM_ANALYSISRESULTS_3DMASSPROP		2

#endif	/* AVMSG_H */

