// -*-C++-*-
#ifndef _MRKPUCTL_
#define _MRKPUCTL_

#include "pan.h"
#ifdef CSI_UNIX
#include <mmsystem.h>  /*For HP{C}STR definitions*/
#endif

#pragma	pack(8)

#include "mfont.hpp"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define		WM_MRK_BASE		(WM_USER + 0x1000)
#define		WM_MRKN_BASE	(WM_USER + 0x1400)

typedef	LONG	MRKENTHANDLE;
typedef	LPLONG	LPMRKENTHANDLE;

#ifndef CSI_UNIX
typedef char _huge *            HPSTR;
typedef const char _huge *      HPCSTR;
#endif

// Default arc line style unit geometry characteristics
#define MRK_ARC_XRADIUS		/*16*/6			// X radius of arc in pixels 
#define MRK_ARC_RATIO		/*0.6*/1.0		// X radius and Y radius ratio used to define the arc 
// Default triangle line style unit geometry characteristics
#define MRK_TRIANGLE_BOTTOM_EDGE		/*32*/	12	// Bottom edge length of triangle in pixels 
#define MRK_TRIANGLE_HEIGHT				/*20*/	6	// Height of the triangle in pixels 

static const double MRK_DEFAULT_ARROW_SIZE = -7.2;  // Default arrow size


// Command Messages:
enum {
	MRK_NULL = WM_MRK_BASE,
	MRK_ADDENTITY,
	MRK_CLEARSEL,
	MRK_CLIENTTOWORLD,
	MRK_COPYLAYER,
	MRK_DELETELAYER,
	MRK_DELETE,
	MRK_EDITENTITY,
	MRK_GET_EPROP,
	MRK_GET_MOPROP,
	MRK_GETACTION,
	MRK_GETACTIVE,
	MRK_GETBASEEXTENTS,
	MRK_GETENTITY,
	MRK_GETENTITIES,
	MRK_GETFGBGCOLOR,
	MRK_GETLAYERS,
	MRK_GETNUMMARKUPS,
	MRK_GETNUMPAGES,
	MRK_GETPAGE,
	MRK_GETPAGESIZE,
	MRK_GETPALETTE,
	MRK_GETUDEINFO,
	MRK_GETVIEWEXTENTS,
	MRK_ENUMENTITIES,
	MRK_ISMRKFILE,
	MRK_LOCKENTITY,
	MRK_NEW,
	MRK_QUIT,
	MRK_READ,
	MRK_REDO,
	MRK_REDDELALL,
	MRK_RENDERONTODC,
	MRK_SAVE,
	MRK_SET_EPROP,
	MRK_SET_MOPROP,
	MRK_SETACTION,
	MRK_SETACTIVE,
	MRK_SETBASEEXTENTS,
	MRK_SETENTITY,
	MRK_SETFGBGCOLOR,
	MRK_SETLAYERS,
	MRK_SETPAGE,
	MRK_SETPALETTE,
	MRK_SETSEL,
	MRK_ADDSEL,
	MRK_REMOVESEL,
	MRK_SETVIEWEXTENTS,
	MRK_UNDO,
	MRK_UNLOCKENTITY,
	MRK_WORLDTOCLIENT,
	MRK_TRANSFORMRECT,	// Not implemented
	MRK_GETROTATE,
	MRK_SETROTATE,
	MRK_GETFLIP,
	MRK_SETFLIP,
	MRK_NOTEBATCHPRINT,
	MRK_NOTEPREPAREPRINT,
	MRK_NOTERENDERPAGE,
	MRK_NOTEENDPRINT,
	MRK_COPYCLPBRD,
	MRK_PASTECLPBRD,

	// 3-D markup messages
	MRK_SETMODELVIEWTRANSFORM,
	MRK_GETMODELVIEWTRANSFORM,
	MRK_LEFTMOUSEDOWN,
	MRK_RIGHTMOUSEUP,
	MRK_GETENTITYEXTRADATA,
	MRK_GROUP,
	MRK_UNGROUP,

	//Message specially for note entity
	MRK_GETNOTECOUNT,
	MRK_SETNOTECOUNT,
	MRK_INCNOTECOUNT,
	MRK_GETNOTENAMEAUTOGEN,

	//Misccelleous

 	MRK_LAST
};

// Notification Messages:
enum {
	MRKN_NULL = WM_MRKN_BASE,
	MRKN_CANCEL,
	MRKN_EDIT,
	MRKN_FIRELINK,
	MRKN_ENTITYADDED,
	MRKN_SELCHANGED,
	MRKN_MODIFIED,
	MRKN_CURSOR,
	MRKN_GETPROPERTY,

	// 3-D Messages
	MRKN_CLIENTTOWORLD,
	MRKN_SNAP,
	MRKN_SNAPSUPPORT,
	MRKN_SNAPCHANGED,

	MRKN_COPYLAYER,
	MRKN_GETMRKPNAME,
	MRKN_TEXTEDITDONE,
	MRKN_LAST
};

// Markup Action Codes: used by MRK_SETACTION and MRK_GETACTION messages
enum {
	MRKP_ACTION_NONE,
	MRKP_ACTION_ADD,
	MRKP_ACTION_DEL,
	MRKP_ACTION_COPY,
	MRKP_ACTION_EDIT,
	MRKP_ACTION_MOVE,
	MRKP_ACTION_SEL,
	MRKP_ACTION_HYBRID
};

// Built-in types:
enum {
	ENTTYPE_NULL = 0x0000,
	ENTTYPE_LINE = 0x0002,
	ENTTYPE_TEXT,
	ENTTYPE_SOLID,
	ENTTYPE_CIRCLE,
	ENTTYPE_ARC,
	ENTTYPE_RECT,
	ENTTYPE_FSTYLE,
	ENTTYPE_NOTE,
	ENTTYPE_LINK,
	ENTTYPE_POLY,
	
	// 3D markup entities
	ENTTYPE_VERTEXDIM,
	ENTTYPE_LINEARDIM,
	ENTTYPE_ARCDIM,
	ENTTYPE_ANGULARDIM,

	// Here is the Basis for UDEs
	ENTTYPE_UDE_BASE = 0x0019
};

// 3d Leader sub types
enum {
	ENTITY_UDE_3DLEADER_TEXT,
	ENTITY_UDE_3DLEADER_NOTE,
	ENTITY_UDE_3DLEADER_VERTEX
};


// arc ude sub types
enum {
	ENTITY_UDE_ARC_RADIUS,
	ENTITY_UDE_ARC_DIAMETER,
	ENTITY_UDE_ARC_AREA
};


// Property values used by MRK_SET_EPROP and MRK_GET_EPROP messages
enum {
	ME_NULL = 0,
	ME_FONT,
	ME_FILLTYPE,
	ME_COLOR,
	ME_FILLCOLOR,
	ME_LAYER,
	ME_PENSTYLE,
	ME_PENWIDTH,
	ME_LINEARROWEND,
	ME_LINEARROWSTART,

	// 3-D property
	ME_SNAPTO,

	ME_PENSTYLE_INFO, // Extra info for cloud/triangle line style if applicable

	ME_USERDATASET,	// User data set

	ME_TEXTBOXVISIBLE,	// TextBox visibility
	ME_LEADERALIGN,		// 2D Leader alignment

	ME_LAST
};

// Value related to the ME_SNAPTO property

#define	MRK_SNAPTO_NONE			0x00000001		// Floating (Default)
#define	MRK_SNAPTO_VERTEX		0x00000002		// Snap to Vertex
#define	MRK_SNAPTO_EDGE			0x00000004		// Snap to Edge
#define	MRK_SNAPTO_MIDEDGE		0x00000008		// Snap to Mid-Edge
#define	MRK_SNAPTO_ARCCENTER	0x00000010		// Snap to Arc-Center
#define	MRK_SNAPTO_FACE			0x00000020		// Snap to Face
#define MRK_SNAPTO_ALL			MRK_SNAPTO_NONE|MRK_SNAPTO_VERTEX|\
								MRK_SNAPTO_EDGE|MRK_SNAPTO_MIDEDGE|\
								MRK_SNAPTO_ARCCENTER|MRK_SNAPTO_FACE
	
#define MRK_ENDTEXTBOX          0x8000  //Indicate end text box editing

// Property values used by MRK_SET_MOPROP and MRK_GET_MOPROP messages
enum {
	MO_NULL = 0,
	MO_INS,
	MO_INFO,
	MO_CURSOR,
	MO_VISIBLE,
	MO_READONLY,
	MO_ISMODIFIED,
	MO_SCALECALIBRATION,
	MO_TRUECOLOR,			// By default, entities that have the same
							// color as the background are drawn using
							// an alternate color to make them visible.
							// Set this property to disable this behaviour.
	MO_BASEWINDOW,
	MO_TRUEBACKGROUND,// Set to FALSE if base drawing background color is
							// the not the same as the control's bg color
							// (e.g. for color raster files).  Affects the
							// way transparent filling is handled.  This
							// property is set to TRUE by default.
	MO_USEUSERFONT,	// Set TRUE if the application want markup control to use the font 
							// specified in ini file instead of the font read from red line file
	MO_VIEWMODESEL,	// Set TRUE if the view mode drawing entity selection mode is active (e.g in minimum
							// distance measurement mode). In this case, the view mode selection 
							// take precedence when there is mouse message conflict bewteen
							// drawing entity selection and markup entity selection
	MO_PRESERVECHILDSIZEWHENEDITED, // A flag to control whether child entity will be resized or not when the parent is resized
	MO_APP_PROFILE_FILENAME,		// Full path to application INI filename (e.g. c:\winnt\avwin.ini)
	MO_ARROW_SIZE,			// markup arrow size. It's either in pixels or in inches, depending whether it is zoomable or not
	MO_LINETHICHNESS_ZOOMABLE, // Set TRUE if the line thickness is zoomable, e.g line thickness dependent on zoom level
	MO_LINESTYLE_ZOOMABLE,		// Set TRUE if the line style is zoomable, e.g the size of each unit line pattern changed when zoom level
								// changed, as a result, the number of unit pattern will not change when zoom level changed
	MO_NOTENAME_AUTOGEN,
	MO_ENTITY_ROTATE_MODE, // Set TRUE to put markup control in entity rotation mode. In this mode, if selected entity support rotation (e.g. text box), dragging edit handle will cause it being rotated instead of being distorted
	MO_APP_IPANDMS,			// Pointer to IPanDMS interface
	MO_LAST
};

// Mouse notifications:  Passed to UDE MouseProc() function.
enum {
	MRK_LBUTTONDOWN = 0,
	MRK_LBUTTONUP,
	MRK_LBUTTONDBLCLK,
	MRK_RBUTTONDOWN,
	MRK_RBUTTONUP,
	MRK_MOUSEMOVE,
};

// Property values used by the MRK_FLIP Message (lParam)
enum {
	FLIP_NULL = 0,
	FLIP_X,
	FLIP_Y,
	FLIP_XY
};

// Property values used by the MRK_TRANSFORMRECT Message (wParam)
enum {
	TRANSFORM_DIRECT = 0,
	TRANSFORM_RECIPROCAL
};

// Different Link Types - Specific to the Link Entity
enum {
	MLINK_TO_DDE = 0,
	MLINK_TO_DLL,
	MLINK_TO_APP,
	MLINK_TO_FILE,
	MLINK_TO_SCRIPT,
	MLINK_EMBED_FILE
};

// Flags for MRK_LinkInfo.dwFlags (must be sinchronized with jVue)
enum {
	MLINK_FLAG_HIDE_ICON			= 0x01,
	MLINK_FLAG_OPEN_WITH_AUTOVUE	= 0x02
};

enum MRKALIGN	{
	MRK_ALIGN_UNDEFINED = -1,
	MRK_ALIGN_TOPLEFT = 0,
	MRK_ALIGN_TOPCENTER,
	MRK_ALIGN_TOPRIGHT,
	MRK_ALIGN_CENTERLEFT,
	MRK_ALIGN_CENTERCENTER,
	MRK_ALIGN_CENTERRIGHT,
	MRK_ALIGN_BOTTOMLEFT,
	MRK_ALIGN_BOTTOMCENTER,
	MRK_ALIGN_BOTTOMRIGHT,
};

enum MRKPENSTYLE	{
	MRK_PENSTYLE_SOLID			= 0,
	MRK_PENSTYLE_DASH,
	MRK_PENSTYLE_DOT,
	MRK_PENSTYLE_DASHDOT,
	MRK_PENSTYLE_DASHDOTDOT,
	MRK_PENSTYLE_HOLLOW,
	
	// Geometry styles
	MRK_PENSTYLE_ARC,
	MRK_PENSTYLE_TRIANGLE
};

// Fill types.
enum {
	MRK_FILLNONE = 0,			// Not filled.
	MRK_FILLSOLID,				// Solid filling.
	MRK_FILLTRANSPARENT,		// Highlight filling.
};

// wParam for MRKN_SETCURSOR:  Gives status of closest entity
// passed in lParam.
enum {
	MRK_ENTNOTSELECTED = 0,
	MRK_ENTSELECTED,
	MRK_ENTDRAGGING
};

// wParam for MRK_GETENTITYEXTRADATA: type of extra data
enum {
	MRK_ENTEXDATA_USERDATA = 0,
};


// Data Structure Definitions:

// Special colour values:  
#define	BYLAYERINDEX	0					// Layer's colour should be applied.
#define BYLAYERRGB		((COLORREF)-1)
#define WIPEOUTRGB		((COLORREF)-2)		// BkColor colour should be applied.
#define LINECOLORRGB	((COLORREF)-3)		// Used for fill color only => fill color is
											// the same as the line color.
#define NOBOXCOLORRGB	((COLORREF)-4)		// Indicate text box does not have border

// Markup render modes.
#define	MRK_RENDERMODEXOR			0x00000001L
#define	MRK_RENDERMODEEDIT			0x00000002L
#define	MRK_RENDERMODENOPALETTE		0x00000004L
#define	MRK_RENDERMODEPRESERVECLIP	0x00000008L
#define	MRK_RENDERMODEMONOCHROME	0x00000010L
#define	MRK_RENDERMODEPRINTING		0x00000020L
#define MRK_RENDERMODECREATEMETA	0x00000040L		// Used when it is creating metafile used to appended to UDE when saving to markup file

#define	MRK_RENDERMODEPIXELFONT		0x10000000L		// Used with MrkDrawText() to indicate
													// that the entity font is specified in pixels.
#define MRK_RENDERMODEINVALIDATEEMF	0x20000000L		// Indidate TextBox's EMF needs to be updated because color of the layer in which the entity is on has changed.

#define	UDE_SUPPORTS2D				0x00000001
#define	UDE_SUPPORTS3D				0x00000002
#define	UDE_SUPPORTSNOFILL			0x00000004
#define	UDE_ONEPERUSER				0x00000008	// Per user singleton
#define	UDE_NODELETEBYUSER			0x00000010	// Cannot be deleted by user
#define	UDE_NOTIFYONMRKMODIFY		0x00000020	// Notify UDE when markup is modified.
#define	UDE_HIDEFROMUI				0x00000040	// Don't automaticall add UDE in toolbars/menus
#define UDE_DELETEONMRKCONSOLIDATE	0x00000080	// Delete when consolidating markups (MRK_COPYLAYER)


#define	POINT_2D		0x00
#define	POINT_3D		0x01

// Structure passed as argument to draw functions:  Contains general info
// on how to draw the entity.
typedef struct	{
	COLORREF	LineColor;					// Line color: -1 to use entity line color.
	COLORREF	FillColor;					// Fill color: -1 to use entity fill color.
	int			FillType;					// Fill type: -1 to use entity fill type.

	int			PenStyle;					// Pen style: -1 to use entity pen style.
	int			PenWidth;					// Pen width in pixels: -1 to use entity pen width.

	int			StartArrow;					// Start arrow: -1 to use entity start arrow.
	int			EndArrow;					// End arrow: -1 to use entity start arrow.
	int         xDevRes;					// Device resolution
	int			yDevRes;
}  MRK_DrawInfo, FAR *LPMRK_DrawInfo;													
													
// Markup render struct.
typedef struct {
	HDC             hdc;    	// Context of device on which to render.

	DWORD           mode;   	// One or more render modes.

	PAN_CtlRange    source; 	// Region to be rendered.
	RECT            devRect;	// Rectangle on device in which to fit selection.

	LPMRK_DrawInfo	lpDrawInfo;	// Special entity draw settings.  If NULL, uses each
								// entity's own settings.
} MRK_RenderOptions, FAR *LPMRK_RenderOptions;

// Base info struct.
typedef struct {
	int			Type;			// Base type.
	PAN_Point	Offset;			// Base offset.
	PAN_Point	Scale;			// Base scale.
	PAN_Point	Dpi;			// Base DIP.

	WORD		Units;			// base file units.

	Real		Rotation;		// Base rotation.
	int			nView;			// Base view index.
} MRK_BaseInfo, FAR *LPMRK_BaseInfo;

// Structure used for MRK_GETENTITIES
typedef	struct {
	MRKENTHANDLE	Handle;			// Handle of entity whose children we want to retreive.

	int				Type;			// Type of entity or ENTTYPE_NULL to get all.
	int				nMaxSize;		// Maximum number handles the given buffer can hold.
	LPMRKENTHANDLE	pHandles;		// Buffer to hold entity handles.
} MRK_GetEntities, FAR * LPMRK_GetEntities;

// which entities to get.
enum {
	GET_ALLENTITIES = 0,		// All entities in the control.
	GET_SELECTED,				// The selected entities.
	GET_ENTCHILDREN				// The children of the entity given by the Handle value in MRK_GetEntities
};

// Structure used for MRK_ENUMENTITIES
typedef	struct {
	MRKENTHANDLE	Handle;			// Handle of entity whose children we want to enumerate.
									// Used only if wParam == ENUM_ENTCHILDREN.

	int				Type;			// Type of entity or ENTTYPE_NULL to enumerate all.
	FARPROC			pCallbackFn;	// Callback procedure.
	LPVOID			lpData;			// Application specific data to be passed as arg
									// to the callback procedure.
} MRK_EnumEntities, FAR * LPMRK_EnumEntities;

// Type of enumeration.
enum {
	ENUM_ALLENTITIES = 0,			// All entities in the control.
	ENUM_SELECTED,					// The selected entities.
	ENUM_ENTCHILDREN,				// The children of the entity given by the Handle value in MRK_EnumEntities.
	ENUM_ALLENTITIES_INORDER 		// Enumerate all entities in the control in order (default one is in reverse order)
};

// Return Values for the Entity Enumeration Procedure:
// Returned by the Application's Enumeration Procedure,
// invoked with the MRK_ENUMENTITIES Message
enum {
	ENUM_NULL,		// Do nothing.
	ENUM_EDIT,		// Edit entity.
	ENUM_DEL,		// Delete entity.
	ENUM_SEL,		// Select entity (for wParam == ENUM_ALLENTITIES only).
	ENUM_UNSEL,		// Unselect entity (for wParam != ENUM_ENTCHILDREN).
	ENUM_SETVISIB,	// Show/Hide entity directly with out going through action stack (used by filter)
	ENUM_QUIT		// Stop enumeration.

};

// Print note flags.
#define	MRK_NOPAGEBREAK		0x00000001		// Do not print on seperate pages.

// Structue used by MRK_NOTEPREPAREPRINT and MRK_NOTEBATCHPRINT
typedef struct {
	int				numNotes;				// Number of notes to print.
	LPMRKENTHANDLE	pHandles;				// Handles of notes to print.
	DWORD			dwFlags;				// Print flags.

	struct {
		WORD            units;  	// input: one of PAN_CTLUNIT*
		double          top;
		double          left;
		double          bottom;
		double          right;
	} margins;                  	// input: margins

	LOGFONT				font;		// input:  title font.

	PRINTDLG FAR    	*printDlg;  // input: common dialog options

	int					numPages;	// output:	pagecount.
	LONGRECT			pageRect;	// output:  page rect in twips.
	RECT				deviceRect;	// output:  corresponding device rect in pixels

} MRK_NotePrint, FAR *LPMRK_NotePrint;

// Structure used by MRK_NOTERENDERPAGE.
typedef struct {
	int					pageIndex;	// input:	pagecount.
	HDC					hdc;		// input:	DC on which to render.
	LONGRECT			pageRect;	// input:  	page rect in twips.
	RECT				deviceRect;	// intput:  corresponding device rect in pixels

} MRK_NoteRender, FAR *LPMRK_NoteRender;

// Structure used by the MRK_COPYLAYER messages
typedef struct {
	int	nSrcMO;
	int	nSrcLayer;
	int	nDestMO;
	int	nDestLayer;
	// ture if the destination markup entity index is to be regenerated instead of copy from source markup
	BOOL bRegenEntIndex; 
} MRK_CopyLayer, FAR *LPMRK_CopyLayer;

// Common entity info.

#define	MRK_ENTITY_FINISHED			0x00000001L
#define	MRK_ENTITY_FIREABLE			0x00000002L
#define	MRK_ENTITY_FILLABLE			0x00000004L
#define	MRK_ENTITY_HIDDEN			0x00000008L
#define	MRK_ENTITY_READONLY			0x00000010L
#define MRK_ENTITY_UNICODE			0x00000020L
#define MRK_ENTITY_ANISOTROPIC		0x00000040L
#define MRK_ENTITY_TEXT_LAST_LINE	0x00000080L
#define MRK_ENTITY_IGNORE			0x00000100L
#define MRK_ENTITY_LINETHICKNESS_ZOOMABLE	0x00000200L
#define MRK_ENTITY_LINESTYLE_ZOOMABLE		0x00000400L
#define MRK_ENTITY_ARROW_DATA		0x00000800L
#define MRK_ENTITY_LEADER_TEXT		0x00001000L
#define MRK_ENTITY_NOEXPORTTOFILE	0x00002000L		// supress actual entity export, just force content to read
#define MRK_ENTITY_TEXTBOXBORDER	0x00004000L		// draw border of text box
#define MRK_ENTITY_NOTIFYONMRKMOD	0x0000F000L

#define MRK_ENTITY_TEXT_OLD_FORMAT	0x10000000L


// Free style specific
#define MRK_ENTITY_MULTI_FREESTYLE	0x00000080L

// Measurement entity specific flag
#define MRK_MEASURE_HAS_UNIT 		0x00000001L
#define MRK_MEASURE_DISPLAY_UNIT 	0x00000002L
#define MRK_MEASURE_HAS_ANCHOR 		0x00000004L
#define MRK_MEASURE_HAS_3DSTYLE 	0x00000008L
#define MRK_MEASURE_HAS_SUBTYPE		0x00000010L
#define MRK_MEASURE_HAS_SYMBOL 		0x00000020L

#define MRK_CLOUD_IS_RECT			0x00000001L

// Flags used by build in text entity
#define MRK_TEXT_IS_OLD_FORMAT			0x00000001L
// Flags used by 2D leader entity
#define MRK_LEADER_HAS_ALIGNMENT		0x00000001L	// Used only for pre-19.3 2D leader entity
#define MRK_LEADER_IS_OLD_FORMAT		0x00000001L
// Flag used by 3D leader text sub entity
#define MRK_3DLEADER_TEXT_IS_OLD_FORMAT	0x00000001L

typedef struct {	
	struct	{
		int nArcXRadius;	// X radius of arc in pixels 
		Real Ratio;		// X radius and Y radius ratio used to define the arc		 		
	} ArcStyleInfo;

	struct	{ 
		int nBottomEdge;	// Bottom edge length of triangle in pixels  
		int nHeight;		// Height of the triangle in pixels 
	} TriangleStyleInfo;

} MRK_LineStyleInfo, FAR *LPMRK_LineStyleInfo;

// Kelvin (Nov 21, 2003): VIEW2D struct
typedef struct {
	PAN_CtlRange		rgViewExtent;	// View extents
	double				ViewRotate;		// View rotation angle setting, stored in degrees
	double				MrkRotate;		// Markup rotation angle setting, stored in degrees
	Long				nViewFlip;		// View flip axis setting
	Long				nMrkFlip;		// Markup flip axis setting
} ViewState2D;

//Mohamed : 10/17/2003 Added new struct for viewstate3d
typedef struct {							
	Hmatrix				ModelTransf;				
	PAN_Point			ptViewPoint;
	PAN_Point			ptTarget;
	PAN_Point			ptUpDir;
	PAN_CtlRange		rgViewExtent;	
}ViewState3D;

typedef struct {
	char	szAppID[_MAX_PATH];			// Application ID
	char	szDataSetType[_MAX_PATH];	// Dataset type
	long	nDataSize;					// Data size of raw data
	void*	pData;						// pointer to raw data
} MRK_UserDataSetInfo, FAR *LPMRK_UserDataSetInfo;


typedef struct {
	long					nNumDataSets;	// number of datasets
	MRK_UserDataSetInfo*	pDataSets;		// pointer to datasets
} MRK_UserDataInfo, FAR *LPMRK_UserDataInfo;

typedef	struct {
	int				Type;					// Entity type.

	MRKENTHANDLE	Handle;					// Entity Handle
	MRKENTHANDLE	ParentHandle;			// Parent Entity Handle

	HWND			hWndCtl;				// Handle of markup control window.

	int				numChildren;			// Number of child entities.

	DWORD			dwFlags	;				// Combo of MRK_ENTITY_XXX flags.

	int				nRedlineIndex;			// Redline index.
	int				nPageIndex;				// Page index.
	int				nLayerIndex;			// Layer index.

	COLORREF 		LineColor;				// Line color.
	COLORREF 		FillColor;				// Fill color.
	int				FillType;				// Fill type:  None, Solid, Transparent.

	int				PenStyle;				// Pen style.
	Real			PenWidth;				// Pen width.

	int				StartArrow;				// Start arrow type.
	int				EndArrow;				// End arrow type.
	Real			Rotation;				// Rotation angle in radians
	char			szAuthor[_MAX_PATH];	// Author who create the entity
	long			LastModifiedTime;		// the latest time when the entity is modified 
	CMrkFont		Font;					// Entity font.
	ViewState2D		stViewState2D;			// Last view settings 2D
	ViewState3D     stViewState3D;			// Last view settings 3D
	MRK_LineStyleInfo		LineStyleInfo;	// Extra info for line style 
	double			InitWorldClientScale;	// World to Client scale when the entity is created
	double			dArrowSize;				// arrow size. Either in inches or in pixels, if arrow is non-zoomable
	PAN_Point		TextDimension;			// Text dimension in world coordinate if applicable 
											// (for text entity or entity contain text, otherwise the size should be 0)
	BOOL			bTextBoxVisible;		// TextBox visibility
	int				nLeaderAlignment;		// 2D Leader alignment
	int				Flip;					// Entity Flip

	MRK_UserDataInfo	UserDataInfo;		// Entity user data

} MRK_CommonInfo, FAR *LPMRK_CommonInfo;

// Entity specific info.
typedef struct	{
	PAN_Point	Pt1;		// Start point.
	PAN_Point	Pt2;		// End point.

} MRK_LineInfo, FAR *LPRMK_LineInfo;

typedef struct	{
	LONG		numPts;				// Number of points.
	PAN_Point	huge *pPoints;		// Buffer of points.

	Int			numSegms;			// number of segments
	Int			huge *ptsCounter;	// point numbers for segments

} MRK_FStyleInfo, FAR *LPRMK_FStyleInfo;

typedef struct	{
	LONG		numPts;				// Number of points.
	PAN_Point	huge *pPoints;		// Buffer of points.

} MRK_PolyInfo, FAR *LPRMK_PolyInfo;

typedef struct	{
	PAN_Point	InsPoint;				// Text insertion point.
	PAN_Point	BottomRightPoint;		// Bottom right point defines the box size
	int			Align;					// Text alignment.
	Real		Rotang;					// Text rotation angle.
	Real		Oblique;				// Text obliquing angle.
	LPCSTR		szText;					// Text string.

} MRK_TextInfo, FAR *LPRMK_TextInfo;

typedef struct	{
	LONG		numPts;				// Number of points.
	PAN_Point	FAR *pPoints;		// Buffer of points.

} MRK_SolidInfo, FAR *LPRMK_SolidInfo;

typedef struct	{
	PAN_Point	Pt1;		// First corner.
	PAN_Point	Pt2;		// Second corner.

} MRK_RectangleInfo, FAR *LPRMK_RectangleInfo;

typedef struct	{
	PAN_Point	Pt1;		// First corner of bounding rect.
	PAN_Point	Pt2;		// Second corner of bounding rect.
	Real		StartAng;	// Start angle in radians.
	Real		EndAng;		// End angle in radians.

} MRK_ArcInfo, FAR *LPRMK_ArcInfo;

typedef struct	{
	PAN_Point	Pt1;		// First corner of bounding rect.
	PAN_Point	Pt2;		// Second corner of bounding rect.

} MRK_CircleInfo, FAR *LPRMK_CircleInfo;

typedef struct	{
	PAN_Point	InsPt;		// Insertion point.

	LPCSTR		szName;		// Note name.
	LPCSTR		szAuthor;	// Note author.
	LPCSTR		szKeyWords;	// Note Key words.
	LPCSTR		szIcon;		// Icon name.

	LONG		NoteLength;	// Length of note content.
	HPSTR		szNote;		// Note content.

} MRK_NoteInfo, FAR *LPRMK_NoteInfo;

typedef struct	{
	PAN_Point	InsPt;		// Insertion point.

	int			LinkType;	// Link type.

	BOOL		fStartApp;	// Link flag.

	DWORD		dwFlags;	// MLINK_FLAG_XXX flags

	LPCSTR		szName;		// Link name.
	LPCSTR		szIcon;		// Icon name.

	LPCSTR		szDef1;		// Link definition 1.
	LPCSTR		szDef2;		// Link definition 2.
	LPCSTR		szDef3;		// Link definition 3.
							// If LinkType == MLINK_EMBED_FILE:
							// 'szDef1' - display name of attached local file / DocID
							// 'szDef2' - actual attached filename
							// 'szDef3' - filename of the temp. file
	LPCSTR		szDesc;		// Link description.
} MRK_LinkInfo, FAR *LPRMK_LinkInfo;

typedef struct	{
	LPCSTR	szName;				// UDE name.
	LONG	DataSize;			// UDE data size.
	void	huge *pData;		// Pointer to UDE data.
	int		eMarkupVersion;
} MRK_UdeInfo, FAR *LPRMK_UdeInfo;

// Actual Specifications of an Entity
typedef struct {
	MRK_CommonInfo	Com;
	union	{
		MRK_LineInfo		Line;
		MRK_FStyleInfo		FStyle;
		MRK_PolyInfo		Poly;
		MRK_SolidInfo		Solid;
		MRK_RectangleInfo	Rect;
		MRK_TextInfo		Text;
		MRK_ArcInfo			Arc;
		MRK_CircleInfo		Circle;
		MRK_NoteInfo		Note;
		MRK_LinkInfo		Link;
		MRK_UdeInfo			Ude;
	} Ent;
} MRK_EntitySpec, FAR *LPMRK_EntitySpec;

// Structure used by MRK_GETUDEINFO message
typedef struct {
	UINT	entID;
	char	entName[_MAX_PATH];
	char	entFileName[_MAX_PATH];
	char	entMenuDesc[_MAX_PATH];
	char	entDescription[_MAX_PATH];
	char	entShortDescription[_MAX_PATH];

	UINT		BitmapResID;				// Resource ID for toobar button bitmap.
	HCURSOR		hCursor;
	HINSTANCE	hinstDLL;

	DWORD		dwHints;			// Bit flags. Combination of the following:
									// UDE_SUPPORTS2D and UDE_SUPPORTS3D. For backward compatibility, 
									// the application should assume 2D support if 3D support flag is not set.
	DWORD		dwSnapSupport;		// Bit flags. Combination of the following:
									//MRK_SNAPTO_NONE,MRK_SNAPTO_VERTEX,MRK_SNAPTO_EDGE
									//MRK_SNAPTO_MIDEDGE,MRK_SNAPTO_ARCCENTER,MRK_SNAPTO_FACE
	void (PASCAL *WhoIAm)(void *Info);

	void (PASCAL *InitEntity)(LPMRK_EntitySpec Entity);
	void (PASCAL *ReleaseEntity)(LPMRK_EntitySpec Entity);

	long (PASCAL *ReadEntity)(LPMRK_EntitySpec Entity);
	long (PASCAL *WriteEntity)(LPMRK_EntitySpec Entity, BOOL fSizeOnly);

	int	 (PASCAL *MouseProc)(int Msg, WPARAM wParam, LPARAM lParam, LPMRK_EntitySpec Entity);

	BOOL (PASCAL *GetControlPoints)(LPINT pNumPts, LPPANPOINT *pPts, LPMRK_EntitySpec Entity);
	BOOL (PASCAL *DoEdit)(PAN_CtlRange *R1, PAN_CtlRange *R2, LPMRK_EntitySpec Entity);
	BOOL (PASCAL *Translate)(PAN_Point *Vector, LPMRK_EntitySpec Entity);

	BOOL (PASCAL *DoCopy)(LPMRK_EntitySpec Entity);

	BOOL (PASCAL *Draw)(MRK_RenderOptions *lpSpec, LPMRK_EntitySpec Entity);

	BOOL (PASCAL *SelectionTest)(PAN_CtlRange *selrange, LPMRK_EntitySpec Entity);

	BOOL (PASCAL *BoundingBox)(LPMRK_EntitySpec Entity);
} UDEINFO, FAR *LPUDEINFO;

// Structure used by the MRKN_COPYLAYER message
typedef struct {
	MRK_CopyLayer copyStruct;
	MRK_EntitySpec entitySpec;
} MRKN_CopyLayer;


// Load/Free markup control.
int PCALLBACK LoadMarkupControl();
int PCALLBACK FreeMarkupControl();

// Definition of a Markup Panel with Offset and Extensions Relative to the Parent Window
HWND PCALLBACK CreateMarkupCtl(HWND hWndParent, int x, int y, int cx, int cy);


int			MrkGetUDECount();
LPUDEINFO	MrkGetUDEFromIndex(int index);

// Memory Management provided to the UDEs
void huge * PCALLBACK MrkAlloc(long Size);
void PCALLBACK MrkFree(void huge *Ptr);
void PCALLBACK MrkMemCopy(void huge *A, void huge *B, long L);
#if 0
void huge * PCALLBACK MrkReAlloc(void huge *oldptr, long OldSize, long Size);
#endif

// Graphical Functions Easing the Drawing for UDEs
// Only World Coordinates are used

// Basic Functions, including Geometric Proximity Determination and Intersection Computation
int PCALLBACK MrkRotate(PAN_Point FAR *P, PAN_Point FAR *Center, double Angle);
int PCALLBACK MrkSegmentVisibleInBox(PAN_Point FAR *P1, PAN_Point FAR *P2, PAN_Point FAR *A, PAN_Point FAR *B);
int PCALLBACK MrkBoxVisibleInBox(PAN_Point FAR *P1, PAN_Point FAR *P2, PAN_Point FAR *A, PAN_Point FAR *B);
int PCALLBACK MrkArcVisibleInBox(PAN_Point FAR *C, PAN_Point FAR *P1, PAN_Point FAR *P2, PAN_Point FAR *A, PAN_Point FAR *B, double A1, double A2);
int PCALLBACK MrkGeomArcVisibleInBox(MRKENTHANDLE Handle, int nLineStyle, PAN_Point *FAR CenterPt, PAN_Point *FAR XRadiusPt, PAN_Point *FAR YRadiusPt, PAN_Point *FAR P1, PAN_Point *FAR P2, Real stang, Real endang);
int PCALLBACK MrkSegIntersectBox(PAN_Point FAR *P1, PAN_Point FAR *P2, PAN_CtlRange FAR *Box, PAN_Point FAR *p1, PAN_Point FAR *p2);
double PCALLBACK MrkDistance(PAN_Point FAR *P1, PAN_Point FAR *P2);
double PCALLBACK MrkDistance3D(PAN_Point FAR *P1, PAN_Point FAR *P2);

// Conversion from One Coordinate System to Another
// Mainly used for Entity Distortion Through Edit Handles
int PCALLBACK MrkDoEdit(PAN_Point FAR *P, PAN_CtlRange FAR *R1, PAN_CtlRange FAR *R2);
int PCALLBACK MrkDoEditRadius(PAN_Point FAR *P, PAN_Point FAR *p, PAN_CtlRange FAR *R1, PAN_CtlRange FAR *R2);

// Line Processing
void PCALLBACK MrkDrawLine(MRKENTHANDLE Handle, HDC hdc, PAN_Point FAR *P1, PAN_Point FAR *P2, DWORD Mode, LPMRK_DrawInfo pDrawInfo);
                                                                                                             void PCALLBACK MrkLineExtents(MRKENTHANDLE Handle, PAN_CtlRange FAR *R, int ArrowHead, int ArrowTail);

// Polyline Processing.
void PCALLBACK MrkDrawPoly(MRKENTHANDLE Handle, HDC hdc, int numPts, PAN_Point FAR *pPts, DWORD Mode, LPMRK_DrawInfo pDrawInfo);
void PCALLBACK MrkPolyExtents(MRKENTHANDLE Handle, PAN_CtlRange FAR *R, int numPts, PAN_Point FAR *pPts, int ArrowHead, int ArrowTail);

// Rect Processing
void PCALLBACK MrkDrawRect(MRKENTHANDLE Handle, HDC hdc, PAN_Point FAR *P1, PAN_Point FAR *P2, DWORD Mode, LPMRK_DrawInfo pDrawInfo);

// Functions related to entity index (counting)
BOOL PCALLBACK MrkSetEntityIndex(MRKENTHANDLE Handle, long nIndex);
long PCALLBACK MrkGetEntityIndex(MRKENTHANDLE Handle);

// Arc/Circle Processing
void PCALLBACK MrkDrawArc(MRKENTHANDLE Handle, HDC hdc, PAN_Point FAR *Center, PAN_Point FAR *Rad1, PAN_Point FAR *Rad2, double stang, double endang, DWORD Mode, LPMRK_DrawInfo pDrawInfo);
void PCALLBACK MrkArcExtents(MRKENTHANDLE Handle, PAN_CtlRange FAR *R, PAN_Point FAR *Center, PAN_Point FAR *Rad1, PAN_Point FAR *Rad2, double stang, double endang);

// Text Processing
void PCALLBACK MrkDrawText(MRKENTHANDLE Handle, HDC hdc, PAN_Point FAR *pPoint, LPCSTR szText, int Align, DWORD Mode, LPMRK_DrawInfo pDrawInfo);
void PCALLBACK MrkDrawText2(MRKENTHANDLE Handle, HDC hdc, PAN_Point FAR *pPoint, LPCSTR szText, int Align, DWORD Mode, LPMRK_DrawInfo pDrawInfo, int nCharset, double rotation);
void PCALLBACK MrkTextExtents(MRKENTHANDLE Handle, LPCSTR szText, int Align, PAN_CtlRange FAR *pRange);
void PCALLBACK MrkTextExtents2(MRKENTHANDLE Handle, LPCSTR szText, int Align, PAN_CtlRange FAR *pRange, int nCharset);
void PCALLBACK MrkDrawTextBox(LPMRK_EntitySpec pEntity, PAN_CtlRange *pRange, MRK_RenderOptions *pRenderSpec );
void PCALLBACK MrkCalculateFontSize(MRKENTHANDLE Handle, double oldWidth, double newWidth, double oldHeight, double newHeight, CMrkFont* pFont);
void PCALLBACK MrkSetTextDimension(MRKENTHANDLE Handle, PAN_Point FAR *pDimension);
void PCALLBACK MrkGetTextDimension(MRKENTHANDLE Handle, PAN_Point FAR *pPoint, LPCSTR szText, int Align, PAN_Point FAR *pDimension, int nCharset);

PAN_Point PCALLBACK MrkGetDefaultTextBoxDimension(MRKENTHANDLE Handle);
void PCALLBACK MrkDrawEMFView(MRKENTHANDLE Handle, HDC hdc, HENHMETAFILE hEMF, PAN_Point FAR *pPoint1, PAN_Point FAR *pPoint2);
void PCALLBACK MrkDrawNewTextBox(MRKENTHANDLE Handle, HDC hdc, PAN_Point FAR *pPoint1, PAN_Point FAR *pPoint2, DWORD dwMode);
Real PCALLBACK MrkGetOldTextToTextBoxFontScale(MRKENTHANDLE Handle);
Real PCALLBACK MrkGetWorldToClientScale(MRKENTHANDLE Handle);
int PCALLBACK MrkParseRTF(const LPBYTE lpbBuff, LONG nByte, LPTSTR lpText, BOOL bReturnUnicode);

// Text Manipulation
BOOL PCALLBACK MrkDoFontDialog(HWND hOwner, LPLOGFONT Font);

// Rotation support
// Get global and local rotation
Real PCALLBACK MrkGetCompoundRotation(MRKENTHANDLE Handle);
// Rotate the P2 around P1. Rotion is based on client coordinate and then converted back to world
// after the function call, P2 is the rotated point
void PCALLBACK MrkRotateWorldPt(MRKENTHANDLE Handle, PAN_Point FAR *P1, PAN_Point FAR *P2, double angle);
//Flip
//Get global and local flip 
int PCALLBACK MrkGetCompoundFlip(MRKENTHANDLE Handle);

// Size of Font Definition In Universal Format
#define MRK_CST_FONTSIZE ( sizeof(Int) * 5 + LF_FACESIZE + 8 )

// Handle of window being marked up.
HWND PCALLBACK MrkGetBaseWindow(HWND hwndCtl);

// Transform the markup points using the new scale and offset of the base drawing
void PCALLBACK MrkAdjustPoints(HWND hwndCtl, PAN_Point *pPoints, int nPoints);

// Snapping support
// pPoints:		IN:	Client coord point. OUT: World coord point if successful.
// dwSnapTo:	IN:	Combination of MRK_SNAPTO_XXX
// Return:		TRUE is able to snap.  FALSE otherwise. 
BOOL PCALLBACK MrkSnap(MRKENTHANDLE Handle, PAN_Point *pPoint, DWORD dwSnapTo);
// Inform the application which snap type the entity will support
BOOL PCALLBACK MrkSnapSupport(MRKENTHANDLE Handle, DWORD dwSnapSupport);

// Utils functions
BOOL			PCALLBACK	MrkWorld3DtoWorld2D(HWND hWndCtl, PAN_Point *pPt);
BOOL			PCALLBACK	MrkWorld2DtoWorld3D(HWND hWndCtl, PAN_Point *pPt);
void			PCALLBACK	MrkDrawGrip(MRK_RenderOptions *pRenderSpec, LPMRK_EntitySpec pEntity, PAN_Point *pGripCenter);
void			PCALLBACK	MrkDrawExtensionLine(MRK_RenderOptions *pRenderSpec, LPMRK_EntitySpec pEntity, PAN_Point *pStartPt, PAN_Point *pEndPt);
BOOL			PCALLBACK	MrkGetTextBoxControlPoints(HWND hWndCtl, MRKENTHANDLE Handle, LPCSTR szText, PAN_Point FAR *pTextPt, int NumPts, PAN_Point *pPts);
void			PCALLBACK	MrkFillInDrawInfoStruct(MRK_RenderOptions *pRenderSpec, int FillType, int StartArrow, int EndArrow, MRK_DrawInfo *pDrawInfo);
PAN_CtlRange	PCALLBACK	MrkGet2DSnapBox(LPMRK_EntitySpec pEntity, PAN_Point *pBoxCenter, int Size /* Pixels */);
BOOL			PCALLBACK	Mrk3DProjectPoint(HWND hWndCtl, PAN_Point *pPoint, PAN_Point *pPlaneNormal, PAN_Point *pInPlanePt);
BOOL			PCALLBACK	MrkGetBaseExtents(HWND hWndCtl, PAN_CtlRange* pExtents);
BOOL			PCALLBACK	MrkGetEntityBoundingBox(MRKENTHANDLE Handle, BOOL fChildren, PAN_CtlRange* pBBox);
void			PCALLBACK	MrkInflateRange(PAN_Point* pMin, PAN_Point* pMax);
void			PCALLBACK	MrkSetLastModifiedTime(MRKENTHANDLE Handle, BOOL fChildren);

// For 3d Note
BOOL 	PCALLBACK MrkIsReadOnly(MRKENTHANDLE Handle);
LRESULT PCALLBACK MrkGetUserName(MRKENTHANDLE Handle, int nBufSize, char FAR *pBuf);
void 	PCALLBACK MrkDrawCustomIcon(MRKENTHANDLE Handle, HDC hdc, PAN_Point P,
                                POINT ptIconSize, LPCSTR szIconName, DWORD Mode);
#ifdef __cplusplus
}
#endif /* __cplusplus */

#pragma	pack()

#define EQUAL_POINTS(X,Y) X.AlmostEqual(Y, SMALL10TOMINUS9)

#endif // _MRKUPCTL_
