/******************************************************************************
**
** PCTL.H       *** VERSION 1.2 ***
**
** Public Definitions & Declarations
**
** C.S.I.'s Multi-Format Controls, (C)1994 C.S.I.
*/

/** 
 * @file Public Definitions & Declarations.
 * Multi-Format Controls
 */ 


#ifndef pctl_h
#define pctl_h

//******************************************************************************
// INCLUDES

#include <windows.h>
#include <commdlg.h>    // for PRINTDLG

#ifndef RC_INVOKED
#include "pan.h"
#if	TARGET==WIN16
#pragma	pack(1)
#else
#pragma	pack(8)
#endif
#endif

//******************************************************************************
// CONSTANTS

// Error codes.
#define PAN_CTLERRNONE                          0
#define PAN_CTLERRMISC                          1
#define PAN_CTLERRNOTINSTALLED                  2
#define PAN_CTLERRALREADYINSTALLED              3
#define PAN_CTLERRNOTIMPLEMENTED                4
#define PAN_CTLERRNOTCOMPATIBLE                 5
#define PAN_CTLERRBADDATA                       6
#define PAN_CTLERRBADPARAM                      7
#define PAN_CTLERRBADWPARAM                     8
#define PAN_CTLERRBADLPARAM                     9
#define PAN_CTLERRBADINSTANCE                   10
#define PAN_CTLERRBADCTLTYPE                    11
#define PAN_CTLERRBADMESSAGE                    12
#define PAN_CTLERRBADCAPS                       13
#define PAN_CTLERRBADWINDOW                     14
#define PAN_CTLERRCANNOTLOCKMEM                 15
#define PAN_CTLERRCANNOTALLOCMEM                16
#define PAN_CTLERRCANNOTLOCKCTLDATA             17
#define PAN_CTLERRCANNOTCREATECTLDATA           18
#define PAN_CTLERRCANNOTFINDCTLDATA             19
#define PAN_CTLERRCANNOTADDCTLDATA              20
#define PAN_CTLERRCANNOTFINDDLL                 21
#define PAN_CTLERRCANNOTLOADDLL                 22
#define PAN_CTLERRCANNOTGETPROCADDRESS          23
#define PAN_CTLERRCANNOTCREATEWINDOW            24
#define PAN_CTLERRCANNOTREGISTERCLASS           25
#define PAN_CTLERRCANNOTCREATECONTROL           26
#define PAN_CTLERRCANNOTQUERYFILE               27
#define PAN_CTLERRCANNOTBEGINFILE               28
#define PAN_CTLERRCANNOTPROCESSFILE             29
#define PAN_CTLERRCANNOTENDFILE                 30
#define PAN_CTLERRCANNOTTERMINATEFILE           31
#define PAN_CTLERRCANNOTMAKEPROCINSTANCE        32
#define PAN_CTLERRNOTSUPPORTED                  33
#define PAN_CTLERRNOFILESET                     34
#define PAN_CTLERRCANNOTCONFIGURETABLE          36
#define PAN_CTLERRDLLFAILED                     37
#define PAN_CTLERRCANNOTCREATEMETAFILE          38
#define PAN_CTLERRBADCLPBRDFMT                  39
#define PAN_CTLERRNOSELSET                      40
#define PAN_CTLERRBADLMBACTION                  41
#define PAN_CTLERRCANNOTGETDC                   42
#define PAN_CTLERRCANNOTCREATEPALETTE           43
#define PAN_CTLERRCANNOTCREATEOBJECT            44
#define PAN_CTLERRBADMODE                       45
#define PAN_CTLERRCANNOTCREATEDC                46
#define PAN_CTLERRCANNOTOPENCLIPBOARD           47
#define PAN_CTLERRBADMSG                        48
#define PAN_CTLERRCANNOTINITTEXT                49
#define PAN_CTLERRNOBLOCK	                	50
#define PAN_CTLERRNOLAYERS	                	51
#define PAN_CTLERRNOVIEW	                	52
#define PAN_CTLERRNOXREFS	                	53
#define PAN_CTLERRNORESOURCEINFO               	54
#define PAN_CTLERRNO3DMODEL			         	55
#define PAN_CTLERRNOVIEWPORTS                	56
#define PAN_CTLERRINTERNAL                      57

/**
 * wParam first bit values to specify whether the message is routed for 2D or 3D. 
 */
#define PAN_MESSAGE_VECTOR2D	 0x0000	// 2D message sent to a 2D page
#define PAN_MESSAGE_VECTOR3D	 0x1000	// 3D message sent to a 3D page

/*
** API command messages.
**
** VERSION 1.2 CHANGES:
**
**      DELETED MESSAGES:
**              PM_CTLGETDC,
**              PM_CTLSETDC,
**              PM_CTLSETBOOKMARK,
**              PM_CTLSETBOOKMARK.
**
**
** NEW MESSAGES:
**              PM_CTLGETSTRING,
**              PM_CTLGETENTITY,
**              PM_CTLCARETTOWORLD,
**              PM_CTLGETCARETPOS,
**              PM_CTLGETDIMS,
**              PM_CTLSETCARETPOS,
**              PM_CTLSETSELCARET,
**              PM_CTLSORT,
**              PM_CTLWORLDTOCARET,

**              PMI_CONVERTCOORD                internal and not documented
**              PMI_UPDATECTL                   internal and not documented
**              PMI_XFRMRECT                    internal and not documented
**				PMI_REALIZEBACKGROUNDPALETTE 	internal and not documented
**				PMI_SENDNOTIFICATION		 	internal and not documented
**				PMI_CONSUMEEVENT			 	internal and not documented
**				PMI_OVERLAYOBJECT			 	internal and not documented
**				PMI_GETPAGEMINSIZE				internal and not documented
*/
enum {
	PM_CTL_first = WM_USER,

	PM_CTLGETINFO = PM_CTL_first,
	PM_CTLGETFILEFMTS,
	PM_CTLGETCLPBRDFMTS,
	PM_CTLGETSTATUS,
	PM_CTLGETCAPS,
	PM_CTLSETCAPS,
	PM_CTLGETMODE,
	PM_CTLSETMODE,
	PM_CTLGETLMBACTION,
	PM_CTLSETLMBACTION,
	PM_CTLCLONECONTROL,
	PM_CTLGETFILETYPE,
	PM_CTLGETFILE,
	PM_CTLSETFILE,
	PM_CTLPAINT,
	PM_CTLRENDERONTODC,                     /* Renamed message. */
	PM_CTLGETNUMPAGES,
	PM_CTLGETPAGE,
	PM_CTLSETPAGE,
	PM_CTLGETPAGESIZE,
	PM_CTLGETROWHEIGHT,
	PM_CTLGETCOLWIDTH,
	PM_CTLSIZE,
	PM_CTLHSCROLL,
	PM_CTLVSCROLL,
	PM_CTLGETNUMSELS,
	PM_CTLGETSELS,
	PM_CTLSETSEL,
	PM_CTLCLEARSELS,
	PM_CTLCOPY,
	PM_CTLGETSTRING,						/* New message: Version 1.2 */
	PM_CTLGETENTITY,						/* New message: Version 1.2 */
	PM_CTLSEARCH,
	PM_CTLGETBASEFONT,
	PM_CTLSETBASEFONT,
	PM_CTLCLIENTTOWORLD,
	PM_CTLWORLDTOCLIENT,
	PM_CTLCARETTOWORLD,                     /* New message: Version 1.2 */
	PM_CTLWORLDTOCARET,                     /* New message: Version 1.2 */
	PM_CTLGETVIEWEXTENTS,
	PM_CTLSETVIEWEXTENTS,
	PM_CTLGETOFFSET,
	PM_CTLSETOFFSET,
	PM_CTLGETZOOM,
	PM_CTLSETZOOM,
	PM_CTLROTATE,
	PM_CTLFLIP,
	PM_CTLGETFGBGCOLOR,
	PM_CTLSETFGBGCOLOR,
	PM_CTLGETPALETTE,
	PM_CTLSETPALETTE,
	PM_CTLPALETTECHANGED,
	PM_CTLQUERYNEWPALETTE,
	PM_CTLVALIDATEMARGINS,
	PM_CTLPRINTPREVIEW,
	PM_CTLPRINT,
	PM_CTLREGEN,
	PM_CTLGETRESOURCEINFOSTATE,
	PM_CTLGETXREFSTATE,
	PM_CTLSETXREFSTATE,
	PM_CTLGETLAYERSTATE,
	PM_CTLSETLAYERSTATE,
	PM_CTLGETBLOCKNAMES,
	PM_CTLSETBLOCK,
	PM_CTLGETBLOCK,
	PM_CTLGETVIEWNAMES,
	PM_CTLSETVIEW,
	PM_CTLGETVIEW,
	PM_CTLGETBOOKMARKS,             /* New message: Version 1.3 */
	PM_CTLSETBOOKMARKS,             /* New message: Version 1.3 */
	PM_CTLABORT,                    /* Unused */
	PM_CTLDESTROYDESCENDENTS,
	PM_CTLDESTROY,
	PM_CTLGETCARETPOS,              /* New message: Version 1.2 */
	PM_CTLSETCARETPOS,              /* New message: Version 1.2 */
	PM_CTLGETDIMS,                  /* New message: Version 1.2 */
	PM_CTLSORT,                     /* New message: Version 1.2 */
	PM_CTLSETSELCARET,              /* New message: Version 1.2 */
	PM_CTLMULTISEARCH,
	PM_CTLCONVERT,
	PM_CTLGETIMAGEEX,
	PM_CTLSETIMAGEEX,
	PM_CTLGETOVERLAYS,
	PM_XFRMRECT,					/* New message: Version 1.2 */
	PM_CTLFLUSH,					/* New message: Version 1.2.  Flush local queue */
	PM_CTLSETDEVICE,				/* New message: Version 1.3.  Sets document control formatting device. */
	PM_CTLGETDEVICE,				/* New message: Version 1.3.  Gets document control formatting device. */
	PM_CTLSHOWENTITY,				/* New message: Version 1.3.  Color with which an entity should be drawn. */

	PM_CTLGETPROFILENAME,			/* New message: Version 1.3.  Gets profile name */
	PM_CTLSETPROFILENAME,			/* New message: Version 1.3.  Sets profile name */

	PM_CTLGETBANDSCOUNT,   
	PM_CTLGETBAND,
	PM_CTLGETLINESTYLETABLE,
	PM_CTLDETECTCOLLISION,
									/* New 3D control messages */
	PM_CTLSETLIGHT,
	PM_CTLGETLIGHT,	
	PM_CTLGETTREE,
	PM_CTLGETMASSPROPS,
	PM_CTLSETCAMERA,
	PM_CTLGETCAMERA,
	PM_CTLGETSECTIONINGPLANE,
	PM_CTLSETSECTIONINGPLANE,
	PM_CTLGETTRANSFORM,
	PM_CTLSETTRANSFORM,
	PM_CTLGETOPTION,
	PM_CTLSETOPTION,
	PM_CTLSETSELENTITY,
	PM_CTLGETMINDISTANCE,	
	PM_CTLGETSECEDGES,
	PM_CTLGETATTRIBUTE,
	PM_CTLSETATTRIBUTE,
	PM_CTLGETENTITYINFO,
	PM_CTLENUMENTITIES,
    PM_CTLENUMDEFINITIONS, 
	PM_CTLIMPORTFILE,
	PM_CTLHEALING,
	PM_CTLGETPAGEINFO,	
	PM_CTLGETLINKS,
	PM_CTLGETROTATION,
	PM_CTLGETFLIP,
	PM_CTLSETPASSWORD,
	PM_CTLGETPASSWORD,
	PM_CTLGETPRINTSETTINGS,
	PM_CTLSIMPLIFYMODEL,
    /* 3D Compare Message */
    PM_CTL3DCOMPARE,
	/* Configuration Message */
	PM_CTLGETCONFIGURATIONS, /* Message for requesting configuration set*/
	PM_CTLSETCONFIGURATION,   /* Message for applying a configuration */

	/* Internal messages (not documented). Version 1.2 */
	PMI_CONVERTCOORD,               /* See the pctnwnd.c for parameter description     */
	PMI_UPDATECTL,
	PMI_EXCEPTION,
	PMI_REALIZEBACKGROUNDPALETTE,
	PMI_SENDNOTIFICATION,
	PMI_CONSUMEEVENT,
	PMI_OVERLAYOBJECT,
	PMI_GETPAGEMINSIZE,
	PMI_CTLGETCLIENTRECT,		/* without scroll bars if any */
	PMI_CTLUPDATESTATE,
	PMI_CTLGETALTERNATEBODIES, /* Internal Message for retrive the vector alter bodies ID from current page */

	PM_CTLGETIDENTICALPARTS = PMI_GETPAGEMINSIZE + 100,
	PM_CTLCREATEMETAFILE,
	PM_CTLRESTOREMETAFILE,	
	PM_CTLEXTRACTARCHIVE,
	
	PM_CTLSETFILEEX,		/* Set File using user resource localization */
	PM_CTLGETFONTSERVER,	/* Returns an address to a FontServer shared pointer  */
	PM_CTLSETBACKGROUND,	/* Changes the background of 3D files with enhanced functionality (Gradient BG, Images...) */

	PM_CTL_last = 		PM_CTLEXTRACTARCHIVE

};

// API notification messages.
enum {
	PNM_CTL_first = WM_USER,

	PNM_CTLSETFOCUS = PNM_CTL_first,
	PNM_CTLSETFILE,
	PNM_CTLSTATUS,
	PNM_CTLSEARCH,
	PNM_CTLHELPSTRING,
	PNM_CTLPAINT,
	PNM_CTLHSCROLL,
	PNM_CTLVSCROLL,
	PNM_CTLSIZE,
	PNM_CTLSETVIEWEXTENTS,
	PNM_CTLDROPFILE,
	PNM_CTLARCFILE,
	PNM_CTLPROCESSINGPAGE,
	PNM_CTLPRINTINGPAGE,
	PNM_CTLPRINT,
	PNM_CTLDESTROY,
	PNM_CTLSETSEL,
	PNM_CTLCOLWIDTH,				// RR: 09/20/94
	PNM_CTLROWHEIGHT,
	PNM_CTLOBJECT,
	PNM_CTLLINK,					// New VCET 1.3
	PNM_CTLREGEN,				
	PNM_CTLEXCEPT,
	PNM_CTLSETPAGE,					// New VCET 1.3
	PNM_CTLRENDERSEL,
	PNM_CTLMODELVIEWTRANSFORM,
	
	PNM_CTL_last = PNM_CTLMODELVIEWTRANSFORM
};


/**
 * wParam values for PM_CTLSHOWENTITY
 */ 
enum PanShowEntityAction
{
	PAN_SHOWENTITY_ADD = 2,	    // Add a "Show-Entity" record
	PAN_SHOWENTITY_REMOVE,	    // Remove an existing "Show-Entity" record
	PAN_SHOWENTITY_ENABLE,	    // Enable an existing "Show-Entity" record
	PAN_SHOWENTITY_DISABLE,	    // Disable an existing "Show-Entity" record
	PAN_SHOWENTITY_REMOVEALL	// Remove all "Show-Entity" records
};

// Formatting device defs:  wParam values for PM_CTLSETDEVICE
// and return values for PM_CTLGETDEVICE
#define	PAN_CTLDEVICESCREEN				1		// Device is the screen.
#define	PAN_CTLDEVICESTANDARD			2		// Device is standard device specified in win.ini file
#define	PAN_CTLDEVICEPRINTER			3		// Device is a printer

// PM_CTLSETIMAGEEX and PM_CTLGETIMAGEEX wParam values
#define PAN_IMAGE_CONTRAST                              0
#define PAN_IMAGE_ANTIALIAS                             1
#define PAN_IMAGE_INVERT                                2

// PM_XFRMRECT wParam values
// The following tow constants are used by the PM_XFRMRECT message
// to indicate if we are to use the function as defined or if we need
// to use the inverse function. This happen for instance when we set a rotation
// we will use the XFRM_FNC but when we want to get the untransformed
// data we call the rotate function with XFRM_FNC_RECIPROCAL.
#define XFRM_FNC                						0
#define XFRM_FNC_RECIPROCAL     						1

// PM_CTLREGEN wParam values
#define	PAN_CLEARLAYERS									0x01
#define	PAN_CLEARBLOCKS									0x02
#define	PAN_CLEARXREFS									0x03
#define	PAN_CLEARVIEWS									0x04
#define	PAN_CLEARVIEWEXTENTS							0x08
#define	PAN_FITVIEWEXTENTS								0x10

// PM_CTLSETPAGE lParam values
#define	PAN_PRESERVEVIEWEXTENTS							0x00000001L
#define	PAN_REMOVECURRENT								0x00000002L

// Control clipboard formats.
// Not all formats apply to a given control type.  Since the type of a control
// depends on the most recently rendered file, use PM_CTLGETCLPBRDFMTS
// to get an up-to-date list of supported formats.
#define PAN_CTLCLPBRDDIB                0x00000001  // Windows CF_DIB
#define PAN_CTLCLPBRDBITMAP             0x00000002  // Windows CF_BITMAP
#define PAN_CTLCLPBRDPALETTE            0x00000004  // Windows CF_PALETTE
#define PAN_CTLCLPBRDMETAFILE           0x00000008  // Windows CF_METAFILEPICT
#define PAN_CTLCLPBRDTEXT               0x00000010  // Windows CF_TEXT
#define PAN_CTLCLPBRDRTF                0x00000020  // Rich Text Format
#define PAN_CTLCLPBRDCOMMA              0x00000040  // comma-separated list of fields
#define PAN_CTLCLPBRDDBASE              0x00000080  // DBase format
#define PAN_CTLCLPBRDHEADINGS           0x00000100  // include headings
#define PAN_CTLCLPBRDBIFF               0x00000200  // BIFF format

// Control status.
#define PAN_CTLSTATUSIDLE				0x00000000
#define PAN_CTLSTATUSPROCESSING			0x00000001
#define PAN_CTLSTATUSREADING			0x00000002
#define PAN_CTLSTATUSREFRESHING			0x00000004
#define PAN_CTLSTATUSREGENERATING       0x00000008
#define PAN_CTLSTATUSREADINGFINISHED    0x00000010
#define PAN_CTLSTATUSRESTOREFAILED		0x00000020

// Control capabilities.
#define PAN_CTLCAPSZOOM                 0x00000001
#define PAN_CTLCAPSCOPY                 0x00000002
#define PAN_CTLCAPSSEARCH               0x00000004
#define PAN_CTLCAPSPAGE                 0x00000008
#define PAN_CTLCAPSSIZE                 0x00000010
#define PAN_CTLCAPSHSCROLL              0x00000020
#define PAN_CTLCAPSVSCROLL              0x00000040
#define PAN_CTLCAPSMOUSE                0x00000080
#define PAN_CTLCAPSKEYBD                0x00000100

// Control modes.
#define PAN_CTLMODEOPAQUE               	0x00000001
#define PAN_CTLMODENOREDRAW             	0x00000002
#define PAN_CTLMODEEXCESSSCROLL         	0x00000004
#define PAN_CTLMODEANISOTROPIC          	0x00000008
#define PAN_CTLMODEDRAGDROP             	0x00000010
#define PAN_CTLMODEINTERRUPTIBLE        	0x00000020
#define PAN_CTLMODESPREADSHEET_NOGRID   	0x00000040		// Not implemented.
//#define PAN_CTLMODESPREADSHEET_NOHEADERS  0x00000080		// Do not Show Row/Column headers.
															// Implemented for rendering only.
#define PAN_CTLMODEMONOCHROME				0x00000100
#define PAN_CTLMODEPRESERVECLIP				0x00000200		// Used strictly for rendering.
#define PAN_CTLMODEPRESERVEPALETTE			0x00000400		// Used striclty for rendering.
#define PAN_CTLMODEIGNOREMINMARGINS			0x00000800		// Used striclty for printing.

#define PAN_CTLMODEPERSPECTIVE				0x00001000		// 3D control only.

#define PAN_CTLMODESPREADSHEET_NORHEADERS   0x00002000		// Do not Show Row headers.
#define PAN_CTLMODESPREADSHEET_NOCHEADERS   0x00004000		// Do not Show Column headers.
#define PAN_CTLMODESPREADSHEET_NOHEADERS   (PAN_CTLMODESPREADSHEET_NORHEADERS | \
											PAN_CTLMODESPREADSHEET_NOCHEADERS)

#define	PAN_CTLMODERENDERSELECTED			0x00008000		// When set, only selected entities are rendered.

#define PAN_CTLMODESPREADSHEET_NOFIRSTRCSNAP   0x00010000	// Disable snapping to start of first
															// row/col when rendering spreadsheet.
															// i.e. can render starting from the middle
															// of a row/col.  Only supported if the
															// row/col headers are disabled.

#define PAN_CTLMODERENDERTOPRINTER				0x00020000		// Render mode which gives the same output as for a printer
															// even when the actual render DC is not a printer DC.
														
#define PAN_CTLMODELIMITTOONETILE			0x00040000		// Used striclty for printing

#define PAN_CTLMODEPMIRENDERMODE_2D			0x00100000		// PMI rendering mode: 2D = force 2D mode for entities supporting it
#define PAN_CTLMODEPMIRENDERMODE_3D			0x00200000		// PMI rendering mode: 3D = force 3D mode for entities supporting it
#define PAN_CTLMODEPMIRENDERMODE_ALL        (PAN_CTLMODEPMIRENDERMODE_2D | PAN_CTLMODEPMIRENDERMODE_3D)

#define PAN_CTLMODE_HIGHLIGHT_DIMMED		0x00400000		// Dimmed highlight mode.
#define PAN_CTLMODE_DISABLE_FORCETOBLACK_ONRASTER			0x00800000
#define PAN_CTLMODE_TILE                    0x01000000		// CMF tile mode
#define PAN_CTLMODE_FORCE_BKG_PAINT         0x02000000
#define PAN_CTLMODE_FAST_PMI                0x04000000

//Note If you add a mode here, add it to the CTL_ALLMODES constant too

// SHADED VIEW hint.
#define	CTL_FILE_HINT_SHADEDVIEW		PAN_VectorShadedView
// EDAT support hint.
#define	CTL_FILE_HINT_EDAT				PAN_VectorSupportsEdat
// ACAD support hint
#define	CTL_FILE_HINT_FROZENLAYERS		PAN_VectorFrozenLayers
// Pdf set new page through scroll hint.
#define	CTL_FILE_HINT_VSCROLLPAGE		PAN_VectorVScrollPage
// Does drawing have its own background.
#define	CTL_FILE_HINT_OWNBACKGROUND		PAN_VectorTrueColor
// Decoder sent Mesh support hint
#define	CTL_FILE_HINT_MESH				PAN_VectorMesh
// Decoder supports Mesh
#define	CTL_FILE_HINT_SUPPORTSMESH		PAN_VectorSupportsMesh
// Decoder supports BRep
#define	CTL_FILE_HINT_SUPPORTSBREP		PAN_VectorSupportsBRep
// Some pages are 2D others are 3D.
#define	CTL_FILE_HINT_2DAND3DPAGES		PAN_Vector2DAnd3DPages

// Decoder supports viewpoint feature.
#define	CTL_FILE_HINT_VIEWPOINT			PAN_VectorViewPoint

//max and min zoom
#define PAN_CTLZOOMMAX 100.0
#define PAN_CTLZOOMMIN 0.01

// Left mouse-button actions.
enum {
	PAN_CTLLMBNONE,
	PAN_CTLLMBSELECT,
	PAN_CTLLMBZOOM,
	PAN_CTLLMBROTATE,
	PAN_CTLLMBPAN,
	PAN_CTLLMBZOOMINOUT,
	PAN_CTLLMBSPIN,	
};

// Zooming axes.
enum {
	PAN_CTLZOOMX,
	PAN_CTLZOOMY,
	PAN_CTLZOOMBOTH,
	PAN_CTLZOOMALL
};

// Flipping directions.
#define	PAN_CTLFLIPNONE	PAN_FLIPNONE
#define	PAN_CTLFLIPX	PAN_FLIPX
#define	PAN_CTLFLIPY	PAN_FLIPY
#define	PAN_CTLFLIPXY	PAN_FLIPXY


// Coordinate Conversion modes
enum {
	PAN_WORLDCOORD,
	PAN_CLIENTCOORD,
	PAN_LOGICALCOORD,
	PAN_DEVICECOORD,
	PAN_POSTYPE,
	PAN_RANGETYPE,
	PAN_POINTTYPE,
	PAN_PHYSPOINTTYPE
};

// Sort attributes
enum {
	PAN_SORTNONE,
	PAN_SORTUP,
	PAN_SORTDOWN,
	PAN_SORTROWS,
	PAN_SORTCOLS
};

// Coordinate units
#define	CTLUNIT_PIXEL		PAN_UNITPIXEL
#define	CTLUNIT_INCH		PAN_UNITINCH
#define	CTLUNIT_MM			PAN_UNITMM
#define	CTLUNIT_RELATIVE	PAN_UNITRELATIVE	// No longer used.
#define	CTLUNIT_TWIPS		PAN_UNITTWIPS

// wParam for PNM_CTLLINK notification.
enum {
	PAN_CTLLINKSETCURSOR,
	PAN_CTLLINKDBLCLICKED
};

// Miscellaneous.
#define PAGES_UNKNOWN                   0

#define	PAN_CTLMAXSTRING				256		// maximum string length
#define PAN_CTLMAXDESC                  64      // maximum description length
#define PAN_CTLMAXEXTS                  128      // maximum length of extensions string
#define PAN_CTLMAXLAYERS                256     // maximum Number of Layers.
#define PAN_CTLMAXBLOCKS                256     // maximum Number Of Blocks.
#define PAN_CTLMAXVIEWS                 64      // maximum Number Of Views.
#define PAN_CTLMAXOVERLAYS				64		// maximum Number Of Overlays
#define PAN_CTLMAXSELS                  16384   // maximum Number Of Selections.
#define PAN_CTLMAXMULTISEARCHBUFFER     1000    // maximum Number Of founded string positions.

// PM_CTLCONVERT wParam values
#define GET_PAFSEXPORT_IDENTIFYIMAGE_HANDLE             0
#define GET_PAFSEXPORT_QUERYIMAGE_HANDLE                1
#define GET_PAFSEXPORT_IDENTIFY_HANDLE                  2
#define GET_PAFSEXPORT_QUERYFORMAT_HANDLE               3
#define GET_PAFSEXPORT_QUERYSUBFORMAT_HANDLE            4
#define GET_PAFSEXPORT_CONVERTFILE_HANDLE               5
#define GET_PAFSEXPORT_CONVERT_HANDLE                   6
#define GET_PAFSEXPORT_OPTIMIZEPALETTE_HANDLE           7
#define GET_PAFSEXPORT_REDUCECOLORS_HANDLE              8


//******************************************************************************
// STRUCTURES & UNIONS

// RR: 06/06/94
typedef void FAR *LPGENERIC;
typedef struct {
	HDC             hdc;            // Device handle to use when converting to/from device.
	int             type;           // Identify the structure type pointed by lpPtr
	char            from;           // Identify the source coord system
	char            to;             // Identify the destination coord system
	LPGENERIC       lpPtr;          // Point to the values to convert
} PAN_CtlCoordCnvt;

// Position and range unions.

typedef PAN_Point               PAN_CtlPos;
typedef PAN_RectangleRange      PAN_CtlRange;
typedef PAN_Handle				PAN_CtlHandle;

// Overlay / OLE objects
typedef PAN_OBJECT              PAN_CtlObject;

// Caret based coordinate:
typedef struct PAN_CtlCaretPos {
	int     page;
	DWORD   flow;
	DWORD   offset;
} PAN_CtlCaretPos;

typedef struct PAN_CtlCaretRange {
	struct PAN_CtlCaretPos  from;
	struct PAN_CtlCaretPos  to;
} PAN_CtlCaretRange;

typedef struct PAN_CtlDimensions {
	Real            DimWidth;
	Real            DimHeight;
	Real            DimDepth;
} PAN_CtlDimensions;

// Structure used with PM_CTLGETINFO.
typedef struct PAN_CtlInfo {
	PAN_FileType    type;                   // type of control
	WORD            version;                // version number of control
} PAN_CtlInfo;

// Structure used with PM_CTLGETPAGEINFO.
typedef struct PAN_CtlPageInfo {
	BOOL	IsMonochrome;
	BOOL	IsEmpty;
} PAN_CtlPageInfo;

// Structure used with PM_CTLGETFILE.
typedef struct PAN_CtlFileInfo {
	PAN_FileType    type;                   // type of associated control
	char            name[PAN_MAX_PATH];     // full pathname
	DWORD           size;                   // file size in bytes
	DWORD           date;                   // file modification date
	char            desc[PAN_CTLMAXDESC];   // format description
	PAN_CtlRange    dimensions;             // view coordinate dimensions
	WORD            colorDepth;             // color depth
	int             nPages;                 // number of pages
	int             tilex, tiley;           // width/height of tiles
	DWORD			dwHints;				// Hints:  default 0x0000
											// only public hint is CTL_FILE_HINT_EDAT bit.

	struct  {
		PAN_Point       offset;                         // Insertion Point
		PAN_Point       scale;                          // Insertion Scaling
		PAN_Point       dpi;                            // Dots-per-inch resolution
		Real            rot;                            // Insertion rotation (Radians)
		WORD			flip;							// Insertion flipping.
		WORD			units;							// Drawing units.
		int				CurPage;						// Last saved page;
	} ins;                                  // Insertion scaling + offsets
											// zeroed if not applicable.
	unsigned long   ClipCount;              // Number of clip regions in the page.
    BOOL            loadedFromMetafile;     // True if the file is loaded from metafile
} PAN_CtlFileInfo;

// Structure used with PM_CTLSEARCH.
typedef struct PAN_CtlSearchInfo {
	BOOL            	fMulti;                 // IN: Find all occurences.
	BOOL            	fDown;                  // IN: search downward
	BOOL            	fWrap;                  // IN: wrap around end of file
	BOOL            	fCase;                  // IN: match case
	BOOL            	fWord;                  // IN: match whole word
	LPCSTR          	string;                 // IN: string to find
	PAN_CtlCaretPos 	startPos;               // IN: starting file position

	WORD            	fFound;                 // OUT: Number of found occurrences of the string
	WORD				foundCnt;				// OUT:	if > 1 => Total number
												// of entries in hFoundHandle and hFoundBBox.
												// (single search only).
	PAN_CtlCaretPos 	foundPos;               // OUT: found file position
	PAN_CtlHandle		foundHandle;         	// OUT: found string handle
	PAN_CtlPos			foundBBox[4];			// OUT: bounding box of found string.

	HGLOBAL				hFoundCnt;				// OUT: Each entry contains the number of
												// hFoundHandle and hFoundBBox entries
												// corresponding to the particular occurrence
												// of the string (multi-search only) .
	HGLOBAL         	hFoundPos;              // OUT: Global handle to array of
												// PAN_CtlCaretPos structures, one
												// for each occurrence (multi-search only).		
	HGLOBAL         	hFoundHandle;        	// OUT: Global handle to array of
												// PAN_CtlHandle structs.  The number of
												// entries for each found occurrence is
												// stored in hFoundCnt.
	HGLOBAL         	hFoundBBox;             // OUT: Global handle to array of
												// PAN_CtlBoundingBox structs.  The number of
												// entries for each found occurrence is
												// stored in hFoundCnt.
} PAN_CtlSearchInfo;


// wParam values for PM_CTLGETFILE
#define	PAN_CTLGETFILEPROPS			1

// wParam values for PM_CTLGETLIGHT/PM_CTLSETLIGHT
#define	PAN_CTLSETDEFAULTLIGHTING	-2
#define	PAN_CTLAMBIENTLIGHT			-1
#define	PAN_CTLNEWLIGHT				0

// wParam values for PM_CTLSETCLIPPLANES
#define	PAN_CTLFRONTCLIPPLANE	0
#define	PAN_CTLBACKCLIPPLANE	1
#define	PAN_CTLBOTHCLIPPLANES	2

typedef struct tagPAN_CtlEntityID {
	DWORD 		entID;		// ID of VCET entity (NULL => Current page).
	const void 	*ID;		// Sub-Entity ID e.g. if entID references a BODY,
							// ID can reference a body sub-entity (face, vertex,
							// edge...).  Set to NULL if not referencing any
							// particular sub-entity.
} PAN_CtlEntityID, *LPPAN_CtlEntityID;

// wParam for PM_CTLGETENTITYINFO
#define	PAN_CTLENTITYTYPE			1
#define	PAN_CTLENTITYBBOX			2
#define	PAN_CTLENTITYPARENT			3
#define	PAN_CTLENTITYCHILDREN		4
#define	PAN_CTLENTITYGEOMETRY3D		5
#define	PAN_CTLENTITYDISPLAYPLANE	6
#define	PAN_CTLENTITYINFO	        7
#define PAN_CTLENTITYGEOMETRYDIM	8
#define PAN_CTLENTITYSMTYPE			9

/*
**	Structure used with PM_CTLGETENTITYINFO when wParam = PAN_CTLENTITYTYPE
*/
typedef struct tagPAN_CtlEntityType {
	PAN_CtlEntityID EntityID;		// In: Entity ID	
	DWORD			dwEntType;		// Out:  Entity type.a
	DWORD			dwEntSubType;	// Out:  Entity subtype
} PAN_CtlEntityType;

// Entity type definitions.
enum PanCtlEntityType
{
	PAN_CTLENTITYTYPE_UNKNOWN,
	PAN_CTLENTITYTYPE_PAGE,
	PAN_CTLENTITYTYPE_ASSEMBLY,
	PAN_CTLENTITYTYPE_PART,
	PAN_CTLENTITYTYPE_BODY,
	PAN_CTLENTITYTYPE_PMI,
	PAN_CTLENTITYTYPE_WIRE,
	PAN_CTLENTITYTYPE_FACE,
	PAN_CTLENTITYTYPE_EDGE,
	PAN_CTLENTITYTYPE_VERTEX,
};

// Entity subtypes.
enum PanCtlEntitySubType
{
	PAN_CTLSUBENTITYTYPE_UNKNOWN,
	PAN_CTLSUBENTITYTYPE_COORDINATESYSTEM,
	PAN_CTLSUBENTITYTYPE_DATUMFEATURESYMBOL,
	PAN_CTLSUBENTITYTYPE_DATUMTARGET,
	PAN_CTLSUBENTITYTYPE_DIMENSION,
	PAN_CTLSUBENTITYTYPE_FEATURECONTROLFRAME,
	PAN_CTLSUBENTITYTYPE_LINEWELD,
	PAN_CTLSUBENTITYTYPE_LOCATOR,
	PAN_CTLSUBENTITYTYPE_MEASUREMENTPOINT,
	PAN_CTLSUBENTITYTYPE_NOTE,
	PAN_CTLSUBENTITYTYPE_REFERENCEGEOMETRY,
	PAN_CTLSUBENTITYTYPE_SPOTWELD,
	PAN_CTLSUBENTITYTYPE_SURFACEFINISH,
	PAN_CTLSUBENTITYTYPE_WIRE,
};

/*
**	Structure used with PM_CTLGETENTITYINFO when wParam = PAN_CTLENTITYBBOX
*/
typedef struct tagPAN_CtlEntityBBox {
	PAN_CtlEntityID		EntityID;	// In: Entity ID
	DWORD				dwFlags;	// In: Option flags
	union {
		PAN_CtlRange	bbox;		// Out: Entity's bounding box.
		void*			pOBB;       // Out: Pointer to a
                                    // CPanOrientedRange class :
                                    // Entity's oriented bounding box.
	};
} PAN_CtlEntityBBox;

// Flags for PAN_CTLEntityBBox.
#define	PAN_CTLENTBBOX_UNTRANSFORMED	0x00000001L
#define PAN_CTLENTBBOX_ORIENTED			0x00000002L

/*
**	Structure used with PM_CTLGETENTITYINFO when wParam = PAN_CTLENTITYPARENT
*/
typedef struct tagPAN_CtlEntityParent {
	PAN_CtlEntityID	EntityID;			// In: Entity ID	
	DWORD			dwFlags;			// In: Option flags.	
	DWORD			parentType;			// In: Return ID only if parent is of this type.	
	PAN_CtlEntityID	parentID;			// Out: ID of parent or predecessor.
} PAN_CtlEntityParent;

// Flags for PAN_CtlEntityParent.
#define	PAN_CTLENTPARENT_PREDECESSOR	0x00000001L	// Check all predecessors (used if parentType is set).

/*
**	Structure used with PM_CTLGETENTITYINFO when wParam = PAN_CTLENTITYCHILDREN
*/
typedef struct tagPAN_CtlEntityChildren {
	PAN_CtlEntityID	EntityID;		// In: Entity ID	
	DWORD			dwFlags;		// In: Option flags.	
	DWORD			childType;		// In: Type of child or descendent to return.
	ULONG			numChildren;	// Out:  Number of children or descendents.
	HGLOBAL			hChildren;		// Out:  Buffer of child or descendent IDs.
									// each entry if of type PAN_CtlEntityID.
} PAN_CtlEntityChildren;

// Flags for PAN_CtlEntityChildren.
#define	PAN_CTLENTCHILDREN_DESCENDENTS	0x00000001L	// Return all descendents
#define	PAN_CTLENTCHILDREN_COUNTONLY	0x00000002L	// Only return the number, do not return the IDS.

/*
**	Structure used with PM_CTLGETENTITYINFO when wParam = PAN_CTLENTITYDISPLAYPLANE
*/
typedef struct tagPAN_CtlEntityDisplayPlane {
	PAN_CtlEntityID	EntityID;		// In: Entity ID	
	WORD			wFlags;			// Out: Validity flags, indicating if the
									//  origin point and direction (x- and y- axis)
									//  are valid or not.
	PAN_Point		origin;			// Out: Origin point
	PAN_Point		xAxis;			// Out: x-axis of the display plane
	PAN_Point		yAxis;			// Out: y-axis of the display plane
} PAN_CtlEntityDisplayPlane;

// Validity flags for PAN_CtlEntityDisplayPlane.
#define PAN_CTLENTDISPLAYPLANE_VALIDORIGIN		0x0001
#define PAN_CTLENTDISPLAYPLANE_VALIDDIRECTION	0x0002

// Structure used as lParam for PM_CTLGETENTITY
typedef struct PAN_CtlGetEntityInfo {
	PAN_CtlRange	 	bbox;            		// IN: bounding box of search in world coordinates.
	int					iThreshold;				// IN: Threshold for search in screen coordinates
												// if bbox.max == bbox.min

	DWORD            	nFound;              	// OUT: number of entities found.
	HGLOBAL         	hFound;        			// OUT: Global handle to a buffer
												// of found entities:  Information
												// is stored as PAN_CtlEntity or
												// PAN_CtlEntityProps depending
												// on wParam.
} PAN_CtlGetEntityInfo, FAR *LPPAN_CtlGetEntityInfo;

// wParam values for PM_CTLGETENTITY.
#define	PAN_CTLGETENTHANDLE		0
#define	PAN_CTLGETENTPROPS		1
#define	PAN_CTLGETENTSNAP		2
#define PAN_CTLGETENT3D			3
#define PAN_CTLGETHYPERLINK		4

// Structure used with PM_CTLGETENTITY when wParam == PAN_CTLGETENTHANDLE
typedef struct PAN_CtlEntity {
	int					inslevel;
	PAN_CtlHandle		handle[1];	// Sequence of (inslevel+1) handles.
} PAN_CtlEntity, FAR *LPPAN_CtlEntity, huge *HPPAN_CtlEntity;

// Structure used with PM_CTLGETENTITY when wParam == PAN_CTLGETENTPROP
typedef struct PAN_CtlEntityProps {
	LONG	Color;					// Line and Fill Colors interpreted as fllows:
	LONG	FillColor;				// if RGB Colors:  RGB value or -1 for Transparent.
									// else :	> 0		=> Index into drawing palette.
									//			== -1	=> Transparent.
									//			== -2	=> Current Background color.
									//			== -3	=> White RGB(255, 255, 255).
									//			== -4	=> Black RGB(0, 0, 0).	
	
	Real	Thickness;				// LineType Thickness interpreted as follows:
									//	> 0		=> Zoom dependent thickness given in world coords.
									//	<= 0	=> Fixed thickness given pixels.	 
} PAN_CtlEntityProps, FAR *LPPAN_CtlEntityProps, huge *HPPAN_CtlEntityProps;


// Definitions and Structures used with PM_CTLSHOWENTITY when wParam = 0
// i.e. 2D ShowEntity.
#define	PAN_CTLSHOWENTITYRESET		0x00000001L		// Use entity's own colors.	
#define	PAN_CTLSHOWENTITYSETCOLOR	0x00000002L		// Use color specified in the struct.
#define	PAN_CTLSHOWENTITYXOR		0x00000004L		// XOR color with background color:
													// Can be combined with PAN_CTLSHOWENTITYSETCOLOR.
#define	PAN_CTLSHOWENTITYBLOCK  	0x00000008L		// SHOW all this block insertion
#define	PAN_CTLSHOWENTITYXREF	  	0x00000010L		// SHOW all this xref insertion

typedef struct PAN_CtlShowEntity {
	PAN_CtlHandle	handle;						// Entity handle.
	DWORD			dwFlags;					// Bit flags: Combination of PAN_CTLSHOWENTITYXXX
	COLORREF		Color;						// RGB color.
} PAN_CtlShowEntity, FAR *LPPAN_CtlShowEntity;

// Structures used with PM_CTLGETFILEFMTS.
typedef struct PAN_CtlFileFmtList {
	WORD            nFmts;          // number of formats
	HGLOBAL         hFmts;          // global handle to array
					// of PAN_CtlFileFmt structures
} PAN_CtlFileFmtList;

typedef struct PAN_CtlFileFmt {
	char            desc[PAN_CTLMAXDESC];   // format description
	char            exts[PAN_CTLMAXEXTS];   // file extensions, e.g. ".bmp.dib"
} PAN_CtlFileFmt;


// Structures used with PM_CTLGETCLPBRDFMTS.
typedef struct PAN_CtlClpbrdFmtList {
	WORD            nFmts;          // number of formats
	HGLOBAL         hFmts;          // global handle to array
					// of PAN_CtlClpbrdFmt structures
} PAN_CtlClpbrdFmtList;

typedef struct PAN_CtlClpbrdFmt {
	WORD    fmt;                    // one of PAN_CTLCLPBRD*
	char    desc[PAN_CTLMAXDESC];   // format description
} PAN_CtlClpbrdFmt;

// Defines for wParam of PM_CTLSETSELXXX messages.
#define	PAN_CTLSELACTION_DEL		0	// Remove from selection.  All PM_CTLSETSELXXX messages (must be zero for backward compatibility).	
#define	PAN_CTLSELACTION_ADD		1	// Add to selection.  All PM_CTLSETSELXXX messages.
#define	PAN_CTLSELACTION_SET		2	// Make this the current selection: Only supported by 3D vector control.
#define	PAN_CTLSELACTION_INVERT		3	// Toggle selection state:  Only supported by 3D vector control. 
#define	PAN_CTLSELACTION_SETNOTSEL	4	// Same as SET but does nothing if already selected:  Only supported by 3D vector control. 

// Structures used with PM_CTLGETSELS.
#define PAN_CTLSELECTION_VIEW           0
#define PAN_CTLSELECTION_CARET          1
#define PAN_CTLSELECTION_ENTITY         2


typedef struct PAN_CtlSelList {
	WORD            nSels;          // number of selections
	HGLOBAL         hSels;          // global handle to array
					// of PAN_CtlSel structures
} PAN_CtlSelList;

// MODIFIED for version 1.2.
typedef struct PAN_CtlSel {
	int                             selType;
	union {
		PAN_CtlRange            vwRange;        // range based on view coordinates.
		PAN_CtlCaretRange       ctRange;        // caret based range
		PAN_CtlEntityID			EntityID;		// specific entity ID.
	} range;
} PAN_CtlSel;

// Structure used with PM_CTLRENDERONTODC.
typedef struct PAN_CtlBrush {	// Brush struct:  Same as LOGBRUSH.
	DWORD     		Style;
	COLORREF 		Color;
	LONG     		Hatch;
} PAN_CtlBrush;

typedef struct PAN_CtlRenderOptions {
	HDC             hdc;    // Context of device on which to render.
	PAN_CtlRange    source; // Region to be rendered.
	DWORD           mode;   // PAN_CTLMODEOPAQUE | PAN_CTLMODEANISOTROPIC | PAN_CTLMODE_DISABLE_FORCETOBLACK_ONRASTER.
							// IF spreadsheet
							// PAN_CTLSPREADSHEET_NOHEADERS
	RECT            devRect;// Rectangle on device in which to fit selection.
	
	int				xDevRes;// Desired resolution.  Set to zero for default.
	int				yDevRes;

	/*
	** Buffer to store scale values for fixed width thick lines.
	** Used as an additional scale for the line width when rendering.
	*/
	WORD			numFixedWidthScale;
	Real	FAR		*lpFixedWidthScale;

	/*
	** Buffer used to store pen thickness (pen index corresponds to entity
	** line color index).  Used to add thickness to entities when rendering.
	** Thicknesses are specified in pixels.
	*/
	WORD			numPens;
	LPWORD			lpPenThickness;
} PAN_CtlRenderOptions;

// Alignment values for PAN_CtlPrintOptions
typedef enum PanCtlPrintAlignment {
	Custom = 0,
	TopLeft,
	TopCenter,
	TopRight,
	MiddleLeft,
	MiddleCenter,
	MiddleRight,
	BottomLeft,
	BottomCenter,
	BottomRight
} PanCtlPrintAlignment;

// Structure used in PAN_CtlPrintOptions.
typedef struct PAN_CtlPrintPreview {
	int             nPages;         // number of physical pages
	WORD            nHorzPages;     // number of physical pages horizontally
					// across image
	WORD            nVertPages;     // number of physical pages vertically down image
	LONGRECT        allPagesRect;   // rectangle of all pages in device units
	RECT			deviceRect;	// page rectangle of the device.
	HGLOBAL         imageRects;     // global handle to array of PAN_CtlRange structures:
					// image rectangles within page rectangles (in world coordinates).
	HGLOBAL         clipRects;      // global handle to array of RECT structures:
					// page rectangles excluding margins and
					// header/footers (in device coordinates)
	int             headerHeight;   // height of header in device coordinates
	int             footerHeight;   // height of footer in device coordinates
	BOOL            systemFontUsed; // TRUE if system font is used
	double          scale;          // relative scaling factor
} PAN_CtlPrintPreview;

// Structure used with PM_CTLPRINT.
typedef struct PAN_CtlPrintOptions {
	PRINTDLG FAR    *printDlg;      // input: common dialog options
	WORD            units;          // input: one of PAN_CTLUNIT*
	double          nImageUnits;    // input: number of image units per
	double          nPaperUnits;    // input: number of paper units
	PAN_CtlRange    source;         // input: area to be printed
	DWORD		mode;		// RR: 09/23/94> IF spreadsheet
					// PAN_CTLSPREADSHEET_GRID | PAN_CTLSPREADSHEET_FRAME

	PanCtlPrintAlignment alignment;       // input: alignment on page(s)
	PHYSPOINT            alignmentCustom; // input: Custom alignment (if alignment == CUSTOM)

	struct {
		WORD            units;  // input: one of PAN_CTLUNIT*
		double          top;
		double          left;
		double          bottom;
		double          right;
	} margins;                      // input: margins

	struct {
		// A header string can contain any of the following escape sequences.
		//
		// %f           full pathname
		// %v           drive letter
		// %d           directory name
		// %b           file basename
		// %e           file extension
		// %p           current page
		// %n           number of pages
		// %%           percent sign

		LOGFONT         font;
		LPCSTR          topLeftText;
		LPCSTR          topCtrText;
		LPCSTR          topRightText;
		LPCSTR          botLeftText;
		LPCSTR          botCtrText;
		LPCSTR          botRightText;
	} headers;								 // input: header strings

	LPCSTR                  outputFileName;	// input: output file name

	PAN_CtlPrintPreview printPreview;       // output: preview information
} PAN_CtlPrintOptions;

/*
**
** New structure for PAN_CTLSORT message.
**
*/
typedef struct PAN_CtlSortInfo {
	PAN_CtlCaretRange       sortRange;      // IN: sort region.
	WORD                    sortBy;         // IN: One of PAN_SORTROWS or
											//   PAN_SORTCOLS.
	PAN_CtlCaretPos         sortKey1;       // IN: Row or column to sort by.
	WORD                    sortDir1;       // IN: One of PAN_SORTUP or
											//   PAN_SORTDOWN.
	PAN_CtlCaretPos         sortKey2;       // IN: Row or column to sort by.
	WORD                    sortDir2;       // IN: One of PAN_SORTUP or
											//   PAN_SORTDOWN.
	PAN_CtlCaretPos         sortKey3;       // IN: Row or column to sort by.
	WORD                    sortDir3;       // IN: One of PAN_SORTUP or
											//   PAN_SORTDOWN.
} PAN_CtlSortInfo;

typedef struct tagPAN_CtlDisplayList {
	// Display list
	DWORD		dwFlag;		// Options
	int         ListIndex;	// In: band number
	void *		pList;		// Out: list of metafile records (CPanStorage *)

	// Font cache (in and out)
	int			numEntries;
	int			nBufSize;
	HGLOBAL		hBuffer;

	// In: Optional filter related to display list type
	// PAN_CTLDISPLAYLIST_ENTITYSET: IVec2DEntitySet *
	// Other types: NULL
	void *		pFilter;
} PAN_CtlDisplayList;

struct PAN_CtlBand {
	/* Input */
	// Bandlist index
	unsigned long nBandListIndex;
	// Band index
	unsigned long nBandIndex;
	
	/* Output */
    // Extended band data (CPanStorage *, must not be NULL)
	void *        pBand;
	
	/* Input/Output */
	// Opaque raw byte buffer representing the state of the CMF streaming.
	// (std::vector<unsigned char> *, pointer must not be NULL,
	// set to empty vector initially)
	void *        pStreamingState;

	/* Input/Output */
	// Character glyphs cache.
	// (CPan2DCharCache *, pointer must not be NULL,
	// set to an new CPan2DCharCache initially)
	void * pCharacterGlyphCache;
};

// Bezier to PolyPoint option (for dwFlag)
#define	PAN_CTLBEZIERTOPOLY			0x00000001
#define	PAN_CTLPOLYPOLYGONTOPOLY	0x00000002

// Display list type flags (for dwFlag)
#define	PAN_CTLDISPLAYLIST_TYPE			0xF0000000
#define PAN_CTLDISPLAYLIST_BAND			0x00000000
#define PAN_CTLDISPLAYLIST_ENTITYSET	0x10000000
#define PAN_CTLDISPLAYLIST_BLOCK		0x20000000 // Not supported yet
#define PAN_CTLDISPLAYLIST_LAYER		0x30000000 // Not supported yet
#define PAN_CTLDISPLAYLIST_HYPERLINK	0x40000000 // Not fully supported yet

typedef struct tagPAN_CtlLineStyle {
				int		iStyle;
				int		nElements;
				Real	FAR * lpRElement;				
				Real	Scale;
				DWORD	dwFlags;
				WORD    wDashLength;
								
} PAN_CtlLineStyle, FAR * LPPAN_CtlLineStyle;

////////////////////////////////////////////////////////////////////////////
// 3D Control Structures
///////////////////////////////////////////////////////////////////////////

typedef struct tagPAN_CtlRotation {
	Real		Angle;		
	PAN_Point	AxisDir;	// Direction of the axis of revolution.
	PAN_Point	Center;		// Center of rotation.
	BOOL		fReset;		// Revert to the original position.
} PAN_CtlRotation, * LPPAN_CtlRotation;

typedef struct tagPAN_CtlLightSource {
	COLORREF	Color; // diffuse color
	COLORREF	SpecularColor; // specular color
	PAN_Point	Position;
	BOOL		fEnable;
} PAN_CtlLightSource, * LPPAN_CtlLightSource;

// Mass prop structure.								
typedef struct tagPAN_CtlMassProps {
	int				numEntities;			//IN
	PAN_CtlEntityID	*pEntityID;				//IN
	DWORD			PropsFlags;				//IN/OUT
	Real			Density;				//IN: Density value interpreted as folows:
											// < 0	=> Use always.  Overrides entity's own density.
											// > 0	=> Use as default if entity does not have a density attribute.
											// = 0	=> Do not apply density to the results.
	int				MassUnits;				//IN: Density mass units
	int				LengthUnits;			//IN: Density Volume units.  Must be
											//the same as the file units.  Application
											//should set this to its own default units
											//if the file units are set to PAN_UNITUNKNOWN.
	Real			RelAccuracy;			//IN: Requested relative accuracy. Not used when asking for Length
	Real			Mass;					//OUT: (in MassUnits)
	Real			Length;					//OUT: (in LengthUnits)
	Real			Volume;					//OUT: (in LengthUnits^3)
	Real			SurfaceArea;			//OUT: (in LengthUnits^2)
	PAN_Point		Centroid;				//OUT: Center of gravity (in LengthUnits)
	PAN_Point		MomentInertia;			//OUT: Principle moment of inertia (in MassUnits * LengthUnits^2)
 	PAN_Point		PrincipleAxes[3];		//OUT: Principle Axes. 
	Real			Tensor[3][3];			//OUT: Inertia tensor(in MassUnits * LengthUnits^2)
	short           fValidityFlags;         //OUT: one bit to indicate property validity
	
} PAN_CtlMassProps, *LPPAN_CtlMassProps;

typedef struct tagPAN_CtlEntityHeader {

	PAN_CtlEntityID	Handle;			
	DWORD			Type;			

} PAN_CtlEntityHeader; 

// wParam values for PM_CTLGETMINDISTANCE.
#define PAN_CTLGETMINIMUMDISTANCE3D     0
#define PAN_CTLGETENTITYMINIMUMDISTANCE 1

// wParam values for 2D requests
#define PAN_CTL2DREQUEST     0
#define PAN_CTL3DREQUEST     1

// flags for mindist
#define PAN_MINDIST_USE_MESH_ONLY		0x00000100		/** if true, no BRep is used for mindist computation */

typedef struct tagPAN_CtlMinDistance {
	PAN_CtlEntityHeader		*pEntity1;			//IN
	int						nCountID1;			//IN
	PAN_CtlEntityHeader		*pEntity2;			//IN
	int						nCountID2;			//IN

	DWORD					dwFlags;			//IN/OUT

	PAN_CtlEntityHeader		OutEntity1;			//OUT
	PAN_CtlEntityHeader		OutEntity2;			//OUT

	PAN_Point				pos1;				//OUT
	PAN_Point				pos2;				//OUT
		
	Real					Distance;			//OUT

} PAN_CtlMinDistance, *LPPAN_CtlMinDistance;

typedef struct tagPAN_CtlGetSectEdges 
{
		ULONG			entID;
		
		HGLOBAL			hSecEdges;
		
		int				nEdges;
		
		DWORD			dwFlags;

		PAN_CtlRange	BBox;

		
} PAN_CtlGetSecEdges, FAR* LPPAN_CtlGetSecEdges;

// Built-in edge types:
enum {
	EDGETYPE_NULL,
	EDGETYPE_LINE,
	EDGETYPE_CIRCLE,
	EDGETYPE_ELLIPSE,	
	EDGETYPE_ARC,
	EDGETYPE_POLY,
	EDGETYPE_SPLINE
};

// Common Edge info.
typedef	struct {
	int				Type;				// Entity type.

	COLORREF 		LineColor;			// Line color.
	COLORREF 		FillColor;			// Fill color.
	int				FillType;			// Fill type:  None, Solid, Transparent.

	int				PenStyle;			// Pen style.
	Real			PenWidth;			// Pen width.

} PAN_EDGEHEADER, FAR *LPPAN_EDGEHEADER;

// Entity specific info.
typedef struct	{
	PAN_Point	StartPt;	// Start point.
	PAN_Point	EndPt;		// End point.

} PAN_EDGE_LineInfo, FAR *LPPAN_EDGE_LineInfo;

typedef struct	{
	LONG		numPts;				// Number of points.
	PAN_Point	huge *pPoints;		// Buffer of points.

} PAN_EDGE_PolyInfo, FAR *LPPAN_EDGE_PolyInfo;

// Spline flags.
#define	PAN_SPLINE_CLOSED			0x00000001
#define	PAN_SPLINE_PERIODIC			0x00000002
#define	PAN_SPLINE_RATIONAL			0x00000004
#define	PAN_SPLINE_PLANAR			0x00000008
#define	PAN_SPLINE_LINEAR			0x00000010

typedef struct	{
	DWORD		dwFlags;
	int			Degree;
	int			nCtrlPts;
	int			nKnots;
	int			nWeights;
	int			nFitPts;
	PAN_Point	*pCtrlPts;
	Real		*pKnots;
	Real		*pWeights;
	PAN_Point	*pFitPts;
	PAN_Point	StTangent;
	PAN_Point	EndTangent;
	PAN_Point	Normal;		//Present only if the spline is planar

} PAN_EDGE_SplineInfo, FAR *LPPAN_EDGE_SplineInfo;

typedef struct	{
	PAN_Point	Center;
	Real		Radius;
	Real		StAngle;
	Real		EndAngle;	

} PAN_EDGE_ArcInfo, FAR *LPPAN_EDGE_ArcInfo;

typedef struct	{
	PAN_Point	Center;
	PAN_Point	Major_Axis;
	PAN_Point	Normal;
	Real		Ratio;
	Real		StParam;
	Real		EndParam;	

} PAN_EDGE_EllipseInfo, FAR *LPPAN_EDGE_EllipseInfo;

typedef struct	{
	PAN_Point	Center;	
	Real		Radius;	
} PAN_EDGE_CircleInfo, FAR *LPPAN_EDGE_CircleInfo;

// Actual Specifications of an Edge
typedef struct {

	PAN_EDGEHEADER	header;

	union	{
		PAN_EDGE_LineInfo		Line;
		PAN_EDGE_PolyInfo		Poly;
		PAN_EDGE_ArcInfo		Arc;
		PAN_EDGE_CircleInfo		Circle;
		PAN_EDGE_EllipseInfo	Ellipse;
		PAN_EDGE_SplineInfo		Spline;
	} Edge;

} PAN_CtlEdgeInfo, FAR *LPPAN_CtlEdgeInfo;

//Sectioning plane action types
typedef enum enumPanSPActionType {
	PAN_SPACTION_SET = 0,
	PAN_SPACTION_DEL,
	PAN_SPACTION_DISABLE,
	PAN_SPACTION_ENABLE
} PanSPActionType;

// Section plane options
#define PAN_SPOPTION_INVERT		    0x00000001
#define PAN_SPOPTION_EDGESONLY	    0x00000002
#define PAN_SPOPTION_SHOWEDGES	    0x00000004
#define PAN_SPOPTION_BOTH	  	    0x00000008
#define PAN_SPOPTION_UPDATE		    0x00000010
#define PAN_SPOPTION_SHADED		    0x00000020
#define PAN_SPOPTION_NO_PROPAGATE	0x00000040

typedef struct tagPAN_CtlSecPlane {
	ULONG		entID; 		//0 - means the whole model
	PAN_Point	Point;
	PAN_Point	Normal;	
	PanSPActionType action;
	DWORD		dwOptions;
	COLORREF	edgeColor;
} PAN_CtlSecPlane, *LPPAN_CtlSecPlane;

// Show entity action type
enum PanSEActionType {
	PAN_SEACTION_SET = 0,
	PAN_SEACTION_ADD,
	PAN_SEACTION_DEL,
	PAN_SEACTION_DELALL,
	PAN_SEACTION_ENABLE,
	PAN_SEACTION_DISABLE,
	PAN_SEACTION_DELETEENTITY,
};

#define PAN_SEOPTION_BBOX  		0x00000001
#define PAN_SEOPTION_COLOR  	0x00000002

// Structure used with PM_CTLSHOWENTITY when wParam = 1 i.e. (3D ShowEntity).
typedef struct tagPAN_CtlShow3DEntity {
	PAN_CtlEntityID	EntityID;
	
	int 		nPage;

	WORD		Action;		// PanSEActionType

	DWORD		dwOptions;
	
	DWORD		dwTopology;
	DWORD		dwGeometry;
	
	COLORREF	rgbColor;
	
} PAN_CtlShow3DEntity, FAR *LPPAN_CtlShow3DEntity;

typedef struct tagPAN_CtlGetSecPlane {
	ULONG	entID;
	BOOL 	fGetOnlyNumber;
	int		nPlanes;	
	HGLOBAL	hSecPlanes;

	BOOL	fGetFaces;	// [IN] return faces of a shaded section
	int		nFaces;		// [OUT] number of faces
	HGLOBAL	hSecFaces;	// [OUT] array of faces
} PAN_CtlGetSecPlane, FAR* LPPAN_CtlGetSecPlane;


// wParam values for PM_CTLENUMENTITIES
#define PAN_CTLENUMCUSTOMCALLBACK   0
#define PAN_CTLENUMENTITYINFO       1


#if	TARGET == WIN32S
typedef	LRESULT  (__stdcall *CTLENUMENTPROC)(WPARAM, LPARAM, LPVOID);
#else
typedef	LRESULT  (PCALLBACKFN *CTLENUMENTPROC)(WPARAM, LPARAM, LPVOID);
#endif

// Structure used for PM_CTLENUMENTITIES:  Enumerate all the drawing entities
// in the entity specified by EntityID or any of its descendents.
typedef	struct {
	PAN_CtlEntityID	EntityID;		// ID of top level entity to enumerate.
	DWORD			dwType;			// Type of entities to enumerate or ENTTYPE_NULL
									// to enumerate all (Currently unused i.e. all entities
									// are enumerated).
	DWORD			dwFlags;		// Option flags PAN_ENUMENTITIES_XXX
	LPVOID			pData;			// Application specific data to be passed as arg
									// to the callback procedure.
	CTLENUMENTPROC	pCallbackFn;	// Callback procedure.
	double 			SurfTol;		// Custom tolerance for enumerated conversion
} PAN_CtlEnumEntities, FAR * LPPAN_CtlEnumEntities;

// Enum-entities option flags.
#define	PAN_ENUMENTS_STREAMEDMESH		0x00000001
#define	PAN_ENUMENTS_NURBSBREP			0x00000002
#define	PAN_ENUMENTS_NORATIONALNURBS	0x00000004	// No support for rational Nurbs
#define PAN_ENUMENTS_PMI				0x00000008

/*
** PAN_ENUMENTS_MESHEXISTS means we send mesh in pData,
** and no need to create it again. Now can be used only 
** in combination with MESHPROP flag.
*/
#define PAN_ENUMENTS_MESHEXISTS			0x00000008 

// Flags combined with PAN_ENUMENTS_STREAMEDMESH to
// define what additional data have to be computed
#define PAN_ENUMENTS_MESHTEDGE			0x00000010
#define PAN_ENUMENTS_MESHTFACE			0x00000020

#define PAN_ENUMENTS_MESHEDGEGEOM		0x00000040
#define PAN_ENUMENTS_MESHFACEGEOM		0x00000080

#define PAN_ENUMENTS_MESHEDGEPROP		0x00000100
#define PAN_ENUMENTS_MESHFACEPROP		0x00000200
#define PAN_ENUMENTS_MESHGLOBPROP		0x00000400

#define PAN_ENUMENTS_MESHLOOPS			0x00000800

#define PAN_ENUMENTS_MESHTOPOLOGY	   (PAN_ENUMENTS_MESHTEDGE|PAN_ENUMENTS_MESHTFACE)
#define PAN_ENUMENTS_MESHFULLTOPOLOGY  (PAN_ENUMENTS_MESHTOPOLOGY|PAN_ENUMENTS_MESHLOOPS)
#define PAN_ENUMENTS_MESHGEOMETRY	   (PAN_ENUMENTS_MESHEDGEGEOM|PAN_ENUMENTS_MESHFACEGEOM)
#define PAN_ENUMENTS_MESHBREP		   (PAN_ENUMENTS_MESHFULLTOPOLOGY|PAN_ENUMENTS_MESHGEOMETRY)
#define PAN_ENUMENTS_MESHPROP		   (PAN_ENUMENTS_MESHEDGEPROP|PAN_ENUMENTS_MESHFACEPROP|PAN_ENUMENTS_MESHGLOBPROP)
#define PAN_ENUMENTS_COMPLETEMESH	   (PAN_ENUMENTS_MESHBREP|PAN_ENUMENTS_MESHPROP)

// Enum-entities structure
typedef struct tagPAN_CtlEnumEntRecord {
	PAN_CtlEntityID	EntityID;		// ID of entity represented in this record.
	int				Type;			// Record type.
	LPVOID			pData;			// Record data.
} PAN_CtlEnumEntsRecord, FAR *LPPAN_CtlEnumEntsRecord;

// Record types.
enum {
	PAN_ENTRECORD_TRIANGLEMESH = 1,
	PAN_ENTRECORD_STREAMEDMESH,
	PAN_ENTRECORD_NURBSBREP,	
};

// Return Values for the Entity Enumeration Procedure:
// Returned by the Application's Enumeration Procedure,
// invoked with the PAN_CTLENUMENTITIES Message
enum {
	PAN_CTLENUMNULL,		// Do nothing.
	PAN_CTLENUMQUIT,	// Stop enumeration.
	PAN_CTLENUMCONTINUE
};


/*
** Params for PM_CTLSETTRANSFORM & PM_CTLGETTRANSFORM;
*/

// Which Transformation type;
#define	PAN_CTLUNKNOWNTRANSFORM		0L
#define	PAN_CTLMODELTRANSFORM		1L			// Set/Get
#define	PAN_CTLVIEWTRANSFORM		2L			// Get only.
#define	PAN_CTLMODELVIEWTRANSFORM	3L			// Get only.
#define	PAN_CTLUSERTRANSFORM		4L			// Set/Get
#define	PAN_CTLPARTTRANSFORM		5L			// Get only (initial transform).
#define	PAN_CTLCOMPLETETRANSFORM	6L			// Get only.

typedef struct tagPAN_CtlTransform {
	PAN_CtlEntityID		EntityID;
	Hmatrix				hm;
} PAN_CtlTransformInfo, FAR *LPPAN_CtlTransformInfo;

typedef struct tagPAN_CtlArrayEntityID {
	HGLOBAL				hEntityID; //PAN_CtlEntityID array
	int					nNumElements;
	DWORD				dwFlags;
} PAN_CtlArrayEntityID, FAR* LPPAN_CtlArrayEntityID;

enum {
	PAN_HEALING_VERTEX = 0,
	PAN_HEALING_EDGEGEOMETRY,
	PAN_HEALING_EDGESTITCH,
	PAN_HEALING_COEDGE,
	PAN_HEALING_LOOP,
	PAN_HEALING_FACE
};

#if	TARGET == WIN32S
typedef	int  (__stdcall *CTLABORTHEALPROC)(WPARAM, LPARAM, LPVOID);
#else
typedef	int  (PCALLBACKFN *CTLABORTHEALPROC)(WPARAM, LPARAM, LPVOID);
#endif

typedef struct tagPAN_CtlHealing {
	DWORD					dwAction;
	DWORD					dwTopology;		 //what type of entities have to be in output array
	PAN_CtlArrayEntityID	inEntityID;
	PAN_CtlArrayEntityID	outEntityID;
	int						outEntityCnt[20];
	LPSTR					fileReportName;
	CTLABORTHEALPROC		pCallbackFn;		// Callback procedure to interrup the healing.
	LPVOID					pData;
} PAN_CtlHealing, FAR* LPPAN_CtlHealing;

// wParam for PM_CTLSETATTRIBUTE & PAM_CTLGETATTRIBUTE.

// Action values

#define PAN_CTLATTRIB_NATIVE        5L  // for generic attribute support using the CVecAttributeInfo class to pass attribute information
#define PAN_CTLATTRIB_EFFECTIVE     6L  // for generic attribute support using the CVecAttributeInfo class to pass attribute information
#define PAN_CTLATTRIB_GLOBAL		7L  // for document attribute support using the IPanGlobalAttributeInfo interface to pass attribute information


typedef	struct tagPAN_CtlAttribColor {
	COLORREF	Color;
} PAN_CtlAttribColor, FAR *LPPAN_CtlAttribColor;

typedef struct tagPAN_CtlAttribVisibility {
    BOOL    fVisible;
} PAN_CtlAttribVisibility, FAR *LPPAN_CtlAttribVisibility;

typedef	struct tagPAN_CtlAttribTranslucency {
	Real	Translucency;
} PAN_CtlAttribTranslucency, FAR *LPPAN_CtlAttribTranslucency;

typedef	struct tagPAN_CtlAttribDisplayMode {
	DWORD	dwMode;
} PAN_CtlAttribDisplayMode, FAR *LPPAN_CtlAttribDisplayMode;

typedef	struct tagPAN_CtlAttribMeshRes {
	int		DefaultMeshRes;
	int		AutoUpRes;
	int		AutoDownRes;	
} PAN_CtlAttribMeshRes, FAR *LPPAN_CtlAttribMeshRes;

typedef	struct tagPAN_CtlAttribDensity {
	Real	Density;
	int		MassUnits;
	int		VolUnits;
} PAN_CtlAttribDensity, FAR *LPPAN_CtlAttribDensity;

typedef	struct tagPAN_CtlAttribName {
	char	szName[256];
} PAN_CtlAttribName, FAR *LPPAN_CtlAttribName;

typedef	struct tagPAN_CtlAttribLayerID {
	long	LayerID;
} PAN_CtlAttribLayerID, FAR *LPPAN_CtlAttribLayerID;

// wParam for PM_CTLSETOPTION & PM_CTLGETOPTION
enum {
	PAN_CTLOPTDYNAMICDISPLAYMODE = 1,
	PAN_CTLOPTSHOWAXES,
	PAN_CTLOPTCULLBACKFACES,
	PAN_CTLOPTPRECISEHIDDENLINE,
	PAN_CTLOPTSECTIONEDGECOLOR,
	PAN_CTLCADOPTIONS,
	PAN_CTLOPTSECTIONFILLCOLOR,
	PAN_CTLOPTDIMLEVEL,
	PAN_CTLOPTAXESCONFIG
};

// Display mode options.
#define	PAN_CTLDISPLAYSHADED			0x00000001
#define	PAN_CTLDISPLAYWIREPOLYGON		0x00000002
#define	PAN_CTLDISPLAYWIREFRAME			0x00000004
#define	PAN_CTLDISPLAYHIDDENLINE		0x00000008
#define	PAN_CTLDISPLAYSILHOUETTE 		0x00000010
#define PAN_CTLDISPLAYSHADEDWIRE		0x00000020

#define	PAN_CTLDISPLAYFLATSHADING		0x00010000
#define	PAN_CTLDISPLAYSMOOTHSHADING		0x00020000

#define PAN_DEFAULTDISPLAYMODE			PAN_CTLDISPLAYSHADEDWIRE

/**
 * Points dynamic mode
 * @note Points dynamic mode draws the vertices of the model's triangle mesh
 */
#define PAN_CTLDISPLAYPOINTS            0x00100000

/**
 * fastframe dynamic mode
 * @note FastFrame dynamic mode tries to guarantee a minimum framerate of 10 frames per second
 */
#define PAN_CTLDISPLAYFASTFRAME         0x00200000

/**
 * bounding box dynamic mode
 * @note BoundingBox dynamic mode draws bounding boxes for each model element
 */
#define PAN_CTLDISPLAYBOUNDINGBOXES		0x00400000

#define PAN_CTLDISPLAYNOLIGHTING		0x01000000

#define PAN_CTLDISPLAYMODES        (PAN_CTLDISPLAYSHADED | \
									PAN_CTLDISPLAYWIREPOLYGON | \
									PAN_CTLDISPLAYWIREFRAME | \
									PAN_CTLDISPLAYHIDDENLINE | \
									PAN_CTLDISPLAYSILHOUETTE | \
									PAN_CTLDISPLAYSHADEDWIRE)

#define PAN_CTLDISPLAYSHADINGS     (PAN_CTLDISPLAYFLATSHADING | \
									PAN_CTLDISPLAYSMOOTHSHADING)

// Show Axis options
#define	PAN_CTLAXESSHOW					0x00000001
#define PAN_CTLCULLBACKFACES			0x00000001
#define PAN_CTLPRECISEHIDDENLINE		0x00000001

//PM_CTLGETIDENTICALPARTS message
typedef struct tagPAN_CtlPartsMap
{
	DWORD groupID1;
	DWORD groupID2;
	Hmatrix	mapTransform;
	PAN_CtlRange bbox1;

} PAN_CtlPartsMap;

typedef struct tagPAN_CtlGetIdenticalParts
{
	int	nPartsMap;
	PAN_CtlPartsMap * partsMap;
	DWORD dwRootNodeID;

} PAN_CtlGetIdenticalParts;

// PM_CTLGETTREE message

// GETTREE flags - used in PAN_CtlGetTree (below)
#define PAN_GETTREE_DETECTIDENTICALPART		0x00000002
#define PAN_GETTREE_GETMESHBBOX		        0x00000004  // if set, tree will get bounding box from the mesh always, not from the solid modeler.
// wrapper structure for tree data
typedef struct tagPAN_CtlGetTree
{
	void * pTreeInfo;		// ** MUST ** be an instance of CPanTreeInfo or NULL (!)
	DWORD dwFlags;			// contains PAN_GETTREE flags 
} PAN_CtlGetTree;


// Flags for WPARAM value of PM_CTLCREATEMETAFILE
#define  PAN_CTLCREATEMETAFILE_SAVEPAGE      0x0
#define  PAN_CTLCREATEMETAFILE_SAVECONTROL   0x1

// Structure for PM_CTLRESTOREMETAFILE
#define  PAN_MTFRESTORE_STORAGE 0x00000001
#define  PAN_MTFRESTORE_FULL    0x00000002 // Indicates that everything must be restored, including the CMF.
typedef struct tagPAN_CtlRestoreMetafile
{
	void*	pMetafileStorage;
	DWORD   dwOverlayIndex;
	DWORD   dwOverlayPage;
	WCHAR16	szMetafileStorageName[PAN_MAX_PATH + 1];
	WCHAR16 szOriginalFileName[PAN_MAX_PATH + 1];
	DWORD	dwFlags;
} PAN_CtlRestoreMetafile;

// Parameter for PM_CTLSIMPLIFYMODEL
#define PAN_CTLSHAREIDENTICALPARTS 1 // start identical parts detection and share duplicated parts
#define PAN_CTLRELEASEDATA         2 // data cleanup wparam


typedef struct tag_PAN_CtlReleaseData
{
	BYTE dataTypes;    // data to be released (see flags below)
	void* pvGroupID;   // std::vector<DWORD> groupIDs to release, if NULL release the whole page
} PAN_CtlReleaseData;

// possible dataTypes for PAN_CtlReleaseData dataTypes
#define PAN_CTL_INTERFERENCECHECKDATA    0x01 // release memory created to process interference checking data
#define PAN_CTL_GEOMETRYDATA             0x02 // release non needed geometry
#define PAN_CTL_GRAPHICALDATA            0x04 // release graphical data for the current page
#define PAN_CTL_NATIVEDATA               0x08 // release solid modeler native data


// wParam values for PM_CTL3DCOMPARE.
#define PAN_CTLGRAPHICALCOMPARE     0  // execute triple color mapping
#define PAN_CTLMODELCOMPARE         1  // execute 3D identical test

//******************************************************************************
// TYPES

typedef int                             PAN_CtlErrorCode;

//******************************************************************************
// FUNCTIONS

#ifdef __cplusplus
extern "C" {    // assume C declarations for C++
#endif

// API functions.
extern int  PCALLBACK PAN_LoadControls(LPCSTR szProfileName, LPCSTR szRegFileName);
extern int  PCALLBACK PAN_FreeControls(void);
extern HWND PCALLBACK PAN_CreateControl(
							HWND,           // window handle
							WORD,           // control ID
							LPRECT,         // control window rectangle
							FARPROC,        // pointer to event consumption procedure
							WNDPROC);       // pointer to notification procedure

extern  int PCALLBACK   PAN_GetCtlErrorCode(void);
extern  int PCALLBACK   PAN_ClearCtlErrorCode(void);

// Prototype for extraction function for use with archive decoders.
typedef BOOL (CCALLBACKFN *LPEXTRFUNC)(LONG ID, WORD index, LPCSTR tmpFile);

#ifdef __cplusplus
}
#endif

#ifndef RC_INVOKED
#pragma	pack()
#endif

#endif  /* pctl_h */


