<?php
/**
 * 签到
 * 
 * * @FeiWa (c) 2015-2018 FeiWa   (http://www.feiwa.org)
 * @license    http://www.feiwa.org
 * @link       联系电话：0539-889333 客服QQ：2116198029
 * @since      山东破浪网络科技有限公司提供技术支持 授权请购买FeiWa授权
 */
defined('ByFeiWa') or exit('Access Invalid!');
class signinModel extends Model {
    public function __construct(){
        parent::__construct();
    }
    /**
     * 新增签到信息
     */
    public function addSignin($param){
        if((!$param['member_id']) || (!$param['member_name']) || (!$param['points'])){
        	return false;
        }
        $insert_arr = array();
        $insert_arr['sl_memberid'] = $param['member_id'];
        $insert_arr['sl_membername'] = $param['member_name'];
        $insert_arr['sl_addtime'] = time();
        $insert_arr['sl_points'] = $param['points'];
        return $this->table('signin')->insert($insert_arr);
    }
    /**
     * 查询签到数
     */
    public function getSigninCount($where, $group = ''){
        return $this->table('signin')->where($where)->group($group)->count();
    }
    /**
     * 检验是否能签到
     * @param int $member_id 会员ID
     */
    public function isAbleSignin($member_id){
        if (!$member_id) {
            return array('done'=>false,'msg'=>'参数错误');
        }
        $where = array();
        $where['sl_memberid'] = $member_id;
        $stime = strtotime(date('Y-m-d',time()));
        $etime = $stime + 86400;
        $where['sl_addtime'] = array('between',array($stime,$etime));
        $signin_count = $this->getSigninCount($where);
        if ($signin_count > 0) {
            return array('done'=>false,'msg'=>'已签到');
        }
        return array('done'=>true);
    }
    /**
     * 获得签到日志
     */
    public function getSigninList($where, $field = '*', $limit = 0, $page = 0, $order = '', $group = '') {
        $list = array();
        if (is_array($page)){
            if ($page[1] > 0){
                $list = $this->table('signin')->field($field)->where($where)->limit($limit)->page($page[0],$page[1])->order($order)->group($group)->select();
            } else {
                $list = $this->table('signin')->field($field)->where($where)->limit($limit)->page($page[0])->order($order)->group($group)->select();
            }
        } else {
            $list = $this->table('signin')->field($field)->where($where)->limit($limit)->page($page)->order($order)->group($group)->select();
        }
        return $list;
    }
}