<?php
/**
 * 虚拟团购区域管理
 *
 * * @FeiWa (c) 2015-2018 FeiWa   (http://www.feiwa.org)
 * @license    http://www.feiwa.org
 * @link       联系电话：0539-889333 客服QQ：2116198029
 * @since      山东破浪网络科技有限公司提供技术支持 授权请购买FeiWa授权
 */
defined('ByFeiWa') or exit('Access Invalid!');

class vr_groupbuy_areaModel extends Model
{
    public function __construct()
    {
        parent::__construct('vr_groupbuy_area');
    }

    /**
     * 线下团购信息
     * @param array $condition
     * @param string $field
     * @return array
     */
    public function getVrGroupbuyAreaInfo($condition, $field = '*')
    {
        return $this->table('vr_groupbuy_area')->field($field)->where($condition)->find();
    }

    /**
     * 线下团购列表
     * @param array $condition
     * @param string $field
     * @param number $page
     * @param string $order
     * @param string $limit
     */
    public function getVrGroupbuyAreaList($condition = array(), $field = '*', $page='15', $order = 'hot_city desc, area_id')
    {
       return $this->table('vr_groupbuy_area')->where($condition)->page($page)->order($order)->select();
    }

    /**
     * 添加线下团购
     * @param array $data
     */
    public function addVrGroupbuyArea($data)
    {
        return $this->table('vr_groupbuy_area')->insert($data);
    }

    /**
     * 编辑线下团购
     * @param array $condition
     * @param array $data
     */
    public function editVrGroupbuyArea($condition, $data)
    {
        return $this->table('vr_groupbuy_area')->where($condition)->update($data);
    }

    /**
     * 删除线下分类
     * @param array $condition
     */
    public function delVrGroupbuyArea($condition)
    {
        return $this->table('vr_groupbuy_area')->where($condition)->delete();
    }
}
