<?php
/**
 * 卖家实物订单管理
 *
 *
 *
 ***/


defined('ByFeiWa') or exit('Access Invalid!');
class order_callControl extends BaseSellerControl {
    public function __construct() {
        parent::__construct();
        Language::read('member_store_index');
    }

	/**
	 * 订单列表
	 *
	 */
	public function indexFeiwa() {
        $model_order = Model('order');
        $condition = array();
        $condition['store_id'] = $_SESSION['store_id'];
        if ($_GET['order_sn'] != '') {
            $condition['order_sn'] = $_GET['order_sn'];
        }
        if ($_GET['buyer_name'] != '') {
            $condition['buyer_name'] = $_GET['buyer_name'];
        }
       
   	    /*$allow_state_array = array('state_new','state_pay','state_send','state_success','state_cancel');
        if (in_array($_GET['state_type'],$allow_state_array)) {
            $condition['order_state'] = str_replace($allow_state_array,
                    array(ORDER_STATE_NEW,ORDER_STATE_PAY,ORDER_STATE_SEND,ORDER_STATE_SUCCESS,ORDER_STATE_CANCEL), $_GET['state_type']);
        } else {
            $_GET['state_type'] = 'store_order';
        }*/
		
		$condition['order_state'] = ORDER_STATE_PAY;
		
		
        $if_start_date = preg_match('/^20\d{2}-\d{2}-\d{2}$/',$_GET['query_start_date']);
        $if_end_date = preg_match('/^20\d{2}-\d{2}-\d{2}$/',$_GET['query_end_date']);
        $start_unixtime = $if_start_date ? strtotime($_GET['query_start_date']) : null;
        $end_unixtime = $if_end_date ? strtotime($_GET['query_end_date']): null;
        if ($start_unixtime || $end_unixtime) {
            $condition['add_time'] = array('time',array($start_unixtime,$end_unixtime));
        }

        if ($_GET['skip_off'] == 1) {
            $condition['order_state'] = array('neq',ORDER_STATE_CANCEL);
        }

        $order_list = $model_order->getOrderList($condition, 20, '*', 'order_id desc','', array('order_goods','order_common','member'));

        //页面中显示那些操作
        foreach ($order_list as $key => $order_info) {

        	//显示取消订单
        	$order_info['if_cancel'] = $model_order->getOrderOperateState('store_cancel',$order_info);

        	//显示调整运费
        	$order_info['if_modify_price'] = $model_order->getOrderOperateState('modify_price',$order_info);
			
		//显示修改价格
        	$order_info['if_spay_price'] = $model_order->getOrderOperateState('spay_price',$order_info);

        	//显示发货
        	$order_info['if_send'] = $model_order->getOrderOperateState('send',$order_info);

        	//显示锁定中
        	$order_info['if_lock'] = $model_order->getOrderOperateState('lock',$order_info);

        	//显示物流跟踪
        	$order_info['if_deliver'] = $model_order->getOrderOperateState('deliver',$order_info);

        	foreach ($order_info['extend_order_goods'] as $value) {
        	    $value['image_60_url'] = cthumb($value['goods_image'], 60, $value['store_id']);
        	    $value['image_240_url'] = cthumb($value['goods_image'], 240, $value['store_id']);
        	    $value['goods_type_cn'] = orderGoodsType($value['goods_type']);
        	    $value['goods_url'] = urlMall('goods','index',array('goods_id'=>$value['goods_id']));
        	    if ($value['goods_type'] == 5) {
        	        $order_info['zengpin_list'][] = $value;
        	    } else {
        	        $order_info['goods_list'][] = $value;
        	    }
        	}

        	if (empty($order_info['zengpin_list'])) {
        	    $order_info['goods_count'] = count($order_info['goods_list']);
        	} else {
        	    $order_info['goods_count'] = count($order_info['goods_list']) + 1;
        	}
			
			
			
        	$order_list[$key] = $order_info;

        }
		

		$print_type = $_SESSION['print_type'];
		$print_type = !empty($print_type) ? $print_type : 0;
        Tpl::output('print_type',$print_type);
		
        Tpl::output('order_list',$order_list);
        Tpl::output('show_page',$model_order->showpage());
        self::profile_menu('list',$_GET['state_type']);

        Tpl::showpage('order_call.index');
	}
	
	public function getajaxorderFeiwa()
	{
		$model_order = Model('order');
        $condition = array();
        $condition['store_id'] = $_SESSION['store_id'];
        if ($_GET['order_sn'] != '') {
            $condition['order_sn'] = $_GET['order_sn'];
        }
        if ($_GET['buyer_name'] != '') {
            $condition['buyer_name'] = $_GET['buyer_name'];
        }
      
		
		$condition['order_state'] = ORDER_STATE_PAY;
		
		
        $if_start_date = preg_match('/^20\d{2}-\d{2}-\d{2}$/',$_GET['query_start_date']);
        $if_end_date = preg_match('/^20\d{2}-\d{2}-\d{2}$/',$_GET['query_end_date']);
        $start_unixtime = $if_start_date ? strtotime($_GET['query_start_date']) : null;
        $end_unixtime = $if_end_date ? strtotime($_GET['query_end_date']): null;
        if ($start_unixtime || $end_unixtime) {
            $condition['add_time'] = array('time',array($start_unixtime,$end_unixtime));
        }

        if ($_GET['skip_off'] == 1) {
            $condition['order_state'] = array('neq',ORDER_STATE_CANCEL);
        }

		$condition['is_print'] = 0;
        $order_list = $model_order->getOrderList($condition, 20, '*', 'order_id desc','', array('order_goods','order_common','member'));
		
        $print_order_arr = array();
		if($order_list)
	    {
			//页面中显示那些操作
			foreach ($order_list as $key => $order_info) {

				//显示取消订单
				$order_info['if_cancel'] = $model_order->getOrderOperateState('store_cancel',$order_info);

				//显示调整运费
				$order_info['if_modify_price'] = $model_order->getOrderOperateState('modify_price',$order_info);
				
				//显示修改价格
				$order_info['if_spay_price'] = $model_order->getOrderOperateState('spay_price',$order_info);

				//显示发货
				$order_info['if_send'] = $model_order->getOrderOperateState('send',$order_info);

				//显示锁定中
				$order_info['if_lock'] = $model_order->getOrderOperateState('lock',$order_info);

				//显示物流跟踪
				$order_info['if_deliver'] = $model_order->getOrderOperateState('deliver',$order_info);

				foreach ($order_info['extend_order_goods'] as $value) {
					$value['image_60_url'] = cthumb($value['goods_image'], 60, $value['store_id']);
					$value['image_240_url'] = cthumb($value['goods_image'], 240, $value['store_id']);
					$value['goods_type_cn'] = orderGoodsType($value['goods_type']);
					$value['goods_url'] = urlMall('goods','index',array('goods_id'=>$value['goods_id']));
					if ($value['goods_type'] == 5) {
						$order_info['zengpin_list'][] = $value;
					} else {
						$order_info['goods_list'][] = $value;
					}
				}

				if (empty($order_info['zengpin_list'])) {
					$order_info['goods_count'] = count($order_info['goods_list']);
				} else {
					$order_info['goods_count'] = count($order_info['goods_list']) + 1;
				}
				
				$order_info['add_time'] = date("Y-m-d H:i:s",$order_info['add_time']);
				
				
				//更改打印状态
				$model = Model();
				$model->table('order')->where(array('order_id'=>$order_info['order_id']))->update(array('is_print'=>1));
				//end
				
				$order_list[$key] = $order_info;
				
				if($order_info['is_print'] == 0)
				{
					$print_order_arr[] = $order_info;
				}

			}
		}
        
		
		
		
		$print_type = $_SESSION['print_type'];
		$print_type = !empty($print_type) ? $print_type : 0;
		
		$data = array(
		    'order_list' => $order_list,
			'show_page' => $model_order->showpage(),
		);
		
		exit(json_encode(array('done'=>true,'order_list'=>array_values($order_list),'show_page'=>$model_order->showpage(),'print_type'=>$print_type,'print_order_arr'=>$print_order_arr)));
		//echo json_encode($data);
		//exit;
		
		//Tpl::output('order_list',$order_list);
        //Tpl::output('show_page',$model_order->showpage());
	}

	/**
	 * 卖家订单详情
	 *
	 */
	public function show_orderFeiwa() {
		Language::read('member_member_index');
	    $order_id = intval($_GET['order_id']);
	    if ($order_id <= 0) {
	        showMessage(Language::get('wrong_argument'),'','html','error');
	    }
	    $model_order = Model('order');
	    $condition = array();
        $condition['order_id'] = $order_id;
        $condition['store_id'] = $_SESSION['store_id'];
	    $order_info = $model_order->getOrderInfo($condition,array('order_common','order_goods','member'));
	    if (empty($order_info)) {
	        showMessage(Language::get('store_order_none_exist'),'','html','error');
	    }

        $model_refund_return = Model('refund_return');
        $order_list = array();
        $order_list[$order_id] = $order_info;
        $order_list = $model_refund_return->getGoodsRefundList($order_list,1);//订单商品的退款退货显示
        $order_info = $order_list[$order_id];
        $refund_all = $order_info['refund_list'][0];
        if (!empty($refund_all) && $refund_all['seller_state'] < 3) {//订单全部退款商家审核状态:1为待审核,2为同意,3为不同意
            Tpl::output('refund_all',$refund_all);
        }

        //显示锁定中
        $order_info['if_lock'] = $model_order->getOrderOperateState('lock',$order_info);

    	//显示调整运费
    	$order_info['if_modify_price'] = $model_order->getOrderOperateState('modify_price',$order_info);
		
		//显示调整价格
    	$order_info['if_spay_price'] = $model_order->getOrderOperateState('spay_price',$order_info);

        //显示取消订单
        $order_info['if_cancel'] = $model_order->getOrderOperateState('buyer_cancel',$order_info);

    	//显示发货
    	$order_info['if_send'] = $model_order->getOrderOperateState('send',$order_info);

        //显示物流跟踪
        $order_info['if_deliver'] = $model_order->getOrderOperateState('deliver',$order_info);

        //显示系统自动取消订单日期
        if ($order_info['order_state'] == ORDER_STATE_NEW) {
            //$order_info['order_cancel_day'] = $order_info['add_time'] + ORDER_AUTO_CANCEL_DAY * 24 * 3600;
			// by abc.com
			$order_info['order_cancel_day'] = $order_info['add_time'] + ORDER_AUTO_CANCEL_DAY + 3 * 24 * 3600;
        }

        //显示快递信息
        if ($order_info['shipping_code'] != '') {
            $express = rkcache('express',true);
            $order_info['express_info']['e_code'] = $express[$order_info['extend_order_common']['shipping_express_id']]['e_code'];
            $order_info['express_info']['e_name'] = $express[$order_info['extend_order_common']['shipping_express_id']]['e_name'];
            $order_info['express_info']['e_url'] = $express[$order_info['extend_order_common']['shipping_express_id']]['e_url'];
        }

        //显示系统自动收获时间
        if ($order_info['order_state'] == ORDER_STATE_SEND) {
            //$order_info['order_confirm_day'] = $order_info['delay_time'] + ORDER_AUTO_RECEIVE_DAY * 24 * 3600;
			//by abc.com
			$order_info['order_confirm_day'] = $order_info['delay_time'] + ORDER_AUTO_RECEIVE_DAY + 15 * 24 * 3600;
        }

        //如果订单已取消，取得取消原因、时间，操作人
        if ($order_info['order_state'] == ORDER_STATE_CANCEL) {
            $order_info['close_info'] = $model_order->getOrderLogInfo(array('order_id'=>$order_info['order_id']),'log_id desc');
        }

        foreach ($order_info['extend_order_goods'] as $value) {
            $value['image_60_url'] = cthumb($value['goods_image'], 60, $value['store_id']);
            $value['image_240_url'] = cthumb($value['goods_image'], 240, $value['store_id']);
            $value['goods_type_cn'] = orderGoodsType($value['goods_type']);
            $value['goods_url'] = urlMall('goods','index',array('goods_id'=>$value['goods_id']));
            if ($value['goods_type'] == 5) {
                $order_info['zengpin_list'][] = $value;
            } else {
                $order_info['goods_list'][] = $value;
            }
        }
        
        if (empty($order_info['zengpin_list'])) {
            $order_info['goods_count'] = count($order_info['goods_list']);
        } else {
            $order_info['goods_count'] = count($order_info['goods_list']) + 1;
        }

	    Tpl::output('order_info',$order_info);

        //发货信息
        if (!empty($order_info['extend_order_common']['daddress_id'])) {
            $daddress_info = Model('daddress')->getAddressInfo(array('address_id'=>$order_info['extend_order_common']['daddress_id']));
            Tpl::output('daddress_info',$daddress_info);
        }

		Tpl::showpage('store_order.show');
	}

	/**
	 * 卖家订单状态操作
	 *
	 */
	public function change_stateFeiwa() {
		$state_type	= $_GET['state_type'];
		$order_id	= intval($_GET['order_id']);

		$model_order = Model('order');
		$condition = array();
		$condition['order_id'] = $order_id;
		$condition['store_id'] = $_SESSION['store_id'];
		$order_info	= $model_order->getOrderInfo($condition);

		if ($_GET['state_type'] == 'order_cancel') {
		    $result = $this->_order_cancel($order_info,$_POST);
		} elseif ($_GET['state_type'] == 'modify_price') {
		    $result = $this->_order_ship_price($order_info,$_POST);
		} elseif ($_GET['state_type'] == 'spay_price') {
			$result = $this->_order_spay_price($order_info,$_POST);
    		}
        if (!$result['state']) {
            showDialog($result['msg'],'','error',empty($_GET['inajax']) ?'':'CUR_DIALOG.close();');
        } else {
            showDialog($result['msg'],'reload','succ',empty($_GET['inajax']) ?'':'CUR_DIALOG.close();');
        }
	}

	/**
	 * 取消订单
	 * @param unknown $order_info
	 */
	private function _order_cancel($order_info, $post) {
	    $model_order = Model('order');
	    $logic_order = Logic('order');

	    if(!chksubmit()) {
            Tpl::output('order_info',$order_info);
            Tpl::output('order_id',$order_info['order_id']);
            Tpl::showpage('store_order.cancel','null_layout');
            exit();
	     } else {
	         $if_allow = $model_order->getOrderOperateState('store_cancel',$order_info);
	         if (!$if_allow) {
	             return callback(false,'无权操作');
	         }
	         $msg = $post['state_info1'] != '' ? $post['state_info1'] : $post['state_info'];
	         return $logic_order->changeOrderStateCancel($order_info,'seller',$_SESSION['member_name'], $msg);
	     }
	}

	/**
	 * 修改运费
	 * @param unknown $order_info
	 */
	private function _order_ship_price($order_info, $post) {
	    $model_order = Model('order');
	    $logic_order = Logic('order');
	    if(!chksubmit()) {
	        Tpl::output('order_info',$order_info);
	        Tpl::output('order_id',$order_info['order_id']);
            Tpl::showpage('store_order.edit_price','null_layout');
            exit();
        } else {
            $if_allow = $model_order->getOrderOperateState('modify_price',$order_info);
            if (!$if_allow) {
                return callback(false,'无权操作');
            }
            return $logic_order->changeOrderShipPrice($order_info,'seller',$_SESSION['member_name'],$post['shipping_fee']);           
        }

	}
	/**
	 * 修改商品价格
	 * @param unknown $order_info
	 */
	private function _order_spay_price($order_info, $post) {
        $model_order = Model('order');
	    $logic_order = Logic('order');
	    if(!chksubmit()) {
	        Tpl::output('order_info',$order_info);
	        Tpl::output('order_id',$order_info['order_id']);
            Tpl::showpage('store_order.edit_spay_price','null_layout');
            exit();
        } else {
            $if_allow = $model_order->getOrderOperateState('spay_price',$order_info);
            if (!$if_allow) {
                return callback(false,'无权操作');
            }
            return $logic_order->changeOrderSpayPrice($order_info,'seller',$_SESSION['member_name'],$post['goods_amount']); 
	    }
	}


	/**
	 * 用户中心右边，小导航
	 *
	 * @param string	$menu_type	导航类型
	 * @param string 	$menu_key	当前导航的menu_key
	 * @return
     */
    private function profile_menu($menu_type='',$menu_key='') {
        Language::read('member_layout');
        switch ($menu_type) {
        	case 'list':
            $menu_array = array(
            array('menu_key'=>'order_call',		'menu_name'=>Language::get('feiwa_member_path_all_order'),	'menu_url'=>'index.php?app=order_call'),
            //array('menu_key'=>'state_new',			'menu_name'=>Language::get('feiwa_member_path_wait_pay'),	'menu_url'=>'index.php?app=store_order&feiwa=index&state_type=state_new'),
            //array('menu_key'=>'state_pay',	        'menu_name'=>Language::get('feiwa_member_path_wait_send'),	'menu_url'=>'index.php?app=store_order&feiwa=store_order&state_type=state_pay'),
            //array('menu_key'=>'state_send',		    'menu_name'=>Language::get('feiwa_member_path_sent'),	    'menu_url'=>'index.php?app=store_order&feiwa=index&state_type=state_send'),
            //array('menu_key'=>'state_success',		'menu_name'=>Language::get('feiwa_member_path_finished'),	'menu_url'=>'index.php?app=store_order&feiwa=index&state_type=state_success'),
            //array('menu_key'=>'state_cancel',		'menu_name'=>Language::get('feiwa_member_path_canceled'),	'menu_url'=>'index.php?app=store_order&feiwa=index&state_type=state_cancel'),
            );
            break;
        }
        Tpl::output('member_menu',$menu_array);
        Tpl::output('menu_key',$menu_key);
    }
	
	public function select_typeFeiwa()
    {
		$type =  intval($_GET['type']);
		$_SESSION['print_type'] = $type;
		
		echo "1";
		exit;
	}
}
