/*=======================================================================
*
*   Copyright (C) 2014 Lysine.
*
*   Filename:    Utils.js
*   Time:        2014/07/05
*   Author:      Lysine
*
*   Lysine is a student majoring in Software Engineering
*   from the School of Software, SUN YAT-SEN UNIVERSITY.
*
*   This program is free software: you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation, either version 3 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.

*   You should have received a copy of the GNU General Public License
*   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
=========================================================================*/

Utils={};

Utils.hue=function(v){
    var c=function(d,b){
        var p=Math.abs(d-b)%360;
        p=p>180?360-p:p;
        if(p<=60){
            return 255;
        }
        else if(p<120){
            return 255*(120-p)/60
        }
        else{
            return 0;
        }
    };
    return Utils.rgb(c(v,120),c(v,240),c(v,0));
};

Utils.rgb=function(r,g,b){
    return Math.floor(r)*0x10000+Math.floor(g)*0x100+Math.floor(b);
};

Utils.formatTimes=function(time){
    var m=Math.floor(time/60);
    m=(m<10?'0':'')+m;
    var s=Math.floor(time)%60;
    s=(s<10?'0':'')+s;
    return m+':'+s;
}

Utils.delay=timer;

Utils.interval=interval;

Utils.distance=function(x1,y1,x2,y2){
    var x=x1-x2,y=y1-y2;
    return Math.sqrt(x*x+y*y);
};

Utils.rand=function(min,max){
    return min+Math.random()*(max-min);
};
