
//trim white space on the left side
String.prototype.LTrim = function()
{
	return this.replace(/(^\s*)/g, "");
} 

//trim white space on the right side
String.prototype.RTrim = function()
{
	return this.replace(/(\s*$)/g, "");
} 

//trim white space on both sides 
String.prototype.Trim = function()
{
	return this.replace(/(^\s*)|(\s*$)/g, "");
} 

//get left part of the string
String.prototype.Left = function(len) 
{ 
	if (isNaN(len)||len==null) 
	{ 
		len = this.length; 
	} 
	else 
	{ 
		if (parseInt(len)<0||parseInt(len)>this.length) 
		{ 
		len = this.length; 
		} 
	} 
	
	return this.substr(0,len); 
} 

//get right part of string
String.prototype.Right = function(len) 
{ 
	if (isNaN(len)||len==null) 
	{ 
		len = this.length; 
	} 
	else 
	{ 
		if (parseInt(len)<0||parseInt(len)>this.length) 
		{ 
			len = this.length; 
		} 
	} 

	return this.substring(this.length-len,this.length); 
} 

//get first index of a substring in this string
String.prototype.IndexOfStr = function(str) 
{ 
	if (str==null) 
	{ 
		str = ""; 
	} 
	
	return this.indexOf(str); 
}


//get last index of a substring in this string
String.prototype.LastIndexOfStr = function(str) 
{ 
	if (str==null) 
	{ 
		str = ""; 
	} 
	
	return this.lastIndexOf(str); 
} 


//get middle part of string
String.prototype.Mid = function(start,len) 
{ 
	return this.substr(start,len); 
} 


//count the print length of the string
String.prototype.Len = function()
{
	return this.replace(/[^\x00-\xff]/g,"aa").length;
} 

String.prototype.Format = function(args) 
{
    var result = this;
    if (arguments.length > 0) 
	{    
        if (arguments.length == 1 && typeof (args) == "object")//if there's only 1 argument and it is a json object
		{
            for (var key in args) 
			{
                if (args[key]!=undefined)
				{
                    var reg = new RegExp("({" + key + "})", "g");
                    result = result.replace(reg, args[key]);
                }
            }
        }
        else //if there're 2+ arguments, or if the only 1 argument is not json
		{
            for (var i = 0; i < arguments.length; i++) 
			{
                if (arguments[i] != undefined) 
				{
　　　　　　　　　　　　var reg= new RegExp("({)" + i + "(})", "g");
                    result = result.replace(reg, arguments[i]);
                }
            }
        }
    }
    return result;
}



//whether it is a valid IP string
String.prototype.IsIP = function() 
{ 
	var reSpaceCheck = /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/; 
	
	if (reSpaceCheck.test(this)) 
	{ 
		this.match(reSpaceCheck); 
		
		if (RegExp.$1 <= 255 && RegExp.$1 >= 0 
		&& RegExp.$2 <= 255 && RegExp.$2 >= 0 
		&& RegExp.$3 <= 255 && RegExp.$3 >= 0 
		&& RegExp.$4 <= 255 && RegExp.$4 >= 0) 
		{ 
			return true;     
		} 
		else 
		{ 
			return false; 
		} 
	} 
	else 
	{ 
		return false; 
	} 

} 


//whether it is a valid long Date string
String.prototype.IsLongDate = function() 
{ 
	var r = this.replace(/(^\s*)|(\s*$)/g, "").match(/^(\d{1,4})(-|\/)(\d{1,2})\2(\d{1,2}) (\d{1,2}):(\d{1,2}):(\d{1,2})$/); 
	if (r==null) 
	{ 
		return false; 
	} 
	var d = new Date(r[1], r[3]-1,r[4],r[5],r[6],r[7]); 
	return (d.getFullYear()==r[1]&&(d.getMonth()+1)==r[3]&&d.getDate()==r[4]&&d.getHours()==r[5]&&d.getMinutes()==r[6]&&d.getSeconds()==r[7]); 
} 

//whether it is a valid short Date string
String.prototype.IsShortDate = function() 
{ 
	var r = this.replace(/(^\s*)|(\s*$)/g, "").match(/^(\d{1,4})(-|\/)(\d{1,2})\2(\d{1,2})$/); 
	if (r==null) 
	{ 
		return false; 
	} 
	var d = new Date(r[1], r[3]-1, r[4]); 
	return (d.getFullYear()==r[1]&&(d.getMonth()+1)==r[3]&&d.getDate()==r[4]); 
} 

//whether it is a valid Date string
String.prototype.IsDate = function() 
{ 
return this.isLongDate()||this.isShortDate(); 
} 

//whether it is a valid mobile phone number
String.prototype.IsMobile = function() 
{ 
return /^0{0,1}13[0-9]{9}$/.test(this); 
} 

//whether it is a valid email address string
String.prototype.IsEmail = function() 
{ 
return /^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$/.test(this); 
} 

//whether it is a valid zip code string
String.prototype.IsZipCode = function() 
{ 
return /^[\\d]{6}$/.test(this); 
} 

//whether it contains ASCII character(s) 
String.prototype.IsContainASCIIChar = function() 
{
	//[\x00-\xff]为ASCII和扩展ASCII,[\u4E00-\u9FA5]为汉字,[\uFE30-\uFFA0]为全角符号
	return (/[\x00-\xff]+/).test(this);
}

//whether it is all ASCII character(s)
String.prototype.IsAllASCIIChar = function() 
{ 
	//[\x00-\xff]为ASCII和扩展ASCII,[\u4E00-\u9FA5]为汉字,[\uFE30-\uFFA0]为全角符号
	return /^[\x00-\xff]*$/.test(this); 
} 

//whether it is all chinese character(s)
String.prototype.IsAllChineseChar = function() 
{
	//[\x00-\xff]为ASCII和扩展ASCII,[\u4e00-\u9fa5]为汉字(简体中文,繁体中文),[\uFE30-\uFFA0]为全角符号
	return (/^[\u4e00-\u9fa5]*$/).test(this);
}

//whether it contains chinese character(s) 
String.prototype.IsContainChineseChar = function() 
{
	//[\x00-\xff]为ASCII和扩展ASCII,[\u4E00-\u9FA5]为汉字,[\uFE30-\uFFA0]为全角符号
	return (/[\u4e00-\u9fa5]+/).test(this);
}

//whether it is chinese string
String.prototype.IsChinese = function() 
{
	//[\x00-\xff]为ASCII和扩展ASCII,[\u4E00-\u9FA5]为汉字,[\uFE30-\uFFA0]为全角符号
	return (/[\u4e00-\u9fa5]+/).test(this);
}

//whether it is a valid file name string
String.prototype.IsFileName = function() 
{ 
return !/[\\\/\*\?\|:"<>]/g.test(this); 
} 

//whether it is a valid url string
String.prototype.IsUrl = function() 
{ 
	return /^http[s]?:\/\/([\w-]+\.)+[\w-]+([\w-./?%&=]*)?$/i.test(this); 
} 

//whether it is an valid id card string
String.prototype.IsIDCard = function() 
{ 
	var iSum=0; 
	var info=""; 
	var sId = this; 
	
	 var aCity={11:"北京",12:"天津",13:"河北",14:"山西",15:"内蒙古",21:"辽宁",22:"吉林",23:"黑龙 江",31:"上海",32:"江苏",33:"浙江",34:"安徽",35:"福建",36:"江西",37:"山东",41:"河南",42:"湖 北",43:"湖南",44:"广东",45:"广西",46:"海南",50:"重庆",51:"四川",52:"贵州",53:"云南",54:"西藏",61:"陕西",62:"甘肃",63:"青海",64:"宁夏",65:"新疆",71:"台湾",81:"香港",82:"澳门",91:"国外"};
	
	if (!/^\d{17}(\d|x)$/i.test(sId)) 
	{ 
		return false; 
	} 
	sId=sId.replace(/x$/i,"a"); 
	//非法地区 
	if (aCity[parseInt(sId.substr(0,2))]==null) 
	{ 
		return false; 
	} 
	
	var sBirthday=sId.substr(6,4)+"-"+Number(sId.substr(10,2))+"-"+Number(sId.substr(12,2)); 
	
	var d=new Date(sBirthday.replace(/-/g,"/")) 
	
	//非法生日 
	if (sBirthday!=(d.getFullYear()+"-"+ (d.getMonth()+1) + "-" + d.getDate())) 
	{ 
		return false; 
	} 
	for (var i = 17;i>=0;i--) 
	{ 
		iSum += (Math.pow(2,i) % 11) * parseInt(sId.charAt(17 - i),11); 
	} 
	
	if (iSum%11!=1) 
	{ 
		return false; 
	} 
	return true; 
} 

//whether it is a valid phone call string
String.prototype.IsPhoneCall = function() 
{ 
	return /(^[0-9]{3,4}\-[0-9]{3,8}$)|(^[0-9]{3,8}$)|(^\([0-9]{3,4}\)[0-9]{3,8}$)|(^0{0,1}13[0-9]{9}$)/.test(this); 
} 


//whether it is a certain kind of valid number string
String.prototype.IsNumeric = function(flag) 
{ 
	//验证是否是数字 
	if (isNaN(this)) 
	{ 
		return false; 
	} 
	
	switch (flag) 
	{ 
		case null:	//数字 
		case "": 
		return true; 
		
		case "+":	//正数 
		return	/(^\+?|^\d?)\d*\.?\d+$/.test(this); 
		
		case "-":	//负数 
		return	/^-\d*\.?\d+$/.test(this); 
		
		case "i":	//整数 
		return	/(^-?|^\+?|\d)\d+$/.test(this); 
		
		case "+i":	//正整数 
		return	/(^\d+$)|(^\+?\d+$)/.test(this);  
		                      
		case "-i":	//负整数 
		return	/^[-]\d+$/.test(this); 
		
		case "f":	//浮点数 
		return	/(^-?|^\+?|^\d?)\d*\.\d+$/.test(this); 
		
		case "+f":	//正浮点数 
		return	/(^\+?|^\d?)\d*\.\d+$/.test(this);  
		                      
		case "-f":	//负浮点数 
		return	/^[-]\d*\.\d$/.test(this);  
		              
		default:	//缺省 
		return	true;                        
	} 
} 

//whether it represents color
String.prototype.IsColor = function() 
{ 
var temp        = this; 
if (temp=="") return true; 
if (temp.length!=7) return false; 
return (temp.search(/\#[a-fA-F0-9]{6}/) != -1); 
} 

//convert to full case
String.prototype.ToFullCase = function() 
{ 
	var tmp = ""; 
	for (var i=0;i<this.length;i++) 
	{ 
		if (this.charCodeAt(i)>0&&this.charCodeAt(i)<255) 
		{ 
			tmp += String.fromCharCode(this.charCodeAt(i)+65248); 
		} 
		else 
		{ 
			tmp += String.fromCharCode(this.charCodeAt(i)); 
		} 
	} 
	return tmp;
} 

//html encode
String.prototype.ToHtmlEncode = function() 
{ 
	var str = this?this:''; 
	
	str=str.replace(/&/g,"&amp;"); 
	str=str.replace(/</g,"&lt;"); 
	str=str.replace(/>/g,"&gt;"); 
	str=str.replace(/\'/g,"&#39;"); 
	str=str.replace(/\"/g,"&quot;"); 
	str=str.replace(/\n/g,"<br>"); 
	str=str.replace(/\ /g,"&nbsp;"); 
	str=str.replace(/\t/g,"&nbsp;&nbsp;&nbsp;&nbsp;"); 
	
	return str; 
} 

//html decode
String.prototype.ToHtmlDecode = function() 
{ 
	var str = this?this:''; 
	
    str = str.replace(/&nbsp;/g, " ");
    str = str.replace(/<br>/g, "\n");
	str = str.replace(/&quot;/g, "\"");
	str = str.replace(/&#39;/g, "\'");
    str = str.replace(/&gt;/g, ">");
	str = str.replace(/&lt;/g, "<");
    str = str.replace(/&amp;/g, "&");

    return str;
} 


//convert to Date
String.prototype.ToDate = function() 
{ 
	try 
	{ 
		return new Date(this.replace(/-/g, "\/")); 
	} 
	catch(e) 
	{ 
		return null; 
	} 
}
