;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;Make dimension scale settings based on dialog box
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun do_scale ()
(if (= sh_styl "english");;; Cond to find architect scale
 (cond
  ((= scale 0)(setvar "dimscale" 1.0)(setq scl 1))
  ((= scale 1)(setvar "dimscale" 4.0)(setq scl 4))
  ((= scale 2)(setvar "dimscale" 8.0)(setq scl 8))
  ((= scale 3)(setvar "dimscale" 12.0)(setq scl 12))
  ((= scale 4)(setvar "dimscale" 16.0)(setq scl 16))
  ((= scale 5)(setvar "dimscale" 24.0)(setq scl 24))
  ((= scale 6)(setvar "dimscale" 32.0)(setq scl 32))
  ((= scale 7)(setvar "dimscale" 48.0)(setq scl 48))
  ((= scale 8)(setvar "dimscale" 64.0)(setq scl 64))
  ((= scale 9)(setvar "dimscale" 96.0)(setq scl 96))
  ((= scale 10)(setvar "dimscale" 192.0)(setq scl 192))

 );end cond
);end if
(if (= sh_styl "engineer");;;Cond to find Engineer scale
 (cond
  ((= scale 0)(setvar "dimscale" 1)(setq scl 1))
  ((= scale 1)(setvar "dimscale" 120)(setq scl 120))
  ((= scale 2)(setvar "dimscale" 240)(setq scl 240))
  ((= scale 3)(setvar "dimscale" 360)(setq scl 360))
  ((= scale 4)(setvar "dimscale" 480)(setq scl 480))
  ((= scale 5)(setvar "dimscale" 600)(setq scl 600))
  ((= scale 6)(setvar "dimscale" 720)(setq scl 720))
  ((= scale 7)(setvar "dimscale" 1200)(setq scl 1200))
  ((= scale 8)(setvar "dimscale" 2400)(setq scl 2400))
 );end cond
);end if
(if (= sh_styl "decimal");;;Cond to find decimal scale
 (cond
  ((= scale 0)(setvar "dimscale" 1)(setq scl 1))
  ((= scale 1)(setvar "dimscale" 10)(setq scl 10))
  ((= scale 2)(setvar "dimscale" 20)(setq scl 20))
  ((= scale 3)(setvar "dimscale" 30)(setq scl 30))
  ((= scale 4)(setvar "dimscale" 40)(setq scl 40))
  ((= scale 5)(setvar "dimscale" 50)(setq scl 50))
  ((= scale 6)(setvar "dimscale" 60)(setq scl 60))
  ((= scale 7)(setvar "dimscale" 100)(setq scl 100))
  ((= scale 8)(setvar "dimscale" 200)(setq scl 200))
 );end cond
);end if

;;;(list "10" "20" "30" "40" "50" "60" "100" "200")

(if (= sh_styl "metric");;;Cond to find Metric scale
 (cond
  ((= scale 0)(setvar "dimscale" 1)(setq scl 1))
  ((= scale 1)(setvar "dimscale" 5)(setq scl 5))
  ((= scale 2)(setvar "dimscale" 10)(setq scl 10))
  ((= scale 3)(setvar "dimscale" 20)(setq scl 20))
  ((= scale 4)(setvar "dimscale" 50)(setq scl 50))
  ((= scale 5)(setvar "dimscale" 75)(setq scl 75))
  ((= scale 6)(setvar "dimscale" 100)(setq scl 100))
  ((= scale 7)(setvar "dimscale" 200)(setq scl 200))
  ((= scale 8)(setvar "dimscale" 500)(setq scl 500))
  ((= scale 9)(setvar "dimscale" 1000)(setq scl 1000))
  ((= scale 10)(setvar "dimscale" 2000)(setq scl 2000))
  ((= scale 10)(setvar "dimscale" 5000)(setq scl 5000))


;;;(list "Full" "1:5" "1:10" "1:20" "1:50" "1:75" "1:100" "1:200" "1:500" "1:1000" "1:2000" "1:5000")

 );end cond
);end if


);end defun  do_scale

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;Set up sheet sizes based on dialog
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun do_size (/ xsize ysize urlim txht txht2 lunits)
(setq size (read sh_indx))
(if (and (= orient1 "p")(or (= sh_styl "english")(= sh_styl "engineer")(= sh_styl "decimal")))
(cond
  ((= size 0)
       (setq xsize (* (getvar "dimscale") 8.5))
       (setq ysize (* (getvar "dimscale") 11 ))
  )
 ((= size 1)
       (setq xsize (* (getvar "dimscale") 9 ))
       (setq ysize (* (getvar "dimscale") 12 ))
  )
  ((= size 2)
       (setq xsize (* (getvar "dimscale") 11 ))
       (setq ysize (* (getvar "dimscale") 17 ))
  )
  ((= size 3)
       (setq xsize (* (getvar "dimscale") 17 ))
       (setq ysize (* (getvar "dimscale") 22 ))
  )
  ((= size 4)
       (setq xsize (* (getvar "dimscale") 22 ))
       (setq ysize (* (getvar "dimscale") 34 ))
  )
  ((= size 5)
       (setq xsize (* (getvar "dimscale") 24 ))
       (setq ysize (* (getvar "dimscale") 36 ))
  )
  ((= size 6)
       (setq xsize (* (getvar "dimscale") 30 ))
       (setq ysize (* (getvar "dimscale") 42 ))
  )
  ((= size 7)
       (setq xsize (* (getvar "dimscale") 36 ))
       (setq ysize (* (getvar "dimscale") 48 ))
  )
 )
)
(if  (and (= orient1 "l")(or (= sh_styl "english")(= sh_styl "engineer")(= sh_styl "decimal")))
(cond
  ((= size 0)
       (setq xsize (* (getvar "dimscale") 11 ))
       (setq ysize (* (getvar "dimscale") 8.5))
  )
  ((= size 1)
       (setq xsize (* (getvar "dimscale") 12 ))
       (setq ysize (* (getvar "dimscale") 9 ))
  )
  ((= size 2)
       (setq xsize (* (getvar "dimscale") 17 ))
       (setq ysize (* (getvar "dimscale") 11 ))
  )
  ((= size 3)
       (setq xsize (* (getvar "dimscale") 22 ))
       (setq ysize (* (getvar "dimscale") 17 ))
  )
  ((= size 4)
       (setq xsize (* (getvar "dimscale") 34 ))
       (setq ysize (* (getvar "dimscale") 22 ))
  )
  ((= size 5)
       (setq xsize (* (getvar "dimscale") 36 ))
       (setq ysize (* (getvar "dimscale") 24 ))
  )
  ((= size 6)
       (setq xsize (* (getvar "dimscale") 42 ))
       (setq ysize (* (getvar "dimscale") 30 ))
  )
  ((= size 7)
       (setq xsize (* (getvar "dimscale") 48 ))
       (setq ysize (* (getvar "dimscale") 36 ))
  )
);end cond
);end if1

(if  (and (= orient1 "p")(= sh_styl "metric"))
(cond
  ((= size 0)
       (setq xsize (* (getvar "dimscale") 210 ))
       (setq ysize (* (getvar "dimscale") 297))
  )
  ((= size 1)
       (setq xsize (* (getvar "dimscale") 297 ))
       (setq ysize (* (getvar "dimscale") 420 ))
  )
  ((= size 2)
       (setq xsize (* (getvar "dimscale") 420 ))
       (setq ysize (* (getvar "dimscale") 594 ))
  )
  ((= size 3)
       (setq xsize (* (getvar "dimscale") 594 ))
       (setq ysize (* (getvar "dimscale") 841 ))
  )
  ((= size 4)
       (setq xsize (* (getvar "dimscale") 707 ))
       (setq ysize (* (getvar "dimscale") 1000))
  )
  ((= size 5)
       (setq xsize (* (getvar "dimscale") 841))
       (setq ysize (* (getvar "dimscale") 1189 ))
  )
);end cond
);end if1

(if  (and (= orient1 "l")(= sh_styl "metric"))
(cond
  ((= size 0)
       (setq xsize (* (getvar "dimscale") 297 ))
       (setq ysize (* (getvar "dimscale") 210))
  )
  ((= size 1)
       (setq xsize (* (getvar "dimscale") 420 ))
       (setq ysize (* (getvar "dimscale") 297 ))
  )
  ((= size 2)
       (setq xsize (* (getvar "dimscale") 594 ))
       (setq ysize (* (getvar "dimscale") 420 ))
  )
  ((= size 3)
       (setq xsize (* (getvar "dimscale") 841 ))
       (setq ysize (* (getvar "dimscale") 594 ))
  )
  ((= size 4)
       (setq xsize (* (getvar "dimscale") 1000 ))
       (setq ysize (* (getvar "dimscale") 707))
  )
  ((= size 5)
       (setq xsize (* (getvar "dimscale") 1189 ))
       (setq ysize (* (getvar "dimscale")841 ))
  )
);end cond
);end if1
(setvar "cmdecho" 0)
(if (= sh_styl "metric")
    (command "grid" (* (getvar "dimscale") 10) )
    (command "grid" (getvar "dimscale"))
);end if
(setq urlim (list xsize ysize))
(command "limits" "0,0" urlim
                   "zoom" "a"
);end command
(setq txht (* 0.1 (getvar "dimscale")))
(setq txht2 (* 2 txht))
(setvar "ltscale" (getvar "dimscale"))
(setq lunits (getvar "lunits"))
(command
   "regenauto" "off"
   "viewres" "y" "2000"
   "style" "title" "romans" txht2 "0.8" "" "" "" ""
   "style" "notes" "romans" txht "0.8" "" "" "" ""
)
(if
  (= lunits 4)
    (command
        "insert" "dimtic" "0,0" "" "" ""
        "erase" "l" ""
        "dim" "dimasz" "0.1" "dimtad" "off"
        "dimtvp" ".7" "dimtsz" "0" "dimblk" "dimtic"
        "dimtih" "off" "dimtoh" "off" "exit"
    )
    (command
        "dim" "dimtad" "on" "dimtih" "off" "dimtoh" "off" "exit"
    )
)

);end defun








;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;Get the current scale factor and set up
;;;popup list index
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun get_sc_indx ()
(setq curscl (getvar "dimscale"))
(if (= sh_styl "english")
(cond
  ( (<= curscl 1) (setq scle_indx "0"))
  ( (<= curscl 4) (setq scle_indx "1"))
  ( (<= curscl 8) (setq scle_indx "2"))
  ( (<= curscl 12) (setq scle_indx "3"))
  ( (<= curscl 16) (setq scle_indx "4"))
  ( (<= curscl 24) (setq scle_indx "5"))
  ( (<= curscl 32) (setq scle_indx "6"))
  ( (<= curscl 48) (setq scle_indx "7"))
  ( (<= curscl 64) (setq scle_indx "8"))
  ( (<= curscl 96) (setq scle_indx "9"))
  ( (<= curscl 192) (setq scle_indx "10"))
);end cond
);end if
(if (= sh_styl "engineer")
(cond
  ( (<= curscl 1) (setq scle_indx "0"))
  ( (<= curscl 120) (setq scle_indx "1"))
  ( (<= curscl 240) (setq scle_indx "2"))
  ( (<= curscl 360) (setq scle_indx "3"))
  ( (<= curscl 480) (setq scle_indx "4"))
  ( (<= curscl 600) (setq scle_indx "5"))
  ( (<= curscl 720) (setq scle_indx "6"))
  ( (<= curscl 1200) (setq scle_indx "7"))
  ( (<= curscl 2400) (setq scle_indx "8"))
);end cond
);end if
(if (= sh_styl "decimal")
(cond
  ( (<= curscl 1) (setq scle_indx "0"))
  ( (<= curscl 10) (setq scle_indx "1"))
  ( (<= curscl 20) (setq scle_indx "2"))
  ( (<= curscl 30) (setq scle_indx "3"))
  ( (<= curscl 40) (setq scle_indx "4"))
  ( (<= curscl 50) (setq scle_indx "5"))
  ( (<= curscl 60) (setq scle_indx "6"))
  ( (<= curscl 100) (setq scle_indx "7"))
  ( (<= curscl 200) (setq scle_indx "8"))
);end cond
);end if
(if (= sh_styl "metric")
(cond
  ( (<= curscl 1) (setq scle_indx "0"))
  ( (<= curscl 5) (setq scle_indx "1"))
  ( (<= curscl 10) (setq scle_indx "2"))
  ( (<= curscl 20) (setq scle_indx "3"))
  ( (<= curscl 50) (setq scle_indx "4"))
  ( (<= curscl 75) (setq scle_indx "5"))
  ( (<= curscl 100) (setq scle_indx "6"))
  ( (<= curscl 200) (setq scle_indx "7"))
  ( (<= curscl 500) (setq scle_indx "8"))
  ( (<= curscl 1000) (setq scle_indx "9"))
  ( (<= curscl 2000) (setq scle_indx "10"))
  ( (<= curscl 5000) (setq scle_indx "11"))
);end cond
);end if
);end defun get_sc_indx


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;Get the current sheet size and
;;;set up popup list index
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun get_sh_indx (/ cursz)
(setq cursz max_size)
(if (or (= sh_styl "english")(= sh_styl "engineer")(= sh_styl "decimal") )
(cond
  ( (<= cursz 11) (setq size1 (atoi (setq sh_indx "0"))))
  ( (<= cursz 12) (setq size1 (atoi (setq sh_indx "1"))))
  ( (<= cursz 17) (setq size1 (atoi (setq sh_indx "2"))))
  ( (<= cursz 22) (setq size1 (atoi (setq sh_indx "3"))))
  ( (<= cursz 34) (setq size1 (atoi (setq sh_indx "4"))))
  ( (<= cursz 36) (setq size1 (atoi (setq sh_indx "5"))))
  ( (<= cursz 42) (setq size1 (atoi (setq sh_indx "6"))))
  ( (<= cursz 48) (setq size1 (atoi (setq sh_indx "7"))))
);end cond
);end if
(if (= sh_styl "metric")
(cond
  ( (<= cursz 297) (setq size1 (atoi (setq sh_indx "0"))))
  ( (<= cursz 420) (setq size1 (atoi (setq sh_indx "1"))))
  ( (<= cursz 594) (setq size1 (atoi (setq sh_indx "2"))))
  ( (<= cursz 841) (setq size1 (atoi (setq sh_indx "3"))))
  ( (<= cursz 1000) (setq size1 (atoi (setq sh_indx "4"))))
  ( (<= cursz 1189) (setq size1 (atoi (setq sh_indx "5"))))
);end cond
);end if
);end defun get_sh_indx

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;Get current sheet size and find orientation
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(defun get_sheet (/ vmin vmax width1 heigh1)
(setq vmin (getvar "limmin"))
(setq vmax (getvar "limmax"))
(setq width1 (- (car vmax)(car vmin)))
(setq heigh1 (- (cadr vmax)(cadr vmin)))
(setq sht_size (strcat (rtos width1 2 2) "x" (rtos heigh1 2 2)))
(if (> width1 heigh1)
   (progn
   (setq max_size (/ width1 (getvar "dimscale")) )
   (setq orient1 "l")
   )
   (progn
   (setq max_size (/ heigh1 (getvar "dimscale")) )
   (setq orient1 "p")
   )
)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; set up scale popup list based on current
;;; dimscale setting
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun get_scale ()
(if (= sh_styl "english")
        (setq scale
                 (list "Full Scale" "    3\" = 1'" "1 1/2\" = 1'" "    1\" = 1'" "  3/4\" = 1'" "  1/2\" = 1'"
                         "  3/8\" = 1'" "  1/4\" = 1'" " 3/16\" = 1'"
                         "  1/8\" = 1'" " 1/16\" = 1'"
                 )
        )
);end if

(if (or (= sh_styl "engineer")(= sh_styl "decimal"))
        (setq scale
                 (list "Full Scale" "1\" = 10'" "1\" = 20'" "1\" = 30'" "1\" = 40'" "1\" = 50'"
                       "1\" = 60'" "1\" = 100'" "1\" = 200'"
                 )
        )
);end if

(if (= sh_styl "metric")
        (setq scale
            (list "Full Scale" "1:5" "1:10" "1:20" "1:50" "1:75" "1:100"
                    "1:200" "1:500" "1:1000" "1:2000" "1:5000")
        )
);end if


(start_list "scale")
(mapcar 'add_list scale)
(end_list)
(set_tile "scale" scle_indx)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;Set up sheet size for popup list
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun get_size ()
(if (or (= sh_styl "english")(= sh_styl "engineer")(= sh_styl "decimal"))
        (setq size
                 (list "8.5x11" "  9x12" " 11x17" " 17x22" " 22x34" " 24x36" " 30x42"
                       " 36x48"
                 )
        )
)
(if (= sh_styl "metric")
        (setq size
                  (list " 297x210" " 420x297" " 594x420" " 841x594" "1000x707" "1189x841")
        )
);end if
(start_list "size")
(mapcar 'add_list size)
(end_list)
(set_tile "size" sh_indx)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Establish Unit Style
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun set_units (val)
(setvar "lunits" val)
)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Setup dialog box, open and act on
;;;dialog selections
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun ddsetup_main ()
    (setq f_done 0)
    (setq other 0)
    (setq dcl_id (load_dialog "ddsetup.dcl"))
       (if
       (not (new_dialog "ddsetup" dcl_id))
       (exit)
       )
(cond
  ( (and (= lunits 2)(= aunits 1))(set_tile "decimal" "1"))
  ( (and (= lunits 3)(= aunits 1))(set_tile "engineering" "1"))
  ( (and (= lunits 4)(= aunits 1))(set_tile "architectural" "1"))
  ( (and (= lunits 3)(= aunits 4))(set_tile "surveyor" "1"))
  ((= lunits 2)(set_tile "decimal" "1"))
)
 (if (= orient1 "l")(set_tile "landscape" "1")(set_tile "portrait" "1"))
(get_scale)(get_size)
(action_tile "metric"
     "(set_units 2)(setvar \"aunits\" 0)(setq sh_styl \"metric\")
       (get_scale)(get_size)(get_sh_indx)(get_sc_indx)")
(action_tile "decimal"
     "(set_units 2)(setvar \"aunits\" 1)(setq sh_styl \"decimal\")
       (get_scale)(get_size)(get_sh_indx)(get_sc_indx)")
(action_tile "engineering"
     "(set_units 3)(setvar \"aunits\" 1)(setq sh_styl \"engineer\")
      (get_scale)(get_size)(get_sh_indx)(get_sc_indx)")
(action_tile "architectural"
     "(set_units 4)(setvar \"aunits\" 1)(setq sh_styl \"english\")
       (get_scale)(get_size)(get_sh_indx)(get_sc_indx)")
(action_tile "surveyor"
     "(set_units 3)(setvar \"aunits\" 4)(setq sh_styl \"engineer\")
      (get_scale)(get_size)(get_sh_indx)(get_sc_indx)")
(action_tile "landscape" "(setq orient1 \"l\")")
(action_tile "portrait" "(setq orient1 \"p\")")
(action_tile "scale" "(setq scale (read (setq scle_indx $value)))")
(action_tile "size" "(setq size (read (setq sh_indx $value)))")
(action_tile "accept" "(setq f_done 1)(done_dialog)")
(action_tile "cancel" "(setq f_done 2)(done_dialog 0)")
(action_tile "help" "(acad_helpdlg \"acad.hlp\" \"units\")" )
)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Main program code
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun c:ddsetup (/
                 sht_size scale   size size1 curscl
                 lunits   f_done scle_indx sh_styl
                dcl_id   aunits  dimscale
                 scle_indx sh_indx
                 )
   (setq f_done 0)
   (get_sheet)
    (setq lunits (getvar "LUNITS"))
    (setq aunits (getvar "aunits"))
    (setq dimscale (getvar "dimscale"))
(cond
;  ((and (= lunits 2)(= aunits 0))(setq sh_styl "metric"))
  ((and (= lunits 2)(= aunits 1))(setq sh_styl "decimal"))
  ((and (= lunits 3)(= aunits 1))(setq sh_styl "engineer"))
  ((and (= lunits 4)(= aunits 1))(setq sh_styl "english"))
  ((and (= lunits 3)(= aunits 4))(setq sh_styl "engineer"))
  ((= lunits 2)(setq sh_styl "engineer"));;;default to "engineer"
)
  (get_sc_indx)
   (get_scale)
  (get_sh_indx)
    (get_size)
   (ddsetup_main)
       (while (< f_done 1)
         (start_dialog)
       )
(unload_dialog dcl_id)
(if (= f_done 1)
  (progn
   (do_scale)
   (do_size)
  )
)
(setq do_scale nil do_size nil get_sc_indx nil
      get_sh_indx nil get_sheet nil get_scale nil
      get_size nil set_units nil ddsetup_main nil
)
(gc)
(princ)
)
