;*****************************************************;
;* This is "epin.lsp" program 			     *;
;* Complete compiled in 02/06/99                     *;
;* Last change in 02/09/99     			     *;
;* ZX Mold Ltd  XY Liao				     *;
;*****************************************************;
;************************************* Main function start **************************************;
(defun epin()
;---------------------------------------------------
;shut off command echo and set undo mark
;---------------------------------------------------
  (setvar "cmdecho" 0)
  (command "undo" "mark")
;---------------------------------------------------
;Save current system variable
;---------------------------------------------------
  (setq os_old (getvar "osmode")
	la_old (getvar "clayer")
	lt_old (getvar "celtype")
	co_old (getvar "cecolor")
	pw_old (getvar "plinewid")
	or_old (getvar "orthomode")
	st_old (getvar "textstyle")
	bp_old (getvar "blipmode")
  )
;---------------------------------------------------
;Initializing
;---------------------------------------------------
  (ini_useri2)
  (setvar "plinewid" 0)
  (setvar "blipmode" 0)
  (setvar "celtype" "bylayer")
  (setvar "cecolor" "bylayer")
  (if (not (tblsearch "layer" "epin"))
    (command "layer" "_new" "epin" "_color" "green" "epin" "l" "continuous" "epin" "")
    (command "_.layer" "thaw" "epin" "on" "epin" "unlock" "epin" "")
  )
  (setvar "clayer" "epin")
  (setq epin_conlb 1)
  (regapp "epin")
;---------------------------------------------------
;Dialog start
;---------------------------------------------------
  (setq epin_dcl_id (load_dialog "Epin.dcl"))
  (while (= 1 epin_conlb)
    (if (not (new_dialog "EPINDLG" epin_dcl_id))
      (*error* "Can't open \"Epin.dcl\"")
    )
    (start_epin_image)
    (action_tile "cancel"  "(done_dialog 0)")
    (action_tile "accept"  "(done_dialog 1)")
    (action_tile "epin_ns" "(done_dialog 2)")
    (action_tile "epin_ws" "(done_dialog 3)")
    (setq epin_next (start_dialog))
    (cond 
      ((= 0 epin_next)
        (setq epin_conlb 0)
        (command "undo" "b")
      )
      ((= 1 epin_next)
        (setq epin_conlb 0)
      )
      ((= 2 epin_next)
        (load "epin_ns")
        (epin_ns)
      )
      ((= 3 epin_next)
        (load "epin_ws")
        (epin_ws)
      )
    )
  )
  (unload_dialog epin_dcl_id)
  (ac_lxy_set)
  (prin1)
)


;****************************** Initializing Image button function ******************************;
(defun start_epin_image()
  (foreach pic_fn '("epin_ns" "epin_ws")
    (start_image pic_fn)
    (slide_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) (strcat "ac_lxy(" pic_fn ")"))
    (end_image)
  )
)
;*************************************** end of function ****************************************;