;*****************************************************;
;* This is "epin_ns.lsp" program 		     *;
;* Complete compiled in 02/06/98                     *;
;* Last change in 02/09/99    			     *;
;* ZX Mold Ltd  XY.Liao    			     *;
;*****************************************************;

;************************************* Main function start **************************************;

(defun epin_ns( / err_msg1	err_msg2)

  (load "epin_lib")
;---------------------------------------------------------------------
;initializing
;---------------------------------------------------------------------
  (setq ns_conlb  1
	last_d_m  0
	last_d_b  0
	last_l_m  0
	last_l_b  0
	mbf       1
	if_h_v    "0"
  )
  (if (not epin_count)
    (setq epin_count 1)
  )
;-------------------------------------------------------------------
;starting dialog
;-------------------------------------------------------------------
  (while (= 1 ns_conlb)
    (if (not (new_dialog "nsdlg" epin_dcl_id))
      (*error* "Can't open \"Epin_ns.dcl\"!")
    )
    (ini_dcl_ns)
    (action_tile "NSM"     "(setq mbf 0) (ini_dcl_ns)")
    (action_tile "NSB"     "(setq mbf 1) (ini_dcl_ns)")
    (action_tile "NSTYP"   "(typ_act)")
    (action_tile "NSLEN"   "(len_act)")
    (action_tile "NSITEM"  "(setq rep_r $reason)  (valid_rep)")
    (action_tile "NSSPEC"  "(setq spec_r $reason) (valid_spec)")
    (action_tile "HIDDENV" "(ch_hidden) (start_ns_image)")
    (action_tile "cancel"  "(done_dialog 0)")
    (action_tile "accept"  "(done_dialog 1)")
    (action_tile "ns_z"    "(done_dialog 2)")
    (action_tile "ns_c"    "(done_dialog 3)")
    (action_tile "BACK"    "(done_dialog 4)")
    (action_tile "LOOK"    "(done_dialog 5)")
    (setq ns_next (start_dialog))
    (cond
      ((= 0 ns_next)
        (command "undo" "b")
        (setq ns_conlb 0)
        (setq epin_conlb 0)
      )
      ((= 1 ns_next)
        (setq ns_conlb 0)
        (setq epin_conlb 0)
      )
      ((= 2 ns_next)
        (epin_ns_zst)
      )
      ((= 3 ns_next)
        (epin_cst)
      )
      ((= 4 ns_next)
        (setq ns_conlb 0)
      )
      ((= 5 ns_next)
        (command "zoom" "")
      )
    )
  )
)
;*************************************** end of function ****************************************;


;**************************** Define dialog control functions group *****************************;
;-----------------------------------------
;Set hidden flag
;-----------------------------------------
(defun ch_hidden()                      
  (setq if_h_v (get_tile "HIDDENV"))
)

;----------------------------------------
;Initialize dialog
;----------------------------------------
(defun ini_dcl_ns()
  (cond 
    ((= 1 mbf)
      (setq mb "B")
      (set_tile "NSB" "1")
      (ini_list "NSTYP" (lib_ep 4))
      (ini_list "NSLEN" (lib_ep 12))
      (set_tile "NSTYP" (itoa last_d_b))
      (set_tile "NSLEN" (itoa last_l_b))
      (setq epin_type (nth last_d_b (lib_ep 4)))
      (setq epin_len  (nth last_l_b (lib_ep 12)))
      (setq d  (nth last_d_b (lib_ep 5)))
      (setq hd (nth last_d_b (lib_ep 6)))
      (setq b  (nth last_d_b (lib_ep 7)))
    )
    ((= 0 mbf)
      (setq mb "M")
      (set_tile "NSM" "1")
      (ini_list "NSTYP" (lib_ep 1))
      (ini_list "NSLEN" (lib_ep 10))
      (set_tile "NSTYP" (itoa last_d_m))
      (set_tile "NSLEN" (itoa last_l_m))
      (setq epin_type (nth last_d_m (lib_ep 1)))
      (setq epin_len  (nth last_l_m (lib_ep 10)))
      (setq d  (atof (nth last_d_m (lib_ep 1))))
      (setq hd (nth last_d_m (lib_ep 2)))
      (setq b  (nth last_d_m (lib_ep 3)))
    )
  )
  (setq rep (strcat "E" (itoa epin_count)))
  (set_tile "NSSPEC" (strcat epin_type "X" epin_len))
  (set_tile "NSITEM" rep)
  (set_tile "HIDDENV" if_h_v)
  (start_ns_image)
  (if err_msg1
    (set_tile "MSG" err_msg1)
    (if err_msg2
      (set_tile "MSG" err_msg2)
    )
  )
)
;-------------------------------------------
;Initialize image button
;-------------------------------------------
(defun start_ns_image(/ pic_fn)
  (cond 
    ((= "0" if_h_v)
      (foreach pic_fn '("ns_z" "ns_c")
	(start_image pic_fn)
	(fill_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) 0)
	(end_image)
      )
      (foreach pic_fn '("ns_z" "ns_c")
	(start_image pic_fn)
	(slide_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) (strcat "ac_lxy(" pic_fn ")"))
	(end_image)
      )
    )
    ((= "1" if_h_v)
      (foreach pic_fn '("ns_z" "ns_c")
	(start_image pic_fn)
	(fill_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) 0)
	(end_image)
      )
      (foreach pic_fn '("ns_z" "ns_c")
	(start_image pic_fn)
	(slide_image 0 0 (dimx_tile pic_fn) (dimy_tile pic_fn) (strcat "ac_lxy(" pic_fn "_h)"))
	(end_image)
      )
    )
  )
)
;------------------------------------------------
;Ejector pin diameter change function
;------------------------------------------------
(defun typ_act()
  (cond
    ((= "B" mb)
      (setq last_d_b (atoi (get_tile "NSTYP")))
      (setq epin_type (nth last_d_b (lib_ep 4)))
      (setq d  (nth last_d_b (lib_ep 5)))
      (setq hd (nth last_d_b (lib_ep 6)))
      (setq b  (nth last_d_b (lib_ep 7)))
    )
    ((= "M" mb)
      (setq last_d_m (atoi (get_tile "NSTYP")))
      (setq epin_type (nth last_d_m (lib_ep 1)))
      (setq d  (atof (nth last_d_m (lib_ep 1))))
      (setq hd (nth last_d_m (lib_ep 2)))
      (setq b  (nth last_d_m (lib_ep 3)))
    )
  )
  (set_tile "NSSPEC" (strcat epin_type "X" epin_len))
)
;------------------------------------------------
;Ejector pin length change function
;------------------------------------------------
(defun len_act()
  (cond
    ((= "B" mb)
      (setq last_l_b (atoi (get_tile "NSLEN")))
      (setq epin_len (nth last_l_b (lib_ep 12)))
    )
    ((= "M" mb)
      (setq last_l_m (atoi (get_tile "NSLEN")))
      (setq epin_len (nth last_l_m (lib_ep 10)))
    )
  )
  (set_tile "NSSPEC" (strcat epin_type "X" epin_len))
)
;------------------------------------------------
;Item number valid verify
;------------------------------------------------
(defun valid_rep()
  (setq rep (lxy_trim (get_tile "NSITEM")))
  (if (= 2 rep_r)
    (if (< (strlen rep) 2)
      (setq err_msg1 "Invalid item number!")
      (if (/= "E" (strcase (substr rep 1 1)))
        (setq err_msg1 "Invalid item number!")
        (if (= 0.0 (atof (substr rep 2)))
          (setq err_msg1 "Invalid item number!")
          (progn
            (setq epin_count (fix (atof (substr rep 2))))
            (setq rep (strcat "E" (itoa epin_count)))
            (set_tile "NSITEM" rep)
	    (setq err_msg1 nil)
          )
        )
      )
    )
  )
  (if err_msg1
    (progn 
      (mode_tile "NSITEM" 2)
      (set_tile "MSG" err_msg1)
    )
    (if (not err_msg2)
      (set_tile "MSG" "")
    )
  )
)
;------------------------------------------------
;specification box reset
;------------------------------------------------
(defun valid_spec()
  (if (= 2 spec_r)
    (set_tile "NSSPEC" (strcat epin_type "X" epin_len))
  )
)
;*********************************** End of functions group *************************************;


;****************************** Call create pin function function *******************************;
(defun epin_cst()
  (load "epnscst")
  (initget 32)
  (setvar "osmode" os_old)
  (setq err_msg2 nil)
  (if (setq pt1 (getpoint "\nPlease enter first point:"))
    (if (setq pt2 (getpoint pt1 "\nPlease enter second point:"))
      (if (setq pt3 (getpoint pt2 "\nPlease enter third point:"))
	(if (setq ob_ent (nentsel))
          (progn
            (setvar "osmode" 0)
            (setq epin_app "NEW")
            (ns_cst)
            (setvar "osmode" os_old)
          )
          (setq err_msg2 "Invalid entity!")
        )
        (setq err_msg2 "Invalid point!")
      )
      (setq err_msg2 "Invalid point!")
    )
    (setq err_msg2 "Invalid point!")
  )
  (if (not err_msg2)
    (progn
      (if (/= len epin_len)
        (cond
          ((= "B" mb)
            (setq last_l_b (xh_get len (lib_ep 12)))
          )
          ((= "M" mb)
            (setq last_l_m (xh_get len (lib_ep 10)))
          )
        )
      )
      (setq epin_sel_zst (ssget "x" '((0 . "INSERT") (-3 ("EPIN")))))
      (setq count_all (sslength epin_sel_zst))
      (setq kkk 0)
      (while (< kkk count_all)
        (setq epin_ent_zst (ssname epin_sel_zst kkk))
        (setq epin_data (cdr (cadr (cadr (assoc -3 (entget epin_ent_zst '("epin")))))))
        (setq epin_data (strtolst epin_data))
        (setq rep_zst  (nth 0 epin_data)
	      zc_zst   (nth 1 epin_data)
              type_zst (nth 2 epin_data)
	      len_zst  (nth 3 epin_data)
              typ_zst  (nth 5 epin_data)
        )
        (if (and (= "Z" zc_zst) (= rep rep_zst))
          (if (or (/= "N" typ_zst) (/= epin_type type_zst) (/= len len_zst))
            (progn
	      (setq cenpt (cdr (assoc 10 (entget epin_ent_zst))))
              ;(setq cenpt (wtou cenpt))
		(setq cenpt cenpt)
	      (entdel epin_ent_zst)
              (setq typ "N")
	      (setq epin_len len)
              (load "epin_zst")
	      (epin_zst)
            )
          )
        )
        (setq kkk (+ 1 kkk))
      )
      (setq epin_count (+ 1 epin_count))
    )
  )
)
;*************************************** end of function ****************************************;

;****************************** Call create pin function function *******************************;
(defun epin_ns_zst()
  (load "epin_zst")
  (setvar "osmode" os_old)
  (while (setq cenpt (getpoint "\nPlease enter center point:"))
    (setvar "osmode" 0)
    (setq typ "N")
    (epin_zst)
    (setq err_msg2 nil)
    (setvar "osmode" os_old)
  )
  (setq epin_count (+ 1 epin_count)) ;set epin counter
)
;*************************************** end of function ****************************************;