(defun mid (w z)
 (LIST 
   (/ (+ (nth 0 w) (nth 0 z))2) 
   (/ (+ (nth 1 w) (nth 1 z))2)
   (/ (+ (nth 2 w) (nth 2 z))2)
 )
)

(defun run_scr ()
(command "script" "mview")
)

(defun getbl_info ()
(setq bl_ent1 (ssget "X" '((0 . "INSERT")(2 . "EYETO"))))
(setq bl_ent2 (ssget "X" '((0 . "INSERT")(2 . "EYEFROM"))))
(if (not bl_ent1)
  (progn
  (setq pt1 (getpoint "\nCamera point not set... Pick camera location: "))
  (command "insert" "eyeto" pt1 "" "" "")
  (setq bl_ent1 (ssget "X" '((0 . "INSERT")(2 . "EYETO"))))
  )
)
(if (not bl_ent2)
  (progn
  (setq pt2 (getpoint pt1 "\nTarget point not set... Pick target point: "))
  (command "insert" "eyefrom" pt2 "" "" "")
  (setq bl_ent2 (ssget "X" '((0 . "INSERT")(2 . "EYEFROM"))))
  )
)
(setq bl_ins1 (cdr (assoc 10 (entget (ssname bl_ent1 0)))))
(setq bl_ins2 (cdr (assoc 10 (entget (ssname bl_ent2 0)))))
)

(defun c:showeye (/ bl_ent1 bl_ent2 bl_ins1 bl_ins2)
(getbl_info)
(command "dview" "" "PO" bl_ins2 bl_ins1 "d" "" "")
(command "change" bl_ent1 "" "" "" bl_ins2 "")
(command "change" bl_ent2 "" "" "" bl_ins1 "")
)

(defun c:findeye (/ bl_ent1 bl_ent2 bl_ins1 bl_ins2)
(getbl_info)
(setq mid_way (mid bl_ins1 bl_ins2))
(grdraw bl_ins1 mid_way 1)
(grdraw mid_way bl_ins2 3)
)

(defun c:crosseye (/ bl_ent1 bl_ent2 bl_ins1 bl_ins2)
(getbl_info)
(command "dview" "" "PO" bl_ins1 bl_ins2 "d" "" "")
(command "change" bl_ent1 "" "" "" bl_ins2 "")
(command "change" bl_ent2 "" "" "" bl_ins1 "")
)

(defun c:mtarg (/ bl_ent1 bl_ent2 bl_ins1 bl_ins2 ptbase)
(getbl_info)
(c:findeye)
(command "move" bl_ent2 "" pause pause)
(c:findeye)
)
(defun c:meye (/ bl_ent1 bl_ent2 bl_ins1 bl_ins2 ptbase)
(getbl_info)
(c:findeye)
(command "move" bl_ent1 "" pause pause)
(c:findeye)
)

(defun c:seteye (/ bl_ent1 bl_ent2 bl_ins1 bl_ins2 DOIT OBJ1 CCAMERA)
(getbl_info)
(princ "\nClick on perspective viewport to make it active. ")
(initget "Off ON Focal Pan Hide Show setUp")
(setq doit (getkword "\nPerspective Off/ON/Focal length/Pan/Hide eyes/Show eyes/setUp vports: "))
(cond
   ((= doit "setUp")(command "script" "mview"))
   ((= doit "Off")(command "dview" "" "O" ""))
   ((= doit "Hide")(command "layer" "off" "eyes" ""))
   ((= doit "Show")(command "layer" "on" "eyes" ""))
   ((= doit "ON")(command "dview" "" "d" "" ""))
   ((= doit "Focal")(setq f_lngth (getreal "\n Enter focal length in mm: "))(command "dview" "" "z" f_lngth ""))
   ((= doit "Pan")(COMMAND "UCS" "W")
                  (setq obj1 (ssget))
                  (princ "pick points: ")
                  (command "dview" obj1 "" "pa" pause pause "")
		  (getbl_info)
		  (setq ccamera (mapcar '+ (getvar "target")(getvar "viewdir")))
		  (command "move" bl_ent2 "" bl_ins2 (getvar "target"))
		  (command "move" bl_ent1 "" bl_ins1 ccamera)
		  (command "ucs" "P")
   )
)
)


(DEFUN C:PANEYE (/ bl_ent1 bl_ent2 bl_ins1 bl_ins2 OBJ1 CCAMERA)
(COMMAND "UCS" "W")
(getbl_info)
(setq obj1 (ssget))
(princ "pick points: ")
(command "dview" obj1 "" "pa" pause pause "")
(getbl_info)
(setq ccamera (mapcar '+ (getvar "target")(getvar "viewdir")))
(command "move" bl_ent2 "" bl_ins2 (getvar "target"))
(command "move" bl_ent1 "" bl_ins1 ccamera)
(command "ucs" "P")
)

(defun c:matcheye (/ bl_ent1 bl_ent2 bl_ins1 bl_ins2 ccamera)
(command "ucs" "W")
(getbl_info)
(setq ccamera (mapcar '+ (getvar "target")(getvar "viewdir")))
(command "move" bl_ent2 "" bl_ins2 (getvar "target"))
(command "move" bl_ent1 "" bl_ins1 ccamera)
(command "ucs" "P")
)