;****************************************;
;* This is "mxb_edit.lsp" program	*;
;* Full compiled in 01/20/99		*;
;* Last changed in 02/23/99		*;
;* ZX Mold Ltd  XY.Liao			*;
;****************************************;
;******************************* Main function start *******************************;
(defun mxb_edit( / pt1 		pt2		rep		qty		desc	
		chin		mat		obv		cot		os_old	
		dcl_id		lib_item_n	qty_n		mat_n		chin_n	
		desc_n		cot_n		err_text	chin_r	 	desc_r)
;----------------------------------------
;defun local function
;----------------------------------------
  (defun a_view() (command "zoom" ""))
;----------------------------------------
;shut off command echo and set undo mark
;----------------------------------------
  (setvar "cmdecho" 0)
  (command "undo" "m")
;----------------------------------------
;save old system variable
;----------------------------------------
  (setq orgpt (getvar "ucsorg"))
  (setq os_old (getvar "osmode"))
  (setq la_old (getvar "clayer"))
  (setq st_old (getvar "textstyle"))
;--------------------------------------
;Initializing 
;--------------------------------------
  (ini_useri2)
  (load "lib_a")
  (ent_get)
  (if (not ent_mxb)
    (*error* "\nInvalid entity!")
  )
  (setq qty_n nil)
  (setq mat_n nil)
  (setq if_continue 1)
;-------------------------------------
;Load dialog and start dialog
;-------------------------------------
  (setq dcl_id (load_dialog "PartList"))
  (while (= 1 if_continue)
    (if (not (new_dialog "mxb_edit" dcl_id))
       (exit)
    )
    (ini_dia)
    (action_tile "A_CHIN_VALUE" "(click_chin)")
    (action_tile "A_DESC_VALUE" "(click_desc)")
    (action_tile "A_MAT_VALUE" "(click_mat)")
    (action_tile "A_QTY_VALUE" "(click_qty)")
    (action_tile "A_COT_VALUE" "(click_cot)")
    (action_tile "A_OBV_VALUE" "(click_obv)")
    (action_tile "accept" "(get_all_a) (done_dialog 1)")
    (action_tile "cancel" "(done_dialog 2)")
    (action_tile "A_DEL" "(done_dialog 3)")
    (setq what_next (start_dialog))
;----------------------------------------
;Determine what to do next
;----------------------------------------
    (cond
	((= 1 what_next)
	 (modify_ent)
  	 (setq if_continue 0)
	)
	((= 2 what_next)
	 (command "undo" "b")
	 (setq if_continue 0)
	)
	((= 3 what_next)
	 (del_item)
	 (setq if_continue 0)
	)
    )
  )
;--------------------------------------
;unload dialog and reset system variable
;--------------------------------------
  (unload_dialog dcl_id)
  (ac_lxy_set)
  (prin1)
)
;****************************** Main function end **********************************;

;--------------------------------------
;Do when change chinses name in dialog
;--------------------------------------
(defun click_chin()
  (setq chin_n (atoi (get_tile "A_CHIN_VALUE")))
  (set_tile "A_CHIN" (nth chin_n (lib_a 1)))
  (set_tile "A_DESC" (nth chin_n (lib_a 2)))
  (set_tile "A_DESC_VALUE" (itoa chin_n))
)

;--------------------------------------
;Do when change english name in dialog
;--------------------------------------
(defun click_desc()
  (setq desc_n (atoi (get_tile "A_DESC_VALUE")))
  (set_tile "A_DESC" (nth desc_n (lib_a 2)))
  (set_tile "A_CHIN" (nth desc_n (lib_a 1)))
  (set_tile "A_CHIN_VALUE" (itoa desc_n))
)

;--------------------------------------
;Do when change part quantity in dialog
;--------------------------------------
(defun click_qty()
  (setq qty_n (atoi (get_tile "A_QTY_VALUE")))
  (set_tile "A_QTY" (nth qty_n (lib_a 5)))
)

;--------------------------------------
;Do when change material in dialog
;--------------------------------------
(defun click_mat()
  (setq mat_n (atoi (get_tile "A_MAT_VALUE")))
  (set_tile "A_MAT" (nth mat_n (lib_a 7)))
)

;--------------------------------------
;Do when change hardness in dialog
;--------------------------------------
(defun click_obv()
  (setq obv_n (atoi (get_tile "A_OBV_VALUE")))
  (set_tile "A_OBV" (nth obv_n (lib_a 8)))
)

;--------------------------------------
;Do when change specification in dialog
;--------------------------------------
(defun click_cot()
  (setq cot_n (atoi (get_tile "A_COT_VALUE")))
)

;--------------------------------------
;Delete bill table item function
;--------------------------------------
(defun del_item(/ ent_sel 	ent_count	k 		ent_1 		ent_2 
		ent_rep 	old_inspt 	new_inspt 	ent_n)
  (if ent_item
    (progn
      (setvar "useri1" (- (getvar "useri1") 1))
      (entdel (cdr (assoc 330 (entget ent_item))))
      (entdel ent_item)
      (entdel ent_mxb)
      (setq ent_sel_item (ssget "X" '((0 . "INSERT") (-3 ("MXBITEM")))))
      (setq ent_sel_mxb  (ssget "X" '((0 . "INSERT") (-3 ("MXB_NSTANDARD")))))
      (if ent_sel_item
        (setq ent_count (sslength ent_sel_item))
      )
      (setq k 0)
      (while (< k ent_count)
        (setq ent (ssname ent_sel_item k))
        (setq rep_old (cdr (cadr (cadr (assoc -3 (entget ent '("mxbitem")))))))
        (if (< (atoi rep) (atoi rep_old))
          (progn
	    (setq ent_1 (entnext ent))
	    (mod_ent1 ent_1 (itoa (- (atoi (cdr (assoc 1 (entget ent_1)))) 1)))
            (setq xd_new (list -3 (list "MXBITEM" (cons 1000 (itoa (- (atoi rep_old) 1))))))
            (setq ed (entget ent '("mxbitem")))
            (setq ed (subst xd_new (assoc -3 ed) ed))
            (entmod ed)
          )
        )
        (setq k (+ 1 k))
      )
      (if ent_sel_mxb
        (setq ent_count (sslength ent_sel_mxb))
      )
      (setq k 0)
      (while (< k ent_count)
        (setq ent (ssname ent_sel_mxb k))
        (setq rep_old (cdr (cadr (cadr (assoc -3 (entget ent '("mxb_nstandard")))))))
        (if (< (atoi rep) (atoi rep_old))
          (progn
	    (setq ent_1 (entnext ent))
            (setq xd_new (list -3 (list "MXB_NSTANDARD" (cons 1000 (itoa (- (atoi rep_old) 1))))))
            (setq ed (entget ent '("mxb_nstandard")))
            (setq ed (subst xd_new (assoc -3 ed) ed))
            (entmod ed)
	    (mod_ent1 ent_1 (itoa (- (atoi (cdr (assoc 1 (entget ent_1)))) 1)))
	    (setq old_inspt (cdr (assoc 10 (entget ent))))
	    (setq new_inspt (polar old_inspt (* pi 0.5) 8.0))
	    (command "move" ent "" new_inspt old_inspt)
          )
        )
        (setq k (+ 1 k))
      )
      (if (= 0 (getvar "useri1"))
        (progn
          (setq nstd_head (ssget "X" '((0 . "INSERT") (-3 ("mxb_nstandard")))))
          (if nstd_head
            (command "erase" nstd_head "")
          )
        )
      )
    )
  )
)

;--------------------------------------
;Get bill table item that need to be modified
;--------------------------------------
(defun ent_get(/ ent_a ent_sel ent_count ent k)
  (setq ent_a (car (entsel)))
  (while (not ent_a)
    (setq ent_a (car (entsel)))
  )
  (if (not (or (assoc -3 (entget ent_a '("mxbitem")))
	       (assoc -3 (entget ent_a '("mxb_nstandard")))
               (assoc -3 (entget ent_a '("mxb_standard")))))
    (*error* "Чʵ")
  )
  (setq ent_item nil)
  (setq ent_mxb nil)
  (cond
    ((assoc -3 (entget ent_a '("mxbitem")))
      (setq ent_item ent_a)
      (setq rep (cdr (cadr (cadr (assoc -3 (entget ent_a '("mxbitem")))))))
      (setq ent_sel (ssget "x" (list (cons 0 "INSERT") (list -3 (list "MXB_NSTANDARD")))))
      (if ent_sel
        (progn
          (setq k 0)
          (setq ent_count (sslength ent_sel))
	  (while (< k ent_count)
            (setq ent (ssname ent_sel k))
            (if (= rep (cdr (cadr (cadr (assoc -3 (entget ent '("mxb_nstandard")))))))
              (setq ent_mxb ent
		    k ent_count
              )
              (setq k (+ k 1))
            )
          )
        )
      )
    )
    ((assoc -3 (entget ent_a '("mxb_nstandard")))
      (setq ent_mxb ent_a)
      (setq rep (cdr (cadr (cadr (assoc -3 (entget ent_a '("mxb_nstandard")))))))
      (setq ent_sel (ssget "x" (list (cons 0 "INSERT") (list -3 (list "MXBITEM")))))
      (if ent_sel
        (progn
          (setq k 0)
          (setq ent_count (sslength ent_sel))
	  (while (< k ent_count)
            (setq ent (ssname ent_sel k))
            (if (= rep (cdr (cadr (cadr (assoc -3 (entget ent '("mxbitem")))))))
              (setq ent_item ent
		    k ent_count
              )
              (setq k (+ k 1))
            )
          )
        )
      )
    )
    ((assoc -3 (entget ent_a '("mxb_standard")))
      (setq ent_mxb ent_a)
      (setq rep (cdr (assoc 1 (entget (entnext ent_a)))))
    )
  )
  (if ent_mxb
    (setq ent_rep  (entnext ent_mxb)
	  ent_qty  (entnext ent_rep)
	  ent_chin (entnext ent_qty)
	  ent_desc (entnext ent_chin)
	  ent_mat  (entnext ent_desc)
	  ent_cot  (entnext ent_mat)
	  ent_obv  (entnext ent_cot)
	  qty      (cdr (assoc 1 (entget ent_qty)))
	  chin     (cdr (assoc 1 (entget ent_chin)))
	  desc     (cdr (assoc 1 (entget ent_desc)))
	  mat      (cdr (assoc 1 (entget ent_mat)))
	  cot      (cdr (assoc 1 (entget ent_cot)))
	  obv      (cdr (assoc 1 (entget ent_obv)))
    )
  )
)
;------------------------------------------------------------------------------------;	
(defun modify_ent()
  (mod_ent1 ent_chin chin)
  (mod_ent1 ent_desc desc)
  (mod_ent1 ent_qty qty)
  (mod_ent1 ent_mat mat)
  (mod_ent1 ent_obv obv)
  (mod_ent1 ent_cot cot)
)

;------------------------------------------------------------------------------------;	
(defun mod_ent1(ent_name mod_data / ent_data)
  (setq ent_data (entget ent_name))
  (setq ent_data (subst (cons 1 mod_data)
			(assoc 1 ent_data)
			ent_data)
  )
  (entmod ent_data)
  (entupd ent_name)
)
;------------------------------------------------------------------------------------;	

;------------------------------------------------------------------------------------;	
(defun mod_ent2(ent_name mod_data / ent_data)
  (setq ent_data (entget ent_name))
  (setq ent_data (subst (append '(10) mod_data)
			(assoc 10 ent_data)
			ent_data)
  )
  (entmod ent_data)
  (entupd ent_name)
)
;------------------------------------------------------------------------------------;	


(defun ini_dia()
  (ini_list "A_CHIN_VALUE" (lib_a 1))
  (ini_list "A_DESC_VALUE" (lib_a 2))
  (ini_list "A_QTY_VALUE" (lib_a 5))
  (set_tile "A_QTY" qty)
  (set_tile "A_CHIN" chin)
  (set_tile "A_DESC" desc)
  (set_tile "A_MAT" mat)
  (set_tile "A_REP" rep)
  (set_tile "A_COT" cot)
  (set_tile "A_OBV" obv)
  (mode_tile "A_REP" 1)
  (if (not ent_item)
    (mode_tile "A_DEL" 1)
  )
  (ini_list "A_MAT_VALUE" (lib_a 7))
  (ini_list "A_OBV_VALUE" (lib_a 8))
)

(defun get_all_a()
  (if (not (setq chin (get_tile "A_CHIN")))
    (setq chin " ")
  )  
  (if (not (setq desc (get_tile "A_DESC")))
    (setq desc " ")
  )  
  (if (not (setq mat (get_tile "A_MAT")))
    (setq mat " ")
  )  
  (if (not (setq cot (get_tile "A_COT")))
    (setq cot " ")
  )  
  (if (not (setq qty (get_tile "A_QTY")))
    (setq qty "1")
  )  
  (if (not (setq obv (get_tile "A_OBV")))
    (setq obv " ")
  )
)  
