;****************************************;
;* This is "mxb_insert.lsp" program	*;
;* Full compiled in 01/20/99		*;
;* Last changed in 02/23/99		*;
;* ZX Mold Ltd  XY.Liao			*;
;****************************************;
;******************************* Main function start *******************************;
(defun mxb_insert( / 	pt1 		pt2		rep		qty		desc	
			chin		mat		obv		cot		os_old	
			dcl_id		lib_item_n	qty_n		mat_n		chin_n	
			desc_n		cot_n		err_text	chin_r	 	desc_r
			rep_r)
;----------------------------------------
;defun local function
;----------------------------------------
  (defun a_view() (command "zoom" ""))
;----------------------------------------
;shut off command echo and set undo mark
;----------------------------------------
  (setvar "cmdecho" 0)
  (command "undo" "m")
;----------------------------------------
;save old system variable
;----------------------------------------
  (setq orgpt (getvar "ucs"))
  (setq os_old (getvar "osmode"))
  (setq la_old (getvar "clayer"))
  (setq st_old (getvar "textstyle"))
;---------------------------------------
;if "mxb" layer does not exist then create it
;else thaw on and unlock it
;--------------------------------------- 
  (if (not (tblsearch "layer" "mxb"))
    (command "_.layer" "_new" "mxb" "_color" "red" "mxb" "_ltype" "continuous" "mxb" "")
    (command "_.layer" "thaw" "mxb" "on" "mxb" "unlock" "mxb" ""
	     "_.layer" "thaw" "0" "on" "0" "unlock" "0" "")
  )
;--------------------------------------
;set current use system variable
;--------------------------------------
  (setvar "clayer" "mxb")
  (setvar "osmode" 0)
;--------------------------------------
;Initializing 
;--------------------------------------
  (ini_useri2)
  (setq lib_item_n nil)
  (setq qty_n nil)
  (setq mat_n nil)
  (load "lib_a")
  (setq if_continue 1)
  (if (not (tblsearch "appid" "mxbitem"))
    (regapp "mxbitem")
  )
  (if (not (tblsearch "appid" "mxb_nstandard"))
    (regapp "mxb_nstandard")
  )
;-------------------------------------
;Load dialog and start dialog
;-------------------------------------
  (setq dcl_id (load_dialog "PartList"))
  (while (= 1 if_continue)
    (if (not (new_dialog "mxb_insert" dcl_id))
	(exit)
    )
    (ini_dia)
    (action_tile "A_CHIN_VALUE" "(click_chin)")
    (action_tile "A_CHIN" "(setq chin_r $reason) (item_en)")
    (action_tile "A_ITEM" "(setq rep_r $reason) (if_valid)")
    (action_tile "A_DESC_VALUE" "(click_desc)")
    (action_tile "A_DESC" "(setq desc_r $reason) (item_en)")
    (action_tile "A_MAT_VALUE" "(click_mat)")
    (action_tile "A_QTY_VALUE" "(click_qty)")
    (action_tile "A_COT_VALUE" "(click_cot)")
    (action_tile "A_OBV_VALUE" "(click_obv)")
    (action_tile "accept" "(get_all_a)")
    (action_tile "cancel" "(done_dialog 2)")
    (action_tile "A_LOOK" "(done_dialog 3)")
    (setq what_next (start_dialog))
;----------------------------------------
;Determine what to do next
;----------------------------------------
    (cond
      ((= 1 what_next)
        (create_ent)
	(setq if_continue 0)
      )
      ((= 2 what_next)
	(command "undo" "b")
	(setq if_continue 0)
      )
      ((= 3 what_next)
	(a_view)
	(setq if_continue 1)
      )
    )
  )
;--------------------------------------
;unload dialog and reset system variable
;--------------------------------------
  (unload_dialog dcl_id)
  (ac_lxy_set)
  (prin1)
)
;****************************** Main function end **********************************;


;--------------------------------------
;Do when change chinses name in dialog
;--------------------------------------
(defun click_chin()
  (setq chin_n (atoi (get_tile "A_CHIN_VALUE")))
  (set_tile "A_CHIN" (nth chin_n (lib_a 1)))
  (set_tile "A_DESC" (nth chin_n (lib_a 2)))
  (set_tile "A_DESC_VALUE" (itoa chin_n))
  (ini_list "A_MAT_VALUE" (nth chin_n (lib_a 3)))
  (set_tile "A_MAT_VALUE" "0")
  (set_tile "A_MAT" (car (nth chin_n (lib_a 3))))
  (ini_list "A_OBV_VALUE" (nth chin_n (lib_a 6)))
  (set_tile "A_OBV_VALUE" "0")
  (set_tile "A_OBV" (car (nth chin_n (lib_a 6))))
  (setq lib_item_n chin_n)
)

;--------------------------------------
;Do when change english name in dialog
;--------------------------------------
(defun click_desc()
  (setq desc_n (atoi (get_tile "A_DESC_VALUE")))
  (set_tile "A_DESC" (nth desc_n (lib_a 2)))
  (set_tile "A_CHIN" (nth desc_n (lib_a 1)))
  (set_tile "A_CHIN_VALUE" (itoa desc_n))
  (ini_list "A_MAT_VALUE" (nth desc_n (lib_a 3)))
  (set_tile "A_MAT_VALUE" "0")
  (set_tile "A_MAT" (car (nth desc_n (lib_a 3))))
  (ini_list "A_OBV_VALUE" (nth desc_n (lib_a 6)))
  (set_tile "A_OBV_VALUE" "0")
  (set_tile "A_OBV" (car (nth desc_n (lib_a 6))))
  (setq lib_item_n desc_n)
)

;--------------------------------------
;Do when change part quantity in dialog
;--------------------------------------
(defun click_qty()
  (setq qty_n (atoi (get_tile "A_QTY_VALUE")))
  (set_tile "A_QTY" (nth qty_n (lib_a 5)))
)

;--------------------------------------
;Do when change material in dialog
;--------------------------------------
(defun click_mat()
  (setq mat_n (atoi (get_tile "A_MAT_VALUE")))
  (if lib_item_n
    (progn
      (set_tile "A_MAT" (nth mat_n (nth lib_item_n (lib_a 3))))
      (if (/= 0 lib_item_n)
	(progn
    	  (set_tile "A_OBV" (nth mat_n (nth lib_item_n (lib_a 6))))
    	  (set_tile "A_OBV_VALUE" (itoa mat_n))
	)
      )
    )
    (set_tile "A_MAT" (nth mat_n (lib_a 7)))
  )
)

;--------------------------------------
;Do when change hardness in dialog
;--------------------------------------
(defun click_obv()
  (setq obv_n (atoi (get_tile "A_OBV_VALUE")))
  (if lib_item_n
    (set_tile "A_OBV" (nth obv_n (nth lib_item_n (lib_a 6))))
    (set_tile "A_OBV" (nth obv_n (lib_a 8)))
  )
)

;--------------------------------------
;Do when change specification in dialog
;--------------------------------------
(defun click_cot()
  (setq cot_n (atoi (get_tile "A_COT_VALUE")))
)



;------------------------------------------------------------------------------------;	
(defun mod_ent1(ent_name mod_data / ent_data)
  (setq ent_data (entget ent_name))
  (setq ent_data (subst (cons 1 mod_data)
			(assoc 1 ent_data)
			ent_data)
  )
  (entmod ent_data)
  (entupd ent_name)
)
;------------------------------------------------------------------------------------;	

;------------------------------------------------------------------------------------;	
(defun mod_ent2(ent_name mod_data / ent_data)
  (setq ent_data (entget ent_name))
  (setq ent_data (subst (append '(10) mod_data)
			(assoc 10 ent_data)
			ent_data)
  )
  (entmod ent_data)
  (entupd ent_name)
)
;------------------------------------------------------------------------------------;	

(defun if_valid(/ strg)
  (if (= 2 rep_r)
    (setq strg (get_tile "A_ITEM"))
  )
  (if (= "" strg)
    (progn
      (setq err_text "ŲΪ!")
      (set_tile "ERR_MSG" err_text)
      (mode_tile "A_ITEM" 2)
    )
    (progn
      (setq strg (lxy_trim strg))
      (if (= 0 (atoi strg))
        (progn
          (setq err_text "Ч!")
          (set_tile "ERR_MSG" err_text)
          (mode_tile "A_ITEM" 2)
        )
        (progn
          (setq strg (itoa (atoi strg)))
          (set_tile "A_ITEM" strg)
          (set_tile "ERR_MSG" "")
          (setq err_text nil)
        )
      )
    )
  )
)

(defun ini_dia()
  (ini_list "A_CHIN_VALUE" (lib_a 1))
  (ini_list "A_DESC_VALUE" (lib_a 2))
  (ini_list "A_QTY_VALUE" (lib_a 5))
  (set_tile "A_QTY" "1")
  (if lib_item_n
    (progn
      (set_tile "A_CHIN" (nth lib_item_n (lib_a 1)))
      (set_tile "A_DESC" (nth lib_item_n (lib_a 2)))
      (set_tile "A_CHIN_VALUE" (itoa lib_item_n))
      (set_tile "A_DESC_VALUE" (itoa lib_item_n))
      (ini_list "A_MAT_VALUE" (nth lib_item_n (lib_a 3)))
      (set_tile "A_MAT_VALUE" "0")
      (set_tile "A_MAT" (car (nth lib_item_n (lib_a 3))))
      (ini_list "A_OBV_VALUE" (nth lib_item_n (lib_a 6)))
      (set_tile "A_OBV_VALUE" "0")
      (set_tile "A_OBV" (car (nth lib_item_n (lib_a 6))))
      (if mat_n
    	(progn
    	  (set_tile "A_MAT" (nth mat_n (nth lib_item_n (lib_a 3))))
    	  (set_tile "A_OBV" (nth mat_n (nth lib_item_n (lib_a 6))))
    	  (set_tile "A_OBV_VALUE" (itoa mat_n))
	)
      )
    )
    (progn
      (ini_list "A_MAT_VALUE" (lib_a 7))
      (ini_list "A_OBV_VALUE" (lib_a 8))
    )
  )
  (if qty_n
    (progn
      (set_tile "A_QTY_VALUE" (itoa qty_n))
      (set_tile "A_QTY" (nth qty_n (lib_a 5)))
    )
  )
)

(defun get_all_a()
  (if (not (setq chin (get_tile "A_CHIN")))
    (setq chin " ")
  )  
  (if (not (setq desc (get_tile "A_DESC")))
    (setq desc " ")
  )  
  (if (not (setq mat (get_tile "A_MAT")))
    (setq mat " ")
  )  
  (if (not (setq cot (get_tile "A_COT")))
    (setq cot " ")
  )  
  (if (not (setq qty (get_tile "A_QTY")))
    (setq qty "1")
  )  
  (if (not (setq obv (get_tile "A_OBV")))
    (setq obv " ")
  )
  (setq rep (get_tile "A_ITEM"))
  (if (/= 2 rep_r)
    (progn
      (setq err_text "!")
      (set_tile "ERR_MSG" err_text)
      (mode_tile "A_ITEM" 2)
    )
    (done_dialog 1)
  )      
)  
  

(defun item_en()
  (if (= 2 chin_r)
    (progn
      (if (xh_get (get_tile "A_CHIN") (lib_a 1))
 	(progn
	  (set_tile "A_CHIN_VALUE" (itoa (xh_get (get_tile "A_CHIN") (lib_a 1))))
	  (click_chin)
        )
	(progn
	  (ini_list "A_MAT_VALUE" (lib_a 7))
	  (ini_list "A_OBV_VALUE" (lib_a 8))
	)
      )
      (setq chin_r nil)
    )
  )
  (if (= 2 desc_r)
    (progn
      (if (xh_get (get_tile "A_DESC") (lib_a 2))
 	(progn
	  (set_tile "A_DESC_VALUE" (itoa (xh_get (get_tile "A_DESC") (lib_a 2))))
	  (click_desc)
	)
	(progn
	  (ini_list "A_MAT_VALUE" (lib_a 7))
	  (ini_list "A_OBV_VALUE" (lib_a 8))
	)
      )
      (setq desc_r nil)
    )
  )
)

;--------------------------------------
;Insert bill table item function
;--------------------------------------
(defun insert_item(/ ent_sel 	ent_count 	k 		ent_1 		ent_2 
		ent_rep 	old_inspt 	new_inspt)

  (setq ent_sel_item (ssget "X" '((0 . "INSERT") (-3 ("MXBITEM")))))
  (setq ent_sel_mxb  (ssget "X" '((0 . "INSERT") (-3 ("MXB_NSTANDARD")))))
  (if ent_sel_item
    (setq ent_count (sslength ent_sel_item))
  )
  (setq k 0)
  (while (< k ent_count)
    (setq ent (ssname ent_sel_item k))
    (setq rep_old (cdr (cadr (cadr (assoc -3 (entget ent '("mxbitem")))))))
    (if (<= (atoi rep) (atoi rep_old))
      (progn
        (setq ent_1 (entnext ent))
	(mod_ent1 ent_1 (itoa (+ (atoi rep_old) 1)))
        (setq xd_new (list -3 (list "MXBITEM" (cons 1000 (itoa (+ (atoi rep_old) 1))))))
        (setq ed (entget ent '("mxbitem")))
        (setq ed (subst xd_new (assoc -3 ed) ed))
        (entmod ed)
      )
    )
    (setq k (+ 1 k))
  )
  (if ent_sel_mxb
    (setq ent_count (sslength ent_sel_mxb))
  )
  (setq k 0)
  (while (< k ent_count)
    (setq ent (ssname ent_sel_mxb k))
    (setq rep_old (cdr (cadr (cadr (assoc -3 (entget ent '("mxb_nstandard")))))))
    (if (<= (atoi rep) (atoi rep_old))
      (progn
	(setq ent_1 (entnext ent))
        (setq xd_new (list -3 (list "MXB_NSTANDARD" (cons 1000 (itoa (+ (atoi rep_old) 1))))))
        (setq ed (entget ent '("mxb_nstandard")))
        (setq ed (subst xd_new (assoc -3 ed) ed))
        (entmod ed)
	(mod_ent1 ent_1 (itoa (+ (atoi rep_old) 1)))
	(setq old_inspt (cdr (assoc 10 (entget ent))))
	(setq new_inspt (polar old_inspt (* pi 1.5) 8.0))
	(command "move" ent "" new_inspt old_inspt)
      )
    )
    (setq k (+ 1 k))
  )
)


;--------------------------------------
;create bill table
;--------------------------------------
(defun create_ent( / pt 	pt1 		pt2 		pt22		a_ent	
				sel_ent old_var)
  (initget 32)
  (if (= 0 (getvar "useri1"))
    (progn
      (while (not basept)
  	(setq basept (getpoint "\nPlease enter bom table insert point:"))
      )
      (setvar "userr1" (+ (car basept)  (car orgpt)))
      (setvar "userr2" (+ (cadr basept) (cadr orgpt)))
    )
    (progn
      (setq basept (list (getvar "userr1") (getvar "userr2")))
      (setq basept (wtou basept))
    )
  )
  (if basept
    (progn
      (setq pt (polar (polar basept pi 200) (/ pi 2) (* (atoi rep) 8)))
      (if (setq pt1 (getpoint "\nPlease get first point:"))
        (if (setq pt2 (getpoint pt1 "\nPlease get second point:"))
          (progn
            (setq pt22 (polar pt2 (angle pt2 pt1) 6))

            (insert_item)
            (setq dmbk_old (getvar "dimblk"))
            (setq dmas_old (getvar "dimasz"))
            (setvar "dimblk" "dot")
            (if (/= 0 (getvar "dimscale"))
              (setvar "dimasz" (/ 1 (getvar "dimscale")))
              (progn
                (setvar "dimscale" (/ 3 (getvar "dimtxt")))
                (setvar "dimasz" (/ 1 (getvar "dimscale")))
              )
            )
	    (setq old_var (getvar "attdia"))
	    (setvar "attdia" 0)
            (command "leader" pt1 pt22 "" "" "_block" "mxb_item" pt2 "" "" "" rep) 
            
            (setq xd (list (list -3 (list "mxbitem" (cons 1000 rep)))))
            (mxdata  (entlast) xd)
            (command "dimblk" dmbk_old)
            (command "dimasz" dmas_old)
            (setvar "useri2" (+ 1 (getvar "useri2")))

            (if (= 0 (getvar "useri1"))
  	      (command "insert" "mxb_head.dwg" basept "" "" "")
            )
            (setq xd (list (list -3 (list "mxb_nstandard" (cons 1000 "mxb_head")))))
            (mxdata  (entlast) xd)
            (command "insert" "MXB_TAB_L.dwg" pt "" "" "" rep qty chin desc mat cot obv)
	    (setvar "attdia" old_var)
            (setq xd (list (list -3 (list "mxb_nstandard" (cons 1000 rep)))))
            (mxdata  (entlast) xd)
            (setvar "useri1" (+ 1 (getvar "useri1")))
          )
        )
      )
    )
  )
)