;****************************************;
;* This is "mxb.lsp" program		*;
;* Full compiled in 01/20/99		*;
;* Last changed in 02/23/99		*;
;* ZX Mold Ltd  XY.Liao			*;
;****************************************;
;******************************* Main function start *******************************;
(defun mxb()
; / 	pt1 		pt2		/*rep/*		qty		desc		
;		chin		mat		obv		cot		os_old		
	;	dcl_id		lib_item_n	qty_n		mat_n		chin_n		
	;	desc_n		cot_n		err_text	chin_r 		desc_r		
	;	orgpt		la_old		item_r)
;----------------------------------------
;defun local function
;----------------------------------------
  (defun a_view() (command "zoom" ""))
;----------------------------------------
;shut off command echo and set undo mark
;----------------------------------------
  (setvar "cmdecho" 0)
  (command "undo" "m")
;----------------------------------------
;save old system variable
;----------------------------------------
  (setq orgpt (getvar "ucsorg"))
  (setq os_old (getvar "osmode"))
  (setq la_old (getvar "clayer"))
  (setq st_old (getvar "textstyle"))
;---------------------------------------
;if "mxb" layer does not exist then create it
;else thaw on and unlock it
;--------------------------------------- 
  (if (not (tblsearch "layer" "mxb"))
    (command "_.layer" "_new" "mxb" "_color" "red" "mxb" "_ltype" "continuous" "mxb" "")
    (command "_.layer" "thaw" "mxb" "on" "mxb" "unlock" "mxb" "")
  )
;--------------------------------------
;set current use system variable
;--------------------------------------
  (setvar "clayer" "mxb")
;--------------------------------------
;Initializing 
;--------------------------------------
  (ini_useri2)
  (load "lib_a")
  (setq lib_item_n nil)
  (setq qty_n nil)
  (setq mat_n nil)
  (setq if_continue 1)
  (if (not (tblsearch "appid" "mxbitem"))
    (regapp "mxbitem")
  )
  (if (not (tblsearch "appid" "mxb_nstandard"))
    (regapp "mxb_nstandard")
  )
;-------------------------------------
;Load dialog and start dialog
;-------------------------------------
  (setq dcl_id (load_dialog "PartList"))
  (while (= 1 if_continue)
    (if (not (new_dialog "mxb_new" dcl_id))
	(exit)
    )
    (ini_dia)
    (action_tile "A_INS" "(get_all_a) (done_dialog 6)")
    (action_tile "A_BASE" "(get_all_a) (done_dialog 2)")
    (action_tile "A_CHIN_VALUE" "(click_chin)")
    (action_tile "A_CHIN" "(setq chin_r $reason) (get_all_a) (item_en)")
    (action_tile "A_DESC_VALUE" "(click_desc)")
    (action_tile "A_DESC" "(setq desc_r $reason) (get_all_a) (item_en)")
    (action_tile "A_MAT_VALUE" "(click_mat)")
    (action_tile "A_QTY_VALUE" "(click_qty)")
    (action_tile "A_COT_VALUE" "(click_cot)")
    (action_tile "A_OBV_VALUE" "(click_obv)")
    ;(action_tile "A_ITEM" "(setq item_r $reason) (rep_verify)")
    (action_tile "A_ITEM" " (rep_verify)")
    (action_tile "accept" "(done_dialog 3)")
    (action_tile "cancel" "(done_dialog 4)")
    (action_tile "A_LOOK" "(get_all_a) (done_dialog 5)")
    (setq what_next (start_dialog))
;----------------------------------------
;Determine what to do next
;----------------------------------------
    (cond
	((= 6 what_next)
	 (create_ent)
	 (setq if_continue 1)
	)
	((= 2 what_next)
	 (bpt_get)
	 (setq if_continue 1)
	)
	((= 3 what_next)
	 (setq if_continue 0)
	)
	((= 4 what_next)
	 (command "undo" "b")
	 (setq if_continue 0)
	)
	((= 5 what_next)
	 (a_view)
	 (setq if_continue 1)
	)
    )
  )
;--------------------------------------
;unload dialog and reset system variable
;--------------------------------------
  (unload_dialog dcl_id)
  (ac_lxy_set)
  (prin1)
)
;****************************** Main function end **********************************;


;--------------------------------------
;Do when change chinses name in dialog
;--------------------------------------
(defun click_chin()
  (setq chin_n (atoi (get_tile "A_CHIN_VALUE")))
  (set_tile "A_CHIN" (nth chin_n (lib_a 1)))
  (set_tile "A_DESC" (nth chin_n (lib_a 2)))
  (set_tile "A_DESC_VALUE" (itoa chin_n))
  (ini_list "A_MAT_VALUE" (nth chin_n (lib_a 3)))
  (set_tile "A_MAT_VALUE" "0")
  (set_tile "A_MAT" (car (nth chin_n (lib_a 3))))
  (ini_list "A_OBV_VALUE" (nth chin_n (lib_a 6)))
  (set_tile "A_OBV_VALUE" "0")
  (set_tile "A_OBV" (car (nth chin_n (lib_a 6))))
  (ini_list "A_COT_VALUE" (nth chin_n (lib_a 4)))
  (set_tile "A_COT_VALUE" "0")
  (set_tile "A_COT" (car (nth chin_n (lib_a 4))))
  (setq lib_item_n chin_n)
)

;--------------------------------------
;Do when change english name in dialog
;--------------------------------------
(defun click_desc()
  (setq desc_n (atoi (get_tile "A_DESC_VALUE")))
  (set_tile "A_DESC" (nth desc_n (lib_a 2)))
  (set_tile "A_CHIN" (nth desc_n (lib_a 1)))
  (set_tile "A_CHIN_VALUE" (itoa desc_n))
  (ini_list "A_MAT_VALUE" (nth desc_n (lib_a 3)))
  (set_tile "A_MAT_VALUE" "0")
  (set_tile "A_MAT" (car (nth desc_n (lib_a 3))))
  (ini_list "A_OBV_VALUE" (nth desc_n (lib_a 6)))
  (set_tile "A_OBV_VALUE" "0")
  (set_tile "A_OBV" (car (nth desc_n (lib_a 6))))
  (ini_list "A_COT_VALUE" (nth desc_n (lib_a 4)))
  (set_tile "A_COT_VALUE" "0")
  (set_tile "A_COT" (car (nth desc_n (lib_a 4))))
  (setq lib_item_n desc_n)
)

;--------------------------------------
;Do when change part quantity in dialog
;--------------------------------------
(defun click_qty()
  (setq qty_n (atoi (get_tile "A_QTY_VALUE")))
  (set_tile "A_QTY" (nth qty_n (lib_a 5)))
)

;--------------------------------------
;Do when change material in dialog
;--------------------------------------
(defun click_mat()
  (setq mat_n (atoi (get_tile "A_MAT_VALUE")))
  (if lib_item_n
    (progn
    	(set_tile "A_MAT" (nth mat_n (nth lib_item_n (lib_a 3))))
	(if (/= 0 lib_item_n)
	   (progn
    		(set_tile "A_OBV" (nth mat_n (nth lib_item_n (lib_a 6))))
    	  	(set_tile "A_OBV_VALUE" (itoa mat_n))
	   )
	)
    )
    (set_tile "A_MAT" (nth mat_n (lib_a 7)))
  )
)

;--------------------------------------
;Do when change hardness in dialog
;--------------------------------------
(defun click_obv()
  (setq obv_n (atoi (get_tile "A_OBV_VALUE")))
  (if lib_item_n
    (set_tile "A_OBV" (nth obv_n (nth lib_item_n (lib_a 6))))
    (set_tile "A_OBV" (nth obv_n (lib_a 8)))
  )
)

;--------------------------------------
;Do when change specification in dialog
;--------------------------------------
(defun click_cot()
  (setq cot_n (atoi (get_tile "A_COT_VALUE")))
  (if lib_item_n
    (set_tile "A_COT" (nth cot_n (nth lib_item_n (lib_a 4))))
  )
)

;--------------------------------------
;Initializing dialog
;--------------------------------------
(defun ini_dia()
  (setq rep (itoa (+ 1 (getvar "useri1"))))
  (setq rep2 (itoa (+ 1 (getvar "useri1"))))
  (set_tile "A_ITEM" rep)
  (ini_list "A_CHIN_VALUE" (lib_a 1))
  (ini_list "A_DESC_VALUE" (lib_a 2))
  (ini_list "A_QTY_VALUE" (lib_a 5))
  (set_tile "A_QTY" "1")
  (if chin
	(set_tile "A_CHIN" chin)
  )
  (if desc
	(set_tile "A_DESC" desc)
  )
  (if cot
	(set_tile "A_COT" cot)
  )
  (if mat
	(set_tile "A_MAT" mat)
  )
  (if obv
	(set_tile "A_OBV" obv)
  )
  (if qty
	(set_tile "A_QTY" qty)
  )
  (if lib_item_n
     (progn
  	(set_tile "A_CHIN_VALUE" (itoa lib_item_n))
  	(set_tile "A_DESC_VALUE" (itoa lib_item_n))
  	(ini_list "A_MAT_VALUE" (nth lib_item_n (lib_a 3)))
  	(set_tile "A_MAT_VALUE" "0")
  	(ini_list "A_OBV_VALUE" (nth lib_item_n (lib_a 6)))
  	(set_tile "A_OBV_VALUE" "0")
	(if mat_n
    	   (progn
    		(set_tile "A_OBV_VALUE" (itoa mat_n))
	   )
	)
     )
     (progn
	(ini_list "A_MAT_VALUE" (lib_a 7))
	(ini_list "A_OBV_VALUE" (lib_a 8))
     )
  )
  (if qty_n
     	(set_tile "A_QTY_VALUE" (itoa qty_n))
  )
)

;--------------------------------------
;Get dialog settings when exit dialogure
;--------------------------------------
(defun get_all_a()
  (if (not (setq chin (get_tile "A_CHIN")))
	(setq chin " ")
  )  
  (if (not (setq desc (get_tile "A_DESC")))
	(setq desc " ")
  )  
  (if (not (setq mat (get_tile "A_MAT")))
	(setq mat " ")
  )  
  (if (not (setq cot (get_tile "A_COT")))
	(setq cot " ")
  )  
  (if (not (setq qty (get_tile "A_QTY")))
	(setq qty "1")
  )  
  (if (not (setq obv (get_tile "A_OBV")))
	(setq obv " ")
  )
  (if (not (setq rep (get_tile "A_ITEM")))
	(setq rep (itoa (getvar "useri1")))
  )
)  
  
;--------------------------------------
;Do when reset base point
;--------------------------------------
(defun bpt_get()
  (if (setq basept (getpoint "\nGet a point:"))
    (progn
      (setvar "userr1" (+ (car basept) (car orgpt)))
      (setvar "userr2" (+ (cadr basept) (cadr orgpt)))
      (setvar "useri1" 0)
    )
  )
)

;--------------------------------------
;Do when chinese or english name
;--------------------------------------
(defun item_en()
  (if (= 2 chin_r)
    (progn
      (if (xh_get (get_tile "A_CHIN") (lib_a 1))
 	(progn
	  (set_tile "A_CHIN_VALUE" (itoa (xh_get (get_tile "A_CHIN") (lib_a 1))))
	  (click_chin)
        )
	(progn
	  (ini_list "A_MAT_VALUE" (lib_a 7))
	  (ini_list "A_OBV_VALUE" (lib_a 8))
	)
      )
      (setq chin_r nil)
    )
  )
  (if (= 2 desc_r)
    (progn
      (if (xh_get (get_tile "A_DESC") (lib_a 2))
 	(progn
	  (set_tile "A_DESC_VALUE" (itoa (xh_get (get_tile "A_DESC") (lib_a 2))))
	  (click_desc)
	)
	(progn
	  (ini_list "A_MAT_VALUE" (lib_a 7))
	  (ini_list "A_OBV_VALUE" (lib_a 8))
	)
      )
      (setq desc_r nil)
    )
  )
)

;---------------------------------------------
;Verify the validation of rep input by user
;---------------------------------------------
(defun rep_verify()
  (if (= 2 )
    (progn
      (setq rep (get_tile "A_ITEM"))
      (if (= 0 (atoi rep))
        (mode_tile "A_ITEM" 2)
      )
      ;(set_tile "A_ITEM" (itoa (atoi rep)))
	(set_tile "A_ITEM" rep)
	;(if (> 0 (atoi rep))
	
      		(setvar "useri2" (atoi rep))
	;)
    )
  )
) 

;--------------------------------------
;create bill table
;--------------------------------------
;**********************/ 	pt 	pt1 	pt2 	pt22	a_ent	sel_ent**
(defun create_ent(/ 	PT pt1 	pt2 	pt22	a_ent	sel_ent  old_var)
  (initget 32)
  (if (= 0 (getvar "useri1"))
    (progn
      (while (not basept)
  	(setq basept (getpoint "\nPlease enter bom table insert point:"))
      )
      (setvar "userr1" (+ (car basept)  (car orgpt)))
      (setvar "userr2" (+ (cadr basept) (cadr orgpt)))
    )
    (progn
      (setq basept (list (getvar "userr1") (getvar "userr2")))
     ; (setq basept (wtou basept))
    )
  )
  (if basept
    (progn
      (setq pt_move (polar (polar basept pi 200) (/ pi 2) (* (atoi rep2) 8))) ;ok
      (if (setq pt1 (getpoint "\nPlease get first point:"))
      (if (setq pt2 (getpoint pt1 "\nPlease get second point:"))
          (progn
            (setq pt22 (polar pt2 (angle pt2 pt1) 6))

	    (setvar "osmode" 0)

            (setq dmbk_old (getvar "dimblk"))
            (setq dmas_old (getvar "dimasz"))
            (setvar "dimblk" "dot")
            (if (/= 0 (getvar "dimscale"))                      ;OK
              (setvar "dimasz" (/ 1 (getvar "dimscale"))) 	;OK
              (progn
                (setvar "dimscale" (/ 3 (getvar "dimtxt")))	;OK
                (setvar "dimasz" (/ 1 (getvar "dimscale")))	;OK
              )
            )	
            (setq old_var (getvar "attdia"))	
            (setvar "attdia" 0")					;OK
            (command "leader" pt1 pt22 "" "" "_block" "mxb_item" pt2 "" "" "" rep) 
            (setvar "attdia" old_var)
            (setq xd (list (list -3 (list "mxbitem" (cons 1000 rep)))))
            (mxdata  (entlast) xd)
            (command "dimblk" dmbk_old)
            (command "dimasz" dmas_old)
            (setvar "useri2" (+ 1 (getvar "useri2")))

            (if (= 0 (getvar "useri1"))
  	      (command "insert" "mxb_head.dwg" basept "" "" "")
            )
            (setq xd (list (list -3 (list "mxb_nstandard" (cons 1000 "mxb_head")))))
            (mxdata  (entlast) xd)
            (command "insert" "MXB_TAB_L.dwg" pt_move "" "" "" rep qty chin desc mat cot obv)
            (setq xd (list (list -3 (list "mxb_nstandard" (cons 1000 rep)))))
            (mxdata  (entlast) xd)
            (if (< (getvar "useri1") (atoi rep2))
              (setvar "useri1" (atoi rep2))
            )
	    (setvar "osmode" os_old)
          )
        )
      )
    )
  )
)